/*
 * Decompiled with CFR 0.152.
 */
package core;

import UI.EpsilonFrame;
import UI.FittingProgressMonitor;
import UI.GecProgressMonitor;
import UI.MainFrame;
import UI.SimulationProgressMonitor;
import UI.SimulationResultsFrame;
import UI.SplashWindow;
import core.Element;
import core.ElementReader;
import core.InputReader;
import core.NotesReader;
import core.NotesWriter;
import core.NuclideReader;
import core.OutputWriter;
import core.Parameter;
import core.ParameterReader;
import core.PositionReader;
import core.ResultsReader;
import core.TemplateReader;
import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Main {
    public static boolean debug = false;
    public static boolean retainFiles = false;
    static Hashtable paramsets;
    static Hashtable params;
    static Hashtable elems;
    static List nuclides;
    static List elements;
    public static String log;
    public static String notes;
    public static int absorbed;
    public static String nuclideLibraryPath;
    static String parameterSetsPath;
    static String detectorTemplatePath;
    static String inputTemplatePath;
    static String geometricEfficiencyTemplatePath;
    public static String detectorPath;
    public static String detectorOutputPath;
    public static String inputPath;
    public static String outputPath;
    static String command;
    static String debugCommand;
    public static String workingDir;
    public static String resultsPath;
    public static String detectorSavePath;
    public static String outputSavePath;
    public static String gecOutputPath;
    public static String elementLibraryPath;
    static List detectorTemplate;
    static List inputTemplate;
    static List geometricEfficiencyTemplate;
    private static boolean popupPlot;
    public static MainFrame mainFrame;
    private static int majorVersion;
    private static int minorVersion;
    private static String release;
    public static boolean aasi_fit;
    public static SplashWindow sp;
    private static SimulationProgressMonitor monitor;
    static byte[] bytes;
    static int BUFFER_SIZE;
    static Process simp;
    static boolean userStopSim;
    static boolean errorsInSim;
    static int num;
    static String nuclideName;
    static boolean popupInfo;
    private static SimulationResultsFrame fr;
    static Thread gecProc;
    static Process gecp;
    static boolean userStopGec;

    public Main() {
        sp = new SplashWindow(null, 10000);
        if (debug) {
            command = debugCommand;
        }
        Main.sp.status.setText("Parsing nuclide library...");
        Main.sp.status.setText("Parsing parameters...");
        this.readParameters();
        Main.sp.bar.setValue(10);
        Main.sp.bar.setValue(15);
        Main.sp.status.setText("Parsing element library...");
        this.readElements();
        Main.sp.bar.setValue(25);
        Main.sp.bar.setValue(35);
        Main.sp.status.setText("Generating materials...");
        Main.sp.bar.setValue(40);
        Main.sp.status.setText("Loading templates...");
        this.readDetectorTemplate();
        Main.sp.bar.setValue(50);
        try {
            Main.readDetector();
        }
        catch (Exception ex) {
            try {
                Main.warnUser("Detector file " + detectorPath + " could not be found.\nUsing AASI/bin/Detector.det instead.", false);
                detectorPath = "./Detector.det";
                Main.readDetector();
            }
            catch (Exception exe) {
                Main.warnUser("File Detector.det is missing!!\nMake sure it is either in your AASI/bin directory\nor detectors subdirectory.\nExiting program..");
                System.exit(0);
            }
        }
        Main.sp.bar.setValue(60);
        this.readInputTemplate();
        Main.sp.bar.setValue(70);
        Main.readInput();
        Parameter p = Main.getParameter("1030");
        String libName = p.getStringValue();
        nuclideLibraryPath = "./" + libName.substring(1, libName.length() - 1);
        Main.sp.bar.setValue(80);
        this.readGeometricEfficiencyTemplate();
        Main.sp.bar.setValue(90);
        Main.sp.status.setText("Opening main window...");
        mainFrame = new MainFrame();
        Main.sp.bar.setValue(100);
        mainFrame.setVisible(true);
        sp.dispose();
    }

    public static int getMajorVersion() {
        return majorVersion;
    }

    public static List getParamList() {
        Vector<Parameter> l = new Vector<Parameter>();
        Enumeration enume = params.elements();
        while (enume.hasMoreElements()) {
            l.add((Parameter)enume.nextElement());
        }
        return l;
    }

    public static void setProgressMonitor(SimulationProgressMonitor mon) {
        monitor = mon;
    }

    public static void setParameters(Hashtable newParams) {
        params = newParams;
    }

    public static Hashtable getParameters() {
        return params;
    }

    public static int getMinorVersion() {
        return minorVersion;
    }

    public static String getRelease() {
        return release;
    }

    public static String getJVMVersion() {
        return System.getProperty("java.version");
    }

    public static String getVersionString() {
        String str = Main.getMajorVersion() + "." + Main.getMinorVersion() + " " + Main.getRelease();
        return str;
    }

    public static String getBackendVersionString() {
        String ret = "";
        System.out.println("Retrieve backend version....");
        try {
            if (bytes == null) {
                bytes = new byte[BUFFER_SIZE];
            }
            File dir = new File(workingDir);
            Process p = Runtime.getRuntime().exec(command, null, dir);
            BufferedInputStream s = new BufferedInputStream(p.getInputStream());
            boolean stop = false;
            while (!stop) {
                int read = s.read(bytes, 0, bytes.length);
                if (read != 0) {
                    String str = new String(bytes, 0, read);
                    int ind = str.lastIndexOf(86);
                    if (ind != -1) {
                        str = str.substring(ind + 2, str.length());
                        str = str.substring(0, str.indexOf(42));
                        stop = true;
                        ret = str;
                    }
                    System.out.println(str);
                    continue;
                }
                stop = true;
            }
            p.destroy();
            s.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    private void readElements() {
        elems = new Hashtable();
        ElementReader reader = new ElementReader();
        elements = reader.loadElements(elementLibraryPath);
        if (debug) {
            System.out.println("Parsed elements.");
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Element elem = (Element)iter.next();
            elems.put(elem.getZ(), elem);
        }
    }

    public static void readDetector() throws Exception {
        InputReader reader = new InputReader();
        reader.loadInput(detectorPath, detectorTemplate);
        if (debug) {
            System.out.println("Parsed detector.");
        }
    }

    private void readDetectorTemplate() {
        TemplateReader reader = new TemplateReader();
        detectorTemplate = reader.loadTemplate(detectorTemplatePath);
        System.out.println("Parsed detector template.");
    }

    private void readInputTemplate() {
        TemplateReader reader = new TemplateReader();
        inputTemplate = reader.loadTemplate(inputTemplatePath);
        System.out.println("Parsed input template.");
    }

    private void readGeometricEfficiencyTemplate() {
        TemplateReader reader = new TemplateReader();
        geometricEfficiencyTemplate = reader.loadTemplate(geometricEfficiencyTemplatePath);
        System.out.println("Parsed geometric efficiency template.");
    }

    public static void readInput() {
        try {
            InputReader reader = new InputReader();
            reader.setAutoCreateParameters(true);
            reader.loadInput(inputPath, inputTemplate);
            NotesReader r = new NotesReader();
            notes = r.loadNotes(inputPath);
        }
        catch (FileNotFoundException fex) {
            fex.printStackTrace();
            Main.warnUser("Input file not found (" + inputPath + ")!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Main.warnUser("Malformed input file!");
        }
        System.out.println("Parsed input.");
    }

    private void readParameters() {
        ParameterReader reader = new ParameterReader();
        reader.loadParameters(parameterSetsPath);
        paramsets = reader.getParameters();
        params = reader.getAllParameters();
        System.out.println("Parsed parameters.");
    }

    public static void readNuclides() {
        NuclideReader reader = new NuclideReader();
        nuclides = reader.getNuclides(nuclideLibraryPath);
        System.out.println("Parsed nuclides.");
    }

    public static List getParamList(String set) {
        Vector l = new Vector();
        List keys = (List)paramsets.get(set);
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            l.add(params.get(key));
        }
        return l;
    }

    public static List getInputTemplate() {
        return inputTemplate;
    }

    public static List getDetectorTemplate() {
        return detectorTemplate;
    }

    public static List getGeometricEfficiencyTemplate() {
        return geometricEfficiencyTemplate;
    }

    public static Parameter getParameter(String hashKey) {
        return (Parameter)params.get(hashKey);
    }

    public static Element getElement(int z) {
        Integer key = new Integer(z);
        return (Element)elems.get(key);
    }

    public static List getElements() {
        ArrayList ret = new ArrayList();
        ret.addAll(elems.values());
        return ret;
    }

    public static void putParameter(String hashKey, Object value) {
        params.put(hashKey, value);
    }

    public static Parameter createParameter(String hashKey) {
        Parameter p = new Parameter();
        p.setHashKey(hashKey);
        params.put(hashKey, p);
        return p;
    }

    public static Parameter cloneParameter(String originalKey, String cloneKey) {
        Parameter orig = Main.getParameter(originalKey);
        Parameter clone = (Parameter)orig.clone();
        clone.setHashKey(cloneKey);
        params.put(cloneKey, clone);
        return clone;
    }

    public static List getNuclides() {
        return nuclides;
    }

    public static void setNuclides(List n) {
        nuclides = n;
    }

    public static synchronized void writeOutput() {
        Parameter p = Main.getParameter("1026");
        String newVal = "'Detector__gen.dat'";
        String oldVal = (String)p.getValue();
        p.setValue(newVal);
        OutputWriter writer = new OutputWriter();
        writer.setOutWriter(null);
        OutputWriter.writeOutput(inputTemplate, outputPath);
        NotesWriter w = new NotesWriter();
        String oldNotes = notes;
        notes = "This file was automatically generated by AASI frontend.\nThis file is the input of the last simulation run.";
        w.writeNotes(outputPath);
        notes = oldNotes;
        writer.setOutWriter(null);
        OutputWriter.writeOutput(detectorTemplate, detectorOutputPath);
        p.setValue(oldVal);
    }

    public static void writeGec() {
        OutputWriter writer = new OutputWriter();
        writer.setOutWriter(null);
        OutputWriter.writeOutput(geometricEfficiencyTemplate, gecOutputPath);
    }

    public static void save() {
        OutputWriter writer = new OutputWriter();
        writer.setOutWriter(null);
        OutputWriter.writeOutput(inputTemplate, outputSavePath);
        if (MainFrame.notesPanel != null) {
            notes = MainFrame.notesPanel.getText();
        }
        NotesWriter w = new NotesWriter();
        w.writeNotes(outputSavePath);
        writer.setOutWriter(null);
        OutputWriter.writeOutput(detectorTemplate, detectorSavePath);
    }

    public static void saveDetector() {
        OutputWriter writer = new OutputWriter();
        writer.setOutWriter(null);
        OutputWriter.writeOutput(detectorTemplate, detectorSavePath);
    }

    public static void saveInput() {
        OutputWriter writer = new OutputWriter();
        writer.setOutWriter(null);
        OutputWriter.writeOutput(inputTemplate, outputSavePath);
        if (MainFrame.notesPanel != null) {
            notes = MainFrame.notesPanel.getText();
        }
        NotesWriter w = new NotesWriter();
        w.writeNotes(outputSavePath);
    }

    public static boolean getSimulationStoppedByUser() {
        return userStopSim;
    }

    public static boolean getSimulationHadErrors() {
        return errorsInSim;
    }

    public static void clearSimulationState() {
        userStopSim = false;
        errorsInSim = false;
    }

    public static void setPopupInfoWindow(boolean enabled) {
        popupInfo = enabled;
    }

    public static void showInfoWindow() {
        if (fr == null) {
            fr = new SimulationResultsFrame();
        }
        fr.setTitle("Simulation info browser");
        fr.setVisible(true);
    }

    public static void clearInfoWindow() {
        if (fr == null) {
            fr = new SimulationResultsFrame();
        }
        fr.clear();
    }

    public static void setPopupPlot(boolean enabled) {
        popupPlot = enabled;
    }

    public static void runSimulator() {
        try {
            userStopSim = false;
            errorsInSim = false;
            try {
                File track = new File("./tracking.dat");
                track.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                File pos = new File("./position.dat");
                pos.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            int insNum = num++;
            try {
                if (fr == null) {
                    fr = new SimulationResultsFrame();
                }
                File dir = new File(workingDir);
                Parameter p = Main.getParameter("1026");
                String newVal = "'Detector__gen.dat'";
                String oldVal = (String)p.getValue();
                p.setValue(newVal);
                p = Main.getParameter("1029");
                nuclideName = p.getStringValue();
                nuclideName = nuclideName.substring(1, nuclideName.length() - 1);
                if (nuclideName.equals("dummy")) {
                    nuclideName = "Line energy (" + Main.getParameter("1031").getValue().toString() + " MeV)";
                }
                final OutputWriter ow = new OutputWriter();
                simp = Runtime.getRuntime().exec(command, null, dir);
                ow.setOutWriter(simp.getOutputStream());
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        OutputWriter.writeOutput(inputTemplate, outputPath);
                    }
                });
                t.setPriority(10);
                t.setName("Outstream Writer (Sim instance " + insNum + ")");
                t.start();
                final SimulationProgressMonitor s = new SimulationProgressMonitor(mainFrame, "Simulating " + nuclideName);
                if (monitor == null) {
                    s.setErrorStream(simp.getErrorStream());
                    s.setInStream(simp.getInputStream());
                    s.setUnbounded(Main.getParameter("1010").getStringValue().equals("y") || Main.getParameter("1009").getStringValue().equals("n"));
                    s.setVisible(true);
                    s.start();
                } else {
                    monitor.setErrorStream(simp.getErrorStream());
                    monitor.setInStream(simp.getInputStream());
                    ((FittingProgressMonitor)monitor).setProcess(simp);
                    monitor.setUnbounded(Main.getParameter("1010").getStringValue().equals("y") || Main.getParameter("1009").getStringValue().equals("n"));
                    monitor.setVisible(true);
                    monitor.start();
                }
                simp.waitFor();
                p = Main.getParameter("1026");
                p.setValue(oldVal);
                try {
                    Thread.sleep(500L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                simp.destroy();
                if (monitor == null) {
                    s.stop();
                } else {
                    monitor.stop();
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        s.dispose();
                    }
                });
                String str = "";
                str = monitor == null ? s.getLogString() : monitor.getLogString();
                int i1 = str.indexOf("Totally absorbed:");
                if (i1 != -1) {
                    String absStr = str.substring(i1 + 17, i1 + 17 + 9);
                    absStr = absStr.replaceAll("\\s+", "");
                    absorbed = Integer.parseInt(absStr);
                    System.out.println("Absorbed:" + absorbed);
                }
                log = log + str;
                if (monitor == null) {
                    errorsInSim = s.hadErrors();
                }
                if (errorsInSim) {
                    if (debug) {
                        System.out.println("Found errors!");
                    }
                    Main.warnUser(s.getErrorString(), true, true);
                    log = log + "\n" + s.getErrorString();
                    System.gc();
                }
                if (!retainFiles) {
                    File f = new File("Input__gen.dat");
                    if (f.exists()) {
                        f.delete();
                    }
                    if ((f = new File("Detector__gen.dat")).exists()) {
                        f.delete();
                    }
                }
                if (!userStopSim && !errorsInSim) {
                    if (popupPlot) {
                        String nname = nuclideName;
                        try {
                            File trackFile;
                            try {
                                String text = "";
                                int ind1 = str.lastIndexOf("Fraction");
                                int ind2 = str.lastIndexOf("Gaussian");
                                if (ind1 >= 0 && ind2 >= 0 && ind2 > ind1) {
                                    nname = fr.setText(str.substring(ind1, ind2), 1, nuclideName, true);
                                }
                                ind1 = str.lastIndexOf("COINCIDENCES");
                                ind2 = str.lastIndexOf("***");
                                if (ind1 >= 0 && ind2 >= 0 && ind2 > ind1) {
                                    fr.setText(str.substring(ind1, ind2), 2, nname, false);
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            File posFile = new File("position.dat");
                            PositionReader pre = null;
                            if (posFile.exists()) {
                                pre = new PositionReader();
                                List l = pre.loadResults("position.dat");
                                fr.setPositions(nname, (float[])l.get(0), (float[])l.get(1), (float[])l.get(2), (float[])l.get(3));
                                if (!retainFiles) {
                                    posFile.delete();
                                }
                            }
                            if ((trackFile = new File("tracking.dat")).exists()) {
                                pre = new PositionReader();
                                List li = pre.loadResults("tracking.dat");
                                fr.setTracking(nname, (float[])li.get(0), (float[])li.get(1), (float[])li.get(2), (float[])li.get(3));
                                if (!retainFiles) {
                                    trackFile.delete();
                                }
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (popupInfo) {
                            Main.showInfoWindow();
                        }
                    }
                    System.gc();
                    Main.simulationEnded();
                } else {
                    log = userStopSim ? log + "\nAborted by user!" : log + "\nAborted!";
                    System.gc();
                }
                if (debug) {
                    System.out.println("Simulation run " + insNum + " is finished.");
                }
                mainFrame.postRun();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getLog() {
        return log;
    }

    public static String getNotes() {
        return notes;
    }

    public static void simulationEnded() {
        try {
            ResultsReader reader = new ResultsReader();
            File resultFile = new File("results.dat");
            if (!resultFile.exists()) {
                Main.warnUser("Results could not be read. This is \npropably due to an undetected error.\nCheck the simulation log.");
                return;
            }
            List list = reader.loadResults("results.dat");
            mainFrame.plot(list, nuclideName, popupPlot);
            File file = new File("results.dat");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void stopSimulation() {
        userStopSim = true;
        simp.destroy();
    }

    public static void runGECalculation() {
        try {
            userStopGec = false;
            gecProc = new Thread(new Runnable(){

                public void run() {
                    try {
                        File file;
                        final OutputWriter ow = new OutputWriter();
                        gecp = Runtime.getRuntime().exec(command, null, null);
                        ow.setOutWriter(gecp.getOutputStream());
                        Thread t = new Thread(new Runnable(){

                            public void run() {
                                OutputWriter.writeOutput(geometricEfficiencyTemplate, ".");
                            }
                        });
                        t.setPriority(10);
                        t.setName("Outstream Writer (GEC)");
                        t.start();
                        GecProgressMonitor f = new GecProgressMonitor(mainFrame);
                        f.setErrorStream(gecp.getErrorStream());
                        f.setInStream(gecp.getInputStream());
                        f.setLocation(MainFrame.gecFrame.getX(), MainFrame.gecFrame.getY() + MainFrame.gecFrame.getHeight());
                        f.setVisible(true);
                        f.start();
                        gecp.waitFor();
                        Thread.yield();
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                        f.dispose();
                        f.stop();
                        gecp.destroy();
                        if (!retainFiles && (file = new File("gec__gen.dat")).exists()) {
                            file.delete();
                        }
                        if (!userStopGec) {
                            EpsilonFrame p = new EpsilonFrame();
                            float result = f.getResult();
                            p.setResult(result);
                            p.setVisible(true);
                            System.gc();
                            Main.gecEnded();
                        } else {
                            System.gc();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            gecProc.setName("GE calculation runner");
            gecProc.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void gecEnded() {
        if (debug) {
            System.out.println("Gec calculation ended.");
        }
    }

    public static void stopGECalculation() {
        userStopGec = true;
        gecp.destroy();
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].indexOf("debug") >= 0) {
                        debug = true;
                    }
                    if (args[i].indexOf("retain") < 0) continue;
                    retainFiles = true;
                }
            }
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Main();
    }

    public static void warnUser(String message) {
        JOptionPane.showMessageDialog(mainFrame, message, "Warning", 2);
    }

    public static boolean askUser(String title, String message) {
        int ret = JOptionPane.showConfirmDialog(mainFrame, message, title, 0, 3);
        return ret == 0;
    }

    public static void warnUser(String message, boolean warning, boolean backend) {
        if (!warning) {
            JOptionPane.showMessageDialog(mainFrame, message + "\nSee Aasi/bin/ErrorCodes.txt for more information.", "Error", 0);
        } else {
            JOptionPane.showMessageDialog(mainFrame, message + "\nSee Aasi/bin/ErrorCodes.txt for more information.", "Warning", 2);
        }
    }

    public static void warnUser(String message, boolean warning) {
        if (!warning) {
            JOptionPane.showMessageDialog(mainFrame, message, "Error", 0);
        } else {
            JOptionPane.showMessageDialog(mainFrame, message, "Warning", 2);
        }
    }

    static {
        log = "Welcome to AASI. Ready to run.\n";
        notes = "";
        absorbed = 0;
        nuclideLibraryPath = "./NuclideLibrary.xml";
        parameterSetsPath = "./lib/ParameterSets.xml";
        detectorTemplatePath = "./lib/DetectorTemplate.dat";
        inputTemplatePath = "./lib/InputTemplate.dat";
        geometricEfficiencyTemplatePath = "./lib/GeometricEfficiencyTemplate.dat";
        detectorPath = "./Detector.det";
        detectorOutputPath = "./Detector__gen.dat";
        inputPath = "./Input.inp";
        outputPath = "./Input__gen.dat";
        command = "./alpha4_1.exe";
        debugCommand = "./alpha4_1.exe";
        workingDir = ".";
        resultsPath = "./results.dat";
        detectorSavePath = "./Detector__gen.dat";
        outputSavePath = "./Input__gen.dat";
        gecOutputPath = "./gec__gen.dat";
        elementLibraryPath = "./stopping.dat";
        popupPlot = true;
        majorVersion = 2;
        minorVersion = 0;
        release = "";
        aasi_fit = false;
        sp = null;
        monitor = null;
        BUFFER_SIZE = 80;
        userStopSim = false;
        errorsInSim = false;
        num = 0;
        popupInfo = false;
        userStopGec = false;
    }
}

