/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.InputReader;
import core.Main;
import core.Parameter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OutputWriter {
    private static boolean debug = false;
    private static BufferedWriter out;

    public void setOutWriter(OutputStream os) {
        if (os == null) {
            out = null;
            return;
        }
        OutputStreamWriter writer = new OutputStreamWriter(os);
        out = new BufferedWriter(writer);
    }

    public static void writeOutput(List inputTemplate, String outputPath) {
        try {
            Object param = null;
            if (out == null) {
                out = new BufferedWriter(new FileWriter(outputPath));
            }
            String outStr = "";
            String comment = "";
            Iterator iter = inputTemplate.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                String str = OutputWriter.handleElems((List)o);
                if (out == null || str == null || str.startsWith(" ")) continue;
                out.write(str + "\n");
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String handleElems(List list) throws IOException {
        Iterator iter = list.iterator();
        String comment = " ! ";
        String outStr = "";
        String commentP = " ! ";
        boolean addComment = true;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (key.startsWith("blank")) {
                return null;
            }
            Parameter p = Main.getParameter(key);
            if (p != null) {
                if (p.getCoeff() != null) {
                    Float val = (Float)p.getValue();
                    outStr = outStr + "" + val.floatValue() * p.getCoeff().floatValue();
                } else {
                    if (p.getValue() == null) {
                        System.out.println("NULL found!");
                    }
                    outStr = outStr + p.getValue().toString();
                }
                comment = p.getComment() != null ? comment + p.getComment() : comment + p.getName();
                if (p.getUnit() != null) {
                    comment = comment + " (" + p.getUnit() + ")";
                }
            } else {
                comment = "";
            }
            if (iter.hasNext()) {
                outStr = outStr + ",";
                comment = comment + " & ";
            }
            if (key.charAt(0) == '?') {
                outStr = outStr + OutputWriter.handleConditional(key);
                continue;
            }
            if (key.charAt(0) == '#') {
                outStr = outStr + OutputWriter.handleLoop(key);
                continue;
            }
            addComment = true;
        }
        if (addComment) {
            for (int i = outStr.length(); i < 20; ++i) {
                comment = " " + comment;
            }
            outStr = outStr + comment;
        }
        if (debug) {
            System.out.println("Wrote:" + outStr);
        }
        return outStr;
    }

    private static String handleElems(String key) throws IOException {
        String comment = "! ";
        String outStr = "";
        Parameter p = Main.getParameter(key);
        if (p != null) {
            if (p.getCoeff() != null) {
                Float val = (Float)p.getValue();
                outStr = outStr + "" + val.floatValue() * p.getCoeff().floatValue();
            } else {
                outStr = outStr + p.getValue().toString();
            }
            comment = p.getComment() != null ? comment + p.getComment() : comment + p.getName();
        } else {
            outStr = "";
        }
        if (key.charAt(0) == '?') {
            outStr = outStr + OutputWriter.handleConditional(key);
        } else if (key.charAt(0) == '#') {
            outStr = outStr + OutputWriter.handleLoop(key);
        }
        if (debug) {
            System.out.println("Wrote:" + outStr);
        }
        return outStr;
    }

    private static String handleConditional(String s) throws IOException {
        String cond = "=|<|>|:";
        s = s.substring(1, s.length() - 1);
        String[] expr = s.split(cond);
        Parameter operand = Main.getParameter(expr[0]);
        String operator = s.substring(expr[0].length(), expr[0].length() + 1);
        String literal = expr[1];
        int sepInd = s.lastIndexOf(58);
        int bInd = s.indexOf(58);
        String ctrue = s.substring(bInd + 1, sepInd);
        String cfalse = s.substring(sepInd + 1, s.length());
        Object templ = null;
        if (debug) {
            System.out.println("\n\n\nFound conditional!");
            System.out.println(expr.length + " tokens:");
            System.out.println("\t\tOperand:" + operand.getName());
            System.out.println("\t\tOperator:" + operator);
            System.out.println("\t\tLiteral:" + literal);
            System.out.println("\t\ttrue:" + ctrue);
            System.out.println("\t\tfalse:" + cfalse);
        }
        if ((templ = InputReader.compare(operand, literal, operator) ? InputReader.eval(ctrue) : InputReader.eval(cfalse)) == null) {
            return "";
        }
        if (templ instanceof String) {
            return OutputWriter.handleElems((String)templ);
        }
        return OutputWriter.handleElems((List)templ);
    }

    public static String handleLoop(String s) throws IOException {
        String ret;
        block22: {
            Object templ;
            int compound;
            block21: {
                String cond = "c|r|\\{";
                int rowLoop = -1;
                compound = -1;
                int cInd = s.indexOf(99);
                int rInd = s.indexOf(114);
                int bInd = s.indexOf(123);
                int opInd = -1;
                if (cInd == -1) {
                    cInd = Integer.MAX_VALUE;
                }
                if (rInd == -1) {
                    rInd = Integer.MAX_VALUE;
                }
                if (bInd == -1) {
                    bInd = Integer.MAX_VALUE;
                }
                if (cInd < rInd && cInd < bInd) {
                    opInd = cInd;
                } else if (rInd < cInd && rInd < bInd) {
                    opInd = rInd;
                    rowLoop = 1;
                } else {
                    opInd = bInd;
                    compound = 1;
                }
                s = s.substring(1);
                String operator = "" + s.charAt(opInd - 1);
                String arg = s.substring(opInd);
                String opKey = s.substring(0, opInd - 1);
                Parameter operand = Main.getParameter(opKey);
                if (arg.charAt(arg.length() - 1) == '}') {
                    arg = arg.substring(0, arg.length() - 1);
                }
                templ = null;
                String str = OutputWriter.loop(operand, arg);
                if (str.length() <= 0) {
                    return "\n";
                }
                templ = InputReader.eval(str);
                if (debug) {
                    System.out.println("\n\n\nFound loop!");
                    System.out.println("\t\tOperand hash:" + opKey);
                    System.out.println("\t\tIterations:" + operand.getValue());
                    System.out.println("\t\tOperator:" + operator);
                    System.out.println("\t\tArg:" + arg);
                }
                if (rowLoop == 1) {
                    rowLoop = (Integer)operand.getValue();
                }
                if (compound == 1) {
                    compound = (Integer)operand.getValue();
                }
                ret = "";
                if (templ instanceof String && rowLoop == -1 && compound == -1) {
                    return OutputWriter.handleElems((String)templ);
                }
                if (templ instanceof List && rowLoop == -1 && compound == -1) {
                    return OutputWriter.handleElems((List)templ);
                }
                if (rowLoop == -1) break block21;
                List tList = (List)templ;
                int ind = 0;
                int i = 0;
                while (i < rowLoop) {
                    ArrayList<String> templElem = new ArrayList<String>();
                    int endInd = tList.size() / rowLoop;
                    for (int j = 0; j < endInd; ++j) {
                        String templStr = (String)tList.get(ind);
                        templElem.add(templStr);
                        ++ind;
                    }
                    ret = ret + OutputWriter.handleElems(templElem);
                    if (++i == rowLoop) continue;
                    ret = ret + "\n";
                }
                break block22;
            }
            if (compound == -1) break block22;
            List tList = (List)templ;
            int ind = 1;
            int i = 0;
            while (ind < tList.size()) {
                ArrayList<String> templElem = new ArrayList<String>();
                boolean nline = false;
                int j = 0;
                while (!nline && ind < tList.size()) {
                    String templStr = (String)tList.get(ind);
                    if (templStr.startsWith("\\")) {
                        nline = true;
                        ++ind;
                    } else {
                        templElem.add(templStr);
                        ++ind;
                    }
                    ++j;
                }
                ret = ret + OutputWriter.handleElems(templElem);
                if (ind < tList.size()) {
                    ret = ret + "\n";
                }
                ++i;
            }
        }
        return ret;
    }

    public static String loop(Parameter op, String arg) {
        int lim = (Integer)op.getValue();
        String[] args = arg.split(",");
        String argn = "";
        String cat = "";
        for (int i = 0; i < lim; ++i) {
            for (int j = 0; j < args.length; ++j) {
                argn = args[j];
                if (argn.charAt(0) != '\\') {
                    if (argn.charAt(0) == '?' || argn.indexOf(35) != -1) {
                        String[] args2 = argn.split("r|c");
                        args2[0] = args2[0].substring(1);
                        argn = "#" + args2[0] + "+" + i + argn.charAt(args2[0].length() + 1) + args2[1];
                    }
                    if (i == 0 && j == 0) {
                        cat = cat + argn + "+" + i;
                        continue;
                    }
                    cat = cat + ',' + argn + "+" + i;
                    continue;
                }
                cat = i == 0 && j == 0 ? cat + "\\" : cat + ",\\";
            }
        }
        return cat;
    }
}

