/*
 * Decompiled with CFR 0.152.
 */
package core;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.List;

public class PhdWriter {
    public void writeResults(String path, List res) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(path));
            double[] x = (double[])res.get(0);
            double[] y = (double[])res.get(1);
            out.write("BEGIN IMS2.0\nMSG_TYPE DATA\nMSG_ID 00000000\nDATA_TYPE SAMPLEPHD\n#Header 3\n");
            out.write("n/a  n/a   P Simulated        FULL\n000\n11\n2\n");
            double w = x[1] - x[0];
            out.write("#g_Energy\n ");
            out.write((x[0] + w / 2.0) * 1000.0 + "   1.0       0.100000\n" + (x[1] + w / 2.0) * 1000.0 + "       2.0     0.100000\n");
            int N = 6;
            int step = x.length / N;
            int ind = 0;
            for (int i = 0; i < N; ++i) {
                if (ind != 0) {
                    out.write((x[ind] + w / 2.0) * 1000.0 + "   " + (ind + 1) + ".0       0.100000\n");
                }
                ind += step;
            }
            out.write("#g_Efficiency\n1000.000000     1.0     1.0\n2000.000000     1.0     1.0\n");
            out.write("#Comment\nCreated by AASI\nOrigin unknown\n");
            out.write("#g_Spectrum\n");
            String xlenStr = "" + x.length;
            String pad = "";
            for (int i = 0; i < 6 - xlenStr.length(); ++i) {
                pad = pad + " ";
            }
            out.write(x.length + pad + "" + (int)(x[x.length - 1] * 1000.0) + "\n");
            for (ind = 0; ind < x.length; ind += 5) {
                String str = ind + 1 + "";
                int offs = x.length - ind - 1;
                for (int i = 0; i < Math.min(5, offs); ++i) {
                    str = str + "         " + (int)y[ind + i];
                }
                out.write(str + "\n");
            }
            out.write("STOP");
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

