/*
 * Decompiled with CFR 0.152.
 */
package core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SikaOutputHandler
extends DefaultHandler {
    String value;
    private String chiSq = "chiSquared";
    private String fittedShape = "fittedShape";
    String phase;
    double chiSquared = -1.0;
    List multipliers = new ArrayList();
    List multiplierUncs = new ArrayList();
    boolean ecal = false;
    double slope = 1.0;
    double offset = 1.0;
    ArrayList shapeNames = new ArrayList();
    Hashtable shapeNamesToFiles = new Hashtable();
    int numShapes = 0;

    public boolean hasEnergyCalibration() {
        return this.ecal;
    }

    public double getSlope() {
        return this.slope;
    }

    public double getOffset() {
        return this.offset;
    }

    public String getShapeName(int shape) {
        return (String)this.shapeNames.get(shape);
    }

    public String getShapeFileName(String shapeName) {
        return (String)this.shapeNamesToFiles.get(shapeName);
    }

    public int getNumberOfShapes() {
        return this.numShapes;
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
        int ind;
        this.value = "";
        this.phase = localName;
        if (localName.equals(this.fittedShape)) {
            ind = atts.getIndex("multiplier");
            Double mul = new Double(atts.getValue(ind));
            ind = atts.getIndex("multiplierUncertainty");
            Double mulUnc = new Double(atts.getValue(ind));
            this.multipliers.add(mul);
            this.multiplierUncs.add(mulUnc);
            ind = atts.getIndex("name");
            String name = atts.getValue(ind);
            this.shapeNames.add(name);
            ind = atts.getIndex("file");
            this.shapeNamesToFiles.put(name, atts.getValue(ind));
            ++this.numShapes;
        }
        if (localName.equals("slope")) {
            this.ecal = true;
            ind = atts.getIndex("value");
            this.slope = Double.parseDouble(atts.getValue(ind));
        }
        if (localName.equals("offset")) {
            this.ecal = true;
            ind = atts.getIndex("value");
            this.offset = Double.parseDouble(atts.getValue(ind));
        }
    }

    public void endDocument() {
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (localName.equals(this.chiSq)) {
            this.chiSquared = Double.parseDouble(this.value);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length < 2 && Character.isWhitespace(ch[start])) {
            return;
        }
        this.value = this.value + new String(ch, start, length);
    }

    public List getMultipliers() {
        return this.multipliers;
    }

    public List getMultiplierUncertainties() {
        return this.multiplierUncs;
    }

    public double getChiSquared() {
        return this.chiSquared;
    }
}

