/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Parameter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public class TemplateReader {
    private static boolean debug = false;

    public List loadTemplate(String templatePath) {
        String line = null;
        ArrayList template = new ArrayList();
        String delim = "\\s,|,\\s|\\s+|,";
        String cond = "=|<|>|:";
        try {
            String[] tokens = null;
            Object param = null;
            BufferedReader in = new BufferedReader(new FileReader(templatePath));
            boolean compound = false;
            boolean compoundFirst = false;
            String cat = "";
            while ((line = in.readLine()) != null) {
                if (line.charAt(0) == '!' || line.charAt(0) == '\n') continue;
                line = TemplateReader.strip(line);
                if (!compound) {
                    cat = "";
                }
                if (line.endsWith("{")) {
                    compound = true;
                    compoundFirst = true;
                }
                if ((tokens = TemplateReader.tokens(line, delim)).length <= 0) continue;
                ArrayList<String> temp = new ArrayList<String>();
                for (int i = 0; i < tokens.length; ++i) {
                    if (tokens[i].charAt(0) == '?' || tokens[i].charAt(0) == '#' || compound) {
                        if (!compound) {
                            cat = "";
                        }
                        boolean stop = false;
                        for (int t = i; t < tokens.length && !stop; ++t) {
                            cat = cat + tokens[t];
                            if (t != tokens.length - 1) {
                                cat = cat + ",";
                            }
                            if (cat.charAt(cat.length() - 1) == ';') {
                                stop = true;
                            }
                            ++i;
                        }
                        if (stop) {
                            temp.add(cat);
                            compound = false;
                        } else {
                            cat = !compoundFirst ? cat + ",\\," : cat + "\\,";
                            compoundFirst = false;
                        }
                        if (!compound || !debug) continue;
                        System.out.println("Part of compound.");
                        continue;
                    }
                    temp.add(tokens[i]);
                }
                if (compound) continue;
                template.add(temp);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return template;
    }

    private static void setParamValueFloat(Parameter p, String value) {
        p.setValue(new Float(value));
    }

    private static String[] tokens(String string, String delim) {
        String[] tokens = null;
        if (Character.isWhitespace(string.charAt(0))) {
            string = string.replaceFirst("\\s+", "");
        }
        string = string.replaceFirst("!.*", "");
        if (debug) {
            System.out.println(string);
        }
        tokens = string.split(delim);
        return tokens;
    }

    private static String strip(String s) {
        s = s.replaceAll("\\s+|!.*|", "");
        return s;
    }
}

