/*
 * Decompiled with CFR 0.152.
 */
package org.stuk.visualization.graphs;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.stuk.visualization.graphs.Axis;
import org.stuk.visualization.graphs.GraphCanvas;
import org.stuk.visualization.graphs.XYGraph;

public class Points
extends XYGraph {
    public Points() {
        super(true);
    }

    public void render(GraphCanvas c, Graphics2D g, Axis a) {
        double trans = 0.0;
        double offs = this.getOffset();
        if (!Double.isNaN(offs)) {
            trans = offs;
        }
        g.setColor(this.color);
        Stroke old = g.getStroke();
        g.setStroke(new BasicStroke(this.strokeWidth, 0, 2));
        double w = a.getSize(0);
        for (int i = 1; i < this.range.length - 1; ++i) {
            double x1 = a.getAxisCoordinateForValue(this.range[i - 1] + trans, 0);
            double y1 = a.getAxisCoordinateForValue(this.domain[i - 1], 1);
            if (this.strokeWidth > 1.0f) {
                g.fillOval((int)(x1 - (double)(this.strokeWidth / 2.0f)), (int)(y1 - (double)(this.strokeWidth / 2.0f)), (int)this.strokeWidth, (int)this.strokeWidth);
                continue;
            }
            g.fillOval((int)x1, (int)y1, 1, 1);
        }
        g.setStroke(old);
    }
}

