/*
 * Decompiled with CFR 0.152.
 */
package org.stuk.visualization.polygonal;

import java.util.List;
import org.stuk.visualization.polygonal.RenderingPipeline;
import org.stuk.visualization.polygonal.Shader;
import org.stuk.visualization.polygonal.util.PolyUtils;

public class PhongShader
extends Shader {
    double[] dArray = new double[]{0.0, 0.0, 0.0, 255.0};
    double ambient;
    double diffuse;
    double specular;
    double Li = 1.0;
    double Kd = 0.4;
    double Ka = 0.1;
    double Ks = 0.6;
    double Rx;
    double Ry;
    double Rz;
    double[] R = new double[]{0.0, 0.0, 1.0};
    double Vx;
    double Vy;
    double Vz;
    double[] V = new double[]{0.0, 0.0, 1.0};
    double[] N = new double[]{0.0, 0.0, 0.0};
    double[] L = new double[]{0.0, 0.0, 0.0};
    double[] P = new double[]{0.0, 0.0, 0.0};
    double[] pl = new double[]{0.0, 0.0, 0.0};
    double[] pl2 = new double[]{0.0, 0.0, 0.0};
    double[] eyeToPos = new double[]{0.0, 0.0, 0.0};
    double shininess = 186.0;
    RenderingPipeline rp;

    public PhongShader(RenderingPipeline rp) {
        this.rp = rp;
    }

    public void shade(int x, int y, double[] data, boolean isEdge) {
        double[] vrp = (double[])this.rp.getGlobalData().get(0);
        double z = data[0];
        this.P[0] = data[1];
        this.P[1] = data[2];
        this.P[2] = data[3];
        this.N[0] = data[4];
        this.N[1] = data[5];
        this.N[2] = data[6];
        List lights = this.rp.getLights();
        this.L = (double[])lights.get(0);
        PolyUtils.minus(this.L, this.P, this.pl);
        PolyUtils.normalize(this.pl);
        this.ambient = this.Li * this.Ka;
        this.diffuse = PolyUtils.dot(this.pl, this.N) * this.Li * this.Kd;
        PolyUtils.minus(vrp, this.P, this.V);
        PolyUtils.normalize(this.V);
        PolyUtils.plus(this.V, this.pl, this.R);
        PolyUtils.mul(0.5, this.R, this.N);
        this.specular = Math.pow(PolyUtils.dot(this.N, this.V), this.shininess) * this.Ks;
        double I = this.ambient + this.diffuse + this.specular;
        if (I < 0.0) {
            I = 0.0;
        }
        if (I > 1.0) {
            I = 1.0;
        }
        this.dArray[0] = I *= 255.0;
        this.dArray[1] = I;
        this.dArray[2] = I;
        this.fb.set(x, y, z, this.dArray);
    }
}

