/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.CustomCellEditor;
import UI.ElementEditorPanel;
import UI.MainFrame;
import core.Element;
import core.Main;
import core.Parameter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class ElementEditor
extends CustomCellEditor
implements TableCellEditor {
    ElementEditorPanel p;
    MainFrame owner;
    JLabel btn = new JLabel();
    JDialog dialog;
    Element elem;
    Parameter param;
    JTable tab;
    JInternalFrame child;
    int elemBase;
    String numElemsHash;
    Parameter z;
    Parameter f;
    int row;
    boolean clearPres;
    String title;

    public ElementEditor(MainFrame owner, JInternalFrame child, String numElemsHash, int elemBase, String title) {
        this.child = child;
        this.numElemsHash = numElemsHash;
        this.owner = owner;
        this.elemBase = elemBase;
        this.title = title;
        this.btn.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ElementEditor.this.handle_mousePressed(e);
            }
        });
        this.dialog = new JDialog((Frame)owner, true);
        this.dialog.setTitle(title);
        this.p = new ElementEditorPanel(this.dialog);
        this.dialog.getContentPane().add(this.p);
    }

    public void updateUI() {
        this.btn = new JLabel();
        this.btn.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ElementEditor.this.handle_mousePressed(e);
            }
        });
        this.dialog = new JDialog((Frame)this.owner, true);
        this.dialog.setTitle(this.title);
        this.p = new ElementEditorPanel(this.dialog);
        this.dialog.getContentPane().add(this.p);
    }

    public void setClearPreset(boolean clear) {
        this.clearPres = clear;
    }

    private void setupPanelValues() {
        Parameter par = Main.getParameter(this.numElemsHash);
        int numElems = (Integer)par.getValue();
        String densKey = this.elemBase - 1 + "";
        Parameter dens = Main.getParameter(densKey);
        String thickKey = this.elemBase + 4 + "";
        Parameter thick = Main.getParameter(thickKey);
        String thFlKey = this.elemBase + 5 + "";
        Parameter thickFl = Main.getParameter(thFlKey);
        this.p.beginSetting();
        this.p.setDensity(dens);
        this.p.setNumElements(numElems);
        for (int i = 0; i < numElems; ++i) {
            String zkey = "" + this.elemBase;
            String akey = "" + (this.elemBase + 1);
            String fkey = "" + (this.elemBase + 2);
            zkey = zkey + "+" + i;
            akey = akey + "+" + i;
            fkey = fkey + "+" + i;
            Parameter z = Main.getParameter(zkey);
            Parameter a = Main.getParameter(akey);
            Parameter f = Main.getParameter(fkey);
            this.p.setZ(i, (Integer)z.getValue());
            this.p.setA(i, (Integer)a.getValue());
            this.p.setFraction(i, ((Float)f.getValue()).floatValue());
        }
        this.p.endSetting();
        if (this.clearPres) {
            this.p.setPreset(-1);
        }
    }

    public void handle_mousePressed(MouseEvent e) {
        Point pt = e.getPoint();
        SwingUtilities.convertPointToScreen(pt, (Component)e.getSource());
        this.dialog.setSize(660, 300);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        d.width /= 2;
        d.height /= 2;
        this.dialog.setLocation(d.width - this.dialog.getWidth() / 2, d.height - this.dialog.getHeight() / 2);
        this.setupPanelValues();
        this.dialog.setVisible(true);
        if (this.p.getStatus() == 1) {
            String densKey = this.elemBase - 1 + "";
            this.p.beginGetting();
            Parameter dens = Main.getParameter(densKey);
            dens.setValue(new Float(this.p.getDensity()));
            Parameter par = Main.getParameter(this.numElemsHash);
            par.setValue(new Integer(this.p.getNumElements()));
            int numElems = (Integer)par.getValue();
            for (int i = 0; i < numElems; ++i) {
                String zkey = "" + this.elemBase;
                String akey = "" + (this.elemBase + 1);
                String fkey = "" + (this.elemBase + 2);
                zkey = zkey + "+" + i;
                akey = akey + "+" + i;
                fkey = fkey + "+" + i;
                Parameter z = Main.getParameter(zkey);
                Parameter a = Main.getParameter(akey);
                Parameter f = Main.getParameter(fkey);
                if (i == this.row) {
                    this.f = f;
                    this.z = z;
                }
                if (z == null) {
                    z = Main.cloneParameter("" + this.elemBase + "+0", zkey);
                    a = Main.cloneParameter("" + (this.elemBase + 1) + "+0", akey);
                    f = Main.cloneParameter("" + (this.elemBase + 2) + "+0", fkey);
                }
                z.setValue(new Integer(this.p.getZ(i)));
                a.setValue(new Integer(this.p.getA(i)));
                f.setValue(new Float(this.p.getFraction(i)));
                this.fireEditingCanceled();
            }
            this.owner.loadMaterialTables();
        } else {
            this.fireEditingCanceled();
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        this.row = rowIndex;
        this.tab = table;
        return this.btn;
    }

    public String getMixtureName(List list) {
        return this.p.getMixtureName(list);
    }

    public Object getCellEditorValue() {
        Vector<Object> v = new Vector<Object>();
        Element e = new Element();
        Integer val = (Integer)this.z.getValue();
        e.setZ(val);
        e.setA(new Integer(this.p.getA(this.row)));
        v.add(e);
        v.add(this.f);
        return v;
    }
}

