/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.AtanAxis;
import UI.BasicEditor;
import UI.ColorComboboxRenderer;
import UI.Drawer;
import UI.FittingProgressMonitor;
import UI.FittingResultsFrame;
import UI.HeaderLabel;
import UI.MiniControlWidgets;
import UI.ParameterEditor;
import UI.ParameterNameRenderer;
import UI.ParameterRenderer;
import UI.Shelf;
import UI.SimulationResultsFrame;
import UI.TileLayout;
import UI.TreeRenderer;
import UI.UnitRenderer;
import core.FitInputReader;
import core.Fitter;
import core.Main;
import core.Parameter;
import core.PhdReader;
import core.PhdWriter;
import core.ResultsReader;
import core.ResultsWriter;
import core.SikaOutputReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.stuk.visualization.graphs.Axis;
import org.stuk.visualization.graphs.Graph;
import org.stuk.visualization.graphs.GraphCanvas;
import org.stuk.visualization.graphs.XYGraph;
import org.stuk.visualization.polygonal.util.PolyUtils;
import say.swing.JFontChooser;

public class FitPanel
extends JPanel {
    private DecimalFormat format;
    public static final int TOOL_NONE = 0;
    public static final int TOOL_ZOOM = 1;
    public static final int TOOL_PAN = 2;
    public static final int TOOL_TEXT = 3;
    public static final int TOOL_EVAL = 4;
    public static final int TOOL_SELECT = 5;
    public static final int TOOL_LINE = 6;
    public static final int TOOL_ERASER = 7;
    public static final int TOOL_FIT_RANGE = 8;
    public static final int TOOL_GRAB_RANGE = 9;
    public static final int MODE_XY = 1;
    public static final int MODE_X = 2;
    public static final int MODE_Y = 3;
    public static final int CS_VIEW = 1;
    public static final int CS_MODEL = 2;
    String rangeTarget = "shape";
    public static final int PT_START = 1;
    public static final int PT_END = 2;
    Color[] colors = new Color[]{Color.black, Color.blue, Color.red.darker(), Color.green.darker(), Color.orange.darker(), Color.yellow.darker()};
    int curColor = 0;
    private int toolCoordinates = 2;
    private int tool = 0;
    private int tool2 = 0;
    private int selectedPt = 0;
    private int panMode = 0;
    private double zoomf = 1.15;
    private int prevZoomType = 0;
    private RenderingHints hints;
    boolean toolDisabled = false;
    Point current = null;
    Hashtable graphs = new Hashtable();
    DropTarget dropTarget;
    private double defaultWidth = 2.0;
    private boolean started = false;
    private Font lastUserFont = new Font("Arial", 0, 10);
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Shape sources");
    DefaultMutableTreeNode session = new DefaultMutableTreeNode("Session");
    DefaultMutableTreeNode files = new DefaultMutableTreeNode("Aasi/shapes/");
    DefaultMutableTreeNode dbs = new DefaultMutableTreeNode("Database");
    boolean paramsValid = false;
    int variationRow = -1;
    Hashtable newParams = new Hashtable();
    boolean vardiagFloating = false;
    String perc = "%";
    Object abs = "mm";
    Properties settings = new Properties();
    boolean first = true;
    XYGraph cur = null;
    Hashtable graphsToNodes = new Hashtable();
    String targetFileName = "";
    XYGraph target = null;
    ArrayList simGraphs = new ArrayList();
    boolean search = false;
    JDialog tdialog = new JDialog();
    Font anfont;
    boolean isEditing = false;
    boolean isCreating = false;
    JTextArea field = new JTextArea();
    int ox;
    int oy;
    double ax;
    double ay;
    int zoomLevel = 1;
    double zoomAmnt = 0.5;
    Point shapeTreeMouse;
    final int BUFFER = 2048;
    boolean userRange = false;
    Hashtable graphsToRanges = new Hashtable();
    Point pprev = null;
    boolean loading = false;
    boolean iterating = false;
    double minChi = 100000.0;
    int minInd = -1;
    float minVal = -1.0f;
    Parameter newVal;
    Parameter par;
    float low;
    float high;
    int cInd = 0;
    ArrayList cgraphs = new ArrayList();
    ArrayList cresiduals = new ArrayList();
    ArrayList cabsorbed = null;
    XYGraph fresult;
    XYGraph residual;
    float res = -1.0f;
    int linSteps = 5;
    int binDepth = 5;
    ArrayList searchResults = new ArrayList();
    Fitter cfitter;
    Component echoPaneComp = null;
    boolean iterateFloating = false;
    Dimension floaterSize = null;
    Point floaterLoc = null;
    JDialog vardiag;
    ArrayList shapes = new ArrayList();
    FittingResultsFrame fr = null;
    private Hashtable graphsToMultipliers = new Hashtable();
    PageFormat currentFormat = null;
    int offsx = 0;
    int offsy = 0;
    double scalex = 1.0;
    double scaley = 1.0;
    Point start;
    Point end;
    boolean isClick = true;
    double targetEcalOffs = 0.0;
    double targetEcalSlope = 0.0;
    double targetOrigOffs = 0.0;
    double targetOrigSlope = 0.0;
    String chooserOpenHome = Main.workingDir;
    String chooserSaveHome = Main.workingDir;
    double logMax = -1.0;
    Hashtable widths = new Hashtable();
    double xmaxx = 7.0;
    double xminx = 7.0;
    double ymaxx = 0.0;
    JColorChooser jcc;
    JDialog dialog;
    boolean isDragging = false;
    String prevCs;
    String cs;
    Point p;
    double ovy = Double.POSITIVE_INFINITY;
    double ovx = 0.0;
    Object selectedObj;
    String type;
    String ptype;
    Font selectedFont;
    Object psel = null;
    int prevTool = 5;
    Point prev;
    private JToggleButton acquireFitRange;
    private JToggleButton acquireFitRange1;
    private JToggleButton addLineButton;
    private JToggleButton addLineTagButton;
    private JToggleButton addRangeButton;
    private JToggleButton addShapeButton;
    private JMenuItem addSourceItem;
    private JToggleButton addTextButton;
    private JToggleButton addTextTagButton;
    private JCheckBox antialiasingCheckbox;
    private JLabel areaLabel;
    private JTextField binDepthField;
    private JRadioButton binRadioButton;
    private JLabel clearMemBtn;
    private JMenuItem clearSessionItem;
    private JPanel colorPanel;
    private JLabel correction;
    private JLabel correction2;
    private JTextField correctionField;
    private ButtonGroup csButtonGroup;
    private JTextField curOffsField;
    private JTextField curSlopeField;
    private JMenuItem deleteFolderItem;
    private JButton deleteGraphButton;
    private JMenuItem deleteShapeItem;
    private JLabel depthLabel;
    private Drawer drawer1;
    private Drawer drawer2;
    private Drawer drawer3;
    private Drawer drawer4;
    private Drawer drawer5;
    private Drawer drawer6;
    private Drawer ecalDrawer;
    private JPanel ecalPanel;
    private Shelf ecalShelf;
    private JToggleButton evalButton;
    private JButton fitButton1;
    private JCheckBox fitEnergyCalibrationOffsCheckbox;
    private JCheckBox fitEnergyCalibrationSlopeCheckbox;
    private JButton fitManualButton;
    private JTextField fitMaxField;
    private JTextField fitMinField;
    private JTable fitShapesTable;
    private JPopupMenu fitShapesTablePopup;
    private JInternalFrame fittingPlotFrame;
    private JToggleButton grabFitRange;
    private GraphCanvas graphCanvas;
    private JTextField graphTitleField;
    private JComboBox graphsCombobox;
    private JComboBox graphsCombobox1;
    private widgets.HeaderLabel headerLabel1;
    private HeaderLabel headerLabel10;
    private HeaderLabel headerLabel11;
    private HeaderLabel headerLabel12;
    private HeaderLabel headerLabel13;
    private widgets.HeaderLabel headerLabel14;
    private HeaderLabel headerLabel15;
    private widgets.HeaderLabel headerLabel2;
    private HeaderLabel headerLabel3;
    private widgets.HeaderLabel headerLabel4;
    private HeaderLabel headerLabel5;
    private widgets.HeaderLabel headerLabel6;
    private HeaderLabel headerLabel8;
    private JCheckBox includeManualCheckbox;
    private JToggleButton infoToolButton;
    private JCheckBox jCheckBox1;
    private JDesktopPane jDesktopPane1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator12;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JToolBar jToolBar3;
    private JRadioButton linRadioButton;
    private JTextField linStepsField;
    private JPanel manualPanel;
    private MiniControlWidgets miniControlWidgets1;
    private JLabel navigationLabel;
    private JMenuItem newFolderItem;
    private JPanel northPanel;
    private JButton openBtn;
    private widgets.HeaderLabel openEcalPropertiesLabel;
    private JLabel openFitSetBtn;
    private widgets.HeaderLabel openGraphPropertiesLabel;
    private widgets.HeaderLabel openROIPropertiesLabel;
    private JLabel openShapeBtn;
    private JMenuItem openShapeItem;
    private JMenuItem openTargetMenuItem;
    private widgets.HeaderLabel openXPropertiesLabel;
    private widgets.HeaderLabel openYPropertiesLabel;
    private JTextField origOffsField;
    private JTextField origSlopeField;
    private JButton pageSetupBtn;
    private JToggleButton panButton;
    private JMenuItem panLeftItem;
    private JMenuItem panRightItem;
    private JInternalFrame parameterSearchFrame;
    private JMenu plotAnnotationsMenu;
    private JPanel plotColorPanel;
    private MiniControlWidgets plotControlWidgets;
    private JMenu plotFileMenu;
    private JPanel plotFillPanel;
    private JMenu plotGraphsMenu;
    private JMenu plotViewMenu;
    private JLabel plotWidthMinusBtn;
    private JLabel plotWidthPlusBtn;
    private JMenu plotZoomMenu;
    private JButton printBtn;
    private JCheckBoxMenuItem propertiesPaneItem;
    private ButtonGroup rangeGroup;
    private ButtonGroup rangeGroup1;
    private JToggleButton recalibrateButton;
    private JButton redoTicsX;
    private JButton redoTicsX1;
    private JButton redoTicsY;
    private JButton redoTicsY1;
    private JLabel refreshBtn;
    private JMenuItem refreshTreeItem;
    private JScrollPane regionsOfInterestPane;
    private JTable regionsOfInterestTable;
    private JPanel regionsPanel;
    private JMenuItem removeAllShapesItem;
    private JLabel removeObjectBtn;
    private JToggleButton removeRegionButton;
    private JLabel removeShapeBtn;
    private JMenuItem removeShapeItem;
    private JMenuItem renameFolderItem;
    private JMenuItem renameShapeItem;
    private JMenuItem replaceWithCurrentItem;
    private GraphCanvas residualCanvas;
    private JToggleButton restoreEcal;
    private JToggleButton restoreEcalButton;
    private JPanel rightPanel;
    private JButton saveBtn;
    private JMenuItem saveFigMenuItem;
    private JLabel saveFitSetBtn;
    private JLabel saveShapeBtn;
    private JMenuItem saveShapeItem;
    private JToggleButton selectButton;
    private JToggleButton selectButton1;
    private JToggleButton selectToolButton;
    private JLabel selectedObjectLabel;
    private JLabel selectionLabel;
    private JTextField sfitMaxField;
    private JTextField sfitMinField;
    private GraphCanvas shapeCanvas;
    private JInternalFrame shapeFittingFrame;
    private JTree shapeSourceTree;
    private JPopupMenu shapeTreePopup;
    private Shelf shelf1;
    private Shelf shelf4;
    private Shelf shelf5;
    private Shelf shelf7;
    private Shelf shelf8;
    private SimulationResultsFrame simulationResultsFrame1;
    private ButtonGroup stepStyleGroup;
    private JLabel stepsLabel;
    private JButton toFrontBtn;
    private JButton toFrontBtn1;
    private ButtonGroup toolsGroup;
    private ButtonGroup typeGroup;
    private ButtonGroup typeGroup1;
    private HeaderLabel varHeaderLabel;
    private JLabel varInfoLabel;
    private JTable variableParamsTable;
    private JCheckBoxMenuItem viewToolbarItem;
    private JLabel width;
    private JLabel width2;
    private JTextField widthField;
    private JRadioButton xAxisLinear;
    private JRadioButton xAxisLog;
    private JTextField xAxisTitleField;
    private JTextField xMaxField;
    private JTextField xMinField;
    private JRadioButton xRangeAutoButton;
    private JRadioButton xRangeButton;
    private HeaderLabel xRangeLabel;
    private JCheckBox xTicsCheckbox;
    private JButton xTitleFontBtn;
    private JRadioButton yAxisLinear;
    private JRadioButton yAxisLog;
    private JPanel yAxisPanel;
    private JPanel yAxisPanel1;
    private JPanel yAxisPanel2;
    private JTextField yAxisTitleField;
    private JTextField yMaxField;
    private JTextField yMinField;
    private JRadioButton yRangeAutoButton;
    private JRadioButton yRangeButton;
    private HeaderLabel yRangeLabel;
    private JCheckBox yTicsCheckbox;
    private JButton yTitleFontBtn;
    private JMenuItem zoomAllMenuItem;
    private JToggleButton zoomButton;
    private JMenuItem zoomInMenuItem;
    private JMenuItem zoomOutMenuItem;
    private JMenuItem zoomRoiMenuItem;

    public FitPanel() {
        this.initComponents();
        this.loadSettings();
        this.setupComponents();
        this.antialiasingCheckbox.setSelected(true);
        this.graphCanvas.setAntialiasingEnabled(true);
        this.northPanel.remove(this.antialiasingCheckbox);
        this.currentFormat = PrinterJob.getPrinterJob().defaultPage();
        this.currentFormat.setOrientation(0);
        this.format = new DecimalFormat();
        this.initDnd();
        DecimalFormatSymbols fs = this.format.getDecimalFormatSymbols();
        fs.setDecimalSeparator('.');
        this.format.setDecimalFormatSymbols(fs);
        this.format.setMaximumFractionDigits(2);
        this.xRangeLabel.setText(" " + this.graphCanvas.getAxis().getTitle(0) + " plot range");
        this.yRangeLabel.setText(" " + this.graphCanvas.getAxis().getTitle(1) + " plot range");
        this.graphCanvas.refresh();
    }

    public JInternalFrame getPlotFrame() {
        return this.fittingPlotFrame;
    }

    public void enablePlotToolbar(boolean enabled) {
        this.plotControlWidgets.setEnabled(enabled);
        this.selectToolButton.setEnabled(enabled);
        this.infoToolButton.setEnabled(enabled);
        this.graphsCombobox1.setEnabled(enabled);
        this.navigationLabel.setEnabled(enabled);
        this.selectionLabel.setEnabled(enabled);
        this.selectedObjectLabel.setEnabled(enabled);
        this.plotWidthPlusBtn.setEnabled(enabled);
        this.plotWidthMinusBtn.setEnabled(enabled);
        this.removeObjectBtn.setEnabled(enabled);
        this.plotZoomMenu.setEnabled(enabled);
        this.plotGraphsMenu.setEnabled(enabled);
        this.plotFillPanel.setEnabled(enabled);
        this.drawer1.setEnabledAll(enabled);
        this.drawer2.setEnabledAll(enabled);
        this.drawer3.setEnabledAll(enabled);
        this.drawer4.setEnabledAll(enabled);
        this.drawer6.setEnabledAll(enabled);
        this.ecalDrawer.setEnabledAll(enabled);
    }

    private void addDir(File dir, DefaultMutableTreeNode under) {
        try {
            File[] child = dir.listFiles();
            for (int i = 0; i < child.length; ++i) {
                DefaultMutableTreeNode n;
                if (child[i].isDirectory()) {
                    if (child[i].listFiles().length <= 0) continue;
                    n = new DefaultMutableTreeNode(child[i].getName());
                    under.add(n);
                    this.addDir(child[i], n);
                    continue;
                }
                n = new DefaultMutableTreeNode(child[i]);
                under.add(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void invalidateVariableParams() {
        this.paramsValid = false;
    }

    private void initTree() {
        this.session = new DefaultMutableTreeNode("Session");
        this.files = new DefaultMutableTreeNode("Aasi/shapes/");
        this.dbs = new DefaultMutableTreeNode("Database");
        this.root.add(this.session);
        this.root.add(this.files);
        this.root.add(this.dbs);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.shapeSourceTree.setModel(treeModel);
        File f = new File("../shapes");
        this.addDir(f, this.files);
    }

    private void setupShapesAndTarget(FitInputReader reader) {
        int n = this.fitShapesTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Double start = null;
            Double end = null;
            Object key = this.fitShapesTable.getValueAt(i, 0);
            Graph g = (Graph)this.graphs.get(key);
            String val = reader.getAttributeFor(g.getTitle(), "isFixed");
            if (val != null && val.length() > 0) {
                this.fitShapesTable.setValueAt(new Boolean(val), i, 1);
            }
            if ((val = reader.getAttributeFor(g.getTitle(), "priority")) != null && val.length() > 0) {
                this.fitShapesTable.setValueAt(new Integer(val), i, 2);
            }
            if ((val = reader.getAttributeFor(g.getTitle(), "regionStart")) != null && val.length() > 0) {
                start = new Double(val);
            }
            if ((val = reader.getAttributeFor(g.getTitle(), "regionEnd")) != null && val.length() > 0) {
                end = new Double(val);
            }
            if (start != null && end != null) {
                double[] range = new double[]{start, end};
                this.graphsToRanges.put(g, range);
            }
            if ((val = reader.getAttributeFor(g.getTitle(), "multiplier")) == null || val.length() <= 0) continue;
            this.graphsToMultipliers.put(g, new Double(val));
        }
        String val2 = null;
        String val = null;
        int i = 0;
        do {
            val = reader.getAttributeFor("fitInterval" + i, "start");
            val2 = reader.getAttributeFor("fitInterval" + i, "end");
            if (val == null) continue;
            this.fitMinField.setText("" + Float.parseFloat(val));
            this.fitMaxField.setText("" + Float.parseFloat(val2));
            this.addRangeButtonActionPerformed(null);
            ++i;
        } while (val != null);
    }

    private void initTable(final JTable table) {
        table.getColumnModel().getColumn(0).setPreferredWidth(195);
        table.getColumnModel().getColumn(1).setPreferredWidth(52);
        table.getColumnModel().getColumn(2).setPreferredWidth(38);
        table.getColumnModel().getColumn(0).setCellRenderer(new ParameterNameRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
                Component c = super.getTableCellRendererComponent(table, value, false, hasFocus, rowIndex, vColIndex);
                if (!((Boolean)table.getValueAt(rowIndex, 3)).booleanValue()) {
                    c.setEnabled(false);
                } else {
                    c.setEnabled(true);
                }
                return c;
            }
        });
        table.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        table.getColumnModel().getColumn(2).setCellRenderer(new UnitRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
                Component c = super.getTableCellRendererComponent(table, value, false, hasFocus, rowIndex, vColIndex);
                if (!((Boolean)table.getValueAt(rowIndex, 3)).booleanValue()) {
                    c.setEnabled(false);
                } else {
                    c.setEnabled(true);
                }
                return c;
            }
        });
        table.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        JCheckBox cb = new JCheckBox();
        final JLabel cob = new JLabel();
        table.getModel().addTableModelListener(new TableModelListener(){
            boolean editing = false;

            public void tableChanged(TableModelEvent e) {
                if (this.editing) {
                    return;
                }
                this.editing = true;
                int c = e.getColumn();
                int r = e.getFirstRow();
                if (c == 3) {
                    FitPanel.this.variationRow = r;
                    FitPanel.this.fitButton1.setEnabled(true);
                    FitPanel.this.paramsValid = true;
                    Parameter p = (Parameter)table.getValueAt(r, 0);
                    FitPanel.this.fitButton1.setText("Search " + p.getName());
                    cob.setText(p.getUnit());
                    for (int i = 0; i < table.getRowCount(); ++i) {
                        if (i == r) continue;
                        table.setValueAt(new Boolean(false), i, c);
                    }
                }
                this.editing = false;
                table.repaint();
            }
        });
        table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(cb));
        table.getColumnModel().getColumn(3).setCellRenderer(new DefaultTableCellRenderer(){
            JRadioButton box = new JRadioButton();
            JLabel lab = new JLabel();

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
                if (value instanceof Boolean) {
                    this.box.setSelected((Boolean)value);
                    return this.box;
                }
                return this.lab;
            }
        });
        table.getColumnModel().getColumn(4).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
                Component c = super.getTableCellRendererComponent(table, value, false, hasFocus, rowIndex, vColIndex);
                if (!((Boolean)table.getValueAt(rowIndex, 3)).booleanValue()) {
                    ((JLabel)c).setOpaque(false);
                    c.setEnabled(false);
                } else {
                    ((JLabel)c).setOpaque(true);
                    c.setEnabled(true);
                }
                return c;
            }
        });
        table.getColumnModel().getColumn(5).setCellRenderer(new DefaultTableCellRenderer(){
            JLabel box = new JLabel();

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
                Component c = super.getTableCellRendererComponent(table, value, false, hasFocus, rowIndex, vColIndex);
                Parameter p = (Parameter)table.getValueAt(rowIndex, 0);
                this.box.setText(p.getUnit());
                c = this.box;
                if (!((Boolean)table.getValueAt(rowIndex, 3)).booleanValue()) {
                    c.setEnabled(false);
                } else {
                    c.setEnabled(true);
                }
                return c;
            }
        });
        table.getColumnModel().getColumn(4).setCellEditor(new BasicEditor());
        table.setRowHeight(table.getRowHeight() + 2);
    }

    private void setupComponents() {
        boolean old = this.loading;
        this.loading = true;
        this.ecalDrawer.setEnabledAll(false);
        this.drawer1.setEnabledAll(false);
        this.drawer2.setEnabledAll(false);
        this.drawer3.setEnabledAll(false);
        this.drawer4.setEnabledAll(false);
        this.drawer6.setEnabledAll(false);
        final JCheckBox di = new JCheckBox();
        di.setOpaque(false);
        this.fitShapesTable.getColumnModel().getColumn(0).setCellRenderer(new TableCellRenderer(){
            JLabel label = new JLabel();

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
                if (value != null) {
                    if (value instanceof HeaderLabel) {
                        this.label.setText(((HeaderLabel)value).getText());
                    } else {
                        this.label.setText(((File)value).getName());
                    }
                    if (isSelected) {
                        this.label.setOpaque(true);
                        this.label.setBackground(Color.black);
                        this.label.setForeground(Color.white);
                    } else {
                        this.label.setOpaque(false);
                        if (value instanceof HeaderLabel) {
                            this.label.setForeground(((HeaderLabel)value).getTextColor());
                        } else {
                            this.label.setForeground(Color.black);
                        }
                    }
                    return this.label;
                }
                this.label.setText("");
                this.label.setOpaque(false);
                return this.label;
            }

            public void validate() {
            }

            public void revalidate() {
            }

            protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            }

            public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
            }
        });
        this.fitShapesTable.getColumnModel().getColumn(1).setCellRenderer(new TableCellRenderer(){
            JLabel label = new JLabel();

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
                if (value != null) {
                    Boolean val = (Boolean)value;
                    di.setSelected(val);
                    return di;
                }
                return this.label;
            }

            public void validate() {
            }

            public void revalidate() {
            }

            protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            }

            public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
            }
        });
        JComboBox<Integer> box = new JComboBox<Integer>();
        for (int i = 0; i < 10; ++i) {
            box.addItem(new Integer(i));
        }
        JCheckBox editor = new JCheckBox();
        editor.setOpaque(false);
        this.fitShapesTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(editor));
        this.fitShapesTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(box));
        this.fitShapesTable.getColumnModel().getColumn(1).setMaxWidth(50);
        this.fitShapesTable.getColumnModel().getColumn(2).setMaxWidth(50);
        this.plotControlWidgets.addSecondaryCanvas(this.residualCanvas);
        this.plotControlWidgets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JLabel) {
                    return;
                }
                FitPanel.this.unselectAllTools();
                if (FitPanel.this.graphCanvas.getSelected() != null) {
                    FitPanel.this.graphCanvas.setSelected(null);
                    FitPanel.this.graphCanvas.refresh();
                    FitPanel.this.graphCanvas.repaint();
                }
            }
        });
        this.loading = false;
    }

    private String encodeFont(Font f) {
        String str = f.getFamily();
        int style = f.getStyle();
        if (style == 1) {
            str = str + "-BOLD";
        }
        if (style == 0) {
            str = str + "-PLAIN";
        }
        if (style == 2) {
            str = str + "-ITALIC";
        }
        if (style == 3) {
            str = str + "-BOLDITALIC";
        }
        str = str + "-" + f.getSize();
        return str;
    }

    public void setVariableParameters(JTable params, String sourceType) {
        int i;
        if (this.paramsValid) {
            return;
        }
        this.fitButton1.setEnabled(false);
        this.fitButton1.setText("Search");
        this.varInfoLabel.setText(sourceType + " is selected in the 'Source' page.");
        this.varHeaderLabel.setText(" Variable parameters for " + sourceType);
        int n = this.variableParamsTable.getRowCount();
        for (i = 0; i < n; ++i) {
            ((DefaultTableModel)this.variableParamsTable.getModel()).removeRow(0);
        }
        n = params.getRowCount();
        for (i = 0; i < n; ++i) {
            Object[] data = new Object[]{params.getValueAt(i, 0), params.getValueAt(i, 1), params.getValueAt(i, 2), new Boolean(false), new Float(1.0), this.perc};
            ((DefaultTableModel)this.variableParamsTable.getModel()).addRow(data);
        }
    }

    public void saveSettings() {
        if (!this.started) {
            System.out.println("Can't save settings!!");
            return;
        }
        try {
            File f = new File("./lib/fit.prs");
            this.settings.setProperty("x_axis_properties_open", this.drawer1.isMinimized() ? "false" : "true");
            this.settings.setProperty("y_axis_properties_open", this.drawer2.isMinimized() ? "false" : "true");
            this.settings.setProperty("graph_properties_open", this.drawer3.isMinimized() ? "false" : "true");
            this.settings.setProperty("x_axis_linear", this.graphCanvas.getAxis().isLogarithmic(0) ? "false" : "true");
            this.settings.setProperty("y_axis_linear", this.graphCanvas.getAxis().isLogarithmic(1) ? "false" : "true");
            this.settings.setProperty("default_graph_width", this.defaultWidth + "");
            Axis a = this.graphCanvas.getAxis();
            this.settings.setProperty("x_tic_font", this.encodeFont(a.getTicFont(0)));
            this.settings.setProperty("y_tic_font", this.encodeFont(a.getTicFont(1)));
            this.settings.setProperty("x_title_font", this.encodeFont(a.getTitleFont(0)));
            this.settings.setProperty("y_title_font", this.encodeFont(a.getTitleFont(1)));
            this.settings.setProperty("last_user_font", this.encodeFont(this.lastUserFont));
            this.settings.setProperty("vertical_divider_loc", this.jSplitPane1.getDividerLocation() + "");
            FileOutputStream fos = new FileOutputStream(f);
            this.settings.store(fos, "Fit settings");
            fos.close();
            System.out.println("Settings saved!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadSettings() {
        try {
            File f = new File("./lib/fit.prs");
            FileInputStream fis = new FileInputStream(f);
            this.settings.load(fis);
            fis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String s = this.settings.getProperty("x_axis_linear", "true");
        s = this.settings.getProperty("y_axis_linear", "true");
        if (s.equals("false")) {
            this.yAxisLogActionPerformed(null);
        }
        Axis a = this.graphCanvas.getAxis();
        s = this.settings.getProperty("x_tic_font", "Arial-PLAIN-10");
        Font f = Font.decode(s);
        a.setTicFont(f, 0);
        s = this.settings.getProperty("y_tic_font", "Arial-PLAIN-10");
        Font f1 = Font.decode(s);
        a.setTicFont(f1, 1);
        s = this.settings.getProperty("x_title_font", "Arial-BOLD-18");
        Font f2 = Font.decode(s);
        a.setTitleFont(f2, 0);
        s = this.settings.getProperty("y_title_font", "Arial-BOLD-18");
        Font f3 = Font.decode(s);
        a.setTitleFont(f3, 1);
        s = this.settings.getProperty("last_user_font", "Arial-PLAIN-10");
        this.lastUserFont = Font.decode(s);
        s = this.settings.getProperty("default_graph_width", "2.0");
        try {
            double d;
            this.defaultWidth = d = Double.parseDouble(s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        s = this.settings.getProperty("vertical_divider_loc");
        if (s != null) {
            this.jSplitPane1.setDividerLocation(Integer.parseInt(s));
        }
    }

    private void initDnd() {
        this.dropTarget = new DropTarget(){

            public void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(1);
                Transferable tr = dtde.getTransferable();
                FitPanel.this.handlePaste(tr);
                dtde.dropComplete(true);
            }
        };
        this.graphCanvas.setDropTarget(this.dropTarget);
    }

    public void start() {
        this.graphCanvas.start();
        this.residualCanvas.start();
        this.loadSettings();
        this.started = true;
    }

    public void setAxisTitles(String titleX, String titleY) {
        this.xAxisTitleField.setText(titleX);
        this.yAxisTitleField.setText(titleY);
        this.xAxisTitleFieldActionPerformed(null);
        this.yAxisTitleFieldActionPerformed(null);
    }

    private void activateTool(int atool) {
        if (atool == 5) {
            this.selectButton.setSelected(true);
            this.tool = 5;
        } else if (atool == 3) {
            this.addTextButton.setSelected(true);
            this.tool = 3;
        } else if (atool == 6) {
            this.addLineButton.setSelected(true);
            this.tool = 6;
        }
    }

    public void addGraph(Graph graph, boolean genColor, boolean isTarget) {
        Axis a;
        if (!this.started) {
            this.start();
        }
        if (!this.graphCanvas.isStarted()) {
            this.graphCanvas.start();
        }
        if (!this.residualCanvas.isStarted()) {
            this.residualCanvas.start();
        }
        this.cur = (XYGraph)graph;
        if (this.iterating && !isTarget) {
            return;
        }
        if (this.first) {
            a = this.graphCanvas.getAxis();
            a.setTitle("Energy (MeV)", 0);
            this.xAxisTitleField.setText("Energy (MeV)");
            a.setTitle("Counts", 1);
            this.yAxisTitleField.setText("Counts");
            this.graphCanvas.getAxis().setMinMax(graph.getXmin(), graph.getYmin(), graph.getXmax(), graph.getYmax());
            this.xMinField.setText(this.format.format(graph.getXmin()));
            this.xMaxField.setText(this.format.format(graph.getXmax()));
            this.yMinField.setText(this.format.format(graph.getYmin()));
            this.yMaxField.setText(this.format.format(graph.getYmax()));
            a.setLogarithmic(true, 1);
        }
        a = this.graphCanvas.getAxis();
        a.setLogarithmic(true, 1);
        if (genColor) {
            graph.setColor(this.colors[this.curColor++ % this.colors.length]);
        }
        graph.setStrokeWidth((float)this.defaultWidth);
        if (isTarget) {
            this.graphCanvas.addGraph(graph);
        }
        HeaderLabel l = new HeaderLabel();
        l.setFore(graph.getColor());
        l.setBack(Color.white);
        l.setBackground(Color.white);
        l.setOpaque(true);
        l.setText(graph.toString());
        this.graphs.put(l, graph);
        if (!isTarget) {
            if (!graph.getTitle().equals("sum")) {
                DefaultMutableTreeNode n = new DefaultMutableTreeNode(l);
                this.graphsToNodes.put(graph, n);
                this.session.add(n);
                int[] indices = new int[]{this.session.getIndex(n)};
                ((DefaultTreeModel)this.shapeSourceTree.getModel()).nodesWereInserted(this.session, indices);
                this.graphsCombobox.addItem(l);
            }
        } else {
            JTabbedPane pane = (JTabbedPane)this.getParent();
            pane.setEnabledAt(7, true);
            this.graphsCombobox1.addItem(l);
            this.fittingPlotFrame.reshape(20, 20, this.fittingPlotFrame.getParent().getWidth() - 20, this.fittingPlotFrame.getParent().getHeight() - 20);
            this.enablePlotToolbar(true);
        }
        if (!isTarget) {
            this.graphsCombobox.setSelectedItem(l);
        }
        this.widthField.setText(graph.getStrokeWidth() + "");
        if (this.first) {
            this.graphCanvas.getAxis().setTics(10);
        }
        if (this.first) {
            this.residualCanvas.getAxis().setDrawTicks(false, 0);
        }
        if (this.xRangeAutoButton.isSelected()) {
            this.xRangeAutoButtonActionPerformed(null);
        }
        if (this.yRangeAutoButton.isSelected()) {
            this.yRangeAutoButtonActionPerformed(null);
        }
        this.residualCanvas.refresh();
        this.graphCanvas.refresh();
        this.first = false;
    }

    private double getMax() {
        double max = 1.0;
        Iterator iter = this.graphCanvas.getGraphs().iterator();
        while (iter.hasNext()) {
            Graph g = (Graph)iter.next();
            double ymax = g.getYmax();
            if (!(ymax > max)) continue;
            max = ymax;
        }
        return max;
    }

    public void addTarget(Graph graph) {
        this.addTarget(graph, false);
    }

    public void addTarget(Graph graph, boolean ecal) {
        this.loading = true;
        if (!ecal) {
            this.targetEcalOffs = 0.0;
            this.targetEcalSlope = 0.0;
            this.getEnergyCalibration((XYGraph)graph);
            this.targetOrigOffs = this.targetEcalOffs;
            this.targetOrigSlope = this.targetEcalSlope;
        }
        this.graphCanvas.getGraphs().clear();
        this.residualCanvas.getGraphs().clear();
        this.graphCanvas.getAnnotations().clear();
        this.graphsCombobox1.removeAllItems();
        this.target = (XYGraph)graph;
        this.target.setColor(Color.gray);
        this.target.setFilled(true);
        this.curOffsField.setText((double)((long)(this.targetEcalOffs * 1000.0)) / 1000000.0 + "");
        this.curSlopeField.setText((double)((long)(this.targetEcalSlope * 1000.0)) / 1000000.0 + "");
        this.origOffsField.setText((double)((long)(this.targetEcalOffs * 1000.0)) / 1000000.0 + "");
        this.origSlopeField.setText((double)((long)(this.targetEcalSlope * 1000.0)) / 1000000.0 + "");
        this.fittingPlotFrame.setTitle("Fitting plot for " + this.targetFileName);
        this.addGraph(graph, false, true);
        this.loading = false;
    }

    public void addGraph(Graph graph, boolean genColor) {
        if (this.search) {
            this.simGraphs.add(graph);
        } else {
            this.addGraph(graph, genColor, false);
        }
    }

    private void addTextDialog(int x, int y) {
        this.addTextDialog(x, y, null, null, null);
    }

    private void addTextAnnotation() {
        if (!this.field.getText().equals("")) {
            this.graphCanvas.addAnnotation(this.field.getForeground());
            this.graphCanvas.addAnnotation(this.field.getFont());
            this.lastUserFont = this.field.getFont();
            String text = this.field.getText();
            this.graphCanvas.addAnnotation(text);
            if (this.toolCoordinates == 2) {
                double[] loc = new double[]{this.ax, this.ay};
                this.graphCanvas.addAnnotation(loc);
                System.out.println("Added String to MODEL_CS.");
            } else {
                System.out.println("Added String to VIEW_CS.");
                int[] loc = new int[]{this.ox, this.oy};
                this.graphCanvas.addAnnotation(loc);
            }
            this.isEditing = false;
            this.tdialog.dispose();
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        } else {
            this.isEditing = false;
            this.tdialog.dispose();
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        }
    }

    private void addTextDialog(int x, int y, String msg, Font f, Color c) {
        this.toolDisabled = true;
        this.disableAllTools();
        if (this.tdialog != null && this.tdialog.isShowing()) {
            return;
        }
        this.anfont = null;
        this.ox = x;
        this.oy = y;
        String orig = msg;
        this.tdialog = new JDialog(JOptionPane.getFrameForComponent(this));
        this.field = new JTextArea();
        this.field.setLineWrap(false);
        if (f != null) {
            this.field.setFont(f);
        } else if (this.lastUserFont != null) {
            this.field.setFont(this.lastUserFont);
        }
        try {
            if (msg != null) {
                this.field.getDocument().insertString(0, msg, null);
            } else {
                this.field.setText("");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (c != null) {
            this.field.setForeground(c);
        }
        this.field.setBackground(Color.lightGray);
        this.ax = this.graphCanvas.getAxis().getValueForAxisCoordinate(x - this.graphCanvas.getXInset(), 0);
        int al = this.graphCanvas.getAxis().getLocation().y;
        this.ay = this.graphCanvas.getAxis().getValueForAxisCoordinate(al - y, 1);
        this.tdialog.getContentPane().setLayout(new FlowLayout(0, 0, 0));
        this.tdialog.getContentPane().setBackground(Color.white);
        final JButton font = new JButton();
        final JButton color = new JButton();
        font.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/FontIcon.png")));
        color.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/FontColorIcon.png")));
        int offs = 0;
        int maxlen = 1;
        try {
            for (int i = 0; i < this.field.getLineCount(); ++i) {
                int coffs = this.field.getLineStartOffset(i);
                int len = coffs - offs;
                if (len > maxlen) {
                    maxlen = len;
                }
                offs = coffs;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.field.setColumns(maxlen + 1);
        this.field.setMaximumSize(new Dimension(100000, 100000));
        this.field.setSize(this.field.getWidth(), font.getHeight());
        this.field.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FitPanel.this.tdialog.invalidate();
                int offs = 0;
                int maxlen = -1;
                try {
                    for (int i = 0; i < FitPanel.this.field.getLineCount(); ++i) {
                        int coffs = FitPanel.this.field.getLineStartOffset(i);
                        int len = FitPanel.this.field.getLineEndOffset(i) - FitPanel.this.field.getLineStartOffset(i);
                        if (len > maxlen) {
                            maxlen = len;
                        }
                        offs = coffs;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (maxlen > 0) {
                    FitPanel.this.field.setColumns(maxlen);
                }
                System.out.println("Maxlen:" + maxlen);
                FitPanel.this.tdialog.pack();
                FitPanel.this.tdialog.validate();
                if (e.getKeyCode() == 27) {
                    if (!FitPanel.this.isEditing) {
                        FitPanel.this.tdialog.dispose();
                        FitPanel.this.isEditing = false;
                    } else {
                        if (FitPanel.this.field.getText().equals("")) {
                            FitPanel.this.graphCanvas.refresh();
                            FitPanel.this.graphCanvas.repaint();
                            FitPanel.this.toolDisabled = true;
                            FitPanel.this.prev = null;
                            FitPanel.this.activateTool(FitPanel.this.prevTool);
                            FitPanel.this.isEditing = false;
                            return;
                        }
                        FitPanel.this.addTextAnnotation();
                        FitPanel.this.toolDisabled = true;
                        FitPanel.this.prev = null;
                        FitPanel.this.isEditing = false;
                        FitPanel.this.activateTool(FitPanel.this.prevTool);
                        FitPanel.this.tdialog.dispose();
                    }
                    FitPanel.this.graphCanvas.refresh();
                    FitPanel.this.graphCanvas.repaint();
                }
            }
        });
        font.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FitPanel.this.toolDisabled = true;
                JFontChooser chooser = new JFontChooser();
                chooser.setSelectedFont(FitPanel.this.field.getFont());
                int retval = chooser.showDialog(FitPanel.this.graphCanvas);
                if (retval == 0) {
                    FitPanel.this.anfont = chooser.getSelectedFont();
                    FitPanel.this.field.setFont(FitPanel.this.anfont);
                    FitPanel.this.lastUserFont = chooser.getSelectedFont();
                }
                FitPanel.this.field.grabFocus();
            }
        });
        color.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FitPanel.this.toolDisabled = true;
                if (FitPanel.this.jcc == null) {
                    FitPanel.this.jcc = new JColorChooser();
                }
                FitPanel.this.dialog = JColorChooser.createDialog(FitPanel.this.colorPanel, "Graph color", true, FitPanel.this.jcc, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        (this).FitPanel.this.field.setForeground((this).FitPanel.this.jcc.getColor());
                        (this).FitPanel.this.field.grabFocus();
                    }
                }, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        (this).FitPanel.this.field.grabFocus();
                    }
                });
                FitPanel.this.dialog.show();
            }
        });
        this.field.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent evnt) {
                Component c = evnt.getOppositeComponent();
                if (c == font || c == color) {
                    return;
                }
                FitPanel.this.enableAllTools();
                FitPanel.this.isClick = false;
                FitPanel.this.addTextAnnotation();
                FitPanel.this.activateTool(FitPanel.this.prevTool);
                FitPanel.this.toolDisabled = true;
                FitPanel.this.prev = null;
                FitPanel.this.isEditing = false;
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.tdialog.setTitle("Add text");
        this.tdialog.getContentPane().add((Component)this.field, "West");
        this.tdialog.getContentPane().add((Component)font, "Center");
        this.tdialog.getContentPane().add((Component)color, "East");
        Point pt = new Point(x, y);
        SwingUtilities.convertPointToScreen(pt, this.graphCanvas);
        this.field.setOpaque(true);
        this.tdialog.setUndecorated(true);
        this.tdialog.pack();
        this.tdialog.setLocation(pt.x, pt.y - this.tdialog.getHeight() / 2);
        this.tdialog.show();
    }

    public Fitter buildFitter() {
        Fitter fitter = new Fitter();
        fitter.setFitTarget(this.target);
        this.addRegionsOfInterest(fitter);
        this.addManualShapes(fitter);
        if (this.fitEnergyCalibrationSlopeCheckbox.isSelected() || this.fitEnergyCalibrationOffsCheckbox.isSelected()) {
            if (this.targetEcalSlope == 0.0) {
                this.getEnergyCalibration(this.target);
            }
            fitter.setEnergyCalibration(this.targetEcalSlope, this.targetEcalOffs, this.fitEnergyCalibrationSlopeCheckbox.isSelected(), this.fitEnergyCalibrationOffsCheckbox.isSelected());
        }
        return fitter;
    }

    private void disableAllTools() {
        this.selectButton.setEnabled(false);
        this.selectButton1.setEnabled(false);
        this.addLineButton.setEnabled(false);
        this.addTextButton.setEnabled(false);
        this.addLineTagButton.setEnabled(false);
        this.addTextTagButton.setEnabled(false);
        this.zoomButton.setEnabled(false);
        this.panButton.setEnabled(false);
        this.evalButton.setEnabled(false);
    }

    private void enableAllTools() {
        this.selectButton.setEnabled(true);
        this.selectButton1.setEnabled(true);
        this.addLineButton.setEnabled(true);
        this.addTextButton.setEnabled(true);
        this.addLineTagButton.setEnabled(true);
        this.addTextTagButton.setEnabled(true);
        this.zoomButton.setEnabled(true);
        this.panButton.setEnabled(true);
        this.evalButton.setEnabled(true);
    }

    private void unselectAllTools() {
        this.infoToolButton.setSelected(false);
        this.selectToolButton.setSelected(false);
        this.infoToolButton.setBackground(this.grabFitRange.getBackground());
        this.selectToolButton.setBackground(this.grabFitRange.getBackground());
        this.tool = 0;
    }

    private void deleteSelectedObject() {
        if (this.selectedObj == null) {
            return;
        }
        List l = this.graphCanvas.getAnnotations();
        int index = l.indexOf(this.selectedObj);
        if (this.selectedObj instanceof String) {
            l.remove(index - 2);
            l.remove(index - 2);
            l.remove(index - 2);
            l.remove(index - 2);
        } else if (this.selectedObj instanceof Image) {
            l.remove(index);
            l.remove(index);
        } else if (this.selectedObj instanceof double[] || this.selectedObj instanceof int[]) {
            l.remove(index);
        }
        this.toolDisabled = true;
        this.prev = null;
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
        this.selectedObj = null;
    }

    private int getScreenX(double dx, GraphCanvas canvas) {
        int xi = canvas.getXInset();
        int x = xi + (int)canvas.getAxis().getAxisCoordinateForValue(dx, 0);
        return x;
    }

    private int getScreenY(double vy, GraphCanvas canvas) {
        int yi = canvas.getYInset();
        int h = canvas.getHeight();
        int y = h - yi - (int)canvas.getAxis().getAxisCoordinateForValue(vy, 1);
        return y;
    }

    private double getValue(int y, GraphCanvas canvas) {
        Axis a = canvas.getAxis();
        int ay = canvas.getHeight() - canvas.getYInset() - y;
        return a.getValueForAxisCoordinate(ay, 1);
    }

    public Graph getSelectedGraph(boolean fromPlot) {
        if (fromPlot) {
            return (Graph)this.graphs.get(this.graphsCombobox1.getSelectedItem());
        }
        return (Graph)this.graphs.get(this.graphsCombobox.getSelectedItem());
    }

    public Graph getSelectedGraph() {
        return this.getSelectedGraph(false);
    }

    private double getDomain(int x, GraphCanvas canvas) {
        Axis a = canvas.getAxis();
        return a.getValueForAxisCoordinate(x - canvas.getXInset(), 0);
    }

    private DefaultMutableTreeNode getSelectedNode() {
        TreePath p = this.shapeSourceTree.getSelectionPath();
        return (DefaultMutableTreeNode)p.getLastPathComponent();
    }

    private void initComponents() {
        this.rangeGroup = new ButtonGroup();
        this.typeGroup = new ButtonGroup();
        this.rangeGroup1 = new ButtonGroup();
        this.typeGroup1 = new ButtonGroup();
        this.toolsGroup = new ButtonGroup();
        this.csButtonGroup = new ButtonGroup();
        this.stepStyleGroup = new ButtonGroup();
        this.fitShapesTablePopup = new JPopupMenu();
        this.removeShapeItem = new JMenuItem();
        this.removeAllShapesItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.replaceWithCurrentItem = new JMenuItem();
        this.simulationResultsFrame1 = new SimulationResultsFrame();
        this.shapeTreePopup = new JPopupMenu();
        this.clearSessionItem = new JMenuItem();
        this.openShapeItem = new JMenuItem();
        this.saveShapeItem = new JMenuItem();
        this.addSourceItem = new JMenuItem();
        this.refreshTreeItem = new JMenuItem();
        this.newFolderItem = new JMenuItem();
        this.deleteShapeItem = new JMenuItem();
        this.renameShapeItem = new JMenuItem();
        this.deleteFolderItem = new JMenuItem();
        this.renameFolderItem = new JMenuItem();
        this.jDesktopPane1 = new JDesktopPane();
        this.shapeFittingFrame = new JInternalFrame();
        this.jPanel7 = new JPanel();
        this.varInfoLabel = new JLabel();
        this.varHeaderLabel = new HeaderLabel();
        this.jPanel10 = new JPanel();
        this.jLabel26 = new JLabel();
        this.headerLabel10 = new HeaderLabel();
        this.linRadioButton = new JRadioButton();
        this.linStepsField = new JTextField();
        this.stepsLabel = new JLabel();
        this.jLabel21 = new JLabel();
        this.binRadioButton = new JRadioButton();
        this.binDepthField = new JTextField();
        this.depthLabel = new JLabel();
        this.jLabel27 = new JLabel();
        this.includeManualCheckbox = new JCheckBox();
        this.jLabel28 = new JLabel();
        this.fitButton1 = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.variableParamsTable = new JTable();
        this.parameterSearchFrame = new JInternalFrame();
        this.shelf1 = new Shelf();
        this.drawer5 = new Drawer();
        this.manualPanel = new JPanel();
        this.jPanel9 = new JPanel();
        this.headerLabel5 = new HeaderLabel();
        this.openShapeBtn = new JLabel();
        this.saveShapeBtn = new JLabel();
        this.graphsCombobox = new JComboBox();
        this.clearMemBtn = new JLabel();
        this.jPanel8 = new JPanel();
        this.shapeCanvas = new GraphCanvas();
        this.miniControlWidgets1 = new MiniControlWidgets();
        this.jLabel15 = new JLabel();
        this.sfitMinField = new JTextField();
        this.jLabel16 = new JLabel();
        this.sfitMaxField = new JTextField();
        this.jLabel17 = new JLabel();
        this.acquireFitRange = new JToggleButton();
        this.jPanel15 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.fitShapesTable = new JTable();
        this.fitManualButton = new JButton();
        this.addShapeButton = new JToggleButton();
        this.jPanel16 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.shapeSourceTree = new JTree();
        this.headerLabel8 = new HeaderLabel();
        this.openFitSetBtn = new JLabel();
        this.saveFitSetBtn = new JLabel();
        this.headerLabel15 = new HeaderLabel();
        this.refreshBtn = new JLabel();
        this.removeShapeBtn = new JLabel();
        this.fittingPlotFrame = new JInternalFrame();
        this.jMenuBar1 = new JMenuBar();
        this.plotFileMenu = new JMenu();
        this.openTargetMenuItem = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.saveFigMenuItem = new JMenuItem();
        this.plotViewMenu = new JMenu();
        this.propertiesPaneItem = new JCheckBoxMenuItem();
        this.viewToolbarItem = new JCheckBoxMenuItem();
        this.plotZoomMenu = new JMenu();
        this.zoomAllMenuItem = new JMenuItem();
        this.zoomRoiMenuItem = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.zoomInMenuItem = new JMenuItem();
        this.zoomOutMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.panRightItem = new JMenuItem();
        this.panLeftItem = new JMenuItem();
        this.plotGraphsMenu = new JMenu();
        this.plotAnnotationsMenu = new JMenu();
        this.jPanel14 = new JPanel();
        this.northPanel = new JPanel();
        this.jToolBar3 = new JToolBar();
        this.openBtn = new JButton();
        this.saveBtn = new JButton();
        this.printBtn = new JButton();
        this.pageSetupBtn = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jToolBar2 = new JToolBar();
        this.zoomButton = new JToggleButton();
        this.panButton = new JToggleButton();
        this.evalButton = new JToggleButton();
        this.jSeparator5 = new JSeparator();
        this.jToolBar1 = new JToolBar();
        this.addTextButton = new JToggleButton();
        this.addLineButton = new JToggleButton();
        this.addTextTagButton = new JToggleButton();
        this.addLineTagButton = new JToggleButton();
        this.jSeparator7 = new JSeparator();
        this.selectButton = new JToggleButton();
        this.selectButton1 = new JToggleButton();
        this.jSeparator6 = new JSeparator();
        this.antialiasingCheckbox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.graphCanvas = new GraphCanvas();
        this.residualCanvas = new GraphCanvas();
        this.jScrollPane1 = new JScrollPane();
        this.rightPanel = new JPanel();
        this.drawer6 = new Drawer();
        this.jPanel3 = new JPanel();
        this.xRangeButton = new JRadioButton();
        this.xRangeAutoButton = new JRadioButton();
        this.xMinField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.xMaxField = new JTextField();
        this.jLabel3 = new JLabel();
        this.xRangeLabel = new HeaderLabel();
        this.yRangeButton = new JRadioButton();
        this.yRangeAutoButton = new JRadioButton();
        this.jLabel9 = new JLabel();
        this.yMinField = new JTextField();
        this.jLabel8 = new JLabel();
        this.yMaxField = new JTextField();
        this.jLabel7 = new JLabel();
        this.yRangeLabel = new HeaderLabel();
        this.ecalShelf = new Shelf();
        this.ecalDrawer = new Drawer();
        this.jPanel13 = new JPanel();
        this.headerLabel12 = new HeaderLabel();
        this.headerLabel13 = new HeaderLabel();
        this.recalibrateButton = new JToggleButton();
        this.restoreEcalButton = new JToggleButton();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.curSlopeField = new JTextField();
        this.curOffsField = new JTextField();
        this.origSlopeField = new JTextField();
        this.origOffsField = new JTextField();
        this.ecalPanel = new JPanel();
        this.openEcalPropertiesLabel = new widgets.HeaderLabel();
        this.headerLabel14 = new widgets.HeaderLabel();
        this.restoreEcal = new JToggleButton();
        this.fitEnergyCalibrationOffsCheckbox = new JCheckBox();
        this.fitEnergyCalibrationSlopeCheckbox = new JCheckBox();
        this.shelf5 = new Shelf();
        this.drawer4 = new Drawer();
        this.jPanel12 = new JPanel();
        this.headerLabel3 = new HeaderLabel();
        this.jLabel18 = new JLabel();
        this.fitMinField = new JTextField();
        this.jLabel19 = new JLabel();
        this.fitMaxField = new JTextField();
        this.jLabel20 = new JLabel();
        this.acquireFitRange1 = new JToggleButton();
        this.regionsOfInterestPane = new JScrollPane();
        this.regionsOfInterestTable = new JTable();
        this.headerLabel11 = new HeaderLabel();
        this.addRangeButton = new JToggleButton();
        this.removeRegionButton = new JToggleButton();
        this.regionsPanel = new JPanel();
        this.openROIPropertiesLabel = new widgets.HeaderLabel();
        this.headerLabel2 = new widgets.HeaderLabel();
        this.grabFitRange = new JToggleButton();
        this.shelf4 = new Shelf();
        this.drawer1 = new Drawer();
        this.jPanel1 = new JPanel();
        this.xAxisTitleField = new JTextField();
        this.xTicsCheckbox = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.xAxisLinear = new JRadioButton();
        this.xAxisLog = new JRadioButton();
        this.redoTicsX = new JButton();
        this.xTitleFontBtn = new JButton();
        this.redoTicsX1 = new JButton();
        this.jLabel10 = new JLabel();
        this.yAxisPanel1 = new JPanel();
        this.headerLabel1 = new widgets.HeaderLabel();
        this.openXPropertiesLabel = new widgets.HeaderLabel();
        this.shelf7 = new Shelf();
        this.drawer2 = new Drawer();
        this.jPanel5 = new JPanel();
        this.yAxisTitleField = new JTextField();
        this.yTicsCheckbox = new JCheckBox();
        this.jLabel11 = new JLabel();
        this.yAxisLinear = new JRadioButton();
        this.yAxisLog = new JRadioButton();
        this.redoTicsY = new JButton();
        this.yTitleFontBtn = new JButton();
        this.redoTicsY1 = new JButton();
        this.jLabel5 = new JLabel();
        this.yAxisPanel = new JPanel();
        this.openYPropertiesLabel = new widgets.HeaderLabel();
        this.headerLabel4 = new widgets.HeaderLabel();
        this.shelf8 = new Shelf();
        this.drawer3 = new Drawer();
        this.jPanel6 = new JPanel();
        this.colorPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.deleteGraphButton = new JButton();
        this.graphTitleField = new JTextField();
        this.jLabel12 = new JLabel();
        this.toFrontBtn = new JButton();
        this.widthField = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.correction = new JLabel();
        this.correctionField = new JTextField();
        this.width = new JLabel();
        this.width2 = new JLabel();
        this.correction2 = new JLabel();
        this.toFrontBtn1 = new JButton();
        this.yAxisPanel2 = new JPanel();
        this.headerLabel6 = new widgets.HeaderLabel();
        this.openGraphPropertiesLabel = new widgets.HeaderLabel();
        this.jPanel4 = new JPanel();
        this.selectionLabel = new JLabel();
        this.selectToolButton = new JToggleButton();
        this.infoToolButton = new JToggleButton();
        this.jSeparator10 = new JSeparator();
        this.navigationLabel = new JLabel();
        this.plotControlWidgets = new MiniControlWidgets();
        this.jSeparator11 = new JSeparator();
        this.selectedObjectLabel = new JLabel();
        this.graphsCombobox1 = new JComboBox();
        this.areaLabel = new JLabel();
        this.plotColorPanel = new JPanel();
        this.plotFillPanel = new JPanel();
        this.plotWidthPlusBtn = new JLabel();
        this.plotWidthMinusBtn = new JLabel();
        this.removeObjectBtn = new JLabel();
        this.jSeparator12 = new JSeparator();
        this.removeShapeItem.setText("Remove shape from fitting");
        this.removeShapeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.removeShapeItemActionPerformed(evt);
            }
        });
        this.fitShapesTablePopup.add(this.removeShapeItem);
        this.removeAllShapesItem.setText("Remove all shapes");
        this.removeAllShapesItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.removeAllShapesItemActionPerformed(evt);
            }
        });
        this.fitShapesTablePopup.add(this.removeAllShapesItem);
        this.fitShapesTablePopup.add(this.jSeparator4);
        this.replaceWithCurrentItem.setText("Replace with current shape");
        this.replaceWithCurrentItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.replaceWithCurrentItemActionPerformed(evt);
            }
        });
        this.fitShapesTablePopup.add(this.replaceWithCurrentItem);
        this.clearSessionItem.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/ClearSmall.png")));
        this.clearSessionItem.setText("Clear session");
        this.clearSessionItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.clearSessionItemActionPerformed(evt);
            }
        });
        this.shapeTreePopup.add(this.clearSessionItem);
        this.openShapeItem.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/OpenSmall.png")));
        this.openShapeItem.setText("Import a shape...");
        this.openShapeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.openShapeItemActionPerformed(evt);
            }
        });
        this.shapeTreePopup.add(this.openShapeItem);
        this.saveShapeItem.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/SaveSmall.png")));
        this.saveShapeItem.setText("Save shape as...");
        this.shapeTreePopup.add(this.saveShapeItem);
        this.addSourceItem.setText("Add a shape source");
        this.shapeTreePopup.add(this.addSourceItem);
        this.refreshTreeItem.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/RefreshSmall.png")));
        this.refreshTreeItem.setText("Refresh tree");
        this.refreshTreeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.refreshTreeItemActionPerformed(evt);
            }
        });
        this.shapeTreePopup.add(this.refreshTreeItem);
        this.newFolderItem.setText("New folder...");
        this.newFolderItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.newFolderItemActionPerformed(evt);
            }
        });
        this.shapeTreePopup.add(this.newFolderItem);
        this.deleteShapeItem.setText("Delete shape file");
        this.deleteShapeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.deleteShapeItemActionPerformed(evt);
            }
        });
        this.shapeTreePopup.add(this.deleteShapeItem);
        this.renameShapeItem.setText("Rename shape file");
        this.renameShapeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.renameShapeItemActionPerformed(evt);
            }
        });
        this.shapeTreePopup.add(this.renameShapeItem);
        this.deleteFolderItem.setText("Delete folder");
        this.deleteFolderItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.deleteFolderItemActionPerformed(evt);
            }
        });
        this.shapeTreePopup.add(this.deleteFolderItem);
        this.renameFolderItem.setText("Rename folder");
        this.renameFolderItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.renameFolderItemActionPerformed(evt);
            }
        });
        this.shapeTreePopup.add(this.renameFolderItem);
        this.setLayout(new BorderLayout());
        this.initTree();
        this.shapeFittingFrame.setIconifiable(true);
        this.shapeFittingFrame.setResizable(true);
        this.shapeFittingFrame.setTitle("Parameter searching");
        this.shapeFittingFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/SpectrumIcon.png")));
        this.shapeFittingFrame.setVisible(true);
        this.rightPanel.setLayout(new TileLayout());
        this.jPanel7.setPreferredSize(new Dimension(527, 45));
        this.jPanel7.setLayout(new FlowLayout(0));
        this.varInfoLabel.setText("Homogeneous source type is selected in the 'Source' page.");
        this.jPanel7.add(this.varInfoLabel);
        this.varHeaderLabel.setText(" Variable parameters for homogeneous source");
        this.varHeaderLabel.setPreferredSize(new Dimension(1226, 15));
        this.jPanel7.add(this.varHeaderLabel);
        this.shapeFittingFrame.getContentPane().add((Component)this.jPanel7, "North");
        this.jPanel10.setPreferredSize(new Dimension(177, 129));
        this.jPanel10.setLayout(new FlowLayout(0, 5, 1));
        this.jLabel26.setPreferredSize(new Dimension(1000, 3));
        this.jPanel10.add(this.jLabel26);
        this.headerLabel10.setText(" Stepping style");
        this.headerLabel10.setPreferredSize(new Dimension(1071, 15));
        this.jPanel10.add(this.headerLabel10);
        this.stepStyleGroup.add(this.linRadioButton);
        this.linRadioButton.setSelected(true);
        this.linRadioButton.setText("Linear");
        this.linRadioButton.setOpaque(false);
        this.linRadioButton.setPreferredSize(new Dimension(81, 21));
        this.linRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.linRadioButtonActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.linRadioButton);
        this.linStepsField.setColumns(3);
        this.linStepsField.setText("5");
        this.jPanel10.add(this.linStepsField);
        this.stepsLabel.setText("steps");
        this.jPanel10.add(this.stepsLabel);
        this.jLabel21.setPreferredSize(new Dimension(1000, 1));
        this.jPanel10.add(this.jLabel21);
        this.stepStyleGroup.add(this.binRadioButton);
        this.binRadioButton.setText("Binary");
        this.binRadioButton.setPreferredSize(new Dimension(82, 18));
        this.binRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.binRadioButtonActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.binRadioButton);
        this.binDepthField.setColumns(3);
        this.binDepthField.setText("5");
        this.binDepthField.setEnabled(false);
        this.jPanel10.add(this.binDepthField);
        this.depthLabel.setText("levels");
        this.depthLabel.setEnabled(false);
        this.jPanel10.add(this.depthLabel);
        this.jLabel27.setPreferredSize(new Dimension(1000, 1));
        this.jPanel10.add(this.jLabel27);
        this.includeManualCheckbox.setText("Include shapes in predefined shape fitting");
        this.jPanel10.add(this.includeManualCheckbox);
        this.jLabel28.setPreferredSize(new Dimension(1000, 1));
        this.jPanel10.add(this.jLabel28);
        this.fitButton1.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/GoSmall.png")));
        this.fitButton1.setText("Search");
        this.fitButton1.setAlignmentY(0.0f);
        this.fitButton1.setEnabled(false);
        this.fitButton1.setPreferredSize(new Dimension(280, 34));
        this.fitButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.fitButton1ActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.fitButton1);
        this.shapeFittingFrame.getContentPane().add((Component)this.jPanel10, "South");
        this.jScrollPane4.setBorder(new SoftBevelBorder(1));
        this.jScrollPane4.setPreferredSize(new Dimension(456, 206));
        this.variableParamsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null}, {null, null, null, null, null, null}, {null, null, null, null, null, null}, {null, null, null, null, null, null}, {null, null, null, null, null, null}, {null, null, null, null, null, null}, {null, null, null, null, null, null}}, new String[]{"", "", "", "Select", "Variate +-", ""}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false, true, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.variableParamsTable.setGridColor(new Color(204, 204, 204));
        this.variableParamsTable.setOpaque(false);
        this.variableParamsTable.setRowSelectionAllowed(false);
        this.initTable(this.variableParamsTable);
        this.variableParamsTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane4.setViewportView(this.variableParamsTable);
        this.shapeFittingFrame.getContentPane().add((Component)this.jScrollPane4, "Center");
        this.shapeFittingFrame.setBounds(540, 50, 470, 340);
        this.jDesktopPane1.add((Component)this.shapeFittingFrame, JLayeredPane.DEFAULT_LAYER);
        this.parameterSearchFrame.setIconifiable(true);
        this.parameterSearchFrame.setResizable(true);
        this.parameterSearchFrame.setTitle("Predefined shape fitting");
        this.parameterSearchFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/SpectrumIcon.png")));
        this.parameterSearchFrame.setVisible(true);
        this.shelf1.setMaximumSize(new Dimension(305, 440));
        this.shelf1.setMinimumSize(new Dimension(305, 40));
        this.shelf1.setPreferredSize(new Dimension(305, 440));
        this.shelf1.setExclusive(false);
        this.shelf1.setLayout(new AbsoluteLayout());
        this.drawer5.setBorder(new SoftBevelBorder(1));
        this.drawer5.setMaximizeComponent(this.manualPanel);
        this.drawer5.setMaximumSize(new Dimension(290, 420));
        this.drawer5.setMinimumSize(new Dimension(290, 24));
        this.drawer5.setPreferredSize(new Dimension(290, 420));
        this.drawer5.setLayout(new TileLayout(1, 1));
        this.drawer5.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.drawer5MouseClicked(evt);
            }
        });
        this.drawer5.setLayout(new FlowLayout(0, 1, 1));
        this.manualPanel.setLayout(new AbsoluteLayout());
        this.drawer5.add(this.manualPanel);
        this.jPanel9.setMinimumSize(new Dimension(290, 20));
        this.jPanel9.setOpaque(false);
        this.jPanel9.setPreferredSize(new Dimension(290, 270));
        this.jPanel9.setLayout(new TileLayout());
        this.jPanel9.setLayout(new FlowLayout(0, 1, 1));
        this.headerLabel5.setText(" Current shape");
        this.headerLabel5.setPreferredSize(new Dimension(280, 16));
        this.jPanel9.add(this.headerLabel5);
        this.openShapeBtn.setBackground(new Color(102, 102, 102));
        this.openShapeBtn.setForeground(new Color(255, 255, 255));
        this.openShapeBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/OpenSmall.png")));
        this.openShapeBtn.setToolTipText("Import a shape file and add it to the session");
        this.openShapeBtn.setPreferredSize(new Dimension(18, 22));
        this.openShapeBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.openShapeBtnMouseClicked(evt);
            }
        });
        this.jPanel9.add(this.openShapeBtn);
        this.saveShapeBtn.setBackground(new Color(102, 102, 102));
        this.saveShapeBtn.setForeground(new Color(255, 255, 255));
        this.saveShapeBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/SaveSmall.png")));
        this.saveShapeBtn.setToolTipText("Save the current shape");
        this.saveShapeBtn.setEnabled(false);
        this.saveShapeBtn.setPreferredSize(new Dimension(18, 22));
        this.saveShapeBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.saveShapeBtnMouseClicked(evt);
            }
        });
        this.jPanel9.add(this.saveShapeBtn);
        this.graphsCombobox.setToolTipText("Select a spectrum to edit");
        this.graphsCombobox.setEnabled(false);
        this.graphsCombobox.setPreferredSize(new Dimension(220, 22));
        this.graphsCombobox.setRenderer(new ColorComboboxRenderer());
        this.graphsCombobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.graphsComboboxActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.graphsCombobox);
        this.clearMemBtn.setBackground(new Color(102, 102, 102));
        this.clearMemBtn.setForeground(new Color(255, 255, 255));
        this.clearMemBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/ClearSmall.png")));
        this.clearMemBtn.setToolTipText("Clear the graphs from memory");
        this.clearMemBtn.setEnabled(false);
        this.clearMemBtn.setPreferredSize(new Dimension(18, 22));
        this.clearMemBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.clearMemBtnMouseClicked(evt);
            }
        });
        this.jPanel9.add(this.clearMemBtn);
        this.jPanel8.setBorder(new SoftBevelBorder(1));
        this.jPanel8.setMaximumSize(new Dimension(250, 158));
        this.jPanel8.setPreferredSize(new Dimension(280, 130));
        this.jPanel8.setLayout(new FlowLayout(0, 1, 1));
        this.shapeCanvas.setBackground(new Color(255, 255, 255));
        this.shapeCanvas.setPreferredSize(new Dimension(272, 120));
        Axis a2 = new Axis();
        a2.setSize(this.shapeCanvas.getWidth(), this.shapeCanvas.getHeight());
        this.shapeCanvas.setAxis(a2);
        this.shapeCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                FitPanel.this.shapeCanvasMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                FitPanel.this.shapeCanvasMouseMoved(evt);
            }
        });
        this.shapeCanvas.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent evt) {
                FitPanel.this.shapeCanvasMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                FitPanel.this.shapeCanvasMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                FitPanel.this.shapeCanvasMouseReleased(evt);
            }
        });
        this.jPanel8.add(this.shapeCanvas);
        this.jPanel9.add(this.jPanel8);
        this.miniControlWidgets1.setCanvas(this.shapeCanvas);
        this.miniControlWidgets1.constrainToPositive(true, true);
        this.jPanel9.add(this.miniControlWidgets1);
        this.jLabel15.setHorizontalAlignment(4);
        this.jLabel15.setText("[");
        this.jPanel9.add(this.jLabel15);
        this.sfitMinField.setBackground(new Color(255, 255, 254));
        this.sfitMinField.setText("min");
        this.sfitMinField.setToolTipText("The lower bound of the region of interest");
        this.sfitMinField.setPreferredSize(new Dimension(40, 16));
        this.sfitMinField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.sfitMinFieldActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.sfitMinField);
        this.jLabel16.setHorizontalAlignment(0);
        this.jLabel16.setText(",");
        this.jPanel9.add(this.jLabel16);
        this.sfitMaxField.setBackground(new Color(255, 255, 254));
        this.sfitMaxField.setText("max");
        this.sfitMaxField.setToolTipText("The upper bound of the region of interest");
        this.sfitMaxField.setPreferredSize(new Dimension(40, 16));
        this.sfitMaxField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.sfitMaxFieldActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.sfitMaxField);
        this.jLabel17.setHorizontalAlignment(2);
        this.jLabel17.setText("]");
        this.jPanel9.add(this.jLabel17);
        this.acquireFitRange.setFont(new Font("Dialog", 0, 10));
        this.acquireFitRange.setText("Set range");
        this.acquireFitRange.setToolTipText("Define the region of interest for this shape");
        this.acquireFitRange.setPreferredSize(new Dimension(80, 16));
        this.acquireFitRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.acquireFitRangeActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.acquireFitRange);
        this.drawer5.add(this.jPanel9);
        this.shelf1.add((Component)this.drawer5, new AbsoluteConstraints(310, 10, -1, 200));
        this.jPanel15.setBorder(new SoftBevelBorder(1));
        this.jPanel15.setPreferredSize(new Dimension(100, 200));
        this.jPanel15.setLayout(new AbsoluteLayout());
        this.jScrollPane3.setBackground(new Color(255, 255, 255));
        this.jScrollPane3.setPreferredSize(new Dimension(280, 110));
        this.fitShapesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Shape", "Fixed", "Group"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, true};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.fitShapesTable.setGridColor(new Color(204, 204, 204));
        this.fitShapesTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.fitShapesTableMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.fitShapesTable);
        this.jPanel15.add((Component)this.jScrollPane3, new AbsoluteConstraints(4, 10, 260, 180));
        this.fitManualButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/GoSmall.png")));
        this.fitManualButton.setText("Fit");
        this.fitManualButton.setToolTipText("Run the fitting with the selected shapes");
        this.fitManualButton.setEnabled(false);
        this.fitManualButton.setPreferredSize(new Dimension(280, 36));
        this.fitManualButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.fitManualButtonActionPerformed(evt);
            }
        });
        this.jPanel15.add((Component)this.fitManualButton, new AbsoluteConstraints(4, 200, 260, -1));
        this.shelf1.add((Component)this.jPanel15, new AbsoluteConstraints(610, 30, 270, 240));
        this.addShapeButton.setText("Add current shape to fitting -->");
        this.addShapeButton.setToolTipText("Add the current shape into the fitting");
        this.addShapeButton.setPreferredSize(new Dimension(280, 18));
        this.addShapeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.addShapeButtonActionPerformed(evt);
            }
        });
        this.shelf1.add((Component)this.addShapeButton, new AbsoluteConstraints(310, 230, 290, 35));
        this.jPanel16.setBorder(new SoftBevelBorder(1));
        this.jPanel16.setLayout(new AbsoluteLayout());
        this.shapeSourceTree.setCellRenderer(new TreeRenderer());
        this.shapeSourceTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                FitPanel.this.shapeSourceTreeValueChanged(evt);
            }
        });
        this.shapeSourceTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.shapeSourceTreeMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.shapeSourceTree);
        this.jPanel16.add((Component)this.jScrollPane2, new AbsoluteConstraints(3, 3, 280, 230));
        this.shelf1.add((Component)this.jPanel16, new AbsoluteConstraints(10, 30, 290, 240));
        this.headerLabel8.setText(" Shapes selected for fitting");
        this.headerLabel8.setPreferredSize(new Dimension(280, 16));
        this.shelf1.add((Component)this.headerLabel8, new AbsoluteConstraints(660, 10, 200, -1));
        this.openFitSetBtn.setBackground(new Color(102, 102, 102));
        this.openFitSetBtn.setForeground(new Color(255, 255, 255));
        this.openFitSetBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/OpenSmall.png")));
        this.openFitSetBtn.setToolTipText("Open a fit set");
        this.openFitSetBtn.setMinimumSize(new Dimension(18, 16));
        this.openFitSetBtn.setPreferredSize(new Dimension(18, 18));
        this.openFitSetBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.openFitSetBtnMouseClicked(evt);
            }
        });
        this.shelf1.add((Component)this.openFitSetBtn, new AbsoluteConstraints(620, 10, -1, -1));
        this.saveFitSetBtn.setBackground(new Color(102, 102, 102));
        this.saveFitSetBtn.setForeground(new Color(255, 255, 255));
        this.saveFitSetBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/SaveSmall.png")));
        this.saveFitSetBtn.setToolTipText("Save the fit set");
        this.saveFitSetBtn.setEnabled(false);
        this.saveFitSetBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.saveFitSetBtnMouseClicked(evt);
            }
        });
        this.shelf1.add((Component)this.saveFitSetBtn, new AbsoluteConstraints(640, 10, -1, -1));
        this.headerLabel15.setText(" Shape file browser");
        this.headerLabel15.setPreferredSize(new Dimension(280, 16));
        this.shelf1.add((Component)this.headerLabel15, new AbsoluteConstraints(10, 10, 270, -1));
        this.refreshBtn.setBackground(new Color(102, 102, 102));
        this.refreshBtn.setForeground(new Color(255, 255, 255));
        this.refreshBtn.setHorizontalAlignment(0);
        this.refreshBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/RefreshSmall.png")));
        this.refreshBtn.setToolTipText("Refresh the tree view");
        this.refreshBtn.setPreferredSize(new Dimension(18, 16));
        this.refreshBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.refreshBtnMouseClicked(evt);
            }
        });
        this.shelf1.add((Component)this.refreshBtn, new AbsoluteConstraints(280, 10, -1, 16));
        this.removeShapeBtn.setBackground(new Color(102, 102, 102));
        this.removeShapeBtn.setForeground(new Color(255, 255, 255));
        this.removeShapeBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/DeleteSmall2.png")));
        this.removeShapeBtn.setToolTipText("Remove the selected shape from the fitting");
        this.removeShapeBtn.setEnabled(false);
        this.removeShapeBtn.setPreferredSize(new Dimension(18, 16));
        this.removeShapeBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.removeShapeBtnMouseClicked(evt);
            }
        });
        this.shelf1.add((Component)this.removeShapeBtn, new AbsoluteConstraints(860, 10, -1, -1));
        this.parameterSearchFrame.getContentPane().add((Component)this.shelf1, "Center");
        this.parameterSearchFrame.setBounds(100, 370, 900, 310);
        this.jDesktopPane1.add((Component)this.parameterSearchFrame, JLayeredPane.DEFAULT_LAYER);
        this.fittingPlotFrame.setMaximizable(true);
        this.fittingPlotFrame.setResizable(true);
        this.fittingPlotFrame.setTitle("Fitting plot");
        this.fittingPlotFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/SpectrumIcon.png")));
        this.fittingPlotFrame.setVisible(true);
        this.plotFileMenu.setText("File");
        this.plotFileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.plotFileMenuActionPerformed(evt);
            }
        });
        this.openTargetMenuItem.setText("Open a fit target");
        this.openTargetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.openTargetMenuItemActionPerformed(evt);
            }
        });
        this.plotFileMenu.add(this.openTargetMenuItem);
        this.plotFileMenu.add(this.jSeparator8);
        this.saveFigMenuItem.setText("Save plot as figure");
        this.saveFigMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.saveFigMenuItemActionPerformed(evt);
            }
        });
        this.plotFileMenu.add(this.saveFigMenuItem);
        this.jMenuBar1.add(this.plotFileMenu);
        this.plotViewMenu.setText("View");
        this.propertiesPaneItem.setSelected(true);
        this.propertiesPaneItem.setText("Show properties pane");
        this.propertiesPaneItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.propertiesPaneItemActionPerformed(evt);
            }
        });
        this.plotViewMenu.add(this.propertiesPaneItem);
        this.viewToolbarItem.setSelected(true);
        this.viewToolbarItem.setText("Show toolbar");
        this.viewToolbarItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.viewToolbarItemActionPerformed(evt);
            }
        });
        this.plotViewMenu.add(this.viewToolbarItem);
        this.jMenuBar1.add(this.plotViewMenu);
        this.plotZoomMenu.setText("Zoom");
        this.plotZoomMenu.setEnabled(false);
        this.zoomAllMenuItem.setText("Zoom all");
        this.zoomAllMenuItem.setToolTipText("Ensures that everything is visible");
        this.zoomAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.zoomAllMenuItemActionPerformed(evt);
            }
        });
        this.plotZoomMenu.add(this.zoomAllMenuItem);
        this.zoomRoiMenuItem.setText("Zoom to ROI");
        this.zoomRoiMenuItem.setToolTipText("Ensures that all regions of interest are visible");
        this.zoomRoiMenuItem.setAccelerator(KeyStroke.getKeyStroke(44, 0));
        this.zoomRoiMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.zoomRoiMenuItemActionPerformed(evt);
            }
        });
        this.plotZoomMenu.add(this.zoomRoiMenuItem);
        this.plotZoomMenu.add(this.jSeparator9);
        this.zoomInMenuItem.setText("Zoom in");
        this.zoomInMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.zoomInMenuItemActionPerformed(evt);
            }
        });
        this.plotZoomMenu.add(this.zoomInMenuItem);
        this.zoomOutMenuItem.setText("Zoom out");
        this.zoomOutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.zoomOutMenuItemActionPerformed(evt);
            }
        });
        this.plotZoomMenu.add(this.zoomOutMenuItem);
        this.plotZoomMenu.add(this.jSeparator1);
        this.panRightItem.setText("Pan right");
        this.panRightItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.panRightItemActionPerformed(evt);
            }
        });
        this.plotZoomMenu.add(this.panRightItem);
        this.panLeftItem.setText("Pan left");
        this.panLeftItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.panLeftItemActionPerformed(evt);
            }
        });
        this.plotZoomMenu.add(this.panLeftItem);
        this.jMenuBar1.add(this.plotZoomMenu);
        this.plotGraphsMenu.setText("Graphs");
        this.plotGraphsMenu.setEnabled(false);
        this.jMenuBar1.add(this.plotGraphsMenu);
        this.plotAnnotationsMenu.setEnabled(false);
        this.jMenuBar1.add(this.plotAnnotationsMenu);
        this.fittingPlotFrame.getContentPane().add((Component)this.jMenuBar1, "North");
        this.jPanel14.setLayout(new BorderLayout());
        this.northPanel.setPreferredSize(new Dimension(1301, 1));
        this.northPanel.setLayout(new FlowLayout(0, 0, 0));
        this.jToolBar3.setFloatable(false);
        this.openBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/OpenIcon.png")));
        this.openBtn.setText("Open a new target");
        this.openBtn.setToolTipText("Open a graph file and add the graph to the spectrums list.");
        this.openBtn.setBorderPainted(false);
        this.openBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.openBtnActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.openBtn);
        this.saveBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/SaveIcon.png")));
        this.saveBtn.setText("Save");
        this.saveBtn.setToolTipText("Save the selected graph into a file.");
        this.saveBtn.setBorderPainted(false);
        this.saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.saveBtnActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.saveBtn);
        this.printBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/PrintIcon.png")));
        this.printBtn.setText("Print");
        this.printBtn.setToolTipText("Save the selected graph into a file.");
        this.printBtn.setBorderPainted(false);
        this.printBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.printBtnActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.printBtn);
        this.pageSetupBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/PageSetupIcon.png")));
        this.pageSetupBtn.setText("Page setup");
        this.pageSetupBtn.setBorderPainted(false);
        this.pageSetupBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.pageSetupBtnActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.pageSetupBtn);
        this.northPanel.add(this.jToolBar3);
        this.jSeparator3.setOrientation(1);
        this.jSeparator3.setPreferredSize(new Dimension(6, 20));
        this.northPanel.add(this.jSeparator3);
        this.jToolBar2.setFloatable(false);
        this.toolsGroup.add(this.zoomButton);
        this.zoomButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/ZoomIcon.png")));
        this.zoomButton.setText("Zoom");
        this.zoomButton.setToolTipText("Zoom tool. Zooms the view of the graph in and out. (left / right mouse button)");
        this.zoomButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.zoomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.zoomButtonActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.zoomButton);
        this.toolsGroup.add(this.panButton);
        this.panButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/HandIcon.png")));
        this.panButton.setText("Pan");
        this.panButton.setToolTipText("Pan tool. Pans the view of the graph.");
        this.panButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.panButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.panButtonActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.panButton);
        this.toolsGroup.add(this.evalButton);
        this.evalButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/CursorIcon.png")));
        this.evalButton.setText("Cursor");
        this.evalButton.setToolTipText("Cursor tool. Displays values in the graph.");
        this.evalButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.evalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.evalButtonActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.evalButton);
        this.northPanel.add(this.jToolBar2);
        this.jSeparator5.setOrientation(1);
        this.jSeparator5.setPreferredSize(new Dimension(6, 20));
        this.northPanel.add(this.jSeparator5);
        this.jToolBar1.setFloatable(false);
        this.toolsGroup.add(this.addTextButton);
        this.addTextButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/TextIcon.png")));
        this.addTextButton.setText("Add text object");
        this.addTextButton.setToolTipText("Text tool. Adds text.");
        this.addTextButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addTextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.addTextButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.addTextButton);
        this.toolsGroup.add(this.addLineButton);
        this.addLineButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/LineIcon.png")));
        this.addLineButton.setText("Add line object ");
        this.addLineButton.setToolTipText("Line tool. Adds lines.");
        this.addLineButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addLineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.addLineButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.addLineButton);
        this.toolsGroup.add(this.addTextTagButton);
        this.addTextTagButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/TextTagIcon.png")));
        this.addTextTagButton.setText("Add text tag object ");
        this.addTextTagButton.setToolTipText("Adds a text tag into the plot range.");
        this.addTextTagButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addTextTagButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.addTextTagButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.addTextTagButton);
        this.toolsGroup.add(this.addLineTagButton);
        this.addLineTagButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/LineTagIcon.png")));
        this.addLineTagButton.setText("Add line tag object ");
        this.addLineTagButton.setToolTipText("Adds a line tag into the plot range.");
        this.addLineTagButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addLineTagButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.addLineTagButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.addLineTagButton);
        this.jSeparator7.setOrientation(1);
        this.jSeparator7.setPreferredSize(new Dimension(6, 20));
        this.jToolBar1.add(this.jSeparator7);
        this.toolsGroup.add(this.selectButton);
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/SelectIcon.png")));
        this.selectButton.setText("Edit object");
        this.selectButton.setToolTipText("Select and edit objects such as lines, text and tags.");
        this.selectButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.selectButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.selectButton);
        this.toolsGroup.add(this.selectButton1);
        this.selectButton1.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/EraseIcon.png")));
        this.selectButton1.setText("Erase object");
        this.selectButton1.setToolTipText("Erase objects, such as lines, text and tags.");
        this.selectButton1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.selectButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.selectButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.selectButton1);
        this.northPanel.add(this.jToolBar1);
        this.jSeparator6.setOrientation(1);
        this.jSeparator6.setPreferredSize(new Dimension(6, 20));
        this.northPanel.add(this.jSeparator6);
        this.antialiasingCheckbox.setText("Antialiasing");
        this.antialiasingCheckbox.setToolTipText("Toggles antialiasing.");
        this.antialiasingCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.antialiasingCheckboxActionPerformed(evt);
            }
        });
        this.northPanel.add(this.antialiasingCheckbox);
        this.jPanel14.add((Component)this.northPanel, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(80);
        this.jSplitPane1.setDividerSize(3);
        this.jSplitPane1.setOrientation(0);
        this.graphCanvas.setBackground(new Color(255, 255, 255));
        Axis a = new Axis();
        a.setSize(this.graphCanvas.getWidth(), this.graphCanvas.getHeight());
        this.graphCanvas.setAxis(a);
        this.graphCanvas.setAntialiasingEnabled(false);
        this.graphCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                FitPanel.this.graphCanvas_handleMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                FitPanel.this.graphCanvasMouseMoved(evt);
            }
        });
        this.graphCanvas.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                FitPanel.this.graphCanvasKeyPressed(evt);
            }
        });
        this.graphCanvas.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.graphCanvas_handleMouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                FitPanel.this.graphCanvasMouseExited(evt);
            }

            public void mousePressed(MouseEvent evt) {
                FitPanel.this.graphCanvas_handleMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                FitPanel.this.graphCanvas_handleMouseReleased(evt);
            }
        });
        this.jSplitPane1.setRightComponent(this.graphCanvas);
        this.residualCanvas.setBackground(new Color(255, 255, 255));
        AtanAxis a1 = new AtanAxis();
        a1.setSize(this.residualCanvas.getWidth(), this.residualCanvas.getHeight());
        this.residualCanvas.setAxis(a1);
        a1.setMinMax(0.0, -1000.0, 10.0, 1000.0);
        double[] atanTics = new double[]{-5.0, -1.0, 1.0, 5.0};
        a1.setTics(atanTics, 1);
        a1.setDrawOriginTick(false);
        a1.setTitle("Residual", 1);
        a1.setTitleFont(new Font("Arial", 1, 12), 1);
        a1.setDrawTitle(false, 0);
        this.jSplitPane1.setTopComponent(this.residualCanvas);
        this.jPanel2.add((Component)this.jSplitPane1, "Center");
        this.jScrollPane1.setMaximumSize(new Dimension(280, Short.MAX_VALUE));
        this.jScrollPane1.setMinimumSize(new Dimension(80, 23));
        this.jScrollPane1.setPreferredSize(new Dimension(280, 752));
        this.rightPanel.setAutoscrolls(true);
        this.rightPanel.setMinimumSize(new Dimension(220, 640));
        this.rightPanel.setPreferredSize(new Dimension(220, 400));
        this.rightPanel.setLayout(new TileLayout());
        this.rightPanel.setLayout(new FlowLayout(0));
        this.jPanel3.setMaximumSize(new Dimension(254, 390));
        this.jPanel3.setMinimumSize(new Dimension(254, 390));
        this.jPanel3.setPreferredSize(new Dimension(240, 120));
        this.jPanel3.setLayout(null);
        this.rangeGroup.add(this.xRangeButton);
        this.xRangeButton.setText("Range");
        this.xRangeButton.setToolTipText("Specify the range of x-axis to display");
        this.xRangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.xRangeButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.xRangeButton);
        this.xRangeButton.setBounds(20, 20, 70, 20);
        this.rangeGroup.add(this.xRangeAutoButton);
        this.xRangeAutoButton.setSelected(true);
        this.xRangeAutoButton.setText("Auto");
        this.xRangeAutoButton.setToolTipText("Automatically determine the range to display.");
        this.xRangeAutoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.xRangeAutoButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.xRangeAutoButton);
        this.xRangeAutoButton.setBounds(20, 40, 110, 20);
        this.xMinField.setBackground(new Color(255, 255, 254));
        this.xMinField.setHorizontalAlignment(0);
        this.xMinField.setText("min");
        this.xMinField.setToolTipText("The lower bound of the display range");
        this.xMinField.setEnabled(false);
        this.xMinField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.xMinFieldActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.xMinField);
        this.xMinField.setBounds(100, 20, 50, 20);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("[");
        this.jPanel3.add(this.jLabel2);
        this.jLabel2.setBounds(90, 20, 10, 20);
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText(",");
        this.jPanel3.add(this.jLabel4);
        this.jLabel4.setBounds(150, 20, 10, 20);
        this.xMaxField.setBackground(new Color(255, 255, 254));
        this.xMaxField.setHorizontalAlignment(0);
        this.xMaxField.setText("max");
        this.xMaxField.setToolTipText("The upper bound of the display range");
        this.xMaxField.setEnabled(false);
        this.xMaxField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.xMaxFieldActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.xMaxField);
        this.xMaxField.setBounds(160, 20, 50, 20);
        this.jLabel3.setHorizontalAlignment(2);
        this.jLabel3.setText("]");
        this.jPanel3.add(this.jLabel3);
        this.jLabel3.setBounds(210, 20, 10, 20);
        this.xRangeLabel.setText(" X-Axis plot range");
        this.jPanel3.add(this.xRangeLabel);
        this.xRangeLabel.setBounds(10, 3, 300, 14);
        this.rangeGroup1.add(this.yRangeButton);
        this.yRangeButton.setText("Range");
        this.yRangeButton.setToolTipText("Specify the range of y-axis to display");
        this.yRangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.yRangeButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.yRangeButton);
        this.yRangeButton.setBounds(20, 80, 70, 20);
        this.rangeGroup1.add(this.yRangeAutoButton);
        this.yRangeAutoButton.setSelected(true);
        this.yRangeAutoButton.setText("Auto");
        this.yRangeAutoButton.setToolTipText("Automatically determine the range to display.");
        this.yRangeAutoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.yRangeAutoButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.yRangeAutoButton);
        this.yRangeAutoButton.setBounds(20, 100, 100, 20);
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText("[");
        this.jPanel3.add(this.jLabel9);
        this.jLabel9.setBounds(90, 80, 10, 20);
        this.yMinField.setBackground(new Color(255, 255, 254));
        this.yMinField.setHorizontalAlignment(0);
        this.yMinField.setText("min");
        this.yMinField.setToolTipText("The lower bound of the display range");
        this.yMinField.setEnabled(false);
        this.yMinField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.yMinFieldActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.yMinField);
        this.yMinField.setBounds(100, 80, 50, 20);
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText(",");
        this.jPanel3.add(this.jLabel8);
        this.jLabel8.setBounds(150, 80, 10, 20);
        this.yMaxField.setBackground(new Color(255, 255, 254));
        this.yMaxField.setHorizontalAlignment(0);
        this.yMaxField.setText("max");
        this.yMaxField.setToolTipText("The upper bound of the display range");
        this.yMaxField.setEnabled(false);
        this.yMaxField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.yMaxFieldActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.yMaxField);
        this.yMaxField.setBounds(160, 80, 50, 20);
        this.jLabel7.setHorizontalAlignment(2);
        this.jLabel7.setText("]");
        this.jPanel3.add(this.jLabel7);
        this.jLabel7.setBounds(210, 80, 10, 20);
        this.yRangeLabel.setText(" Y-Axis plot range");
        this.jPanel3.add(this.yRangeLabel);
        this.yRangeLabel.setBounds(10, 63, 300, 14);
        this.drawer6.add(this.jPanel3);
        this.rightPanel.add(this.drawer6);
        this.ecalShelf.setMaximumSize(new Dimension(305, 140));
        this.ecalShelf.setMinimumSize(new Dimension(305, 140));
        this.ecalShelf.setPreferredSize(new Dimension(244, 70));
        this.ecalShelf.setExclusive(false);
        this.ecalShelf.setLayout(null);
        this.ecalDrawer.setBorder(new SoftBevelBorder(1));
        this.ecalDrawer.setMaximizeComponent(this.ecalPanel);
        this.ecalDrawer.setMaximumSize(new Dimension(290, 250));
        this.ecalDrawer.setMinimumSize(new Dimension(290, 67));
        this.ecalDrawer.setOpaque(false);
        this.ecalDrawer.setPreferredSize(new Dimension(240, 67));
        this.ecalDrawer.setLayout(new AbsoluteLayout());
        this.jPanel13.setOpaque(false);
        this.jPanel13.setLayout(new AbsoluteLayout());
        this.headerLabel12.setText(" Current energy calibration");
        this.jPanel13.add((Component)this.headerLabel12, new AbsoluteConstraints(0, 10, 300, -1));
        this.headerLabel13.setText(" Original energy calibration");
        this.jPanel13.add((Component)this.headerLabel13, new AbsoluteConstraints(0, 100, 300, -1));
        this.recalibrateButton.setText("Recalibrate");
        this.recalibrateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.recalibrateButtonActionPerformed(evt);
            }
        });
        this.jPanel13.add((Component)this.recalibrateButton, new AbsoluteConstraints(10, 70, 90, -1));
        this.restoreEcalButton.setText("Restore");
        this.restoreEcalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.restoreEcalButtonActionPerformed(evt);
            }
        });
        this.jPanel13.add((Component)this.restoreEcalButton, new AbsoluteConstraints(10, 160, 90, -1));
        this.jLabel22.setText("Slope:");
        this.jPanel13.add((Component)this.jLabel22, new AbsoluteConstraints(10, 30, 60, 20));
        this.jLabel23.setText("Offset:");
        this.jPanel13.add((Component)this.jLabel23, new AbsoluteConstraints(10, 50, 60, 20));
        this.jLabel24.setText("Slope:");
        this.jPanel13.add((Component)this.jLabel24, new AbsoluteConstraints(10, 120, 60, 20));
        this.jLabel25.setText("Offset:");
        this.jPanel13.add((Component)this.jLabel25, new AbsoluteConstraints(10, 140, 60, 20));
        this.curSlopeField.setText("0.01");
        this.jPanel13.add((Component)this.curSlopeField, new AbsoluteConstraints(70, 30, 60, -1));
        this.curOffsField.setText("0.01");
        this.jPanel13.add((Component)this.curOffsField, new AbsoluteConstraints(70, 50, 60, -1));
        this.origSlopeField.setEditable(false);
        this.origSlopeField.setText("0.01");
        this.jPanel13.add((Component)this.origSlopeField, new AbsoluteConstraints(70, 120, 60, -1));
        this.origOffsField.setEditable(false);
        this.origOffsField.setText("0.01");
        this.jPanel13.add((Component)this.origOffsField, new AbsoluteConstraints(70, 140, 60, -1));
        this.ecalDrawer.add((Component)this.jPanel13, new AbsoluteConstraints(10, 60, 220, 200));
        this.ecalPanel.setLayout(new AbsoluteLayout());
        this.openEcalPropertiesLabel.setText(" +");
        this.openEcalPropertiesLabel.setFore(new Color(153, 255, 153));
        this.openEcalPropertiesLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.openEcalPropertiesLabelMouseClicked(evt);
            }
        });
        this.ecalPanel.add((Component)this.openEcalPropertiesLabel, new AbsoluteConstraints(0, 0, 20, -1));
        this.headerLabel14.setText("Target energy calibration");
        this.headerLabel14.setDark(false);
        this.ecalPanel.add((Component)this.headerLabel14, new AbsoluteConstraints(20, 0, 130, -1));
        this.restoreEcal.setFont(new Font("Dialog", 0, 10));
        this.restoreEcal.setText("Restore");
        this.restoreEcal.setToolTipText("Restore the original energy calibration");
        this.restoreEcal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.restoreEcalActionPerformed(evt);
            }
        });
        this.ecalPanel.add((Component)this.restoreEcal, new AbsoluteConstraints(150, 0, 70, 16));
        this.fitEnergyCalibrationOffsCheckbox.setText("Include energy calibration offset in fitting");
        this.fitEnergyCalibrationOffsCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.fitEnergyCalibrationOffsCheckboxActionPerformed(evt);
            }
        });
        this.ecalPanel.add((Component)this.fitEnergyCalibrationOffsCheckbox, new AbsoluteConstraints(5, 15, 270, -1));
        this.fitEnergyCalibrationSlopeCheckbox.setText("Include energy calibration slope in fitting");
        this.ecalPanel.add((Component)this.fitEnergyCalibrationSlopeCheckbox, new AbsoluteConstraints(5, 35, 270, -1));
        this.ecalDrawer.add((Component)this.ecalPanel, new AbsoluteConstraints(5, 5, 230, 60));
        this.ecalShelf.add(this.ecalDrawer);
        this.ecalDrawer.setBounds(2, 2, 240, 67);
        this.rightPanel.add(this.ecalShelf);
        this.shelf5.setMaximumSize(new Dimension(305, 140));
        this.shelf5.setMinimumSize(new Dimension(305, 30));
        this.shelf5.setPreferredSize(new Dimension(246, 30));
        this.shelf5.setExclusive(false);
        this.shelf5.setLayout(null);
        this.drawer4.setBorder(new SoftBevelBorder(1));
        this.drawer4.setMaximizeComponent(this.regionsPanel);
        this.drawer4.setMaximumSize(new Dimension(250, 180));
        this.drawer4.setMinimumSize(new Dimension(250, 24));
        this.drawer4.setOpaque(false);
        this.drawer4.setPreferredSize(new Dimension(250, 24));
        this.drawer4.setLayout(new AbsoluteLayout());
        this.jPanel12.setOpaque(false);
        this.jPanel12.setLayout(new AbsoluteLayout());
        this.headerLabel3.setText(" Current Region");
        this.jPanel12.add((Component)this.headerLabel3, new AbsoluteConstraints(0, 10, 220, -1));
        this.jLabel18.setHorizontalAlignment(4);
        this.jLabel18.setText("[");
        this.jPanel12.add((Component)this.jLabel18, new AbsoluteConstraints(0, 30, 10, 20));
        this.fitMinField.setBackground(new Color(255, 255, 254));
        this.fitMinField.setText("min");
        this.fitMinField.setToolTipText("The lower bound of the display range");
        this.jPanel12.add((Component)this.fitMinField, new AbsoluteConstraints(10, 30, 40, -1));
        this.jLabel19.setHorizontalAlignment(0);
        this.jLabel19.setText(",");
        this.jPanel12.add((Component)this.jLabel19, new AbsoluteConstraints(50, 30, 10, 20));
        this.fitMaxField.setBackground(new Color(255, 255, 254));
        this.fitMaxField.setText("max");
        this.fitMaxField.setToolTipText("The upper bound of the display range");
        this.jPanel12.add((Component)this.fitMaxField, new AbsoluteConstraints(60, 30, 40, -1));
        this.jLabel20.setHorizontalAlignment(2);
        this.jLabel20.setText("]");
        this.jPanel12.add((Component)this.jLabel20, new AbsoluteConstraints(100, 30, 10, 20));
        this.acquireFitRange1.setText("Get");
        this.acquireFitRange1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.acquireFitRange1ActionPerformed(evt);
            }
        });
        this.jPanel12.add((Component)this.acquireFitRange1, new AbsoluteConstraints(110, 30, 50, -1));
        this.regionsOfInterestPane.setPreferredSize(new Dimension(200, 200));
        this.regionsOfInterestTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Region start", "Region end"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.regionsOfInterestTable.setGridColor(new Color(204, 204, 204));
        this.regionsOfInterestPane.setViewportView(this.regionsOfInterestTable);
        this.jPanel12.add((Component)this.regionsOfInterestPane, new AbsoluteConstraints(0, 80, 220, 70));
        this.headerLabel11.setText(" Currently selected regions");
        this.jPanel12.add((Component)this.headerLabel11, new AbsoluteConstraints(0, 60, 220, -1));
        this.addRangeButton.setText("->");
        this.addRangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.addRangeButtonActionPerformed(evt);
            }
        });
        this.jPanel12.add((Component)this.addRangeButton, new AbsoluteConstraints(170, 30, 50, -1));
        this.removeRegionButton.setText("Remove");
        this.removeRegionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.removeRegionButtonActionPerformed(evt);
            }
        });
        this.jPanel12.add((Component)this.removeRegionButton, new AbsoluteConstraints(0, 80, 60, -1));
        this.drawer4.add((Component)this.jPanel12, new AbsoluteConstraints(10, 20, 270, 160));
        this.regionsPanel.setLayout(new AbsoluteLayout());
        this.openROIPropertiesLabel.setText(" +");
        this.openROIPropertiesLabel.setFore(new Color(153, 255, 153));
        this.openROIPropertiesLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.openROIPropertiesLabelMouseClicked(evt);
            }
        });
        this.regionsPanel.add((Component)this.openROIPropertiesLabel, new AbsoluteConstraints(0, 0, 20, -1));
        this.headerLabel2.setText(" Target regions of interest");
        this.headerLabel2.setDark(false);
        this.regionsPanel.add((Component)this.headerLabel2, new AbsoluteConstraints(20, 0, 150, -1));
        this.grabFitRange.setFont(new Font("Dialog", 0, 10));
        this.grabFitRange.setText("Set");
        this.grabFitRange.setToolTipText("Acquire and add a region.");
        this.grabFitRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.grabFitRangeActionPerformed(evt);
            }
        });
        this.regionsPanel.add((Component)this.grabFitRange, new AbsoluteConstraints(180, 0, 50, 16));
        this.drawer4.add((Component)this.regionsPanel, new AbsoluteConstraints(5, 5, 230, -1));
        this.shelf5.add(this.drawer4);
        this.drawer4.setBounds(2, 2, 240, 24);
        this.rightPanel.add(this.shelf5);
        this.shelf4.setMaximumSize(new Dimension(305, 100));
        this.shelf4.setMinimumSize(new Dimension(305, 30));
        this.shelf4.setPreferredSize(new Dimension(246, 30));
        this.shelf4.setExclusive(false);
        this.shelf4.setLayout(null);
        this.drawer1.setBorder(new SoftBevelBorder(1));
        this.drawer1.setMaximizeComponent(this.yAxisPanel1);
        this.drawer1.setMaximumSize(new Dimension(290, 170));
        this.drawer1.setMinimumSize(new Dimension(290, 24));
        this.drawer1.setPreferredSize(new Dimension(290, 24));
        this.drawer1.setLayout(new AbsoluteLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.xAxisTitleField.setBackground(new Color(255, 255, 254));
        this.xAxisTitleField.setText("X-Axis");
        this.xAxisTitleField.setToolTipText("The title of the x-axis");
        this.xAxisTitleField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.xAxisTitleFieldActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.xAxisTitleField, new AbsoluteConstraints(40, 10, 80, 20));
        this.xTicsCheckbox.setSelected(true);
        this.xTicsCheckbox.setText("Tics");
        this.xTicsCheckbox.setToolTipText("Display tics on the x-axis.");
        this.xTicsCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.xTicsCheckboxActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.xTicsCheckbox, new AbsoluteConstraints(10, 90, -1, -1));
        this.jLabel6.setText("Title");
        this.jPanel1.add((Component)this.jLabel6, new AbsoluteConstraints(10, 10, -1, 20));
        this.typeGroup.add(this.xAxisLinear);
        this.xAxisLinear.setSelected(true);
        this.xAxisLinear.setText("Linear");
        this.xAxisLinear.setToolTipText("Use linear x-axis");
        this.xAxisLinear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.xAxisLinearActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.xAxisLinear, new AbsoluteConstraints(10, 40, -1, 20));
        this.typeGroup.add(this.xAxisLog);
        this.xAxisLog.setText("Logarithmic");
        this.xAxisLog.setToolTipText("Use logarithmic x-axis");
        this.xAxisLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.xAxisLogActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.xAxisLog, new AbsoluteConstraints(10, 60, -1, 20));
        this.redoTicsX.setText("+");
        this.redoTicsX.setToolTipText("Redraw the axis tics");
        this.redoTicsX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.redoTicsXActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.redoTicsX, new AbsoluteConstraints(60, 110, -1, -1));
        this.xTitleFontBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/FontIcon.png")));
        this.xTitleFontBtn.setToolTipText("Choose the font of the x-axis title.");
        this.xTitleFontBtn.setAlignmentX(1.0f);
        this.xTitleFontBtn.setAlignmentY(1.0f);
        this.xTitleFontBtn.setIconTextGap(0);
        this.xTitleFontBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.xTitleFontBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.xTitleFontBtn, new AbsoluteConstraints(120, 10, 24, 22));
        this.redoTicsX1.setText("-");
        this.redoTicsX1.setToolTipText("Redraw the axis tics");
        this.redoTicsX1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.redoTicsX1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.redoTicsX1, new AbsoluteConstraints(110, 110, -1, -1));
        this.jLabel10.setText("Tic size:");
        this.jPanel1.add((Component)this.jLabel10, new AbsoluteConstraints(10, 113, -1, -1));
        this.drawer1.add((Component)this.jPanel1, new AbsoluteConstraints(10, 20, 150, 150));
        this.yAxisPanel1.setPreferredSize(new Dimension(227, 15));
        this.yAxisPanel1.setLayout(new AbsoluteLayout());
        this.headerLabel1.setText(" X-Axis properties");
        this.headerLabel1.setDark(false);
        this.yAxisPanel1.add((Component)this.headerLabel1, new AbsoluteConstraints(20, 0, 210, -1));
        this.openXPropertiesLabel.setText(" +");
        this.openXPropertiesLabel.setFore(new Color(153, 255, 153));
        this.openXPropertiesLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.openXPropertiesLabelMouseClicked(evt);
            }
        });
        this.yAxisPanel1.add((Component)this.openXPropertiesLabel, new AbsoluteConstraints(0, 0, 20, -1));
        this.drawer1.add((Component)this.yAxisPanel1, new AbsoluteConstraints(5, 5, 230, -1));
        this.shelf4.add(this.drawer1);
        this.drawer1.setBounds(2, 2, 240, 24);
        this.rightPanel.add(this.shelf4);
        this.shelf7.setMaximumSize(new Dimension(305, 100));
        this.shelf7.setMinimumSize(new Dimension(305, 30));
        this.shelf7.setPreferredSize(new Dimension(244, 30));
        this.shelf7.setExclusive(false);
        this.shelf7.setLayout(null);
        this.drawer2.setBorder(new SoftBevelBorder(1));
        this.drawer2.setMaximizeComponent(this.yAxisPanel);
        this.drawer2.setMaximumSize(new Dimension(290, 170));
        this.drawer2.setMinimumSize(new Dimension(290, 24));
        this.drawer2.setPreferredSize(new Dimension(250, 24));
        this.drawer2.setLayout(new AbsoluteLayout());
        this.jPanel5.setOpaque(false);
        this.jPanel5.setLayout(new AbsoluteLayout());
        this.yAxisTitleField.setBackground(new Color(255, 255, 254));
        this.yAxisTitleField.setText("Y-Axis");
        this.yAxisTitleField.setToolTipText("The title of the y-axis");
        this.yAxisTitleField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.yAxisTitleFieldActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.yAxisTitleField, new AbsoluteConstraints(40, 10, 80, 20));
        this.yTicsCheckbox.setSelected(true);
        this.yTicsCheckbox.setText("Tics");
        this.yTicsCheckbox.setToolTipText("toolTipText\tDisplay tics on the y-axis.");
        this.yTicsCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.yTicsCheckboxActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.yTicsCheckbox, new AbsoluteConstraints(10, 90, -1, -1));
        this.jLabel11.setText("Title");
        this.jPanel5.add((Component)this.jLabel11, new AbsoluteConstraints(10, 10, -1, 20));
        this.typeGroup1.add(this.yAxisLinear);
        this.yAxisLinear.setSelected(true);
        this.yAxisLinear.setText("Linear");
        this.yAxisLinear.setToolTipText("Use linear y-axis");
        this.yAxisLinear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.yAxisLinearActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.yAxisLinear, new AbsoluteConstraints(10, 40, -1, 20));
        this.typeGroup1.add(this.yAxisLog);
        this.yAxisLog.setText("Logarithmic");
        this.yAxisLog.setToolTipText("Use logarithmic y-axis");
        this.yAxisLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.yAxisLogActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.yAxisLog, new AbsoluteConstraints(10, 60, -1, 20));
        this.redoTicsY.setText("+");
        this.redoTicsY.setToolTipText("Redraw the axis tics");
        this.redoTicsY.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.redoTicsYActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.redoTicsY, new AbsoluteConstraints(60, 120, -1, -1));
        this.yTitleFontBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/FontIcon.png")));
        this.yTitleFontBtn.setToolTipText("Choose the font of the y-axis title.");
        this.yTitleFontBtn.setAlignmentX(1.0f);
        this.yTitleFontBtn.setAlignmentY(1.0f);
        this.yTitleFontBtn.setIconTextGap(0);
        this.yTitleFontBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.yTitleFontBtnActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.yTitleFontBtn, new AbsoluteConstraints(120, 10, 24, 22));
        this.redoTicsY1.setText("-");
        this.redoTicsY1.setToolTipText("Redraw the axis tics");
        this.redoTicsY1.setPreferredSize(new Dimension(31, 36));
        this.redoTicsY1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.redoTicsY1ActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.redoTicsY1, new AbsoluteConstraints(110, 120, -1, -1));
        this.jLabel5.setText("Tic size:");
        this.jPanel5.add((Component)this.jLabel5, new AbsoluteConstraints(10, 120, -1, -1));
        this.drawer2.add((Component)this.jPanel5, new AbsoluteConstraints(0, 20, 160, 150));
        this.yAxisPanel.setLayout(new AbsoluteLayout());
        this.openYPropertiesLabel.setText(" +");
        this.openYPropertiesLabel.setFore(new Color(153, 255, 153));
        this.openYPropertiesLabel.setPreferredSize(new Dimension(20, 16));
        this.openYPropertiesLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.openYPropertiesLabelMouseClicked(evt);
            }
        });
        this.yAxisPanel.add((Component)this.openYPropertiesLabel, new AbsoluteConstraints(0, 0, 20, -1));
        this.headerLabel4.setText(" Y-Axis properties");
        this.headerLabel4.setDark(false);
        this.headerLabel4.setPreferredSize(new Dimension(195, 16));
        this.yAxisPanel.add((Component)this.headerLabel4, new AbsoluteConstraints(20, 0, 210, -1));
        this.drawer2.add((Component)this.yAxisPanel, new AbsoluteConstraints(5, 5, 230, 16));
        this.shelf7.add(this.drawer2);
        this.drawer2.setBounds(2, 2, 240, 24);
        this.rightPanel.add(this.shelf7);
        this.shelf8.setMaximumSize(new Dimension(305, 100));
        this.shelf8.setMinimumSize(new Dimension(305, 40));
        this.shelf8.setPreferredSize(new Dimension(244, 30));
        this.shelf8.setExclusive(false);
        this.shelf8.setLayout(null);
        this.drawer3.setBorder(new SoftBevelBorder(1));
        this.drawer3.setMaximizeComponent(this.yAxisPanel2);
        this.drawer3.setMaximumSize(new Dimension(290, 280));
        this.drawer3.setMinimumSize(new Dimension(290, 24));
        this.drawer3.setPreferredSize(new Dimension(290, 24));
        this.drawer3.setLayout(new AbsoluteLayout());
        this.jPanel6.setOpaque(false);
        this.jPanel6.setLayout(new AbsoluteLayout());
        this.colorPanel.setBackground(new Color(0, 0, 0));
        this.colorPanel.setToolTipText("Choose the color of the selected spectrum");
        this.colorPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.colorPanelMouseClicked(evt);
            }
        });
        this.jPanel6.add((Component)this.colorPanel, new AbsoluteConstraints(50, 40, 20, 20));
        this.jLabel1.setText("Color");
        this.jPanel6.add((Component)this.jLabel1, new AbsoluteConstraints(10, 40, -1, 20));
        this.deleteGraphButton.setText("Delete");
        this.deleteGraphButton.setToolTipText("Delete the selected spectrum");
        this.deleteGraphButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.deleteGraphButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.deleteGraphButton, new AbsoluteConstraints(10, 170, 90, -1));
        this.graphTitleField.setBackground(new Color(255, 255, 254));
        this.graphTitleField.setToolTipText("The title of the selected spectrum");
        this.graphTitleField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.graphTitleFieldActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.graphTitleField, new AbsoluteConstraints(50, 10, 100, -1));
        this.jLabel12.setText("Title");
        this.jPanel6.add((Component)this.jLabel12, new AbsoluteConstraints(10, 10, -1, 20));
        this.toFrontBtn.setText("To front");
        this.toFrontBtn.setToolTipText("Bring the selected spectrum to front. Superimposing it on all the other spectrums.");
        this.toFrontBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.toFrontBtnActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.toFrontBtn, new AbsoluteConstraints(10, 200, 90, -1));
        this.widthField.setToolTipText("Set the stroke width of the selected spectrum");
        this.widthField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.widthFieldActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.widthField, new AbsoluteConstraints(50, 70, 40, -1));
        this.jLabel13.setText("Width");
        this.jPanel6.add((Component)this.jLabel13, new AbsoluteConstraints(10, 70, -1, 20));
        this.jLabel14.setText("Fill");
        this.jPanel6.add((Component)this.jLabel14, new AbsoluteConstraints(10, 100, -1, 20));
        this.jCheckBox1.setToolTipText("Display the spectrum as filled or outline");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.jCheckBox1, new AbsoluteConstraints(30, 100, 20, -1));
        this.correction.setText("Energy shift:");
        this.jPanel6.add((Component)this.correction, new AbsoluteConstraints(10, 140, -1, 20));
        this.correctionField.setBackground(new Color(255, 255, 254));
        this.correctionField.setToolTipText("The title of the selected spectrum");
        this.correctionField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.correctionFieldActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.correctionField, new AbsoluteConstraints(100, 140, 40, -1));
        this.width.setText("Channel width:");
        this.jPanel6.add((Component)this.width, new AbsoluteConstraints(10, 120, -1, 20));
        this.width2.setText("10.667 keV");
        this.jPanel6.add((Component)this.width2, new AbsoluteConstraints(100, 120, 60, 20));
        this.correction2.setHorizontalAlignment(0);
        this.correction2.setText("MeV");
        this.jPanel6.add((Component)this.correction2, new AbsoluteConstraints(140, 140, 30, 20));
        this.toFrontBtn1.setText("To back");
        this.toFrontBtn1.setToolTipText("Bring the selected spectrum to front. Superimposing it on all the other spectrums.");
        this.toFrontBtn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.toFrontBtn1ActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.toFrontBtn1, new AbsoluteConstraints(10, 230, 90, -1));
        this.drawer3.add((Component)this.jPanel6, new AbsoluteConstraints(10, 20, -1, 260));
        this.yAxisPanel2.setLayout(new AbsoluteLayout());
        this.headerLabel6.setText(" Graph properties");
        this.headerLabel6.setDark(false);
        this.yAxisPanel2.add((Component)this.headerLabel6, new AbsoluteConstraints(20, 0, 210, -1));
        this.openGraphPropertiesLabel.setText(" +");
        this.openGraphPropertiesLabel.setFore(new Color(153, 255, 153));
        this.openGraphPropertiesLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.openGraphPropertiesLabelMouseClicked(evt);
            }
        });
        this.yAxisPanel2.add((Component)this.openGraphPropertiesLabel, new AbsoluteConstraints(0, 0, 20, -1));
        this.drawer3.add((Component)this.yAxisPanel2, new AbsoluteConstraints(5, 5, 230, -1));
        this.shelf8.add(this.drawer3);
        this.drawer3.setBounds(2, 2, 240, 24);
        this.rightPanel.add(this.shelf8);
        this.jScrollPane1.setViewportView(this.rightPanel);
        this.jPanel2.add((Component)this.jScrollPane1, "East");
        this.jPanel14.add((Component)this.jPanel2, "Center");
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel4.setLayout(new FlowLayout(0, 2, 0));
        this.selectionLabel.setText("Selection:");
        this.selectionLabel.setEnabled(false);
        this.jPanel4.add(this.selectionLabel);
        this.selectToolButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/SelectSmall.png")));
        this.selectToolButton.setBorderPainted(false);
        this.selectToolButton.setContentAreaFilled(false);
        this.selectToolButton.setEnabled(false);
        this.selectToolButton.setFocusPainted(false);
        this.selectToolButton.setPreferredSize(new Dimension(20, 16));
        this.selectToolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.selectToolButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.selectToolButton);
        this.infoToolButton.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/CursorSmall.png")));
        this.infoToolButton.setBorderPainted(false);
        this.infoToolButton.setContentAreaFilled(false);
        this.infoToolButton.setEnabled(false);
        this.infoToolButton.setFocusPainted(false);
        this.infoToolButton.setPreferredSize(new Dimension(20, 16));
        this.infoToolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.infoToolButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.infoToolButton);
        this.jSeparator10.setOrientation(1);
        this.jSeparator10.setPreferredSize(new Dimension(4, 16));
        this.jPanel4.add(this.jSeparator10);
        this.navigationLabel.setText("Navigation:");
        this.navigationLabel.setEnabled(false);
        this.jPanel4.add(this.navigationLabel);
        this.plotControlWidgets.setEnabled(false);
        this.plotControlWidgets.setCanvas(this.graphCanvas);
        this.plotControlWidgets.constrainToPositive(true, true);
        this.jPanel4.add(this.plotControlWidgets);
        this.jSeparator11.setOrientation(1);
        this.jSeparator11.setPreferredSize(new Dimension(4, 16));
        this.jPanel4.add(this.jSeparator11);
        this.selectedObjectLabel.setText("Selected spectrum:");
        this.selectedObjectLabel.setEnabled(false);
        this.jPanel4.add(this.selectedObjectLabel);
        this.graphsCombobox1.setToolTipText("Select a spectrum to edit");
        this.graphsCombobox1.setEnabled(false);
        this.graphsCombobox1.setPreferredSize(new Dimension(125, 19));
        this.graphsCombobox1.setRenderer(new ColorComboboxRenderer());
        this.graphsCombobox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FitPanel.this.graphsCombobox1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.graphsCombobox1);
        this.areaLabel.setEnabled(false);
        this.jPanel4.add(this.areaLabel);
        this.plotColorPanel.setBackground(new Color(0, 0, 0));
        this.plotColorPanel.setToolTipText("Choose the color of the selected spectrum");
        this.plotColorPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.plotColorPanelMouseClicked(evt);
            }
        });
        this.jPanel4.add(this.plotColorPanel);
        this.plotFillPanel.setBackground(new Color(102, 102, 102));
        this.plotFillPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.plotFillPanel.setToolTipText("Fill the spectrum");
        this.plotFillPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.plotFillPanelMouseClicked(evt);
            }
        });
        this.jPanel4.add(this.plotFillPanel);
        this.plotWidthPlusBtn.setBackground(new Color(102, 102, 102));
        this.plotWidthPlusBtn.setForeground(new Color(255, 255, 255));
        this.plotWidthPlusBtn.setHorizontalAlignment(0);
        this.plotWidthPlusBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/PlusSmall.png")));
        this.plotWidthPlusBtn.setToolTipText("Increase line width");
        this.plotWidthPlusBtn.setEnabled(false);
        this.plotWidthPlusBtn.setPreferredSize(new Dimension(12, 16));
        this.jPanel4.add(this.plotWidthPlusBtn);
        this.plotWidthMinusBtn.setBackground(new Color(102, 102, 102));
        this.plotWidthMinusBtn.setForeground(new Color(255, 255, 255));
        this.plotWidthMinusBtn.setHorizontalAlignment(0);
        this.plotWidthMinusBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/MinusSmall.png")));
        this.plotWidthMinusBtn.setToolTipText("Decrease line width");
        this.plotWidthMinusBtn.setEnabled(false);
        this.plotWidthMinusBtn.setPreferredSize(new Dimension(12, 16));
        this.jPanel4.add(this.plotWidthMinusBtn);
        this.removeObjectBtn.setBackground(new Color(102, 102, 102));
        this.removeObjectBtn.setForeground(new Color(255, 255, 255));
        this.removeObjectBtn.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/DeleteSmall2.png")));
        this.removeObjectBtn.setToolTipText("Remove the currently selected graph");
        this.removeObjectBtn.setEnabled(false);
        this.removeObjectBtn.setPreferredSize(new Dimension(18, 16));
        this.removeObjectBtn.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FitPanel.this.removeObjectBtnMouseClicked(evt);
            }
        });
        this.jPanel4.add(this.removeObjectBtn);
        this.jSeparator12.setOrientation(1);
        this.jSeparator12.setPreferredSize(new Dimension(4, 16));
        this.jPanel4.add(this.jSeparator12);
        this.jPanel14.add((Component)this.jPanel4, "South");
        this.fittingPlotFrame.getContentPane().add((Component)this.jPanel14, "Center");
        this.fittingPlotFrame.setBounds(30, 20, 570, 300);
        this.jDesktopPane1.add((Component)this.fittingPlotFrame, JLayeredPane.DEFAULT_LAYER);
        this.add((Component)this.jDesktopPane1, "Center");
    }

    private void viewToolbarItemActionPerformed(ActionEvent evt) {
        if (this.viewToolbarItem.isSelected()) {
            this.jPanel4.setPreferredSize(new Dimension(this.jPanel4.getWidth(), 20));
            this.jPanel14.doLayout();
            this.jPanel14.repaint();
            this.fittingPlotFrame.doLayout();
            this.fittingPlotFrame.repaint();
            this.fittingPlotFrame.setLocation(this.fittingPlotFrame.getX(), this.fittingPlotFrame.getY());
        } else {
            this.jPanel4.setPreferredSize(new Dimension(this.jPanel4.getWidth(), 1));
            this.jPanel14.doLayout();
            this.jPanel14.repaint();
            this.fittingPlotFrame.doLayout();
            this.fittingPlotFrame.repaint();
            this.fittingPlotFrame.setLocation(this.fittingPlotFrame.getX(), this.fittingPlotFrame.getY());
        }
    }

    private void propertiesPaneItemActionPerformed(ActionEvent evt) {
        if (this.propertiesPaneItem.isSelected()) {
            this.jScrollPane1.setPreferredSize(new Dimension(280, this.rightPanel.getHeight()));
            this.jPanel2.doLayout();
            this.rightPanel.doLayout();
            this.rightPanel.repaint();
            this.fittingPlotFrame.doLayout();
            this.fittingPlotFrame.repaint();
            this.fittingPlotFrame.setLocation(this.fittingPlotFrame.getX(), this.fittingPlotFrame.getY());
        } else {
            this.jScrollPane1.setPreferredSize(new Dimension(1, this.rightPanel.getHeight()));
            this.jPanel2.doLayout();
            this.rightPanel.doLayout();
            this.rightPanel.repaint();
            this.fittingPlotFrame.doLayout();
            this.fittingPlotFrame.repaint();
            this.fittingPlotFrame.setLocation(this.fittingPlotFrame.getX(), this.fittingPlotFrame.getY());
        }
    }

    private void panLeftItemActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double m = a.getMin(0);
        double M = a.getMax(0);
        if (m < 0.4) {
            return;
        }
        double panAmnt = (M - m) / 8.0;
        a.setMinMax(m - panAmnt, M - panAmnt, 0);
        a.setTics();
        this.plotControlWidgets.setLogTics(1);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void panRightItemActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double m = a.getMin(0);
        double M = a.getMax(0);
        double panAmnt = (M - m) / 8.0;
        a.setMinMax(m + panAmnt, M + panAmnt, 0);
        a.setTics();
        this.plotControlWidgets.setLogTics(1);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void zoomOutMenuItemActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double xmin = a.getMin(0);
        double xmax = a.getMax(0);
        double ymin = a.getMin(1);
        double ymax = a.getMax(1);
        this.zoomAmnt = (xmax - xmin) / 5.0;
        a.setMinMax(xmin - this.zoomAmnt, 0.0, xmax + this.zoomAmnt, ymax + this.zoomAmnt);
        a.setTics();
        this.plotControlWidgets.setLogTics(1);
        --this.zoomLevel;
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void zoomInMenuItemActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double xmin = a.getMin(0);
        double xmax = a.getMax(0);
        double ymin = a.getMin(1);
        double ymax = a.getMax(1);
        this.zoomAmnt = (xmax - xmin) / 5.0;
        a.setMinMax(xmin + this.zoomAmnt, 0.0, xmax - this.zoomAmnt, ymax - this.zoomAmnt);
        a.setTics();
        this.plotControlWidgets.setLogTics(1);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void zoomRoiMenuItemActionPerformed(ActionEvent evt) {
        this.yRangeAutoButtonActionPerformed(null);
        if (this.regionsOfInterestTable.getRowCount() == 0) {
            return;
        }
        double min = 1000000.0;
        double max = -100.0;
        List l = this.graphCanvas.getGraphs();
        for (int i = 0; i < this.regionsOfInterestTable.getRowCount(); ++i) {
            Double d = (Double)this.regionsOfInterestTable.getValueAt(i, 0);
            double dd = d;
            if (dd < min) {
                min = dd;
            }
            if (!((dd = (d = (Double)this.regionsOfInterestTable.getValueAt(i, 1)).doubleValue()) > max)) continue;
            max = dd;
        }
        double maxy = -1.0;
        for (int i = 0; i < l.size(); ++i) {
            XYGraph g = (XYGraph)l.get(i);
            double[] y = g.getY();
            double[] x = g.getX();
            for (int j = 0; j < y.length; ++j) {
                if (!(x[j] >= min) || !(x[j] <= max) || !(y[j] > maxy)) continue;
                maxy = y[j];
            }
        }
        this.graphCanvas.getAxis().setMinMax(min, max, 0);
        this.graphCanvas.getAxis().setMinMax(0.0, maxy, 1);
        this.plotControlWidgets.setLogTics(1);
        this.graphCanvas.getAxis().setTics();
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void zoomAllMenuItemActionPerformed(ActionEvent evt) {
        this.xRangeAutoButtonActionPerformed(null);
        this.yRangeAutoButtonActionPerformed(null);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void deleteShapeItemActionPerformed(ActionEvent evt) {
        TreePath p = this.shapeSourceTree.getSelectionPath();
        String path = "../shapes";
        for (int i = 2; i < p.getPathCount() - 1; ++i) {
            DefaultMutableTreeNode nod = (DefaultMutableTreeNode)p.getPathComponent(i);
            String str = (String)nod.getUserObject();
            path = path + "/" + str;
        }
        String fName = ((File)this.getSelectedNode().getUserObject()).getName();
        File f = new File(path + "/" + fName);
        boolean status = f.delete();
        if (!status) {
            Main.warnUser("Couldn't delete file " + path + "/" + fName);
        } else {
            DefaultMutableTreeNode sel = this.getSelectedNode();
            int[] indices = new int[]{sel.getParent().getChildCount() - 1};
            DefaultMutableTreeNode selParent = (DefaultMutableTreeNode)sel.getParent();
            selParent.remove(selParent.getIndex(sel));
            Object[] nodes = new DefaultMutableTreeNode[]{sel};
            ((DefaultTreeModel)this.shapeSourceTree.getModel()).nodesWereRemoved(selParent, indices, nodes);
        }
    }

    private void removeDirRecursively(File dir) {
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                this.removeDirRecursively(list[i]);
                list[i].delete();
                continue;
            }
            this.graphs.remove(list[i]);
            this.graphsCombobox.removeItem(list[i]);
            list[i].delete();
        }
    }

    private void deleteFolderItemActionPerformed(ActionEvent evt) {
        TreePath p = this.shapeSourceTree.getSelectionPath();
        String path = "../shapes";
        for (int i = 2; i < p.getPathCount() - 1; ++i) {
            DefaultMutableTreeNode nod = (DefaultMutableTreeNode)p.getPathComponent(i);
            String str = (String)nod.getUserObject();
            path = path + "/" + str;
        }
        DefaultMutableTreeNode sel = this.getSelectedNode();
        String fName = (String)sel.getUserObject();
        File f = new File(path + "/" + fName);
        boolean status = f.delete();
        if (!status) {
            if (f.listFiles().length > 0 && Main.askUser("Confirm folder deletion", "Folder\n" + path + "/" + fName + "\nis not empty.\n Delete the whole subtree?")) {
                this.removeDirRecursively(f);
                f.delete();
                int[] indices = new int[]{sel.getParent().getChildCount() - 1};
                DefaultMutableTreeNode selParent = (DefaultMutableTreeNode)sel.getParent();
                selParent.remove(selParent.getIndex(sel));
                Object[] nodes = new DefaultMutableTreeNode[]{sel};
                ((DefaultTreeModel)this.shapeSourceTree.getModel()).nodesWereRemoved(selParent, indices, nodes);
            }
        } else {
            int[] indices = new int[]{sel.getParent().getChildCount() - 1};
            DefaultMutableTreeNode selParent = (DefaultMutableTreeNode)sel.getParent();
            selParent.remove(selParent.getIndex(sel));
            Object[] nodes = new DefaultMutableTreeNode[]{sel};
            ((DefaultTreeModel)this.shapeSourceTree.getModel()).nodesWereRemoved(selParent, indices, nodes);
        }
    }

    private void renameFolderItemActionPerformed(ActionEvent evt) {
        TreePath p = this.shapeSourceTree.getSelectionPath();
        String path = "../shapes";
        for (int i = 2; i < p.getPathCount() - 1; ++i) {
            DefaultMutableTreeNode nod = (DefaultMutableTreeNode)p.getPathComponent(i);
            String str = (String)nod.getUserObject();
            path = path + "/" + str;
        }
        String fName = (String)this.getSelectedNode().getUserObject();
        File f = new File(path + "/" + fName);
        final JDialog diag = new JDialog((Frame)Main.mainFrame, true);
        diag.getContentPane().add((Component)new HeaderLabel(" New name for " + fName + " "), "North");
        JTextField field = new JTextField(fName);
        field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                diag.dispose();
            }
        });
        diag.getContentPane().add((Component)field, "Center");
        diag.setLocation(this.shapeTreeMouse);
        diag.setUndecorated(true);
        diag.pack();
        diag.setVisible(true);
        String newName = field.getText();
        File nf = new File(path + "/" + newName);
        boolean status = f.renameTo(nf);
        if (!status) {
            Main.warnUser("Can't rename the folder " + path + "/" + fName + " to " + path + "/" + newName);
        } else {
            this.getSelectedNode().setUserObject(newName);
        }
        this.shapeSourceTree.repaint();
    }

    private void renameShapeItemActionPerformed(ActionEvent evt) {
        TreePath p = this.shapeSourceTree.getSelectionPath();
        String path = "../shapes";
        for (int i = 2; i < p.getPathCount() - 1; ++i) {
            DefaultMutableTreeNode nod = (DefaultMutableTreeNode)p.getPathComponent(i);
            String str = (String)nod.getUserObject();
            path = path + "/" + str;
        }
        String fName = ((File)this.getSelectedNode().getUserObject()).getName();
        File f = new File(path + "/" + fName);
        final JDialog diag = new JDialog((Frame)Main.mainFrame, true);
        diag.getContentPane().add((Component)new HeaderLabel(" New name for " + fName + " "), "North");
        JTextField field = new JTextField(fName);
        field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                diag.dispose();
            }
        });
        diag.getContentPane().add((Component)field, "Center");
        diag.setLocation(this.shapeTreeMouse);
        diag.setUndecorated(true);
        diag.pack();
        diag.setVisible(true);
        String newName = field.getText();
        File nf = new File(path + "/" + newName);
        boolean status = f.renameTo(nf);
        if (!status) {
            Main.warnUser("Can't rename the shape " + f + " to " + nf);
        } else {
            this.getSelectedNode().setUserObject(nf);
        }
        this.shapeSourceTree.repaint();
    }

    private void openShapeItemActionPerformed(ActionEvent evt) {
        this.openShapeBtnMouseClicked(null);
    }

    private void newFolderItemActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode n = this.getSelectedNode();
        Object obj = n.getUserObject();
        if (obj instanceof String) {
            if (((String)obj).equals("Aasi/shapes/")) {
                File newDir = new File("../shapes/New_folder");
                newDir.mkdir();
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("New_folder");
                this.files.add(newNode);
                int[] indices = new int[]{this.files.getChildCount() - 1};
                ((DefaultTreeModel)this.shapeSourceTree.getModel()).nodesWereInserted(this.files, indices);
            } else {
                String path = "../shapes";
                TreePath p = this.shapeSourceTree.getSelectionPath();
                int[] indices = new int[]{n.getChildCount()};
                for (int i = 2; i < p.getPathCount(); ++i) {
                    DefaultMutableTreeNode nod = (DefaultMutableTreeNode)p.getPathComponent(i);
                    String str = (String)nod.getUserObject();
                    path = path + "/" + str;
                }
                path = path + "/New_folder";
                File newDir = new File(path);
                newDir.mkdir();
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("New_folder");
                n.add(newNode);
                ((DefaultTreeModel)this.shapeSourceTree.getModel()).nodesWereInserted(n, indices);
            }
        }
    }

    private void refreshTreeItemActionPerformed(ActionEvent evt) {
    }

    private void clearSessionItemActionPerformed(ActionEvent evt) {
        this.loading = true;
        int n = this.session.getChildCount();
        TreeNode[] nodes = new TreeNode[n];
        int[] indices = new int[n];
        int ind = 0;
        int cur = 0;
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode nd = (DefaultMutableTreeNode)this.session.getChildAt(0);
            Object obj = nd.getUserObject();
            boolean found = false;
            for (int j = 0; j < this.fitShapesTable.getRowCount(); ++j) {
                if (this.fitShapesTable.getValueAt(j, 0) != obj) continue;
                found = true;
            }
            if (!found) {
                nodes[ind] = nd;
                indices[ind++] = i;
                Object o = this.graphs.get(obj);
                this.graphs.remove(obj);
                if (o != null) {
                    this.graphsCombobox.removeItem(obj);
                }
                this.session.remove(cur);
                continue;
            }
            ++cur;
        }
        int[] t = new int[ind];
        Object[] nod = new TreeNode[ind];
        for (int i = 0; i < t.length; ++i) {
            t[i] = indices[i];
            nod[i] = nodes[i];
        }
        if (this.graphsCombobox.getItemCount() == 0) {
            this.shapeCanvas.getGraphs().clear();
            this.shapeCanvas.getAnnotations(true).clear();
            this.shapeCanvas.refresh();
            this.shapeCanvas.repaint();
            this.graphsCombobox.setEnabled(false);
        } else {
            this.graphsComboboxActionPerformed(null);
        }
        ((DefaultTreeModel)this.shapeSourceTree.getModel()).nodesWereRemoved(this.session, t, nod);
        this.loading = false;
    }

    private void shapeSourceTreeMouseClicked(MouseEvent evt) {
        if (evt.getButton() != 3) {
            return;
        }
        this.shapeTreePopup.removeAll();
        TreePath p = this.shapeSourceTree.getSelectionPath();
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)p.getLastPathComponent();
        Object obj = n.getUserObject();
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.equals("Session")) {
                this.shapeTreePopup.add(this.clearSessionItem);
                this.shapeTreePopup.add(this.openShapeItem);
            } else if (str.equals("Shape sources")) {
                this.shapeTreePopup.add(this.addSourceItem);
            } else if (!str.equals("Database")) {
                if (str.equals("Aasi/shapes/")) {
                    this.shapeTreePopup.add(this.newFolderItem);
                } else {
                    this.shapeTreePopup.add(this.newFolderItem);
                    this.shapeTreePopup.add(this.renameFolderItem);
                    this.shapeTreePopup.add(new JSeparator());
                    this.shapeTreePopup.add(this.deleteFolderItem);
                }
            }
        }
        if (obj instanceof File) {
            this.shapeTreePopup.add(this.renameShapeItem);
            this.shapeTreePopup.add(this.saveShapeItem);
            this.shapeTreePopup.add(new JSeparator());
            this.shapeTreePopup.add(this.deleteShapeItem);
        }
        this.shapeTreePopup.add(new JSeparator());
        this.shapeTreePopup.add(this.refreshTreeItem);
        this.shapeTreePopup.show(this.shapeSourceTree, evt.getX(), evt.getY());
        this.shapeTreeMouse = this.shapeTreePopup.getLocationOnScreen();
    }

    private void clearMemBtnMouseClicked(MouseEvent evt) {
        this.loading = true;
        int n = this.graphsCombobox.getItemCount();
        int ind = 0;
        for (int i = 0; i < n; ++i) {
            Object o = this.graphsCombobox.getItemAt(ind);
            int c = this.fitShapesTable.getRowCount();
            boolean found = false;
            if (o instanceof HeaderLabel) {
                found = true;
            }
            for (int j = 0; j < c && !found; ++j) {
                if (this.fitShapesTable.getValueAt(j, 0) != o) continue;
                found = true;
            }
            if (!found) {
                this.graphsCombobox.removeItem(o);
                this.graphs.remove(o);
                continue;
            }
            ++ind;
        }
        this.graphsCombobox.repaint();
        if (this.graphsCombobox.getItemCount() == 0) {
            this.graphsCombobox.setEnabled(false);
            this.shapeCanvas.getGraphs().clear();
            this.shapeCanvas.getAnnotations(true).clear();
            this.shapeCanvas.refresh();
            this.shapeCanvas.repaint();
            this.loading = false;
        } else {
            this.loading = false;
            this.graphsCombobox.setSelectedIndex(0);
        }
    }

    private void refreshBtnMouseClicked(MouseEvent evt) {
        this.root.removeAllChildren();
        this.initTree();
    }

    private XYGraph[] openShapes(File[] files, boolean addToGraphs) {
        XYGraph[] ret = new XYGraph[files.length];
        try {
            this.toolDisabled = true;
            for (int i = 0; i < files.length; ++i) {
                XYGraph g;
                List l;
                File file;
                Object reader;
                if (files[i].getName().indexOf(".phd") != -1) {
                    reader = new PhdReader();
                    file = files[i];
                    l = ((PhdReader)reader).read(file.getCanonicalPath());
                    g = new XYGraph(true);
                    g.setX((float[])l.get(0));
                    g.setY((float[])l.get(1));
                    g.setOffset(0.0);
                    g.setTitle(file.getName());
                    this.setWidth(g, ((PhdReader)reader).getChannelWidth());
                    ret[i] = g;
                    if (!addToGraphs) continue;
                    this.addGraph(g, true);
                    continue;
                }
                reader = new ResultsReader();
                file = files[i];
                l = ((ResultsReader)reader).loadResults(file.getCanonicalPath());
                g = new XYGraph(true);
                g.setX((float[])l.get(0));
                g.setY((float[])l.get(1));
                g.setOffset(0.0);
                g.setTitle(file.getName());
                ret[i] = g;
                if (!addToGraphs) continue;
                this.addGraph(g, true);
            }
        }
        catch (Exception ex) {
            Main.warnUser("Can't load file. Possibly wrong format.");
            ex.printStackTrace();
        }
        return ret;
    }

    private void shapeSourceTreeValueChanged(TreeSelectionEvent evt) {
        if (this.loading) {
            return;
        }
        this.loading = true;
        TreePath path = this.shapeSourceTree.getSelectionPath();
        if (path == null) {
            this.loading = false;
            return;
        }
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object o = n.getUserObject();
        if (o == null) {
            this.loading = false;
            return;
        }
        if (o instanceof HeaderLabel) {
            XYGraph g = (XYGraph)this.graphs.get(o);
            if (g == null) {
                this.loading = false;
                return;
            }
            this.graphsCombobox.setSelectedItem(o);
            this.setShape(g);
        } else if (o instanceof File) {
            if (this.graphs.get(o) == null) {
                File f = (File)o;
                File[] files = new File[]{f};
                XYGraph[] g = this.openShapes(files, false);
                if (g.length == 0 || g[0].getX().length == 0) {
                    this.loading = false;
                    Main.warnUser(f.getName() + " is not a valid shape file.");
                    return;
                }
                this.graphs.put(f, g[0]);
                this.graphsToNodes.put(g[0], n);
                this.setShape(g[0]);
                boolean found = false;
                for (int i = 0; i < this.graphsCombobox.getItemCount() && !found; ++i) {
                    Object item = this.graphsCombobox.getItemAt(i);
                }
                if (!found) {
                    this.graphsCombobox.addItem(f);
                }
                this.graphsCombobox.setSelectedItem(f);
            } else {
                this.graphsCombobox.setSelectedItem(o);
                this.setShape((XYGraph)this.graphs.get(o));
            }
        }
        this.loading = false;
    }

    private void setShape(XYGraph g) {
        this.saveShapeBtn.setEnabled(true);
        this.clearMemBtn.setEnabled(true);
        this.graphsCombobox.setEnabled(true);
        this.shapeCanvas.getGraphs().clear();
        this.shapeCanvas.getAnnotations(true).clear();
        if (g == null) {
            this.colorPanel.setBackground(Color.black);
            this.graphTitleField.setText("");
            return;
        }
        this.colorPanel.setBackground(g.getColor());
        this.graphTitleField.setText(g.getTitle());
        this.widthField.setText(g.getStrokeWidth() + "");
        this.jCheckBox1.setSelected(g.isFilled());
        double of = g.getOffset();
        if (!Double.isNaN(of)) {
            this.correctionField.setEnabled(true);
            this.correctionField.setText(of + "");
            this.correctionField.setVisible(true);
            this.correction.setVisible(true);
            this.correction2.setVisible(true);
            this.width.setVisible(true);
            this.width2.setVisible(true);
            double w = this.getWidth(g);
            w = (double)((int)(w * 1000.0)) / 1000.0;
            if (w != 0.0) {
                this.width2.setText(w + " keV");
            } else {
                this.width2.setText("n/a");
            }
        } else {
            this.correctionField.setVisible(false);
            this.correction.setVisible(false);
            this.correctionField.setText("");
            this.correction2.setVisible(false);
            this.width.setVisible(false);
            this.width2.setVisible(false);
            this.correction.setVisible(false);
        }
        double[] y = g.getY();
        double[] x = g.getX();
        double ymax = g.getYmax();
        double level = 5.0;
        int xmin = -1;
        int xmax = -1;
        for (int i = 0; i < y.length; ++i) {
            if (y[i] > level && xmin == -1) {
                xmin = i;
                continue;
            }
            if (!(y[i] > level)) continue;
            xmax = i;
        }
        if (xmin == -1) {
            xmin = 0;
        }
        if (xmax == -1) {
            xmax = y.length - 1;
        }
        this.xminx = x[xmin];
        if (!this.shapeCanvas.isStarted()) {
            this.shapeCanvas.start();
        }
        this.xmaxx = x[xmax];
        this.ymaxx = g.getYmax();
        this.shapeCanvas.getAxis().setMinMax(Math.max(0.0, this.xminx - 0.1), 0.0, this.xmaxx + 0.1, ymax);
        this.shapeCanvas.addGraph(g);
        this.shapeCanvas.getAxis().setTics(3);
        double[] range = (double[])this.graphsToRanges.get(g);
        if (range != null) {
            double x1 = range[0];
            double x2 = range[1];
            if (x1 != g.getXmax() && x2 != g.getXmin()) {
                Rectangle2D.Double rect = new Rectangle2D.Double();
                ((Rectangle2D)rect).setRect(x1, 0.0, x2 - x1, 1.0E7);
                this.shapeCanvas.addAnnotation(Color.orange, true);
                this.shapeCanvas.addAnnotation(GraphCanvas.ANNOTATION_FILL, true);
                this.shapeCanvas.addAnnotation(rect, true);
                this.shapeCanvas.addAnnotation(GraphCanvas.ANNOTATION_STOP_FILL, true);
            }
        }
        this.shapeCanvas.refresh();
        this.shapeCanvas.repaint();
    }

    private void removeObjectBtnMouseClicked(MouseEvent evt) {
        this.deleteGraphButtonActionPerformed(null);
        if (this.graphCanvas.getGraphs().size() == 0) {
            this.enablePlotToolbar(false);
        }
    }

    private void infoToolButtonActionPerformed(ActionEvent evt) {
        if (this.tool == 4) {
            return;
        }
        Color c = this.infoToolButton.getBackground();
        this.infoToolButton.setBackground(c.darker());
        this.selectToolButton.setBackground(c);
        this.tool = 4;
        this.prev = null;
        this.plotControlWidgets.setSelectedTool(0);
        this.graphCanvas.repaint();
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }

    private void graphsCombobox1ActionPerformed(ActionEvent evt) {
        if (this.loading) {
            return;
        }
        Graph g = this.getSelectedGraph(true);
        this.plotColorPanel.setBackground(g.getColor());
        this.plotFillPanel.setBackground(g.isFilled() ? Color.gray : this.selectionLabel.getBackground());
    }

    private void plotColorPanelMouseClicked(MouseEvent evt) {
        this.colorPanelMouseClicked(evt);
        if (this.fr.isShowing()) {
            this.fr.repaint();
        }
    }

    private void plotFillPanelMouseClicked(MouseEvent evt) {
        Graph g;
        g.setFilled(!(g = this.getSelectedGraph(true)).isFilled());
        this.plotFillPanel.setBackground(g.isFilled() ? Color.gray : this.selectionLabel.getBackground());
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void selectToolButtonActionPerformed(ActionEvent evt) {
        if (this.tool == 5) {
            return;
        }
        Color c = this.selectToolButton.getBackground();
        this.selectToolButton.setBackground(c.darker());
        this.infoToolButton.setBackground(c);
        this.tool = 5;
        this.prev = null;
        this.plotControlWidgets.setSelectedTool(0);
        this.graphCanvas.repaint();
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }

    private void saveFigMenuItemActionPerformed(ActionEvent evt) {
        this.saveBtnActionPerformed(null);
    }

    private void openTargetMenuItemActionPerformed(ActionEvent evt) {
        this.openBtnActionPerformed(null);
    }

    private void restoreEcalButtonActionPerformed(ActionEvent evt) {
        this.restoreEcalButton.setSelected(false);
        this.restoreEcalActionPerformed(null);
    }

    private void recalibrateButtonActionPerformed(ActionEvent evt) {
        this.recalibrateButton.setSelected(false);
        this.targetEcalSlope = Double.parseDouble(this.curSlopeField.getText()) * 1000.0;
        this.targetEcalOffs = Double.parseDouble(this.curOffsField.getText()) * 1000.0;
        this.recalibrate(this.target, this.targetEcalSlope / 1000.0, this.targetEcalOffs / 1000.0);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void restoreEcalActionPerformed(ActionEvent evt) {
        this.restoreEcal.setSelected(false);
        this.recalibrate(this.target, this.targetOrigSlope / 1000.0, this.targetOrigOffs / 1000.0);
        this.curOffsField.setText((double)((long)(this.targetOrigOffs * 1000.0)) / 1000000.0 + "");
        this.curSlopeField.setText((double)((long)(this.targetOrigSlope * 1000.0)) / 1000000.0 + "");
        this.targetEcalOffs = this.targetOrigOffs;
        this.targetEcalSlope = this.targetOrigSlope;
        this.graphCanvas.refresh();
        this.residualCanvas.refresh();
        this.graphCanvas.repaint();
        this.residualCanvas.repaint();
    }

    private void openEcalPropertiesLabelMouseClicked(MouseEvent evt) {
        if (this.ecalDrawer.isMinimized()) {
            this.ecalShelf.maximize(this.ecalDrawer);
            this.openEcalPropertiesLabel.setText(" -");
        } else {
            this.ecalShelf.minimize(this.ecalDrawer);
            this.openEcalPropertiesLabel.setText(" +");
        }
    }

    private void shapeCanvasMouseExited(MouseEvent evt) {
        if (this.tool2 == 8 || this.tool2 == 9) {
            this.p = this.prev;
            this.drawEvalXor(this.p, this.ovx, this.ovy, this.shapeCanvas);
            this.ovy = Double.NEGATIVE_INFINITY;
            this.prev = null;
        }
        this.prev = null;
    }

    private void fitEnergyCalibrationOffsCheckboxActionPerformed(ActionEvent evt) {
    }

    private void removeRegionButtonActionPerformed(ActionEvent evt) {
        this.removeRegionButton.setSelected(false);
        int ind = this.regionsOfInterestTable.getSelectedRow();
        if (ind == -1) {
            return;
        }
        DefaultTableModel d = (DefaultTableModel)this.regionsOfInterestTable.getModel();
        d.removeRow(ind);
        this.graphCanvas.getAnnotations(true).clear();
        int n = this.regionsOfInterestTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Rectangle2D.Double rect = new Rectangle2D.Double();
            double x1 = (Double)this.regionsOfInterestTable.getValueAt(i, 0);
            double x2 = (Double)this.regionsOfInterestTable.getValueAt(i, 1);
            rect.setRect(x1, 0.0, x2 - x1, 10000.0);
            this.graphCanvas.addAnnotation(Color.orange, true);
            this.graphCanvas.addAnnotation(GraphCanvas.ANNOTATION_FILL, true);
            this.graphCanvas.addAnnotation(rect, true);
            this.graphCanvas.addAnnotation(GraphCanvas.ANNOTATION_STOP_FILL, true);
        }
        this.coverResidual();
        this.residualCanvas.refresh();
        this.residualCanvas.repaint();
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void addRangeButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.regionsOfInterestTable.getModel();
        String mfstr = this.fitMinField.getText();
        String Mfstr = this.fitMaxField.getText();
        if (this.fitMinField.getText().equals("min")) {
            mfstr = "0";
        }
        if (this.fitMaxField.getText().equals("max")) {
            Mfstr = this.target.getXmax() + "";
        }
        Object[] row = new Object[]{new Double(mfstr), new Double(Mfstr)};
        dtm.addRow(row);
        int xi = this.graphCanvas.getXInset();
        int yi = this.graphCanvas.getYInset();
        Rectangle2D.Double rect = new Rectangle2D.Double();
        int n = this.regionsOfInterestTable.getRowCount();
        double x1 = (Double)this.regionsOfInterestTable.getValueAt(n - 1, 0);
        double x2 = (Double)this.regionsOfInterestTable.getValueAt(n - 1, 1);
        rect.setRect(x1, 0.0, x2 - x1, 1.0E8);
        this.graphCanvas.addAnnotation(Color.orange, true);
        this.graphCanvas.addAnnotation(GraphCanvas.ANNOTATION_FILL, true);
        this.graphCanvas.addAnnotation(rect, true);
        this.graphCanvas.addAnnotation(GraphCanvas.ANNOTATION_STOP_FILL, true);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
        this.coverResidual();
        this.residualCanvas.refresh();
        this.residualCanvas.repaint();
        this.tool = 0;
        this.prev = null;
        this.addRangeButton.setSelected(false);
    }

    private void addShapeButtonActionPerformed(ActionEvent evt) {
        Object key = this.graphsCombobox.getSelectedItem();
        DefaultTableModel dtm = (DefaultTableModel)this.fitShapesTable.getModel();
        Object[] row = new Object[]{key, new Boolean(false), new Integer(1)};
        dtm.addRow(row);
        this.saveFitSetBtn.setEnabled(true);
        this.addShapeButton.setSelected(false);
        this.removeShapeBtn.setEnabled(true);
        this.fitManualButton.setEnabled(true);
    }

    private void addFileToZip(String name, File f, ZipOutputStream zout, boolean delete) {
        try {
            ZipEntry entry = new ZipEntry(name);
            FileReader reader = new FileReader(f);
            BufferedReader buf = new BufferedReader(reader);
            zout.putNextEntry(entry);
            while (buf.ready()) {
                char c = (char)buf.read();
                String s = "" + c;
                zout.write(s.getBytes());
            }
            zout.closeEntry();
            if (delete) {
                f.delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void saveFitSetBtnMouseClicked(MouseEvent evt) {
        if (!this.saveFitSetBtn.isEnabled()) {
            return;
        }
        try {
            this.toolDisabled = true;
            JFileChooser chooser = new JFileChooser();
            FileFilter f0 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("fit");
                }

                public String getDescription() {
                    return "(.fit) AASI - SIKA Fit set.";
                }
            };
            chooser.addChoosableFileFilter(f0);
            chooser.setCurrentDirectory(new File(this.chooserSaveHome));
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                this.chooserSaveHome = chooser.getSelectedFile().getPath();
                Fitter fitter = new Fitter();
                FileOutputStream fos = new FileOutputStream(chooser.getSelectedFile());
                ZipOutputStream zout = new ZipOutputStream(fos);
                this.addManualShapes(fitter);
                this.addRegionsOfInterest(fitter);
                fitter.setFitTarget(this.target);
                fitter.writeInputFiles("_FitTarget.phd", "_FitShape", "_FitInput.xml");
                this.addFileToZip("FitTarget.phd", new File("sika_data/_FitTarget.phd"), zout, true);
                this.addFileToZip("FitInput.xml", new File("sika_data/_FitInput.xml"), zout, true);
                for (int i = 0; i < this.fitShapesTable.getRowCount(); ++i) {
                    this.addFileToZip("FitShape-" + i + ".graph", new File("sika_data/_FitShape-" + i + ".graph"), zout, true);
                }
                zout.flush();
                zout.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int unzip(File f) {
        int i = 0;
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(f);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                System.out.println("Extracting: " + entry);
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream("_temp" + entry.getName());
                dest = new BufferedOutputStream(fos, 2048);
                ++i;
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return i - 2;
    }

    private void openFitSetBtnMouseClicked(MouseEvent evt) {
        try {
            FitInputReader inReader = null;
            this.toolDisabled = true;
            JFileChooser chooser = new JFileChooser();
            FileFilter f2 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("fit");
                }

                public String getDescription() {
                    return "(.fit) AASI - SIKA Fit set";
                }
            };
            chooser.addChoosableFileFilter(f2);
            chooser.setCurrentDirectory(new File(this.chooserOpenHome));
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.chooserOpenHome = chooser.getSelectedFile().getPath();
                int numShapes = this.unzip(chooser.getSelectedFile());
                inReader = new FitInputReader();
                inReader.read("_tempFitInput.xml");
                new File("_tempFitInput.xml").delete();
                PhdReader reader = new PhdReader();
                List l = reader.read("_tempFitTarget.phd");
                XYGraph g = new XYGraph();
                g.setX((float[])l.get(0));
                g.setY((float[])l.get(1));
                g.setOffset(0.0);
                g.setTitle("Target");
                this.targetEcalOffs = reader.getEnergyOffset();
                this.targetEcalSlope = reader.getEnergySlope();
                this.setWidth(g, reader.getChannelWidth());
                this.addTarget(g, true);
                new File("_tempFitTarget.phd").delete();
                for (int i = 0; i < numShapes; ++i) {
                    ResultsReader reader2 = new ResultsReader();
                    List l2 = reader2.loadResults("_tempFitShape-" + i + ".graph");
                    XYGraph g2 = new XYGraph();
                    g2.setX((float[])l2.get(0));
                    g2.setY((float[])l2.get(1));
                    g2.setOffset(0.0);
                    g2.setTitle("_FitShape-" + i + ".graph");
                    this.addGraph(g2, true);
                    this.addShapeButtonActionPerformed(null);
                    new File("_tempFitShape-" + i + ".graph").delete();
                }
                this.setupShapesAndTarget(inReader);
                this.graphsCombobox.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            Main.warnUser("Can't load file. Possibly wrong format.");
            ex.printStackTrace();
        }
    }

    private void saveShapeBtnMouseClicked(MouseEvent evt) {
        if (!this.saveShapeBtn.isEnabled()) {
            return;
        }
        try {
            this.toolDisabled = true;
            JFileChooser chooser = new JFileChooser();
            FileFilter f0 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("phd");
                }

                public String getDescription() {
                    return "(.phd) IMS2.0 format (text).";
                }
            };
            FileFilter f2 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("graph");
                }

                public String getDescription() {
                    return "(.graph) shape file (text).";
                }
            };
            chooser.addChoosableFileFilter(f0);
            chooser.addChoosableFileFilter(f2);
            chooser.setCurrentDirectory(new File(this.chooserSaveHome));
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                this.chooserSaveHome = chooser.getSelectedFile().getPath();
                if (chooser.getSelectedFile().getName().indexOf(".graph") != -1) {
                    ResultsWriter writer = new ResultsWriter();
                    XYGraph g = (XYGraph)this.graphs.get(this.graphsCombobox.getSelectedItem());
                    ArrayList<double[]> l = new ArrayList<double[]>();
                    l.add(g.getX());
                    l.add(g.getY());
                    writer.writeResults(chooser.getSelectedFile().getCanonicalPath(), l);
                } else if (chooser.getSelectedFile().getName().indexOf(".phd") != -1) {
                    PhdWriter writer = new PhdWriter();
                    XYGraph g = (XYGraph)this.graphs.get(this.graphsCombobox.getSelectedItem());
                    ArrayList<double[]> l = new ArrayList<double[]>();
                    l.add(g.getX());
                    l.add(g.getY());
                    writer.writeResults(chooser.getSelectedFile().getCanonicalPath(), l);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void openShapeBtnMouseClicked(MouseEvent evt) {
        try {
            this.toolDisabled = true;
            JFileChooser chooser = new JFileChooser();
            FileFilter f1 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("fig");
                }

                public String getDescription() {
                    return "(.fig) Complete figure with graphs and annotations (binary).";
                }
            };
            FileFilter f2 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("graph");
                }

                public String getDescription() {
                    return "(.graph) Graph only (text)";
                }
            };
            FileFilter f3 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("phd");
                }

                public String getDescription() {
                    return "(.phd) IMS2.0 format";
                }
            };
            chooser.addChoosableFileFilter(f3);
            chooser.addChoosableFileFilter(f2);
            chooser.setCurrentDirectory(new File(this.chooserOpenHome));
            chooser.setMultiSelectionEnabled(true);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.chooserOpenHome = chooser.getSelectedFile().getPath();
                File[] files = chooser.getSelectedFiles();
                for (int i = 0; i < files.length; ++i) {
                    XYGraph g;
                    List l;
                    File file;
                    Object reader;
                    if (files[i].getName().indexOf(".phd") != -1) {
                        reader = new PhdReader();
                        file = files[i];
                        l = ((PhdReader)reader).read(file.getCanonicalPath());
                        g = new XYGraph(true);
                        g.setX((float[])l.get(0));
                        g.setY((float[])l.get(1));
                        g.setOffset(0.0);
                        g.setTitle(file.getName());
                        this.setWidth(g, ((PhdReader)reader).getChannelWidth());
                        this.addGraph(g, true);
                        continue;
                    }
                    reader = new ResultsReader();
                    file = files[i];
                    l = ((ResultsReader)reader).loadResults(file.getCanonicalPath());
                    g = new XYGraph(true);
                    g.setX((float[])l.get(0));
                    g.setY((float[])l.get(1));
                    g.setOffset(0.0);
                    g.setTitle(file.getName());
                    this.addGraph(g, true);
                }
            }
        }
        catch (Exception ex) {
            Main.warnUser("Can't load file. Possibly wrong format.");
            ex.printStackTrace();
        }
    }

    private void sfitMaxFieldActionPerformed(ActionEvent evt) {
        double[] range;
        List graphs = this.shapeCanvas.getGraphs();
        if (graphs.size() == 0) {
            return;
        }
        Graph g = (Graph)graphs.get(0);
        String text = this.sfitMaxField.getText();
        double x2 = g.getXmax();
        if (!text.equalsIgnoreCase("max")) {
            try {
                x2 = Double.parseDouble(text);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((range = (double[])this.graphsToRanges.get(g)) == null) {
            range = new double[]{0.0, x2};
        }
        this.graphsToRanges.put(g, range);
        this.graphsComboboxActionPerformed(null);
    }

    private void sfitMinFieldActionPerformed(ActionEvent evt) {
        double[] range;
        List graphs = this.shapeCanvas.getGraphs();
        if (graphs.size() == 0) {
            return;
        }
        Graph g = (Graph)graphs.get(0);
        String text = this.sfitMinField.getText();
        double x1 = 0.0;
        if (!text.equalsIgnoreCase("min")) {
            try {
                x1 = Double.parseDouble(text);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((range = (double[])this.graphsToRanges.get(g)) == null) {
            range = new double[2];
            range[1] = g.getXmax();
        }
        range[0] = x1;
        this.graphsToRanges.put(g, range);
        this.graphsComboboxActionPerformed(null);
    }

    private void shapeCanvasMouseMoved(MouseEvent evt) {
        this.current = evt.getPoint();
        if (this.toolDisabled) {
            this.toolDisabled = false;
            return;
        }
        if (this.tool2 == 8 || this.tool2 == 9) {
            this.p = evt.getPoint();
            this.eval(this.p.x, this.p.y, this.shapeCanvas);
        }
        this.prev = this.p;
        this.pprev = this.p;
    }

    private void grabFitRangeActionPerformed(ActionEvent evt) {
        this.plotControlWidgets.setSelectedTool(0);
        this.tool = 9;
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private boolean between(double v, double x1, double x2, double eps) {
        double b1 = Math.min(x1, x2);
        double b2 = Math.max(x1, x2);
        return v > b1 - eps && v < b2 + eps;
    }

    private void rangeUnion() {
        double x2;
        double x1;
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        int n = this.regionsOfInterestTable.getRowCount();
        boolean[] hit = new boolean[n];
        for (int i = 0; i < n; ++i) {
            if (hit[i]) continue;
            Double X1 = (Double)this.regionsOfInterestTable.getValueAt(i, 0);
            Double X2 = (Double)this.regionsOfInterestTable.getValueAt(i, 1);
            x1 = X1;
            x2 = X2;
            Rectangle ire = new Rectangle((int)(x1 * 1000.0), 0, (int)((x2 - x1) * 1000.0), 10);
            for (int j = i + 1; j < n; ++j) {
                Double X3 = (Double)this.regionsOfInterestTable.getValueAt(j, 0);
                Double X4 = (Double)this.regionsOfInterestTable.getValueAt(j, 1);
                double x3 = X3;
                double x4 = X4;
                boolean b1 = this.between(x1, x3, x4, 1.0E-4);
                boolean b2 = this.between(x2, x3, x4, 1.0E-4);
                if (b1 && b2) {
                    hit[j] = true;
                    continue;
                }
                if (!b1 && !b2 && !this.between(x3, x1, x2, 1.0E-4) && !this.between(x4, x1, x2, 1.0E-4)) continue;
                Rectangle jre = new Rectangle((int)(x3 * 1000.0), 0, (int)((x4 - x3) * 1000.0), 10);
                ire = ire.union(jre);
                hit[j] = true;
            }
            list.add(ire);
        }
        DefaultTableModel dtm = (DefaultTableModel)this.regionsOfInterestTable.getModel();
        for (int i = 0; i < n; ++i) {
            dtm.removeRow(0);
        }
        this.graphCanvas.getAnnotations().clear();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Rectangle r = (Rectangle)iter.next();
            x1 = r.getX();
            x2 = x1 + r.getWidth();
            Object[] row = new Object[]{new Double(x1 /= 1000.0), new Double(x2 /= 1000.0)};
            dtm.addRow(row);
        }
    }

    private void openROIPropertiesLabelMouseClicked(MouseEvent evt) {
        if (this.drawer4.isMinimized()) {
            this.shelf5.maximize(this.drawer4);
            this.openROIPropertiesLabel.setText(" -");
        } else {
            this.shelf5.minimize(this.drawer4);
            this.openROIPropertiesLabel.setText(" +");
        }
    }

    private void replaceWithCurrentItemActionPerformed(ActionEvent evt) {
        int ind = this.fitShapesTable.getSelectedRow();
        if (ind != -1) {
            DefaultTableModel m = (DefaultTableModel)this.fitShapesTable.getModel();
            HeaderLabel key = (HeaderLabel)this.graphsCombobox.getSelectedItem();
            DefaultTableModel dtm = (DefaultTableModel)this.fitShapesTable.getModel();
            Object[] row = new Object[]{key, new Boolean(false), new Integer(1)};
            System.out.println("Adding row:" + key.toString());
            this.fitShapesTable.setValueAt(key, ind, 0);
            this.fitShapesTable.setValueAt(new Boolean(false), ind, 1);
            this.fitShapesTable.setValueAt(new Integer(1), ind, 2);
        }
        this.fitShapesTablePopup.setVisible(false);
    }

    private void removeAllShapesItemActionPerformed(ActionEvent evt) {
        DefaultTableModel mod = (DefaultTableModel)this.fitShapesTable.getModel();
        int n = this.fitShapesTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            mod.removeRow(0);
        }
        this.fitShapesTablePopup.setVisible(false);
        this.saveFitSetBtn.setEnabled(false);
        this.removeShapeBtn.setEnabled(false);
        this.fitManualButton.setEnabled(false);
    }

    private void removeShapeItemActionPerformed(ActionEvent evt) {
        int ind = this.fitShapesTable.getSelectedRow();
        if (ind >= 0) {
            DefaultTableModel mod = (DefaultTableModel)this.fitShapesTable.getModel();
            mod.removeRow(ind);
        }
        if (this.fitShapesTable.getRowCount() == 0) {
            this.saveFitSetBtn.setEnabled(false);
            this.removeShapeBtn.setEnabled(false);
            this.fitManualButton.setEnabled(false);
        }
        this.fitShapesTablePopup.setVisible(false);
    }

    private void fitShapesTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.fitShapesTablePopup.show(this.fitShapesTable, evt.getX(), evt.getY());
        } else {
            this.graphsCombobox.setSelectedItem(this.fitShapesTable.getValueAt(this.fitShapesTable.getSelectedRow(), 0));
        }
    }

    private void binRadioButtonActionPerformed(ActionEvent evt) {
        this.linStepsField.setEnabled(false);
        this.binDepthField.setEnabled(true);
        this.stepsLabel.setEnabled(false);
        this.depthLabel.setEnabled(true);
    }

    private void linRadioButtonActionPerformed(ActionEvent evt) {
        this.linStepsField.setEnabled(true);
        this.binDepthField.setEnabled(false);
        this.stepsLabel.setEnabled(true);
        this.depthLabel.setEnabled(false);
    }

    private void removeShapeBtnMouseClicked(MouseEvent evt) {
        this.removeShapeItemActionPerformed(null);
    }

    private void drawer5MouseClicked(MouseEvent evt) {
    }

    private void shapeCanvasMouseReleased(MouseEvent evt) {
        this.p = evt.getPoint();
        if (this.tool2 == 1) {
            this.end = evt.getPoint();
            int xi = this.shapeCanvas.getXInset();
            int yi = this.shapeCanvas.getYInset();
            int wi = xi + this.shapeCanvas.getAxis().getSize(0);
            int hi = yi + this.shapeCanvas.getAxis().getSize(1);
            int x = evt.getX();
            int y = evt.getY();
            if (evt.getButton() != 3 && this.isDragging) {
                if (this.start.equals(this.end)) {
                    return;
                }
                if (y < hi && Math.abs(this.start.x - this.end.x) < 10) {
                    return;
                }
                this.zoom(this.shapeCanvas);
                this.userRange = true;
                this.shapeCanvas.repaint();
            } else if (evt.getButton() == 3 || x < xi || y > hi) {
                this.p = evt.getPoint();
                this.zoom(evt.getPoint(), evt.getButton() == 1 ? 1 : 3, this.shapeCanvas);
                this.userRange = true;
            }
        }
        if (this.tool2 == 8 || this.tool2 == 9) {
            double x2;
            double ex;
            double x1 = this.getDomain(this.start.x, this.shapeCanvas);
            double sx = (double)((int)(1000.0 * x1)) / 1000.0;
            if (sx > (ex = (double)((int)(1000.0 * (x2 = this.getDomain(this.end.x, this.shapeCanvas)))) / 1000.0)) {
                double t = sx;
                sx = ex;
                ex = t;
            }
            Rectangle2D.Double rect = new Rectangle2D.Double();
            this.sfitMinField.setText(sx + "");
            this.sfitMaxField.setText(ex + "");
            ((Rectangle2D)rect).setRect(sx, 0.0, ex - sx, 1000000.0);
            this.shapeCanvas.getAnnotations(true).clear();
            this.shapeCanvas.addAnnotation(Color.orange, true);
            this.shapeCanvas.addAnnotation(GraphCanvas.ANNOTATION_FILL, true);
            this.shapeCanvas.addAnnotation(rect, true);
            this.shapeCanvas.addAnnotation(GraphCanvas.ANNOTATION_STOP_FILL, true);
            this.shapeCanvas.refresh();
            this.shapeCanvas.repaint();
            this.acquireFitRange.setSelected(false);
            List l = this.shapeCanvas.getGraphs();
            if (l.size() != 0) {
                XYGraph g = (XYGraph)l.get(0);
                double[] range = new double[]{sx, ex};
                this.graphsToRanges.put(g, range);
            }
            this.tool2 = 0;
        }
    }

    private void shapeCanvasMousePressed(MouseEvent evt) {
        this.isDragging = false;
        if (this.tool2 == 1 || this.tool2 == 8 || this.tool2 == 9) {
            this.start = evt.getPoint();
            if (this.tool2 == 8 || this.tool2 == 9) {
                this.start.y = this.shapeCanvas.getHeight() - 2;
            }
            this.end = null;
        }
        this.prev = evt.getPoint();
        this.pprev = evt.getPoint();
    }

    private void shapeCanvasMouseDragged(MouseEvent evt) {
        this.isDragging = true;
        if (this.tool2 == 2) {
            Point p = evt.getPoint();
            if (this.pprev != null) {
                this.pan(p, this.pprev, this.shapeCanvas);
            }
        }
        if (this.tool2 == 1) {
            if (this.end != null) {
                this.fillRectXor(this.shapeCanvas);
            }
            this.end = evt.getPoint();
            this.fillRectXor(this.shapeCanvas);
        }
        if (this.tool2 == 8) {
            if (this.end != null) {
                this.fillRectXor(this.shapeCanvas);
            }
            this.end = evt.getPoint();
            this.end.y = this.shapeCanvas.getHeight() - 2;
            this.fillRectXor(this.shapeCanvas);
        }
        this.prev = evt.getPoint();
        this.pprev = evt.getPoint();
    }

    private void binarySearch() {
        final int depth = this.binDepth;
        try {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    Main.setPopupPlot(false);
                    int num = 2;
                    float ohigh = FitPanel.this.high;
                    float olow = FitPanel.this.low;
                    float mid = -1.0f;
                    float lastMin = -1.0f;
                    boolean convergence = false;
                    boolean outside = false;
                    FittingProgressMonitor mon = new FittingProgressMonitor(Main.mainFrame, "Parameter search: " + FitPanel.this.par.getName() + " (binary stepping) progress");
                    Main.setProgressMonitor(mon);
                    mon.setNumProcessPhases(depth + 1);
                    int total = 1;
                    for (int k = 0; k < depth && !convergence; ++k) {
                        float cval = FitPanel.this.low;
                        if (mid != -1.0f) {
                            cval = mid;
                            num = 1;
                        }
                        FitPanel.this.cInd = 0;
                        while (FitPanel.this.cInd < num) {
                            long stime = System.currentTimeMillis();
                            mon.setUnbounded(false);
                            float step = FitPanel.this.high - FitPanel.this.low;
                            FitPanel.this.newVal.setValue(new Float(cval));
                            float pval = FitPanel.this.newVal.getFloatValue().floatValue();
                            System.out.println("\tbsrch:Param: " + FitPanel.this.newVal.getName() + " current val:" + FitPanel.this.newVal.getValue() + " interval: [" + FitPanel.this.low + "," + FitPanel.this.high + "]");
                            mon.setProcessPhase(total);
                            Main.setProgressMonitor(mon);
                            int nnuclides = Main.mainFrame.runAndWait();
                            System.out.println("\tbsrch:Simulated: " + nnuclides + " nuclides");
                            if (mon.isCancelled()) break;
                            Fitter f = new Fitter();
                            f.setFitTarget(FitPanel.this.target);
                            f.setEnergyCalibration(FitPanel.this.targetEcalSlope, FitPanel.this.targetEcalOffs, FitPanel.this.fitEnergyCalibrationSlopeCheckbox.isSelected(), FitPanel.this.fitEnergyCalibrationOffsCheckbox.isSelected());
                            FitPanel.this.addRegionsOfInterest(f);
                            if (FitPanel.this.includeManualCheckbox.isSelected()) {
                                FitPanel.this.addManualShapes(f);
                            }
                            f.setProgressMonitor(mon);
                            mon.setUnbounded(true);
                            Iterator iter = FitPanel.this.simGraphs.iterator();
                            ArrayList<Integer> absorbed = new ArrayList<Integer>();
                            for (int i = 0; iter.hasNext() && i < nnuclides; ++i) {
                                XYGraph g = (XYGraph)iter.next();
                                f.addFitShape(g, 5, false, 0.0);
                                absorbed.add(new Integer(Main.mainFrame.getAbsorbed(i)));
                                System.out.println("\t\tbsrch:" + g.getTitle() + "-> to fitting");
                            }
                            f.fit();
                            FitPanel.this.simGraphs.clear();
                            if (mon.isCancelled() || mon.isStopped()) break;
                            System.out.println("ChiSq:" + f.getChiSquared());
                            XYGraph result = f.getResultsGraph();
                            XYGraph resi = f.getResidualGraph();
                            ++total;
                            mon.setETA((System.currentTimeMillis() - stime) * (long)(depth + 1));
                            double chi = f.getChiSquared();
                            mon.addResult(result, "Param:" + (double)((long)(pval * 100.0f)) / 100.0 + " ChiSq:" + (double)((long)(chi * 100.0)) / 100.0);
                            if (chi < FitPanel.this.minChi) {
                                FitPanel.this.minChi = chi;
                                FitPanel.this.minInd = 0;
                                FitPanel.this.minVal = pval;
                                FitPanel.this.cgraphs.clear();
                                FitPanel.this.cgraphs.add(result);
                                FitPanel.this.cresiduals.clear();
                                FitPanel.this.cresiduals.add(resi);
                                FitPanel.this.searchResults.clear();
                                FitPanel.this.cabsorbed = absorbed;
                                FitPanel.this.cfitter = f;
                                FitPanel.this.addResultGraphs(f.getResultReader(), FitPanel.this.searchResults);
                                if (f.getResultReader().hasEnergyCalibration()) {
                                    System.out.println("Recalibrating the fit target graph!!!");
                                    double slope = f.getResultReader().getSlope();
                                    double offset = f.getResultReader().getOffset();
                                    FitPanel.this.targetEcalOffs = offset * 1000.0;
                                    FitPanel.this.targetEcalSlope = slope * 1000.0;
                                    FitPanel.this.recalibrate(FitPanel.this.target, slope, offset);
                                    FitPanel.this.curOffsField.setText((double)((long)(FitPanel.this.targetEcalOffs * 1000.0)) / 1000000.0 + "");
                                    FitPanel.this.curSlopeField.setText((double)((long)(FitPanel.this.targetEcalSlope * 1000.0)) / 1000000.0 + "");
                                }
                            }
                            cval += step;
                            System.out.println("bsrch: Step done =================================");
                            ++FitPanel.this.cInd;
                        }
                        if (mon.isCancelled()) break;
                        if (convergence && k == 1) {
                            outside = true;
                        }
                        lastMin = FitPanel.this.minVal;
                        mid = FitPanel.this.low + (FitPanel.this.high - FitPanel.this.low) / 2.0f;
                        FitPanel.this.high = Math.max(FitPanel.this.minVal, mid);
                        FitPanel.this.low = Math.min(FitPanel.this.minVal, mid);
                        FitPanel.this.res = FitPanel.this.minVal;
                    }
                    String msg = "";
                    if (mon.isCancelled()) {
                        mon.stop();
                        mon.dispose();
                        Main.setProgressMonitor(null);
                        FitPanel.this.iterating = false;
                        FitPanel.this.search = false;
                        Main.setPopupPlot(true);
                        return;
                    }
                    if (FitPanel.this.minVal == ohigh || FitPanel.this.minVal == olow) {
                        msg = "( search ended at the boundary)";
                    }
                    int[] loc = new int[]{10, 20};
                    mon.stop();
                    mon.dispose();
                    Main.setProgressMonitor(null);
                    FitPanel.this.fresult = (XYGraph)FitPanel.this.cgraphs.get(FitPanel.this.minInd);
                    FitPanel.this.showResults(FitPanel.this.cfitter, FitPanel.this.cabsorbed);
                    FitPanel.this.fresult.setColor(Color.black);
                    FitPanel.this.fresult.setTitle("Fitted total");
                    FitPanel.this.addGraph(FitPanel.this.fresult, false, true);
                    for (int i = 0; i < FitPanel.this.searchResults.size(); ++i) {
                        XYGraph gr = (XYGraph)FitPanel.this.searchResults.get(i);
                        FitPanel.this.addGraph(gr, false, true);
                        int[] loc2 = new int[]{10, 35 + i * 15};
                    }
                    FitPanel.this.residual = (XYGraph)FitPanel.this.cresiduals.get(FitPanel.this.minInd);
                    FitPanel.this.fresult.setColor(Color.black);
                    FitPanel.this.fr.setParameterValue(FitPanel.this.newVal.getName(), (double)((long)(FitPanel.this.minVal * 100.0f)) / 100.0);
                    double max = FitPanel.this.residual.getYmax();
                    FitPanel.this.residualCanvas.getGraphs().clear();
                    FitPanel.this.residual.setColor(Color.red);
                    FitPanel.this.residualCanvas.addGraph(FitPanel.this.residual);
                    FitPanel.this.graphCanvas.refresh();
                    FitPanel.this.graphCanvas.repaint();
                    FitPanel.this.residualCanvas.refresh();
                    FitPanel.this.residualCanvas.repaint();
                    Main.putParameter(FitPanel.this.par.hashKey(), FitPanel.this.par);
                    FitPanel.this.iterating = false;
                    Main.setPopupPlot(true);
                    FitPanel.this.iterating = false;
                    FitPanel.this.search = false;
                    Main.setProgressMonitor(null);
                    Main.mainFrame.setPage(8);
                }
            });
            t.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void linearSearch() {
        try {
            this.searchResults.clear();
            Thread t = new Thread(new Runnable(){

                public void run() {
                    Main.setPopupPlot(false);
                    int num = FitPanel.this.linSteps;
                    float ohigh = FitPanel.this.high;
                    float olow = FitPanel.this.low;
                    float mid = -1.0f;
                    float lastMin = -1.0f;
                    boolean convergence = false;
                    boolean outside = false;
                    float cval = FitPanel.this.low;
                    FittingProgressMonitor mon = new FittingProgressMonitor(Main.mainFrame, "Parameter search: " + FitPanel.this.par.getName() + " (linear stepping) progress");
                    Main.setProgressMonitor(mon);
                    mon.setNumProcessPhases(num);
                    FitPanel.this.cInd = 0;
                    while (FitPanel.this.cInd < num) {
                        long stime = System.currentTimeMillis();
                        mon.setUnbounded(false);
                        float step = (FitPanel.this.high - FitPanel.this.low) / (float)(num - 1);
                        FitPanel.this.newVal.setValue(new Float(cval));
                        float pval = FitPanel.this.newVal.getFloatValue().floatValue();
                        System.out.println("\tlsrch: Param: " + FitPanel.this.newVal.getName() + " current val:" + FitPanel.this.newVal.getValue() + " interval: [" + FitPanel.this.low + "," + FitPanel.this.high + "]");
                        mon.setProcessPhase(FitPanel.this.cInd + 1);
                        int nnuclides = Main.mainFrame.runAndWait();
                        System.out.println("\tlsrch: Simulated " + nnuclides + " nuclides");
                        if (mon.isCancelled() || mon.isStopped()) break;
                        Fitter f = new Fitter();
                        f.setProgressMonitor(mon);
                        f.setFitTarget(FitPanel.this.target);
                        f.setEnergyCalibration(FitPanel.this.targetEcalSlope, FitPanel.this.targetEcalOffs, FitPanel.this.fitEnergyCalibrationSlopeCheckbox.isSelected(), FitPanel.this.fitEnergyCalibrationOffsCheckbox.isSelected());
                        FitPanel.this.addRegionsOfInterest(f);
                        if (FitPanel.this.includeManualCheckbox.isSelected()) {
                            FitPanel.this.addManualShapes(f);
                        }
                        Iterator iter = FitPanel.this.simGraphs.iterator();
                        ArrayList<Integer> absorbed = new ArrayList<Integer>();
                        for (int i = 0; iter.hasNext() && i < nnuclides; ++i) {
                            XYGraph g = (XYGraph)iter.next();
                            System.out.println("\t\tlsrch: " + g.getTitle() + " -> to fitting");
                            f.addFitShape(g, 5, false, 0.0);
                            absorbed.add(new Integer(Main.mainFrame.getAbsorbed(i)));
                        }
                        f.fit();
                        FitPanel.this.simGraphs.clear();
                        if (mon.isCancelled() || mon.isStopped()) break;
                        System.out.println("ChiSq:" + f.getChiSquared());
                        XYGraph result = f.getResultsGraph();
                        XYGraph residual = f.getResidualGraph();
                        double chi = f.getChiSquared();
                        mon.addResult(result, "Param:" + (double)((long)(pval * 100.0f)) / 100.0 + " ChiSq:" + (double)((long)(chi * 100.0)) / 100.0);
                        if (chi < FitPanel.this.minChi) {
                            FitPanel.this.minChi = chi;
                            FitPanel.this.minInd = FitPanel.this.cInd;
                            FitPanel.this.minVal = pval;
                            FitPanel.this.searchResults.clear();
                            FitPanel.this.addResultGraphs(f.getResultReader(), FitPanel.this.searchResults);
                            FitPanel.this.cgraphs.clear();
                            FitPanel.this.cresiduals.clear();
                            FitPanel.this.minInd = 0;
                            FitPanel.this.cgraphs.add(result);
                            FitPanel.this.cresiduals.add(residual);
                            FitPanel.this.cabsorbed = absorbed;
                            FitPanel.this.cfitter = f;
                            if (f.getResultReader().hasEnergyCalibration()) {
                                System.out.println("Recalibrating the fit target graph!!!");
                                double slope = f.getResultReader().getSlope();
                                double offset = f.getResultReader().getOffset();
                                FitPanel.this.targetEcalOffs = offset * 1000.0;
                                FitPanel.this.targetEcalSlope = slope * 1000.0;
                                FitPanel.this.recalibrate(FitPanel.this.target, slope, offset);
                                FitPanel.this.curOffsField.setText((double)((long)(FitPanel.this.targetEcalOffs * 1000.0)) / 1000000.0 + "");
                                FitPanel.this.curSlopeField.setText((double)((long)(FitPanel.this.targetEcalSlope * 1000.0)) / 1000000.0 + "");
                            }
                        }
                        cval += step;
                        long eta = (System.currentTimeMillis() - stime) * (long)num;
                        mon.setETA(eta);
                        System.out.println("lsrch: Step done ============================");
                        ++FitPanel.this.cInd;
                    }
                    if (mon.isCancelled()) {
                        mon.stop();
                        mon.dispose();
                        Main.setProgressMonitor(null);
                        FitPanel.this.iterating = false;
                        FitPanel.this.search = false;
                        Main.setPopupPlot(true);
                        return;
                    }
                    lastMin = FitPanel.this.minVal;
                    mid = FitPanel.this.low + (FitPanel.this.high - FitPanel.this.low) / 2.0f;
                    FitPanel.this.high = Math.max(FitPanel.this.minVal, mid);
                    FitPanel.this.low = Math.min(FitPanel.this.minVal, mid);
                    FitPanel.this.res = FitPanel.this.minVal;
                    mon.stop();
                    mon.dispose();
                    Main.setProgressMonitor(null);
                    String msg = "";
                    int[] loc = new int[]{10, 20};
                    FitPanel.this.fresult = (XYGraph)FitPanel.this.cgraphs.get(FitPanel.this.minInd);
                    FitPanel.this.showResults(FitPanel.this.cfitter, FitPanel.this.cabsorbed);
                    FitPanel.this.fr.setParameterValue(FitPanel.this.newVal.getName(), (double)((long)(FitPanel.this.minVal * 100.0f)) / 100.0);
                    FitPanel.this.fresult.setColor(Color.black);
                    FitPanel.this.fresult.setTitle("Fitted total");
                    FitPanel.this.addGraph(FitPanel.this.fresult, false, true);
                    for (int i = 0; i < FitPanel.this.searchResults.size(); ++i) {
                        XYGraph gr = (XYGraph)FitPanel.this.searchResults.get(i);
                        FitPanel.this.addGraph(gr, false, true);
                    }
                    FitPanel.this.residual = (XYGraph)FitPanel.this.cresiduals.get(FitPanel.this.minInd);
                    FitPanel.this.fresult.setColor(Color.black);
                    double max = FitPanel.this.residual.getYmax();
                    double min = FitPanel.this.residual.getYmin();
                    FitPanel.this.residualCanvas.getGraphs().clear();
                    FitPanel.this.residual.setColor(Color.red);
                    FitPanel.this.residualCanvas.addGraph(FitPanel.this.residual);
                    max = FitPanel.this.graphCanvas.getAxis().getMax(0);
                    min = FitPanel.this.graphCanvas.getAxis().getMin(0);
                    FitPanel.this.residualCanvas.getAxis().setMinMax(min, max, 0);
                    FitPanel.this.graphCanvas.refresh();
                    FitPanel.this.residualCanvas.refresh();
                    FitPanel.this.residualCanvas.repaint();
                    FitPanel.this.graphCanvas.repaint();
                    Main.putParameter(FitPanel.this.par.hashKey(), FitPanel.this.par);
                    FitPanel.this.iterating = false;
                    Main.setPopupPlot(true);
                    FitPanel.this.search = false;
                    Main.mainFrame.setPage(8);
                }
            });
            t.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void deleteFiles() {
        try {
            File f = new File("./sika_data/FitResults.xml");
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception ex) {
            Main.warnUser(ex.getMessage(), true);
        }
    }

    private void addResultGraphs(SikaOutputReader r, List l) {
        int n = r.getNumShapes();
        Color[] cycle = new Color[]{Color.blue, Color.red, Color.green, Color.MAGENTA, Color.PINK};
        for (int i = 0; i < n; ++i) {
            String name = r.getShapeName(i);
            String fName = r.getShapeFileName(name);
            if (fName == null) continue;
            ResultsReader rr = new ResultsReader();
            List li = rr.loadResults("./sika_data/" + fName);
            XYGraph g = new XYGraph(true);
            g.setTitle(name);
            g.setX((float[])li.get(0));
            g.setY((float[])li.get(1));
            g.setColor(cycle[i % cycle.length]);
            l.add(g);
        }
    }

    private void fitButton1ActionPerformed(ActionEvent evt) {
        Float fmax;
        boolean steps = true;
        this.deleteFiles();
        if (this.target == null) {
            Main.warnUser("Must have a target for parameter search!");
            this.iterating = false;
            return;
        }
        List g = this.graphCanvas.getGraphs();
        Object o = g.get(0);
        g.clear();
        g.add(o);
        this.graphCanvas.getAnnotations().clear();
        this.cgraphs.clear();
        this.iterating = true;
        this.par = (Parameter)this.variableParamsTable.getValueAt(this.variationRow, 0);
        if (this.variationRow == -1 || this.par == null) {
            Main.warnUser("Must select one parameter to search for!!");
            this.iterating = false;
            return;
        }
        this.newVal = (Parameter)this.par.clone();
        Object dbl = this.variableParamsTable.getValueAt(this.variationRow, 4);
        float amnt = (float)((Float)dbl).doubleValue();
        float val = this.newVal.getFloatValue().floatValue();
        float coeff = 1.0f;
        if (this.newVal.getCoeff() != null) {
            coeff = this.newVal.getCoeff().floatValue();
        }
        float perc = coeff * this.newVal.getFloatValue().floatValue() / 100.0f * amnt;
        this.low = val - perc;
        this.high = val + perc;
        String varType = (String)this.variableParamsTable.getValueAt(this.variationRow, 5);
        this.low = val - amnt;
        this.high = val + amnt;
        Float fmin = (Float)this.par.getMinValue();
        this.minInd = 100000;
        this.minVal = 100000.0f;
        if (fmin != null && this.low < fmin.floatValue()) {
            this.low = fmin.floatValue() + 0.001f;
            if (!this.par.getMinBoundInclusive()) {
                this.low = (float)((double)this.low + 0.001);
            }
        }
        if ((fmax = (Float)this.par.getMaxValue()) != null && this.high > fmax.floatValue()) {
            this.high = fmax.floatValue() + 1.0E-4f;
            if (!this.par.getMaxBoundInclusive()) {
                this.high = (float)((double)this.high - 1.0E-4);
            }
        }
        this.newVal.setValue(new Float(this.low));
        Main.putParameter(this.newVal.hashKey(), this.newVal);
        XYGraph target = this.target;
        target.setFilled(true);
        target.setColor(Color.gray);
        this.minChi = 100000.0;
        this.minInd = -1;
        this.minVal = -1.0f;
        try {
            this.binDepth = Integer.parseInt(this.binDepthField.getText());
        }
        catch (Exception ex) {
            Main.warnUser("Depth must be an integer!");
            ex.printStackTrace();
            this.iterating = false;
            return;
        }
        try {
            this.linSteps = Integer.parseInt(this.linStepsField.getText());
        }
        catch (Exception ex) {
            Main.warnUser("Number of steps must be an integer!");
            ex.printStackTrace();
            this.iterating = false;
            return;
        }
        this.cgraphs.clear();
        this.cresiduals.clear();
        this.simGraphs.clear();
        this.search = true;
        System.out.println("Parameter search: Begin =================================");
        if (this.binRadioButton.isSelected()) {
            this.binarySearch();
        } else {
            this.linearSearch();
        }
    }

    private void acquireFitRange1ActionPerformed(ActionEvent evt) {
        this.plotControlWidgets.setSelectedTool(0);
        this.tool = 8;
        this.prev = null;
        this.p = null;
        this.rangeTarget = "target";
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void addManualShapes(Fitter fitter) {
        int n = this.fitShapesTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object key = this.fitShapesTable.getValueAt(i, 0);
            XYGraph shape = (XYGraph)this.graphs.get(key);
            Integer group = (Integer)this.fitShapesTable.getValueAt(i, 2);
            Boolean fixed = (Boolean)this.fitShapesTable.getValueAt(i, 1);
            double[] range = (double[])this.graphsToRanges.get(shape);
            Double d = (Double)this.graphsToMultipliers.get(shape);
            double mul = -1.0;
            if (d != null) {
                mul = d;
            }
            if (range == null) {
                fitter.addFitShape(shape, group, fixed, mul);
                continue;
            }
            fitter.addFitShape(shape, range[0], range[1], group, fixed, mul);
        }
    }

    private void addRegionsOfInterest(Fitter fitter) {
        int n = this.regionsOfInterestTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Double start = (Double)this.regionsOfInterestTable.getValueAt(i, 0);
            Double end = (Double)this.regionsOfInterestTable.getValueAt(i, 1);
            fitter.addTargetFitRegion(start, end);
        }
    }

    private void getEnergyCalibration(XYGraph g) {
        try {
            PhdWriter writer = new PhdWriter();
            File f = File.createTempFile("phd", null);
            ArrayList<double[]> al = new ArrayList<double[]>();
            al.add(g.getX());
            al.add(g.getY());
            writer.writeResults(f.getPath(), al);
            PhdReader reader = new PhdReader();
            List l = reader.read(f.getPath());
            f.delete();
            this.targetEcalOffs = reader.getEnergyOffset();
            this.targetEcalSlope = reader.getEnergySlope();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showResults(Fitter fitter, ArrayList absorbed) {
        if (this.fr == null) {
            this.fr = new FittingResultsFrame();
        }
        this.fr.clear();
        for (int i = 0; i < fitter.getResultReader().getNumShapes(); ++i) {
            String name = fitter.getResultReader().getShapeName(i);
            XYGraph gr = (XYGraph)this.searchResults.get(i);
            Color c = gr.getColor();
            double mul = (Double)fitter.getResultReader().getMultipliers().get(i);
            double mulUnc = (Double)fitter.getResultReader().getMultiplierUncertainties().get(i);
            double area = this.getArea(gr) / mul;
            HeaderLabel hl = new HeaderLabel(name);
            hl.setForeground(c);
            if (absorbed != null) {
                this.fr.addResult((Graph)gr, this.getArea(gr), area * mulUnc, (int)((double)((Integer)absorbed.get(i)).intValue() * mul));
            } else {
                this.fr.addResult((Graph)gr, this.getArea(gr), area * mulUnc, null);
            }
            double chi = fitter.getChiSquared();
            this.fr.setChiSquared(fitter.getChiSquared());
        }
        this.fr.show();
    }

    private void fitManualButtonActionPerformed(ActionEvent evt) {
        this.loading = true;
        this.deleteFiles();
        if (this.target == null) {
            this.loading = false;
            Main.warnUser("Must select a target for fitting!", false);
            return;
        }
        if (this.fitShapesTable.getRowCount() == 0) {
            Main.warnUser("Must select shapes for fitting!", false);
            this.loading = false;
            return;
        }
        Thread t = new Thread(new Runnable(){

            public void run() {
                Fitter fitter = FitPanel.this.buildFitter();
                FittingProgressMonitor progMon = new FittingProgressMonitor(Main.mainFrame, "Manual fitting", true);
                fitter.setProgressMonitor(progMon);
                fitter.fit();
                if (progMon.isCancelled()) {
                    return;
                }
                FitPanel.this.residualCanvas.getGraphs().clear();
                FitPanel.this.graphCanvas.getGraphs().clear();
                FitPanel.this.graphsCombobox1.removeAllItems();
                FitPanel.this.graphCanvas.getAnnotations().clear();
                FitPanel.this.addTarget(FitPanel.this.target);
                FitPanel.this.fresult = fitter.getResultsGraph();
                if (fitter.getResultReader().hasEnergyCalibration()) {
                    System.out.println("Recalibrating the fit target graph!!!");
                    double slope = fitter.getResultReader().getSlope();
                    double offset = fitter.getResultReader().getOffset();
                    FitPanel.this.targetEcalOffs = offset * 1000.0;
                    FitPanel.this.targetEcalSlope = slope * 1000.0;
                    FitPanel.this.recalibrate(FitPanel.this.target, slope, offset);
                    FitPanel.this.curOffsField.setText((double)((long)(FitPanel.this.targetEcalOffs * 1000.0)) / 1000000.0 + "");
                    FitPanel.this.curSlopeField.setText((double)((long)(FitPanel.this.targetEcalSlope * 1000.0)) / 1000000.0 + "");
                }
                FitPanel.this.loading = false;
                FitPanel.this.fresult.setTitle("Fitted total");
                FitPanel.this.addGraph(FitPanel.this.fresult, false, true);
                SikaOutputReader r = fitter.getResultReader();
                FitPanel.this.searchResults.clear();
                FitPanel.this.addResultGraphs(r, FitPanel.this.searchResults);
                Iterator itera = FitPanel.this.searchResults.iterator();
                while (itera.hasNext()) {
                    XYGraph gr = (XYGraph)itera.next();
                    FitPanel.this.addGraph(gr, false, true);
                }
                List l = fitter.getMultipliers();
                Iterator iter = l.iterator();
                int ind = 0;
                while (iter.hasNext()) {
                    Double multiplier = (Double)iter.next();
                    Object key = FitPanel.this.fitShapesTable.getValueAt(ind++, 0);
                    XYGraph shape = (XYGraph)FitPanel.this.graphs.get(key);
                    FitPanel.this.graphsToMultipliers.put(shape, multiplier);
                }
                XYGraph spec = fitter.getSpectrumGraph();
                FitPanel.this.residual = fitter.getResidualGraph();
                double chi = fitter.getChiSquared();
                FitPanel.this.showResults(fitter, null);
                for (int i = 0; i < fitter.getResultReader().getNumShapes(); ++i) {
                    String name = fitter.getResultReader().getShapeName(i);
                    XYGraph gr = (XYGraph)FitPanel.this.searchResults.get(i);
                    Color c = gr.getColor();
                    int[] loc2 = new int[]{10, 35 + i * 15};
                }
                double max = FitPanel.this.residual.getYmax();
                double min = FitPanel.this.residual.getYmin();
                FitPanel.this.residual.setColor(Color.red);
                FitPanel.this.coverResidual();
                FitPanel.this.residualCanvas.addGraph(FitPanel.this.residual);
                max = FitPanel.this.graphCanvas.getAxis().getMax(0);
                min = FitPanel.this.graphCanvas.getAxis().getMin(0);
                FitPanel.this.residualCanvas.getAxis().setMinMax(min, max, 0);
                FitPanel.this.graphCanvas.refresh();
                FitPanel.this.graphCanvas.repaint();
                FitPanel.this.residualCanvas.refresh();
                FitPanel.this.residualCanvas.repaint();
                Main.mainFrame.setPage(8);
            }
        });
        t.start();
    }

    private void coverResidual() {
        this.residualCanvas.getAnnotations().clear();
        int n = this.regionsOfInterestTable.getRowCount();
        if (n == 0) {
            return;
        }
        double[] x1s = new double[n];
        double[] x2s = new double[n];
        ArrayList ar = new ArrayList();
        Rectangle2D.Double[] r = new Rectangle2D.Double[n];
        for (int i = 0; i < n; ++i) {
            double x1 = (Double)this.regionsOfInterestTable.getValueAt(i, 0);
            double x2 = (Double)this.regionsOfInterestTable.getValueAt(i, 1);
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.setRect(x1, -5.0, x2 - x1, 1.0E8);
            r[i] = rect;
        }
        Arrays.sort(r, new Comparator(){

            public int compare(Object o1, Object o2) {
                Rectangle2D.Double r1 = (Rectangle2D.Double)o1;
                Rectangle2D.Double r2 = (Rectangle2D.Double)o2;
                if (r1.getX() < r2.getX()) {
                    return -1;
                }
                if (r1.getX() == r2.getX()) {
                    return 0;
                }
                return 1;
            }
        });
        double last = 0.0;
        this.residualCanvas.addAnnotation(Color.white);
        this.residualCanvas.addAnnotation(GraphCanvas.ANNOTATION_FILL);
        for (int i = 0; i < n; ++i) {
            Rectangle2D.Double r1 = r[i];
            double x1 = (Double)this.regionsOfInterestTable.getValueAt(i, 0);
            double x2 = (Double)this.regionsOfInterestTable.getValueAt(i, 1);
            x1 = r[i].getX();
            x2 = r[i].getWidth() + x1;
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.setRect(last, -5.0, x1 - last, 1.0E8);
            this.residualCanvas.addAnnotation(rect);
            last = x2;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double();
        rect.setRect(last, -5.0, 100000.0, 1.0E8);
        this.residualCanvas.addAnnotation(rect);
        this.residualCanvas.addAnnotation(GraphCanvas.ANNOTATION_STOP_FILL);
    }

    private void recalibrate(XYGraph g, double slope, double offset) {
        double[] x = g.getX();
        System.out.println("Recalibrate with slope:" + slope + " and offset:" + offset);
        double w = 2.0 * slope + offset - (1.0 * slope + offset);
        for (int i = 1; i < x.length + 1; ++i) {
            x[i - 1] = (double)i * slope + offset - w / 2.0;
        }
    }

    private void acquireFitRangeActionPerformed(ActionEvent evt) {
        this.rangeTarget = "shape";
        this.prev = null;
        this.p = null;
        this.tool2 = 8;
        this.shapeCanvas.refresh();
        this.shapeCanvas.repaint();
    }

    private void redoTicsX1ActionPerformed(ActionEvent evt) {
        Font f = this.graphCanvas.getAxis().getTicFont(0);
        this.graphCanvas.getAxis().setTicFont(f.deriveFont((float)f.getSize() - 1.0f), 0);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void redoTicsY1ActionPerformed(ActionEvent evt) {
        Font f = this.graphCanvas.getAxis().getTicFont(1);
        this.graphCanvas.getAxis().setTicFont(f.deriveFont((float)f.getSize() - 1.0f), 1);
        if (this.graphCanvas.getAxis().isLogarithmic(1)) {
            this.setLogTics(this.graphCanvas);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void redoTicsXActionPerformed(ActionEvent evt) {
        Font f = this.graphCanvas.getAxis().getTicFont(0);
        this.graphCanvas.getAxis().setTicFont(f.deriveFont((float)f.getSize() + 1.0f), 0);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void toFrontBtn1ActionPerformed(ActionEvent evt) {
        List l = this.graphCanvas.getGraphs();
        Object key = this.graphsCombobox.getSelectedItem();
        Graph g = (Graph)this.graphs.get(key);
        l.remove(g);
        l.add(0, g);
        this.graphsCombobox.removeItem(key);
        this.graphsCombobox.addItem(key);
        this.graphsCombobox.setSelectedItem(key);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void openGraphPropertiesLabelMouseClicked(MouseEvent evt) {
        if (this.drawer3.isMinimized()) {
            this.shelf8.maximize(this.drawer3);
            this.openGraphPropertiesLabel.setText(" -");
        } else {
            this.shelf8.minimize(this.drawer3);
            this.openGraphPropertiesLabel.setText(" +");
        }
    }

    private void openYPropertiesLabelMouseClicked(MouseEvent evt) {
        if (this.drawer2.isMinimized()) {
            this.shelf7.maximize(this.drawer2);
            this.openYPropertiesLabel.setText(" -");
        } else {
            this.shelf7.minimize(this.drawer2);
            this.openYPropertiesLabel.setText(" +");
        }
    }

    private void openXPropertiesLabelMouseClicked(MouseEvent evt) {
        if (this.drawer1.isMinimized()) {
            this.shelf4.maximize(this.drawer1);
            this.openXPropertiesLabel.setText(" -");
        } else {
            this.shelf4.minimize(this.drawer1);
            this.openXPropertiesLabel.setText(" +");
        }
    }

    private void addLineTagButtonActionPerformed(ActionEvent evt) {
        this.tool = 6;
        this.toolCoordinates = 2;
        this.graphCanvas.repaint();
        this.prev = null;
        this.start = null;
        this.p = null;
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }

    private void addTextTagButtonActionPerformed(ActionEvent evt) {
        this.tool = 3;
        this.toolCoordinates = 2;
        this.graphCanvas.repaint();
        try {
            this.graphCanvas.setCursor(Cursor.getSystemCustomCursor("Invalid.16x16"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void correctionFieldActionPerformed(ActionEvent evt) {
        this.getSelectedGraph().setOffset(Double.parseDouble(this.correctionField.getText()));
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void selectButton1ActionPerformed(ActionEvent evt) {
        this.tool = 7;
        this.graphCanvas.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FitPanel.this.drawAnchors(FitPanel.this.graphCanvas);
            }
        });
        this.prev = null;
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void pageSetupBtnActionPerformed(ActionEvent evt) {
        final JDialog diag = new JDialog(JOptionPane.getFrameForComponent(this));
        diag.setTitle("Print preview");
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (this.currentFormat == null) {
            this.currentFormat = printJob.defaultPage();
        }
        this.currentFormat = printJob.pageDialog(this.currentFormat);
        final JPanel panel = new JPanel(){

            public void paint(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g.setColor(Color.gray);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.white);
                g.fillRect(0, 0, (int)FitPanel.this.currentFormat.getWidth(), (int)FitPanel.this.currentFormat.getHeight());
                g.setColor(Color.red);
                g.drawRect((int)FitPanel.this.currentFormat.getImageableX(), (int)FitPanel.this.currentFormat.getImageableY(), (int)FitPanel.this.currentFormat.getImageableWidth(), (int)FitPanel.this.currentFormat.getImageableHeight());
                FitPanel.this.graphCanvas.setClearToBackground(false);
                g2d.scale(FitPanel.this.scalex, FitPanel.this.scaley);
                g.translate(FitPanel.this.offsx, FitPanel.this.offsy);
                FitPanel.this.graphCanvas.print(g, FitPanel.this.currentFormat, 0);
                FitPanel.this.graphCanvas.setClearToBackground(true);
            }
        };
        diag.getContentPane().add((Component)panel, "Center");
        JButton but = new JButton("Close");
        final JButton left = new JButton("Left");
        final JButton right = new JButton("Right");
        final JButton up = new JButton("Up");
        final JButton down = new JButton("Down");
        final JButton widthPlus = new JButton("+");
        final JButton widthMinus = new JButton("-");
        final JButton heightPlus = new JButton("+");
        final JButton heightMinus = new JButton("-");
        ActionListener ac = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src == left) {
                    FitPanel.this.offsx -= 5;
                } else if (src == right) {
                    FitPanel.this.offsx += 5;
                } else if (src == up) {
                    FitPanel.this.offsy -= 5;
                } else if (src == down) {
                    FitPanel.this.offsy += 5;
                } else if (src == widthPlus) {
                    FitPanel.this.scalex += 0.05;
                } else if (src == widthMinus) {
                    FitPanel.this.scalex -= 0.05;
                } else if (src == heightPlus) {
                    FitPanel.this.scaley += 0.05;
                } else if (src == heightMinus) {
                    FitPanel.this.scaley -= 0.05;
                }
                panel.repaint();
            }
        };
        left.addActionListener(ac);
        up.addActionListener(ac);
        down.addActionListener(ac);
        right.addActionListener(ac);
        widthPlus.addActionListener(ac);
        widthMinus.addActionListener(ac);
        heightPlus.addActionListener(ac);
        heightMinus.addActionListener(ac);
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                diag.dispose();
            }
        });
        JPanel buttons = new JPanel();
        buttons.add(but);
        buttons.add(new JLabel("Position:"));
        buttons.add(left);
        buttons.add(right);
        buttons.add(up);
        buttons.add(down);
        buttons.add(new JLabel("Width:"));
        buttons.add(widthPlus);
        buttons.add(widthMinus);
        buttons.add(new JLabel("Height:"));
        buttons.add(heightPlus);
        buttons.add(heightMinus);
        diag.getContentPane().add((Component)buttons, "South");
        panel.setSize((int)this.currentFormat.getWidth(), (int)this.currentFormat.getHeight());
        diag.setSize((int)this.currentFormat.getWidth() + 50, (int)this.currentFormat.getHeight() + 50);
        diag.setVisible(true);
    }

    private void printBtnActionPerformed(ActionEvent evt) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        this.graphCanvas.setPrintOffsetScale(this.offsx, this.offsy, this.scalex, this.scaley);
        if (this.currentFormat != null) {
            printJob.setPrintable(this.graphCanvas, this.currentFormat);
        } else {
            printJob.setPrintable(this.graphCanvas);
        }
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        Graph g = this.getSelectedGraph();
        if (g == null) {
            return;
        }
        g.setFilled(this.jCheckBox1.isSelected());
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void widthFieldActionPerformed(ActionEvent evt) {
        Graph g = this.getSelectedGraph();
        if (g == null) {
            return;
        }
        float w = Float.parseFloat(this.widthField.getText());
        this.defaultWidth = w;
        g.setStrokeWidth(w);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void addLineButtonActionPerformed(ActionEvent evt) {
        this.tool = 6;
        this.toolCoordinates = 1;
        this.graphCanvas.repaint();
        this.prev = null;
        this.start = null;
        this.p = null;
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }

    private int isSupported(DataFlavor[] f) {
        for (int i = 0; i < f.length; ++i) {
            if (f[i].getDefaultRepresentationClass() == null) continue;
            return i;
        }
        return -1;
    }

    private void graphCanvasKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.deleteSelectedObject();
        }
        if (evt.getKeyCode() == 86) {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                Transferable data = tk.getSystemClipboard().getContents(this);
                this.handlePaste(data);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (evt.getKeyCode() == 67) {
            this.graphCanvas.refresh();
            final BufferedImage img = this.graphCanvas.getImage();
            Toolkit tk = Toolkit.getDefaultToolkit();
            Transferable tr = new Transferable(){

                public Object getTransferData(DataFlavor flavor) {
                    return img;
                }

                public DataFlavor[] getTransferDataFlavors() {
                    DataFlavor[] f = new DataFlavor[]{DataFlavor.imageFlavor};
                    return f;
                }

                public boolean isDataFlavorSupported(DataFlavor f) {
                    return f == DataFlavor.imageFlavor;
                }
            };
            tk.getSystemClipboard().setContents(tr, null);
        }
    }

    private void handleOpenFile(File f) throws Exception {
        if (f.getName().indexOf(".fig") != -1) {
            FileInputStream fis = new FileInputStream(f);
            ObjectInputStream ois = new ObjectInputStream(fis);
            List annotations = (List)ois.readObject();
            int numGraphs = ois.readInt();
            List l = this.graphCanvas.getAnnotations();
            l.addAll(annotations);
            for (int j = 0; j < numGraphs; ++j) {
                XYGraph g = (XYGraph)ois.readObject();
                g.setOffset(0.0);
            }
        } else if (f.getName().indexOf(".phd") != -1) {
            PhdReader reader = new PhdReader();
            File file = f;
            List l = reader.read(file.getCanonicalPath());
            XYGraph g = new XYGraph(true);
            g.setX((float[])l.get(0));
            g.setY((float[])l.get(1));
            g.setOffset(0.0);
            g.setTitle(file.getName());
            this.setWidth(g, reader.getChannelWidth());
            this.targetEcalOffs = reader.getEnergyOffset();
            this.targetEcalSlope = reader.getEnergySlope();
            this.targetOrigOffs = reader.getEnergyOffset();
            this.targetOrigSlope = reader.getEnergySlope();
            g.setTitle("Fitting target");
            this.targetFileName = f.getName();
            this.addTarget(g, true);
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        } else if (f.getName().indexOf(".png") != -1 || f.getName().indexOf(".jpg") != -1 || f.getName().indexOf(".gif") != -1) {
            BufferedImage im = null;
            try {
                im = ImageIO.read(f);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (im != null) {
                this.graphCanvas.addAnnotation(im);
                int[] loc = new int[]{10, 10};
                this.graphCanvas.addAnnotation(loc);
                this.graphCanvas.refresh();
                this.graphCanvas.repaint();
            }
        } else {
            ResultsReader reader = new ResultsReader();
            File file = f;
            List l = reader.loadResults(file.getCanonicalPath());
            XYGraph g = new XYGraph(true);
            g.setX((float[])l.get(0));
            g.setY((float[])l.get(1));
            g.setOffset(0.0);
            g.setTitle(file.getName());
            this.targetEcalOffs = 0.0;
            this.targetEcalSlope = 0.0;
            this.getEnergyCalibration(g);
            this.targetOrigOffs = this.targetEcalOffs;
            this.targetOrigSlope = this.targetEcalSlope;
            g.setTitle("Fitting target");
            this.targetFileName = f.getName();
            this.addTarget(g, true);
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        }
    }

    public void handlePaste(Transferable data) {
        try {
            if (data.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image i = (Image)data.getTransferData(DataFlavor.imageFlavor);
                if (this.current != null) {
                    this.graphCanvas.addAnnotation(i);
                    if (this.toolCoordinates == 2) {
                        double ax = this.graphCanvas.getAxis().getValueForAxisCoordinate(this.current.x - this.graphCanvas.getXInset(), 0);
                        int al = this.graphCanvas.getAxis().getLocation().y;
                        double ay = this.graphCanvas.getAxis().getValueForAxisCoordinate(al - this.current.y, 1);
                        double[] loc = new double[]{ax, ay};
                        this.graphCanvas.addAnnotation(loc);
                    } else {
                        int[] loc = new int[]{this.current.x, this.current.y};
                        this.graphCanvas.addAnnotation(loc);
                    }
                    this.graphCanvas.refresh();
                    this.graphCanvas.repaint();
                }
            } else if (data.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List flist = (List)data.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iter = flist.iterator();
                while (iter.hasNext()) {
                    File f = (File)iter.next();
                    this.handleOpenFile(f);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void graphCanvas_handleMouseReleased(MouseEvent evt) {
        if (this.tool == 1) {
            int xi = this.graphCanvas.getXInset();
            int yi = this.graphCanvas.getYInset();
            int wi = xi + this.graphCanvas.getAxis().getSize(0);
            int hi = yi + this.graphCanvas.getAxis().getSize(1);
            int x = evt.getX();
            int y = evt.getY();
            if (evt.getButton() != 3 && this.isDragging) {
                if (this.start.equals(this.end)) {
                    return;
                }
                if (y < hi && Math.abs(this.start.x - this.end.x) < 10) {
                    return;
                }
                this.zoom(this.graphCanvas);
                this.graphCanvas.repaint();
            } else if (evt.getButton() == 3 || x < xi || y > hi) {
                this.p = evt.getPoint();
                this.zoom(evt.getPoint(), evt.getButton() == 1 ? 1 : 3, this.graphCanvas);
            }
        }
        if (this.tool == 5) {
            if (this.selectedObj == null) {
                return;
            }
            this.start = null;
            this.end = null;
            this.prev = null;
            this.p = null;
            if (this.selectedObj == null) {
                return;
            }
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
            this.toolDisabled = true;
            this.prev = null;
            this.ovy = Double.NEGATIVE_INFINITY;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FitPanel.this.drawAnchors(FitPanel.this.graphCanvas);
                }
            });
        }
        if (this.tool == 6) {
            if (this.start == null) {
                return;
            }
            this.p = evt.getPoint();
            if (this.toolCoordinates == 2) {
                double x1 = this.getDomain(this.start.x, this.graphCanvas);
                double y1 = this.getValue(this.start.y, this.graphCanvas);
                double x2 = this.getDomain(this.p.x, this.graphCanvas);
                double y2 = this.getValue(this.p.y, this.graphCanvas);
                double[] loc = new double[]{x1, y1, x2, y2};
                this.graphCanvas.addAnnotation(loc);
            } else {
                int[] loc = new int[]{this.start.x, this.start.y, this.p.x, this.p.y};
                this.graphCanvas.addAnnotation(loc);
            }
            this.prev = null;
            this.start = null;
            this.end = null;
            this.p = null;
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        }
        if (this.tool == 2) {
            Axis a = this.graphCanvas.getAxis();
            a.setTics(10);
            this.prev = null;
            if (a.isLogarithmic(1)) {
                this.setLogTics(this.graphCanvas);
            }
            this.graphCanvas.refresh();
            this.graphCanvas.repaint();
        }
        if (this.tool == 8) {
            double sx = this.getDomain(this.start.x, this.graphCanvas);
            double ex = this.getDomain(this.end.x, this.graphCanvas);
            if ((sx = (double)((int)(1000.0 * sx)) / 1000.0) > (ex = (double)((int)(1000.0 * ex)) / 1000.0)) {
                double t = sx;
                sx = ex;
                ex = t;
            }
            if (this.rangeTarget.equals("target")) {
                this.fitMinField.setText(sx + "");
                this.fitMaxField.setText(ex + "");
            } else {
                this.sfitMinField.setText(sx + "");
                this.sfitMaxField.setText(ex + "");
            }
            this.grabFitRange.setSelected(false);
            this.acquireFitRange1.setSelected(false);
        }
        if (this.tool == 9) {
            double sx = this.getDomain(this.start.x, this.graphCanvas);
            double ex = this.getDomain(this.end.x, this.graphCanvas);
            if ((sx = (double)((int)(1000.0 * sx)) / 1000.0) > (ex = (double)((int)(1000.0 * ex)) / 1000.0)) {
                double t = sx;
                sx = ex;
                ex = t;
            }
            this.fitMinField.setText(sx + "");
            this.fitMaxField.setText(ex + "");
            int n = this.regionsOfInterestTable.getRowCount();
            DefaultTableModel dtm = (DefaultTableModel)this.regionsOfInterestTable.getModel();
            for (int i = 0; i < n; ++i) {
                dtm.removeRow(0);
            }
            this.graphCanvas.getAnnotations(true).clear();
            this.addRangeButtonActionPerformed(null);
            this.grabFitRange.setSelected(false);
            this.acquireFitRange1.setSelected(false);
        }
    }

    private void graphCanvas_handleMousePressed(MouseEvent evt) {
        this.isDragging = false;
        if (this.tool == 5) {
            if (this.selectedObj == null) {
                return;
            }
            this.drawSelectXor(evt.getPoint(), this.ovx, this.ovy, this.ptype, this.graphCanvas);
            this.prev = null;
        }
        if (this.tool == 6) {
            if (!(this.toolCoordinates == 1 || this.toolCoordinates == 2 && this.insideAxis(evt.getPoint(), this.graphCanvas))) {
                return;
            }
            this.drawLineXor(this.prev, this.prevCs, this.graphCanvas);
            this.start = evt.getPoint();
            this.end = null;
            this.prev = null;
        }
        if (this.tool == 3 && this.tdialog != null && this.tdialog.isVisible()) {
            this.enableAllTools();
            this.isClick = false;
            this.addTextAnnotation();
            this.activateTool(this.prevTool);
            this.toolDisabled = true;
            this.prev = null;
        }
        if (this.tool == 1) {
            this.start = evt.getPoint();
            this.end = null;
        }
        if (this.tool == 8 || this.tool == 9) {
            this.drawEvalXor(this.prev, this.ovx, this.ovy, this.graphCanvas);
            this.start = evt.getPoint();
            this.start.y = this.graphCanvas.getHeight() - 10;
            this.end = null;
        }
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        this.tool = 5;
        this.prev = null;
        this.graphCanvas.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FitPanel.this.drawAnchors(FitPanel.this.graphCanvas);
            }
        });
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void yTitleFontBtnActionPerformed(ActionEvent evt) {
        this.toolDisabled = true;
        JFontChooser chooser = new JFontChooser();
        chooser.setSelectedFont(this.graphCanvas.getAxis().getTitleFont(1));
        int returnVal = chooser.showDialog(this);
        if (returnVal == 0) {
            this.graphCanvas.getAxis().setTitleFont(chooser.getSelectedFont(), 1);
            this.lastUserFont = chooser.getSelectedFont();
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void xTitleFontBtnActionPerformed(ActionEvent evt) {
        this.toolDisabled = true;
        JFontChooser chooser = new JFontChooser();
        chooser.setSelectedFont(this.graphCanvas.getAxis().getTitleFont(0));
        int returnVal = chooser.showDialog(this);
        if (returnVal == 0) {
            this.graphCanvas.getAxis().setTitleFont(chooser.getSelectedFont(), 0);
            this.lastUserFont = chooser.getSelectedFont();
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void addTextButtonActionPerformed(ActionEvent evt) {
        this.tool = 3;
        this.toolCoordinates = 1;
        this.graphCanvas.repaint();
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void evalButtonActionPerformed(ActionEvent evt) {
        this.tool = 4;
        this.graphCanvas.repaint();
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }

    private void antialiasingCheckboxActionPerformed(ActionEvent evt) {
        if (this.antialiasingCheckbox.isSelected()) {
            this.graphCanvas.setAntialiasingEnabled(true);
        } else {
            this.graphCanvas.setAntialiasingEnabled(false);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        try {
            this.toolDisabled = true;
            JFileChooser chooser = new JFileChooser();
            FileFilter f0 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("phd");
                }

                public String getDescription() {
                    return "(.phd) IMS2.0 format (text).";
                }
            };
            FileFilter f11 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("pdf");
                }

                public String getDescription() {
                    return "(.pdf) Portable document format (vector).";
                }
            };
            FileFilter f12 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("png");
                }

                public String getDescription() {
                    return "(.png) Portable network graphics (bitmap).";
                }
            };
            FileFilter f13 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("emf");
                }

                public String getDescription() {
                    return "(.emf) Enhanced metafile (vector).";
                }
            };
            FileFilter f1 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("fig");
                }

                public String getDescription() {
                    return "(.fig) Complete figure with graphs and annotations (binary).";
                }
            };
            FileFilter f2 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("graph");
                }

                public String getDescription() {
                    return "(.graph) Currently selected graph only (text).";
                }
            };
            FileFilter f3 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equals("eps");
                }

                public String getDescription() {
                    return "(.eps) Encapsulated postscript. (vector)";
                }
            };
            chooser.addChoosableFileFilter(f12);
            chooser.addChoosableFileFilter(f11);
            chooser.addChoosableFileFilter(f13);
            chooser.addChoosableFileFilter(f3);
            chooser.addChoosableFileFilter(f1);
            chooser.setCurrentDirectory(new File(this.chooserSaveHome));
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                this.chooserSaveHome = chooser.getSelectedFile().getPath();
                if (chooser.getSelectedFile().getName().indexOf(".eps") != -1) {
                    Properties p = new Properties();
                    p.setProperty("PageSize", "A4");
                    p.setProperty("Orientation", "Portrait");
                    if (this.currentFormat.getOrientation() == 1) {
                        p.setProperty("Orientation", "Portrait");
                    } else {
                        p.setProperty("Orientation", "Landscape");
                    }
                    this.graphCanvas.setRenderOnPaint(true);
                    this.graphCanvas.setClearToBackground(false);
                    this.graphCanvas.setPrintOffsetScale(this.offsx, this.offsy, this.scalex, this.scaley);
                    PSGraphics2D g = new PSGraphics2D(chooser.getSelectedFile(), new Dimension(this.graphCanvas.getSize()));
                    ((VectorGraphics)g).setProperties(p);
                    ((VectorGraphics)g).startExport();
                    this.graphCanvas.print(g);
                    ((VectorGraphics)g).endExport();
                    this.graphCanvas.setClearToBackground(true);
                    this.graphCanvas.setRenderOnPaint(false);
                    this.graphCanvas.setAntialiasingEnabled(true);
                    this.graphCanvas.refresh();
                    this.graphCanvas.repaint();
                } else if (chooser.getSelectedFile().getName().indexOf(".fig") != -1) {
                    List l = this.graphCanvas.getAnnotations();
                    FileOutputStream fos = new FileOutputStream(chooser.getSelectedFile());
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(l);
                    List l2 = this.graphCanvas.getGraphs();
                    oos.writeInt(l2.size());
                    Iterator iter = l2.iterator();
                    while (iter.hasNext()) {
                        Object o = iter.next();
                        oos.writeObject(o);
                    }
                    oos.close();
                } else if (chooser.getSelectedFile().getName().indexOf(".pdf") != -1) {
                    Properties p = new Properties();
                    p.setProperty("PageSize", "A4");
                    p.setProperty("Orientation", "Portrait");
                    if (this.currentFormat.getOrientation() == 1) {
                        p.setProperty("Orientation", "Portrait");
                    } else {
                        p.setProperty("Orientation", "Landscape");
                    }
                    this.graphCanvas.setRenderOnPaint(true);
                    this.graphCanvas.setClearToBackground(false);
                    this.graphCanvas.setPrintOffsetScale(this.offsx, this.offsy, this.scalex, this.scaley);
                    PDFGraphics2D g = new PDFGraphics2D(chooser.getSelectedFile(), new Dimension(this.graphCanvas.getSize()));
                    ((VectorGraphics)g).setProperties(p);
                    ((VectorGraphics)g).startExport();
                    this.graphCanvas.print(g);
                    ((VectorGraphics)g).endExport();
                    this.graphCanvas.setClearToBackground(true);
                    this.graphCanvas.setRenderOnPaint(false);
                    this.graphCanvas.setAntialiasingEnabled(true);
                    this.graphCanvas.refresh();
                    this.graphCanvas.repaint();
                } else if (chooser.getSelectedFile().getName().indexOf(".svg") != -1) {
                    Properties p = new Properties();
                    p.setProperty("PageSize", "A4");
                    p.setProperty("Orientation", "Portrait");
                    if (this.currentFormat.getOrientation() == 1) {
                        p.setProperty("Orientation", "Portrait");
                    } else {
                        p.setProperty("Orientation", "Landscape");
                    }
                    this.graphCanvas.setRenderOnPaint(true);
                    this.graphCanvas.setClearToBackground(false);
                    this.graphCanvas.setPrintOffsetScale(this.offsx, this.offsy, this.scalex, this.scaley);
                    SVGGraphics2D g = new SVGGraphics2D(chooser.getSelectedFile(), new Dimension(this.graphCanvas.getSize()));
                    ((VectorGraphics)g).setProperties(p);
                    ((VectorGraphics)g).startExport();
                    this.graphCanvas.print(g);
                    ((VectorGraphics)g).endExport();
                    this.graphCanvas.setClearToBackground(true);
                    this.graphCanvas.setRenderOnPaint(false);
                    this.graphCanvas.setAntialiasingEnabled(true);
                    this.graphCanvas.refresh();
                    this.graphCanvas.repaint();
                } else if (chooser.getSelectedFile().getName().indexOf(".png") != -1) {
                    this.graphCanvas.refresh();
                    ImageIO.write((RenderedImage)this.graphCanvas.getImage(), "png", chooser.getSelectedFile());
                } else if (chooser.getSelectedFile().getName().indexOf(".emf") != -1) {
                    Properties p = new Properties();
                    p.setProperty("PageSize", "A4");
                    this.graphCanvas.setRenderOnPaint(true);
                    this.graphCanvas.setClearToBackground(false);
                    this.graphCanvas.setPrintOffsetScale(this.offsx, this.offsy, this.scalex, this.scaley);
                    EMFGraphics2D g = new EMFGraphics2D(chooser.getSelectedFile(), new Dimension(this.graphCanvas.getSize()));
                    ((VectorGraphics)g).setProperties(p);
                    ((VectorGraphics)g).startExport();
                    this.graphCanvas.print(g);
                    ((VectorGraphics)g).endExport();
                    this.graphCanvas.setClearToBackground(true);
                    this.graphCanvas.setRenderOnPaint(false);
                    this.graphCanvas.setAntialiasingEnabled(true);
                    this.graphCanvas.refresh();
                    this.graphCanvas.repaint();
                } else if (chooser.getSelectedFile().getName().indexOf(".graph") != -1) {
                    ResultsWriter writer = new ResultsWriter();
                    XYGraph g = (XYGraph)this.graphs.get(this.graphsCombobox.getSelectedItem());
                    ArrayList<double[]> l = new ArrayList<double[]>();
                    l.add(g.getX());
                    l.add(g.getY());
                    writer.writeResults(chooser.getSelectedFile().getCanonicalPath(), l);
                } else if (chooser.getSelectedFile().getName().indexOf(".phd") != -1) {
                    PhdWriter writer = new PhdWriter();
                    XYGraph g = (XYGraph)this.graphs.get(this.graphsCombobox.getSelectedItem());
                    ArrayList<double[]> l = new ArrayList<double[]>();
                    l.add(g.getX());
                    l.add(g.getY());
                    writer.writeResults(chooser.getSelectedFile().getCanonicalPath(), l);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getExtension(File f) {
        String ext = "";
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private void openBtnActionPerformed(ActionEvent evt) {
        try {
            this.toolDisabled = true;
            JFileChooser chooser = new JFileChooser();
            FileFilter f3 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return FitPanel.this.getExtension(f).equalsIgnoreCase("phd");
                }

                public String getDescription() {
                    return "(.phd) IMS2.0 format";
                }
            };
            chooser.addChoosableFileFilter(f3);
            chooser.setCurrentDirectory(new File(this.chooserOpenHome));
            chooser.setMultiSelectionEnabled(true);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.chooserOpenHome = chooser.getSelectedFile().getPath();
                File[] files = chooser.getSelectedFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.handleOpenFile(files[i]);
                }
            }
        }
        catch (Exception ex) {
            Main.warnUser("Can't load file. Possibly wrong format.");
            ex.printStackTrace();
        }
    }

    private void toFrontBtnActionPerformed(ActionEvent evt) {
        List l = this.graphCanvas.getGraphs();
        Object key = this.graphsCombobox.getSelectedItem();
        Graph g = (Graph)this.graphs.get(key);
        l.remove(g);
        l.add(g);
        this.graphsCombobox.removeItem(key);
        this.graphsCombobox.addItem(key);
        this.graphsCombobox.setSelectedItem(key);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void yAxisLinearActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setLogarithmic(false, 1);
        if (this.graphCanvas.getAxis().getMin(1) == 1.0) {
            this.graphCanvas.getAxis().setMin(0.0, 1);
        }
        this.graphCanvas.getAxis().setTics(10);
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.zoomButton.setEnabled(true);
        }
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.panButton.setEnabled(true);
        }
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.evalButton.setEnabled(true);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void refreshCanvas() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FitPanel.this.graphCanvas.refresh();
                FitPanel.this.graphCanvas.repaint();
            }
        });
    }

    private void xAxisLinearActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setLogarithmic(false, 0);
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.zoomButton.setEnabled(true);
        }
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.panButton.setEnabled(true);
        }
        if (!this.xAxisLog.isSelected() && !this.yAxisLog.isSelected()) {
            this.evalButton.setEnabled(true);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void setLogTics(GraphCanvas canvas) {
        int i;
        Axis axis = canvas.getAxis();
        double[] tics = new double[55];
        double tic = 10.0;
        double incr = 10.0;
        int ind = 0;
        int i2 = 0;
        while (ind < tics.length - 1) {
            for (int j = 1; j < 10; ++j) {
                tics[ind + 1] = (double)j * incr;
                ++ind;
            }
            incr *= 10.0;
            ++i2;
        }
        tics[0] = 1.0;
        int d = 100000000;
        for (i = 0; i < tics.length - 1; ++i) {
            int y1 = this.getScreenY(tics[i], canvas);
            int y2 = this.getScreenY(tics[i + 1], canvas);
            int td = Math.abs(y1 - y2);
            if (Math.abs(y1 - y2) >= d) continue;
            d = Math.abs(y1 - y2);
        }
        if (d <= axis.getTicFont(1).getSize() - 3) {
            tics = new double[10];
            tic = 10.0;
            for (i = 1; i < tics.length; ++i) {
                tics[i] = tic;
                tic *= 10.0;
            }
            tics[0] = 1.0;
        }
        axis.setMin(1.0, 1);
        axis.setTics(tics, 1);
    }

    private void yAxisLogActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double min = a.getMin(1);
        double max = this.getMax();
        this.yAxisLog.setSelected(true);
        a.setMin(1.0, 1);
        a.setLogarithmic(true, 1);
        this.setLogTics(this.graphCanvas);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void xAxisLogActionPerformed(ActionEvent evt) {
        Axis a = this.graphCanvas.getAxis();
        double min = a.getMin(0);
        a.setMin(Math.max(min, 1.0), 0);
        a.setLogarithmic(true, 0);
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void graphTitleFieldActionPerformed(ActionEvent evt) {
        HeaderLabel key = (HeaderLabel)this.graphsCombobox.getSelectedItem();
        key.setText(" " + this.graphTitleField.getText());
        Graph g = (Graph)this.graphs.get(this.graphsCombobox.getSelectedItem());
        g.setTitle(this.graphTitleField.getText());
        this.graphsCombobox.repaint();
    }

    private void setWidth(Graph g, double d) {
        this.widths.put(g, new Double(d));
    }

    private double getWidth(Graph g) {
        Double d = (Double)this.widths.get(g);
        if (d != null) {
            return d;
        }
        return Double.NaN;
    }

    private void graphsComboboxActionPerformed(ActionEvent evt) {
        if (this.loading) {
            return;
        }
        this.loading = true;
        if (this.graphsCombobox.getItemCount() > 0) {
            this.saveShapeBtn.setEnabled(true);
        } else {
            this.saveShapeBtn.setEnabled(false);
        }
        Object o = this.graphsCombobox.getSelectedItem();
        if (o == null) {
            this.loading = false;
            return;
        }
        XYGraph g = (XYGraph)this.graphs.get(o);
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.graphsToNodes.get(g);
        TreePath path = new TreePath(n.getPath());
        this.shapeSourceTree.setSelectionPath(path);
        this.setShape(g);
        this.loading = false;
    }

    private void deleteGraphButtonActionPerformed(ActionEvent evt) {
        Graph g = this.getSelectedGraph(true);
        if (g == null || g == this.target) {
            return;
        }
        this.graphCanvas.getGraphs().remove(g);
        this.graphsCombobox1.removeItem(this.graphsCombobox1.getSelectedItem());
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
        System.gc();
    }

    private void yTicsCheckboxActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setDrawTicks(this.yTicsCheckbox.isSelected(), 1);
        this.redoTicsY.setEnabled(this.yTicsCheckbox.isSelected());
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void handleColorChooser_actionOK(ActionEvent e) {
        this.dialog.dispose();
        Color c = this.jcc.getColor();
        this.colorPanel.setBackground(c);
        this.plotColorPanel.setBackground(c);
        this.colorPanel.repaint();
        Graph g = this.getSelectedGraph(true);
        g.setColor(c);
        HeaderLabel h = (HeaderLabel)this.graphsCombobox1.getSelectedItem();
        h.setFore(c);
        this.graphCanvas.refresh();
    }

    private void handleColorChooser_actionCancel(ActionEvent e) {
        this.dialog.dispose();
    }

    private void colorPanelMouseClicked(MouseEvent evt) {
        this.toolDisabled = true;
        if (this.jcc == null) {
            this.jcc = new JColorChooser();
        }
        this.dialog = JColorChooser.createDialog(this.colorPanel, "Graph color", true, this.jcc, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FitPanel.this.handleColorChooser_actionOK(e);
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FitPanel.this.handleColorChooser_actionCancel(e);
            }
        });
        this.dialog.show();
        this.graphCanvas.repaint();
    }

    private void graphCanvas_handleMouseDragged(MouseEvent evt) {
        this.isDragging = true;
        if (this.tool == 2) {
            Point p = evt.getPoint();
            if (this.prev != null) {
                int dx = p.x - this.prev.x;
                int dy = p.y - this.prev.y;
                if (this.panMode == 2) {
                    dy = 0;
                } else if (this.panMode == 3) {
                    dx = 0;
                }
                this.pan(-dx, dy, this.graphCanvas);
            }
            this.prev = p;
        }
        if (this.tool == 1) {
            if (this.end != null) {
                this.fillRectXor(this.graphCanvas);
            }
            this.end = evt.getPoint();
            this.fillRectXor(this.graphCanvas);
        }
        if (this.tool == 8 || this.tool == 9) {
            if (this.end != null) {
                this.fillRectXor(this.graphCanvas);
            }
            this.end = evt.getPoint();
            this.end.y = this.graphCanvas.getHeight() - 10;
            this.fillRectXor(this.graphCanvas);
        }
        if (this.tool == 5) {
            int indx;
            List l;
            if (this.selectedObj == null) {
                return;
            }
            if (this.selectedObj instanceof String) {
                l = this.graphCanvas.getAnnotations();
                indx = l.indexOf(this.selectedObj);
                Object location = l.get(indx + 1);
                if (this.toolCoordinates == 2) {
                    double[] loc;
                    if (location instanceof double[]) {
                        loc = (double[])location;
                    } else {
                        int[] lo = (int[])location;
                        loc = new double[]{this.getDomain(lo[0], this.graphCanvas), this.getValue(lo[0], this.graphCanvas)};
                        l.remove(indx + 1);
                        l.add(indx + 1, loc);
                    }
                    loc[0] = this.getDomain(evt.getX(), this.graphCanvas);
                    loc[1] = this.getValue(evt.getY(), this.graphCanvas);
                    if (this.prev != null) {
                        this.drawDragStringXor(this.prev, this.ovx, this.ovy, this.selectedFont, this.prevCs, this.graphCanvas);
                    }
                    this.drawDragStringXor(evt.getPoint(), loc[0], loc[1], this.selectedFont, this.cs, this.graphCanvas);
                    this.ovx = loc[0];
                    this.ovy = loc[1];
                } else {
                    int[] loc;
                    if (location instanceof int[]) {
                        loc = (int[])l.get(indx + 1);
                    } else {
                        loc = new int[2];
                        l.remove(indx + 1);
                        l.add(indx + 1, loc);
                    }
                    loc[0] = evt.getX() / 10 * 10;
                    loc[1] = evt.getY() / 10 * 10;
                    if (this.prev != null) {
                        this.drawDragStringXor(this.prev, this.ovx, this.ovy, this.selectedFont, this.prevCs, this.graphCanvas);
                    }
                    this.drawDragStringXor(new Point(loc[0], loc[1]), this.ovx, this.ovy, this.selectedFont, this.cs, this.graphCanvas);
                }
            } else if (this.selectedObj instanceof Image) {
                l = this.graphCanvas.getAnnotations();
                indx = l.indexOf(this.selectedObj);
                if (this.toolCoordinates == 2) {
                    Object loca = l.get(indx + 1);
                    double[] loc = null;
                    if (loca instanceof double[]) {
                        loc = (double[])loca;
                    } else {
                        loc = new double[2];
                        l.remove(indx + 1);
                        l.add(indx + 1, loc);
                    }
                    loc[0] = this.getDomain(evt.getX(), this.graphCanvas);
                    loc[1] = this.getValue(evt.getY(), this.graphCanvas);
                    if (this.prev != null) {
                        this.drawDragImageXor(this.prev, this.ovx, this.ovy, this.prevCs, this.graphCanvas);
                    }
                    this.drawDragImageXor(evt.getPoint(), loc[0], loc[1], this.cs, this.graphCanvas);
                    this.ovx = loc[0];
                    this.ovy = loc[1];
                } else {
                    Object loca = l.get(indx + 1);
                    int[] loc = null;
                    if (loca instanceof int[]) {
                        loc = (int[])loca;
                    } else {
                        l.remove(indx + 1);
                        loc = new int[2];
                        l.add(indx + 1, loc);
                    }
                    loc[0] = evt.getX();
                    loc[1] = evt.getY();
                    if (this.prev != null) {
                        this.drawDragImageXor(this.prev, this.ovx, this.ovy, this.prevCs, this.graphCanvas);
                    }
                    this.drawDragImageXor(evt.getPoint(), this.ovx, this.ovy, this.cs, this.graphCanvas);
                }
                this.prevCs = this.cs;
            } else if (this.selectedObj instanceof double[]) {
                l = this.graphCanvas.getAnnotations();
                double[] loc = (double[])this.selectedObj;
                if (this.selectedPt == 1) {
                    loc[0] = this.getDomain(evt.getX(), this.graphCanvas);
                    loc[1] = this.getValue(evt.getY(), this.graphCanvas);
                } else {
                    loc[2] = this.getDomain(evt.getX(), this.graphCanvas);
                    loc[3] = this.getValue(evt.getY(), this.graphCanvas);
                }
                if (this.prev != null) {
                    this.drawLineXor(this.prev, this.prevCs, this.graphCanvas);
                }
                this.drawLineXor(evt.getPoint(), this.cs, this.graphCanvas);
                this.ovx = loc[0];
                this.ovy = loc[1];
            } else if (this.selectedObj instanceof int[]) {
                int[] loc = (int[])this.selectedObj;
                if (this.selectedPt == 1) {
                    loc[0] = evt.getX();
                    loc[1] = evt.getY();
                } else {
                    loc[2] = evt.getX();
                    loc[3] = evt.getY();
                }
                if (this.prev != null) {
                    this.drawLineXor(this.prev, this.prevCs, this.graphCanvas);
                }
                this.drawLineXor(evt.getPoint(), this.cs, this.graphCanvas);
                this.ovx = loc[0];
                this.ovy = loc[1];
            }
            this.prevCs = this.cs;
        }
        if (this.tool == 6) {
            if (this.prev != null) {
                this.drawLineXor(this.prev, this.prevCs, this.graphCanvas);
            }
            this.p = evt.getPoint();
            this.drawLineXor(this.p, this.cs, this.graphCanvas);
            this.prev = this.p;
        }
    }

    private void redoTicsYActionPerformed(ActionEvent evt) {
        Font f = this.graphCanvas.getAxis().getTicFont(1);
        this.graphCanvas.getAxis().setTicFont(f.deriveFont((float)f.getSize() + 1.0f), 1);
        if (this.graphCanvas.getAxis().isLogarithmic(1)) {
            this.setLogTics(this.graphCanvas);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void graphCanvasMouseExited(MouseEvent evt) {
        if (this.toolDisabled) {
            return;
        }
        if (this.tool == 1) {
            this.p = this.prev;
            this.drawRectXor(this.graphCanvas);
            this.prev = null;
        }
        if (this.tool == 4 || this.tool == 9) {
            this.p = this.prev;
            this.drawEvalXor(this.p, this.ovx, this.ovy, this.graphCanvas);
            this.ovy = Double.NEGATIVE_INFINITY;
            this.prev = null;
        }
        if (this.tool == 3) {
            this.p = this.prev;
            this.drawTextXor(this.p, this.ovx, this.ovy, this.prevCs, this.graphCanvas);
            this.ovy = Double.NEGATIVE_INFINITY;
        }
    }

    private void resumeTool(GraphCanvas canvas) {
        if (this.tool == 1) {
            this.prev = null;
            this.drawRectXor(canvas);
        }
        if (this.tool == 5) {
            this.drawAnchors(canvas);
        }
    }

    private void drawAnchor(int x, int y) {
        Graphics g = this.graphCanvas.getGraphics();
        g.setColor(Color.red);
        g.fillOval(x - 5, y - 5, 10, 10);
        g.setColor(Color.ORANGE);
        g.fillOval(x - 5, y - 5, 6, 6);
        g.setColor(Color.white);
        g.fillOval(x - 4, y - 4, 4, 4);
    }

    private void drawAnchors(GraphCanvas canvas) {
        List l = this.graphCanvas.getAnnotations();
        int xi = this.graphCanvas.getXInset();
        int yi = this.graphCanvas.getYInset();
        int wi = xi + this.graphCanvas.getAxis().getSize(0);
        int hi = yi + this.graphCanvas.getAxis().getSize(1);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            int y;
            int x;
            Object[] loc;
            Object ann = iter.next();
            if (ann instanceof int[]) {
                loc = (int[])ann;
                if (loc.length < 4) {
                    this.drawAnchor(loc[0], loc[1]);
                } else {
                    this.drawAnchor(loc[0], loc[1]);
                    this.drawAnchor(loc[2], loc[3]);
                }
            }
            if (!(ann instanceof double[])) continue;
            loc = (double[])ann;
            if (loc.length < 4) {
                x = this.getScreenX(loc[0], canvas);
                y = this.getScreenY(loc[1], canvas);
                if (x <= xi || y <= yi || x >= wi || y >= hi) continue;
                this.drawAnchor(this.getScreenX(loc[0], canvas), this.getScreenY(loc[1], canvas));
                continue;
            }
            x = this.getScreenX(loc[0], canvas);
            y = this.getScreenY(loc[1], canvas);
            if (x > xi && y > yi && x < wi && y < hi) {
                this.drawAnchor(this.getScreenX(loc[0], canvas), this.getScreenY(loc[1], canvas));
            }
            x = this.getScreenX(loc[2], canvas);
            y = this.getScreenY(loc[3], canvas);
            if (x <= xi || y <= yi || x >= wi || y >= hi) continue;
            this.drawAnchor(this.getScreenX(loc[2], canvas), this.getScreenY(loc[3], canvas));
        }
    }

    private void drawRectXor(GraphCanvas canvas) {
        Axis a = canvas.getAxis();
        double lenx = a.getSize(0) / 5;
        double leny = a.getSize(1) / 5;
        Graphics2D g = (Graphics2D)canvas.getGraphics();
        g.setXORMode(Color.gray);
        if (this.p == null) {
            return;
        }
        if (this.p.x < canvas.getXInset()) {
            g.drawRect(this.p.x - 4, this.p.y - (int)(leny / 2.0), 8, (int)leny);
            g.drawString("Left button - zoom in", this.p.x - 2, this.p.y - (int)(leny / 2.0) - 25);
            g.drawString("Right button - zoom out", this.p.x - 2, this.p.y - (int)(leny / 2.0) - 15);
            g.drawString("Drag to zoom region", this.p.x - 2, this.p.y - (int)(leny / 2.0) - 5);
        } else if (this.p.y > canvas.getHeight() - canvas.getYInset()) {
            g.drawRect(this.p.x - (int)(lenx / 2.0), this.p.y - 4, (int)lenx, 8);
            g.drawString("Left button - zoom in", this.p.x - 2, this.p.y - 4 - 25);
            g.drawString("Right button - zoom out", this.p.x - 2, this.p.y - 4 - 15);
            g.drawString("Drag to zoom region", this.p.x - 2, this.p.y - 4 - 5);
        } else {
            g.drawString("< Move cursor to axis you want to zoom >", this.p.x - 2, this.p.y - 5);
        }
        this.prev = this.p;
    }

    private void drawPanXor(Point p, GraphCanvas canvas) {
        Axis a = canvas.getAxis();
        double lenx = a.getSize(0) / 5;
        double leny = a.getSize(1) / 5;
        Graphics2D g = (Graphics2D)canvas.getGraphics();
        g.setXORMode(Color.gray);
        if (p.x < canvas.getXInset()) {
            g.drawString("< Drag to pan on y-axis >", p.x + 4, p.y - 8);
        } else if (p.y > canvas.getHeight() - canvas.getYInset()) {
            g.drawString("< Drag to pan on x-axis >", p.x + 4, p.y - 8);
        } else {
            g.drawString("< Drag to pan >", p.x + 4, p.y - 8);
        }
        this.prev = p;
    }

    private void fillRectXor(GraphCanvas canvas) {
        Axis a = canvas.getAxis();
        int lenx = Math.abs(this.end.x - this.start.x);
        int leny = Math.abs(this.end.y - this.start.y);
        int sx = Math.min(this.start.x, this.end.x);
        int sy = Math.min(this.start.y, this.end.y);
        Graphics2D g = (Graphics2D)canvas.getGraphics();
        g.setXORMode(Color.red);
        if (this.start.x < canvas.getXInset()) {
            g.fillRect(canvas.getXInset(), sy, canvas.getAxis().getSize(0), leny);
        } else if (this.start.y > canvas.getHeight() - canvas.getYInset()) {
            g.fillRect(sx, canvas.getYInset(), lenx, canvas.getAxis().getSize(1));
        } else {
            this.end = this.start;
        }
        this.prev = this.p;
    }

    private void drawLineXor(Point p, String csMsg, GraphCanvas canvas) {
        Graphics2D g = (Graphics2D)canvas.getGraphics();
        g.setXORMode(Color.gray);
        if (this.start == null) {
            String pos = "";
            if (this.toolCoordinates == 1) {
                g.drawString("< click and drag to add line > ", p.x + 2, p.y);
            } else if (this.insideAxis(p, canvas)) {
                g.drawString("< click and drag to add line tag > ", p.x + 2, p.y);
            } else {
                g.drawString("< Move the cursor inside the axis area > ", p.x + 2, p.y);
            }
            return;
        }
        if (this.prev != null && this.start != null) {
            g.drawLine(this.start.x, this.start.y, this.prev.x, this.prev.y);
        }
        if (this.tool == 6) {
            g.drawString("< release button to add this line >", p.x + 2, p.y - 2);
        } else {
            g.drawString("< release button to reposition this line >", p.x + 2, p.y - 2);
        }
        if (this.toolCoordinates == 2 && !this.insideAxis(p, canvas)) {
            g.drawString("Note: Line tag won't be displayed fully in current plot range.", p.x + 4, p.y + 10);
        }
        if (this.start != null) {
            g.drawLine(this.start.x, this.start.y, p.x, p.y);
        }
        this.prev = p;
    }

    private void drawTextXor(Point p, double vx, double vy, String csStr, GraphCanvas canvas) {
        String yStr;
        boolean e = true;
        boolean c = true;
        Axis a = this.graphCanvas.getAxis();
        int lenx = this.getWidth();
        int leny = this.getHeight();
        Graphics2D g = (Graphics2D)canvas.getGraphics();
        g.setXORMode(Color.gray);
        String xStr = e ? this.xAxisTitleField.getText() + ": " + this.format.format(vx) : "";
        String string = yStr = c ? this.yAxisTitleField.getText() + ": " + this.format.format(vy) : "";
        if (p != null && !this.tdialog.isShowing()) {
            if (this.toolCoordinates == 1) {
                g.drawString("< click to add text here > ", p.x + 2, p.y);
            } else if (this.insideAxis(p, canvas)) {
                g.drawString("< click to add text tag here > ", p.x + 2, p.y);
            } else {
                g.drawString("< Move the cursor inside the axis area > ", p.x + 2, p.y);
            }
        } else if (p != null && this.tdialog.isShowing()) {
            g.drawString("< click to end editing > ", p.x + 2, p.y);
        }
        this.prev = p;
    }

    private void drawDragStringXor(Point p, double vx, double vy, Font font, String csmsg, GraphCanvas canvas) {
        boolean e = true;
        boolean c = true;
        Axis a = this.graphCanvas.getAxis();
        int lenx = this.getWidth();
        int leny = this.getHeight();
        Graphics2D g = (Graphics2D)canvas.getGraphics();
        g.setXORMode(Color.gray);
        String xStr = e ? this.xAxisTitleField.getText() + ": " + this.format.format(vx) : "";
        String yStr = c ? this.yAxisTitleField.getText() + ": " + this.format.format(vy) : "";
        Font t = g.getFont();
        if (font != null) {
            g.setFont(font);
        }
        if (this.toolCoordinates == 1) {
            g.drawString((String)this.selectedObj, p.x, p.y);
            g.setFont(t);
        } else if (this.insideAxis(p, canvas)) {
            g.drawString((String)this.selectedObj, p.x, p.y);
            g.setFont(t);
        } else {
            g.drawString((String)this.selectedObj, p.x, p.y);
            g.setFont(t);
            g.drawString("Note: Text tag object will not be visible in current plot range", p.x + 4, p.y + 10);
        }
        this.prev = p;
    }

    private void drawDragImageXor(Point p, double vx, double vy, String csmsg, GraphCanvas canvas) {
        boolean e = true;
        boolean c = true;
        Axis a = canvas.getAxis();
        int lenx = this.getWidth();
        int leny = this.getHeight();
        Graphics2D g = (Graphics2D)canvas.getGraphics();
        g.setXORMode(Color.gray);
        String xStr = e ? this.xAxisTitleField.getText() + ": " + this.format.format(vx) : "";
        String yStr = c ? this.yAxisTitleField.getText() + ": " + this.format.format(vy) : "";
        g.drawString(csmsg, p.x + 2, p.y - 10);
        Image sel = (Image)this.selectedObj;
        g.drawRect(p.x, p.y, sel.getWidth(null), sel.getHeight(null));
        this.prev = p;
    }

    private void drawEvalXor(Point p, double vx, double vy, GraphCanvas canvas) {
        String yStr;
        boolean e = true;
        boolean c = true;
        if (p == null) {
            return;
        }
        Axis a = canvas.getAxis();
        int lenx = this.getWidth();
        int leny = this.getHeight();
        Graphics2D g = (Graphics2D)canvas.getGraphics();
        g.setXORMode(Color.gray);
        if (p.x < canvas.getXInset()) {
            g.drawLine(0, p.y, lenx, p.y);
            e = false;
        } else if (p.y > canvas.getHeight() - canvas.getYInset()) {
            c = false;
            g.drawLine(p.x, leny, p.x, 0);
        } else {
            g.drawLine(0, p.y, lenx, p.y);
            g.drawLine(p.x, leny, p.x, 0);
        }
        String xStr = e ? this.xAxisTitleField.getText() + ": " + this.format.format(vx) : "";
        String string = yStr = c ? this.yAxisTitleField.getText() + ": " + this.format.format(vy) : "";
        if (this.tool == 4) {
            g.drawString(xStr + " " + yStr, p.x + 2, p.y - 2);
        } else {
            g.drawString(xStr + " <drag to define fit range>", p.x + 2, p.y - 2);
        }
        this.prev = p;
    }

    private void drawSelectXor(Point p, double vx, double vy, String typeStr, GraphCanvas canvas) {
        boolean e = true;
        boolean c = true;
        Axis a = canvas.getAxis();
        int lenx = this.getWidth();
        int leny = this.getHeight();
        Graphics2D g = (Graphics2D)canvas.getGraphics();
        g.setXORMode(Color.gray);
        if (typeStr == null) {
            this.prev = p;
            return;
        }
        if (p.x < canvas.getXInset()) {
            e = false;
        } else if (p.y > canvas.getHeight() - canvas.getYInset()) {
            c = false;
        }
        if (this.toolCoordinates == 2 && e && c) {
            g.drawLine(0, p.y, lenx, p.y);
            g.drawLine(p.x, leny, p.x, 0);
        } else if (this.toolCoordinates == 1) {
            g.drawLine(0, p.y, lenx, p.y);
            g.drawLine(p.x, leny, p.x, 0);
        }
        String xStr = "x: " + p.x;
        String yStr = "y: " + p.y;
        int sw = SwingUtilities.computeStringWidth(g.getFontMetrics(), typeStr);
        g.drawString(typeStr, p.x - sw - 2, p.y - 16);
        this.prev = p;
    }

    private void eval(int x, int y, GraphCanvas canvas) {
        Axis a = canvas.getAxis();
        int ay = canvas.getHeight() - canvas.getYInset() - y;
        double vx = a.getValueForAxisCoordinate(x - canvas.getXInset(), 0);
        double vy = a.getValueForAxisCoordinate(ay, 1);
        if (!Double.isInfinite(this.ovy)) {
            this.drawEvalXor(this.prev, this.ovx, this.ovy, canvas);
        }
        this.drawEvalXor(this.p, vx, vy, canvas);
        this.ovx = vx;
        this.ovy = vy;
    }

    private void text(int x, int y, GraphCanvas canvas) {
        Axis a = canvas.getAxis();
        int ay = canvas.getHeight() - canvas.getYInset() - y;
        double vx = a.getValueForAxisCoordinate(x - canvas.getXInset(), 0);
        double vy = a.getValueForAxisCoordinate(ay, 1);
        String csStr = "";
        if (this.toolCoordinates == 1) {
            csStr = " (absolute positioning)";
        }
        if (this.toolCoordinates == 2) {
            csStr = " (relative positioning)";
        }
        if (!Double.isInfinite(this.ovy)) {
            this.drawTextXor(this.prev, this.ovx, this.ovy, this.prevCs, canvas);
        }
        this.drawTextXor(this.p, vx, vy, csStr, canvas);
        this.prev = this.p;
        this.ovx = vx;
        this.ovy = vy;
        this.prevCs = csStr;
    }

    private void select(int x, int y, GraphCanvas canvas) {
        this.selectedObj = null;
        Axis a = canvas.getAxis();
        int ay = canvas.getHeight() - this.graphCanvas.getYInset() - y;
        double vx = a.getValueForAxisCoordinate(x - canvas.getXInset(), 0);
        double vy = a.getValueForAxisCoordinate(ay, 1);
        double two = a.getValueForAxisCoordinate(2, 0);
        double one = a.getValueForAxisCoordinate(1, 0);
        double intrX = two - one;
        two = a.getValueForAxisCoordinate(2, 1);
        one = a.getValueForAxisCoordinate(1, 1);
        double intrY = two - one;
        List l = canvas.getAnnotations();
        Iterator iter = l.iterator();
        int ind = 0;
        this.type = null;
        int xi = canvas.getXInset();
        int yi = canvas.getYInset();
        int wi = xi + canvas.getAxis().getSize(0);
        int hi = yi + canvas.getAxis().getSize(1);
        while (iter.hasNext()) {
            Object[] line;
            Object ann = iter.next();
            if (ann instanceof double[] && (line = (double[])ann).length == 4) {
                Axis ax;
                int x1 = this.getScreenX(line[0], canvas);
                int y1 = this.getScreenY(line[1], canvas);
                int x2 = this.getScreenX(line[2], canvas);
                int y2 = this.getScreenY(line[3], canvas);
                if (Math.abs(x1 - x) < 5 && Math.abs(y1 - y) < 5 && x1 > xi && x1 < wi && y1 > yi && y1 < hi) {
                    this.selectedObj = line;
                    this.selectedPt = 1;
                    this.toolCoordinates = 2;
                    this.type = this.tool == 5 ? "Line tag object - drag to reposition" : "Line tag object - click to delete";
                    ax = this.graphCanvas.getAxis();
                    this.start = new Point((int)ax.getAxisCoordinateForValue(line[2], 0) + ax.getLocation().x, canvas.getHeight() - (int)ax.getAxisCoordinateForValue(line[3], 1) - canvas.getYInset());
                } else if (Math.abs(x2 - x) < 5 && Math.abs(y2 - y) < 5 && x2 > xi && x2 < wi && y2 > yi && y2 < hi) {
                    this.selectedObj = line;
                    this.selectedPt = 2;
                    this.toolCoordinates = 2;
                    this.type = this.tool == 5 ? "Line tag object - drag to reposition" : "Line tag object - click to delete";
                    ax = this.graphCanvas.getAxis();
                    this.start = new Point((int)ax.getAxisCoordinateForValue(line[0], 0) + ax.getLocation().x, canvas.getHeight() - (int)ax.getAxisCoordinateForValue(line[1], 1) - canvas.getYInset());
                }
            }
            if (ann instanceof int[] && (line = (Object[])((int[])ann)).length == 4) {
                if (Math.abs((int)(line[0] - x)) < 5 && Math.abs((int)(line[1] - y)) < 5) {
                    this.selectedObj = line;
                    this.selectedPt = 1;
                    this.toolCoordinates = 1;
                    this.start = new Point((int)line[2], (int)line[3]);
                    this.type = this.tool == 5 ? "Line object - drag to reposition" : "Line object - click to delete";
                } else if (Math.abs((int)(line[2] - x)) < 5 && Math.abs((int)(line[3] - y)) < 5) {
                    this.selectedObj = line;
                    this.selectedPt = 2;
                    this.toolCoordinates = 1;
                    this.start = new Point((int)line[0], (int)line[1]);
                    this.type = this.tool == 5 ? "Line object - drag to reposition" : "Line object - click to delete";
                }
            }
            if (ann instanceof String || ann instanceof Image) {
                Object[] loc;
                Object location = iter.next();
                if (location instanceof double[]) {
                    loc = (double[])location;
                    int x1 = this.getScreenX(loc[0], canvas);
                    int y1 = this.getScreenY(loc[1], canvas);
                    if (Math.abs(x1 - x) < 5 && Math.abs(y1 - y) < 5 && x1 > xi && x1 < wi && y1 > yi && y1 < hi) {
                        this.selectedObj = ann;
                        vx = loc[0];
                        vy = loc[1];
                        this.toolCoordinates = 2;
                        if (ann instanceof String) {
                            this.type = this.tool == 5 ? "Text tag object - click to edit, drag to reposition" : "Text tag object - click to remove";
                            try {
                                this.selectedFont = (Font)l.get(l.indexOf(ann) - 1);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            this.type = this.tool == 5 ? "Image object - drag to reposition" : "Image object - click to delete";
                        }
                    }
                    ++ind;
                } else {
                    loc = (int[])location;
                    if (Math.abs((int)(loc[0] - x)) < 5 && Math.abs((int)(loc[1] - y)) < 5) {
                        this.selectedObj = ann;
                        vx = loc[0];
                        vy = loc[1];
                        this.toolCoordinates = 1;
                        if (ann instanceof String) {
                            this.type = this.tool == 5 ? "Text object - click to edit, drag to reposition" : "Text object - click to remove";
                            try {
                                this.selectedFont = (Font)l.get(l.indexOf(ann) - 1);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            this.type = this.tool == 5 ? "Image object - drag to reposition" : "Image object - click to delete";
                        }
                    }
                }
                ++ind;
            }
            ++ind;
        }
        if (this.prev != null) {
            this.drawSelectXor(this.prev, this.ovx, this.ovy, this.ptype, canvas);
        }
        this.drawSelectXor(this.p, vx, vy, this.type, canvas);
        this.prev = this.p;
        this.ovx = vx;
        this.ovy = vy;
        this.ptype = this.type;
    }

    private void pan(Point p1, Point p2, GraphCanvas canvas) {
        double dx = this.getDomain(p2.x, canvas) - this.getDomain(p1.x, canvas);
        double dy = this.getValue(p2.y, canvas) - this.getValue(p1.y, canvas);
        Axis a = canvas.getAxis();
        double mx = a.getMin(0);
        double my = a.getMin(1);
        double Mx = a.getMax(0);
        double My = a.getMax(1);
        if (mx + dx < 0.0) {
            dx = -dx;
        }
        if (my + dy < 0.0) {
            dy = -my;
        }
        a.setMinMax(mx + dx, my + dy, Mx + dx, My + dy);
        if (canvas == this.graphCanvas) {
            this.residualCanvas.getAxis().setMinMax(mx, Mx, 0);
        }
        canvas.refresh();
        canvas.repaint();
        if (canvas == this.graphCanvas) {
            this.residualCanvas.refresh();
            this.residualCanvas.repaint();
        }
    }

    private void pan(int dx, int dy, GraphCanvas canvas) {
        double d;
        Axis a = canvas.getAxis();
        double mix = a.getMin(0);
        double miy = a.getMin(1);
        double max = a.getMax(0);
        double may = a.getMax(1);
        int one = 1;
        int two = 2;
        double donex = a.getValueForAxisCoordinate(two, 0) - a.getValueForAxisCoordinate(one, 0);
        double doney = a.getValueForAxisCoordinate(two, 1) - a.getValueForAxisCoordinate(one, 1);
        double ddx = (double)dx * donex;
        double ddy = (double)dy * doney;
        a.setMinMax(mix + ddx, miy + ddy, max + ddx, may + ddy);
        if (canvas == this.graphCanvas) {
            double yM = this.residualCanvas.getAxis().getMax(1);
            double ym = this.residualCanvas.getAxis().getMin(1);
            this.residualCanvas.getAxis().setMinMax(mix + ddx, ym, max + ddx, yM);
        }
        mix = a.getMin(0);
        max = a.getMax(0);
        if (mix < 0.0 && canvas == this.graphCanvas) {
            d = max - mix;
            a.setMinMax(0.0, d, 0);
            this.residualCanvas.getAxis().setMinMax(0.0, d, 0);
        }
        miy = a.getMin(1);
        may = a.getMax(1);
        if (miy < 0.0) {
            d = may - miy;
            a.setMinMax(0.0, d, 1);
        }
        canvas.refresh();
        canvas.repaint();
        if (canvas == this.graphCanvas) {
            this.residualCanvas.refresh();
            this.residualCanvas.repaint();
        }
    }

    private void zoom(Point p, int button, GraphCanvas canvas) {
        Axis a = canvas.getAxis();
        double mix = a.getMin(0);
        double miy = a.getMin(1);
        double max = a.getMax(0);
        double may = a.getMax(1);
        double lenx = (max - mix) / 2.0;
        double leny = (may - miy) / 2.0;
        int px = p.x - canvas.getXInset();
        int py = canvas.getHeight() - p.y - canvas.getYInset();
        double cx = a.getValueForAxisCoordinate(px, 0);
        double cy = a.getValueForAxisCoordinate(py, 1);
        double f = 0.0;
        double len1x = cx - mix;
        double len2x = max - cx;
        double len1y = cy - miy;
        double len2y = may - cy;
        f = button == 1 ? this.zoomf : 2.0 - this.zoomf;
        len1x /= f;
        len2x /= f;
        len1y /= f;
        len2y /= f;
        if (p.x < canvas.getXInset()) {
            double my = cy - len1y;
            my = Math.max(my, 0.0);
            a.setMinMax(mix, my, max, cy + len2y);
            double Mry = this.residualCanvas.getAxis().getMax(1);
            double mry = this.residualCanvas.getAxis().getMin(1);
            if (canvas == this.graphCanvas) {
                this.residualCanvas.getAxis().setMinMax(mix, max, 0);
            }
            a.setTics();
            if (a.isLogarithmic(1)) {
                this.setLogTics(canvas);
            }
        } else if (p.y > canvas.getHeight() - canvas.getYInset()) {
            double mx = cx - len1x;
            mx = Math.max(mx, 0.0);
            a.setMinMax(mx, miy, cx + len2x, may);
            double mry = this.residualCanvas.getAxis().getMax(1);
            if (canvas == this.graphCanvas) {
                this.residualCanvas.getAxis().setMinMax(mx, cx + len2x, 0);
            }
            a.setTics();
            if (a.isLogarithmic(1)) {
                this.setLogTics(canvas);
            }
        } else {
            double my = cy - len1y;
            my = Math.max(my, 0.0);
            double mx = cx - len1x;
            mx = Math.max(mx, 0.0);
            a.setMinMax(mx, my, cx + len2x, cy + len2y);
            double mry = this.residualCanvas.getAxis().getMax(1);
            if (canvas == this.graphCanvas) {
                this.residualCanvas.getAxis().setMinMax(mx, cx + len2x, 0);
            }
            a.setTics();
            if (a.isLogarithmic(1)) {
                this.setLogTics(canvas);
            }
        }
        canvas.refresh();
        canvas.repaint();
        if (canvas == this.graphCanvas) {
            this.residualCanvas.refresh();
        }
        if (canvas == this.graphCanvas) {
            this.residualCanvas.repaint();
        }
        this.prev = null;
    }

    public void refresh() {
        this.graphCanvas.refresh();
        this.residualCanvas.refresh();
        this.shapeCanvas.refresh();
        this.repaint();
    }

    private double getArea(XYGraph g) {
        double[] y = g.getY();
        double sum = 0.0;
        for (int i = 0; i < y.length; ++i) {
            if (!(y[i] > 0.0)) continue;
            sum += y[i];
        }
        return (double)((long)(sum * 100.0)) / 100.0;
    }

    private void zoom(GraphCanvas canvas) {
        int t;
        Axis a = canvas.getAxis();
        double mix = a.getMin(0);
        double miy = a.getMin(1);
        double max = a.getMax(0);
        double may = a.getMax(1);
        double lenx = (max - mix) / 2.0;
        double leny = (may - miy) / 2.0;
        int px1 = this.start.x - canvas.getXInset();
        int py1 = canvas.getHeight() - this.start.y - canvas.getYInset();
        int px2 = this.end.x - canvas.getXInset();
        int py2 = canvas.getHeight() - this.end.y - canvas.getYInset();
        if (px2 < px1) {
            t = px2;
            px2 = px1;
            px1 = t;
        }
        if (py2 < py1) {
            t = py2;
            py2 = py1;
            py1 = t;
        }
        double cx1 = a.getValueForAxisCoordinate(px1, 0);
        double cy1 = a.getValueForAxisCoordinate(py1, 1);
        double cx2 = a.getValueForAxisCoordinate(px2, 0);
        double cy2 = a.getValueForAxisCoordinate(py2, 1);
        double f = 0.0;
        double len1x = cx1 - mix;
        double len2x = max - cx1;
        double len1y = cy1 - miy;
        double len2y = may - cy1;
        len1x /= f;
        len2x /= f;
        len1y /= f;
        len2y /= f;
        if (this.p.x < canvas.getXInset()) {
            double m = Math.min(cy1, cy2);
            m = Math.max(0.0, m);
            double M = Math.max(cy1, cy2);
            a.setMinMax(mix, m, max, M);
            if (canvas == this.graphCanvas) {
                this.residualCanvas.getAxis().setMinMax(mix, max, 0);
            }
            a.setTics();
            if (a.isLogarithmic(1)) {
                this.setLogTics(canvas);
            }
        } else if (this.p.y > canvas.getHeight() - canvas.getYInset()) {
            double m = Math.min(cx1, cx2);
            m = Math.max(0.0, m);
            double M = Math.max(cx1, cx2);
            a.setMinMax(m, miy, M, may);
            if (canvas == this.graphCanvas) {
                this.residualCanvas.getAxis().setMinMax(m, M, 0);
            }
            a.setTics();
            if (a.isLogarithmic(1)) {
                this.setLogTics(canvas);
            }
        } else {
            double my = Math.min(cy1, cy2);
            double My = Math.max(cy1, cy2);
            double mx = Math.min(cx1, cx2);
            double Mx = Math.max(cx1, cx2);
            my = Math.max(0.0, my);
            mx = Math.max(0.0, mx);
            a.setMinMax(mx, my, Mx, My);
            if (canvas == this.graphCanvas) {
                this.residualCanvas.getAxis().setMinMax(mx, Mx, 0);
            }
            a.setTics();
            if (a.isLogarithmic(1)) {
                this.setLogTics(canvas);
            }
        }
        canvas.refresh();
        canvas.repaint();
        if (canvas == this.graphCanvas) {
            this.residualCanvas.refresh();
        }
        if (canvas == this.graphCanvas) {
            this.residualCanvas.repaint();
        }
        this.prev = null;
    }

    private void graphCanvasMouseMoved(MouseEvent evt) {
        this.current = evt.getPoint();
        if (this.toolDisabled) {
            this.toolDisabled = false;
            return;
        }
        if (this.tool == 4) {
            this.p = evt.getPoint();
            this.eval(this.p.x, this.p.y, this.graphCanvas);
        }
        if (this.tool == 8 || this.tool == 9) {
            this.p = evt.getPoint();
            this.eval(this.p.x, this.p.y, this.graphCanvas);
        }
        if (this.tool == 3) {
            this.p = evt.getPoint();
            if (this.toolCoordinates == 1) {
                this.p.x = this.p.x / 20 * 20;
                this.p.y = this.p.y / 20 * 20;
            }
            this.text(this.p.x, this.p.y, this.graphCanvas);
        }
        if (this.tool == 1) {
            if (this.prev != null) {
                this.p = this.prev;
                this.drawRectXor(this.graphCanvas);
            }
            this.p = evt.getPoint();
            this.drawRectXor(this.graphCanvas);
            this.prev = this.p;
        }
        if (this.tool == 6) {
            if (this.prev != null) {
                this.drawLineXor(this.prev, this.prevCs, this.graphCanvas);
            }
            this.p = evt.getPoint();
            this.drawLineXor(this.p, this.cs, this.graphCanvas);
            this.prev = this.p;
        }
        if (this.tool == 5 || this.tool == 7) {
            this.p = evt.getPoint();
            this.select(this.p.x, this.p.y, this.graphCanvas);
        }
        if (this.tool == 2) {
            int x = evt.getX();
            int y = evt.getY();
            if (y > this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
                this.panMode = 2;
                this.graphCanvas.setCursor(Cursor.getPredefinedCursor(10));
            } else if (x < this.graphCanvas.getXInset() && y < this.graphCanvas.getHeight() - this.graphCanvas.getYInset()) {
                this.panMode = 3;
                this.graphCanvas.setCursor(Cursor.getPredefinedCursor(9));
            } else {
                this.panMode = 1;
                this.graphCanvas.setCursor(Cursor.getPredefinedCursor(13));
            }
            if (this.prev != null) {
                this.drawPanXor(this.prev, this.graphCanvas);
            }
            this.p = evt.getPoint();
            this.drawPanXor(this.p, this.graphCanvas);
            this.prev = this.p;
        }
        this.prevCs = this.cs;
    }

    private void setSelectedObject(Object o) {
        boolean found = false;
        for (int i = 0; i < this.graphsCombobox1.getItemCount() && !found; ++i) {
            HeaderLabel l = (HeaderLabel)this.graphsCombobox1.getItemAt(i);
            XYGraph g = (XYGraph)this.graphs.get(l);
            if (g == null || g != o) continue;
            found = true;
            this.graphsCombobox1.setSelectedIndex(i);
        }
    }

    public static boolean onLine(double x1, double y1, double x2, double y2, double px, double py) {
        double[] v1 = new double[]{x2 - x1, y2 - y1, 0.0};
        double[] v2 = new double[]{px - x1, py - y1, 0.0};
        double dot = PolyUtils.dot(v1, v2);
        double d1 = Math.sqrt(Math.pow(v1[0], 2.0) + Math.pow(v1[1], 2.0));
        double d2 = Math.sqrt(Math.pow(v2[0], 2.0) + Math.pow(v2[1], 2.0));
        double ang = Math.acos(dot);
        return ang < 0.1 && d1 > d2;
    }

    private void graphCanvas_handleMouseClicked(MouseEvent evt) {
        List l;
        if (!this.isClick) {
            this.isClick = true;
            return;
        }
        if (this.tool == 5) {
            l = this.graphCanvas.getGraphs();
            boolean found = false;
            Graph selected = this.getSelectedGraph(true);
            for (int i = 0; i < l.size() && !found; ++i) {
                XYGraph g = (XYGraph)l.get(i);
                if (g == selected) continue;
                double[] x = g.getX();
                double[] y = g.getY();
                Point p = evt.getPoint();
                for (int j = 0; j < x.length - 1 && !found; ++j) {
                    int sy2;
                    int sx2;
                    int sy;
                    int sx = this.getScreenX(x[j], this.graphCanvas);
                    if (!FitPanel.onLine(sx, sy = this.getScreenY(y[j], this.graphCanvas), sx2 = this.getScreenX(x[j + 1], this.graphCanvas), sy2 = this.getScreenY(y[j + 1], this.graphCanvas), p.x, p.y) && (Math.abs(p.x - sx) >= 4 || Math.abs(p.y - sy) >= 4)) continue;
                    found = true;
                    selected = g;
                }
            }
            if (selected == null) {
                ArrayList al = new ArrayList();
                al.addAll(this.graphCanvas.getAnnotations());
                al.addAll(this.graphCanvas.getAnnotations(true));
                for (int i = 0; i < al.size(); ++i) {
                    Object ann = al.get(i);
                    if (!(ann instanceof String)) continue;
                }
            } else {
                System.out.println("Found:" + selected);
                this.setSelectedObject(selected);
            }
        }
        if (this.tool == 2) {
            this.prev = null;
        }
        if (this.tool == 3) {
            this.p = evt.getPoint();
            if (this.toolCoordinates == 1 || this.toolCoordinates == 2 && this.insideAxis(this.p, this.graphCanvas)) {
                this.p = this.prev;
                this.drawTextXor(this.p, this.ovx, this.ovy, this.prevCs, this.graphCanvas);
                this.ovy = Double.NEGATIVE_INFINITY;
                this.p = evt.getPoint();
                if (this.toolCoordinates == 1) {
                    this.p.x = this.p.x / 20 * 20;
                    this.p.y = this.p.y / 20 * 20;
                }
                this.isEditing = false;
                this.prevTool = 3;
                this.addTextDialog(this.p.x, this.p.y);
            }
        }
        if (this.tool == 7) {
            this.deleteSelectedObject();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FitPanel.this.drawAnchors(FitPanel.this.graphCanvas);
                }
            });
        }
        if (this.tool == 5) {
            if (this.isDragging) {
                return;
            }
            if (this.selectedObj == null) {
                return;
            }
            if (this.selectedObj instanceof String) {
                Object[] loc;
                this.tool = 3;
                this.addTextButton.setSelected(true);
                l = this.graphCanvas.getAnnotations();
                int indx = l.indexOf(this.selectedObj);
                if (indx == -1) {
                    return;
                }
                if (this.toolCoordinates == 1) {
                    loc = (int[])l.get(indx + 1);
                    if (this.p == null) {
                        this.p = new Point();
                    }
                    this.p.x = loc[0];
                    this.p.y = loc[1];
                }
                if (this.toolCoordinates == 2) {
                    loc = (double[])l.get(indx + 1);
                    if (this.p == null) {
                        this.p = new Point();
                    }
                    this.p.x = this.getScreenX(loc[0], this.graphCanvas);
                    this.p.y = this.getScreenY(loc[1], this.graphCanvas);
                }
                Color c = (Color)l.get(indx - 2);
                Font f = (Font)l.get(indx - 1);
                l.remove(indx - 2);
                l.remove(indx - 2);
                l.remove(indx - 2);
                l.remove(indx - 2);
                this.isEditing = true;
                this.prevTool = 5;
                this.addTextDialog(this.p.x, this.p.y, (String)this.selectedObj, f, c);
            }
        }
    }

    private boolean insideAxis(Point p, GraphCanvas canvas) {
        int xi = canvas.getXInset();
        int yi = canvas.getYInset();
        int wa = canvas.getAxis().getSize(0);
        int ha = canvas.getAxis().getSize(1);
        return p.x > xi && p.x < xi + wa && p.y > yi && p.y < yi + ha;
    }

    private void panButtonActionPerformed(ActionEvent evt) {
        this.graphCanvas.repaint();
        if (this.panButton.isSelected()) {
            this.tool = 2;
        }
        this.prev = null;
        this.graphCanvas.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void zoomButtonActionPerformed(ActionEvent evt) {
        this.graphCanvas.repaint();
        if (this.zoomButton.isSelected()) {
            this.tool = 1;
            this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.prev = null;
    }

    private void yMaxFieldActionPerformed(ActionEvent evt) {
        this.yMinFieldActionPerformed(null);
    }

    private void yMinFieldActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setMin(Double.parseDouble(this.yMinField.getText()), 1);
        this.graphCanvas.getAxis().setMax(Double.parseDouble(this.yMaxField.getText()), 1);
        this.graphCanvas.getAxis().setTics(10);
        Axis a = this.graphCanvas.getAxis();
        if (a.isLogarithmic(1)) {
            this.setLogTics(this.graphCanvas);
        }
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void yRangeAutoButtonActionPerformed(ActionEvent evt) {
        if (this.yRangeAutoButton.isSelected()) {
            this.yMinField.setEnabled(false);
            this.yMaxField.setEnabled(false);
            double yMin = Double.MAX_VALUE;
            double yMax = -1.7976931348623157E308;
            Iterator iter = this.graphCanvas.getGraphs().iterator();
            boolean hasGraphs = false;
            while (iter.hasNext()) {
                Graph graph = (Graph)iter.next();
                yMin = Math.min(yMin, graph.getYmin());
                yMax = Math.max(yMax, graph.getYmax());
                hasGraphs = true;
            }
            if (!hasGraphs) {
                yMin = 0.0;
                yMax = 10.0;
            }
            if (this.graphCanvas.getAxis().isLogarithmic(1)) {
                yMin = Math.max(yMin, 1.0);
            }
            this.graphCanvas.getAxis().setMinMax(yMin, yMax, 1);
            this.yMinField.setText(this.format.format(yMin));
            this.yMaxField.setText(this.format.format(yMax));
            this.graphCanvas.getAxis().setTics(10);
            if (this.graphCanvas.getAxis().isLogarithmic(1)) {
                this.setLogTics(this.graphCanvas);
            }
            if (evt != null) {
                this.graphCanvas.refresh();
                this.graphCanvas.repaint();
                this.residualCanvas.refresh();
                this.residualCanvas.repaint();
            }
        }
    }

    private void yRangeButtonActionPerformed(ActionEvent evt) {
        if (this.yRangeButton.isSelected()) {
            this.yMinField.setEnabled(true);
            this.yMaxField.setEnabled(true);
        }
    }

    private void xMaxFieldActionPerformed(ActionEvent evt) {
        this.xMinFieldActionPerformed(null);
    }

    private void xMinFieldActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setMin(Double.parseDouble(this.xMinField.getText()), 0);
        this.residualCanvas.getAxis().setMin(Double.parseDouble(this.xMinField.getText()), 0);
        this.graphCanvas.getAxis().setMax(Double.parseDouble(this.xMaxField.getText()), 0);
        this.residualCanvas.getAxis().setMax(Double.parseDouble(this.xMaxField.getText()), 0);
        this.graphCanvas.getAxis().setTics(10);
        if (this.graphCanvas.getAxis().isLogarithmic(1)) {
            this.setLogTics(this.graphCanvas);
        }
        this.residualCanvas.refresh();
        this.residualCanvas.repaint();
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void xRangeAutoButtonActionPerformed(ActionEvent evt) {
        if (this.xRangeAutoButton.isSelected()) {
            this.xMinField.setEnabled(false);
            this.xMaxField.setEnabled(false);
            double xMin = Double.MAX_VALUE;
            double xMax = -1.7976931348623157E308;
            Iterator iter = this.graphCanvas.getGraphs().iterator();
            boolean hasGraphs = false;
            while (iter.hasNext()) {
                Graph graph = (Graph)iter.next();
                double offset = graph.getOffset();
                double offs = 0.0;
                if (!Double.isNaN(offset)) {
                    offs = offset;
                }
                xMin = Math.min(xMin, graph.getXmin() + offs);
                xMax = Math.max(xMax, graph.getXmax() + offs);
                hasGraphs = true;
            }
            if (!hasGraphs) {
                xMin = 0.0;
                xMax = 1.0;
            }
            if (Math.abs(xMin) < 0.001) {
                xMin = 0.0;
            }
            this.graphCanvas.getAxis().setMinMax(xMin, xMax, 0);
            double myx = this.residualCanvas.getAxis().getMax(1);
            this.residualCanvas.getAxis().setMinMax(xMin, xMax, 0);
            this.xMinField.setText(this.format.format(xMin));
            this.xMaxField.setText(this.format.format(xMax));
            this.graphCanvas.getAxis().setTics(10);
            if (this.graphCanvas.getAxis().isLogarithmic(1)) {
                this.setLogTics(this.graphCanvas);
            }
            if (evt != null) {
                this.graphCanvas.refresh();
                this.graphCanvas.repaint();
                this.residualCanvas.refresh();
                this.residualCanvas.repaint();
            }
        }
    }

    private void xRangeButtonActionPerformed(ActionEvent evt) {
        if (this.xRangeButton.isSelected()) {
            this.xMinField.setEnabled(true);
            this.xMaxField.setEnabled(true);
        }
    }

    private void yAxisTitleFieldActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setTitle(this.yAxisTitleField.getText(), 1);
        this.yRangeLabel.setText(" " + this.yAxisTitleField.getText() + " plot range");
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void xTicsCheckboxActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setDrawTicks(this.xTicsCheckbox.isSelected(), 0);
        this.redoTicsX.setEnabled(this.xTicsCheckbox.isSelected());
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void xAxisTitleFieldActionPerformed(ActionEvent evt) {
        this.graphCanvas.getAxis().setTitle(this.xAxisTitleField.getText(), 0);
        this.xRangeLabel.setText(" " + this.xAxisTitleField.getText() + " plot range");
        this.graphCanvas.refresh();
        this.graphCanvas.repaint();
    }

    private void plotFileMenuActionPerformed(ActionEvent evt) {
    }
}

