/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.HeaderLabel;
import UI.MiniControlWidgets;
import UI.SimulationProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.SoftBevelBorder;
import org.stuk.visualization.graphs.Axis;
import org.stuk.visualization.graphs.GraphCanvas;
import org.stuk.visualization.graphs.XYGraph;

public class FittingProgressMonitor
extends SimulationProgressMonitor
implements Runnable {
    private int BUFFER_SIZE = 1024;
    private boolean stop = false;
    private InputStream inStream;
    private InputStream errorStream;
    private BufferedReader inReader;
    private BufferedReader errorReader;
    private Thread t;
    private char[] buf;
    private boolean error = false;
    private boolean debug = false;
    private String err = "";
    private String log = "";
    private int n = 0;
    private int phase = 1;
    private int max = 0;
    private int cur = 0;
    private String titleInfo = "";
    private boolean finished = false;
    private boolean unbounded = false;
    public int PHASE_SIMULATION = 0;
    public int PHASE_FITTING = 1;
    private int processPhase;
    private long ETA = -1L;
    private long elapsed = 0L;
    private long startTime = 0L;
    private int maxPhases = 1;
    private boolean cancelled = false;
    private boolean stopped = false;
    private Process proc;
    String cat = "";
    double maxy = 0.0;
    double maxx = 0.0;
    private JButton cancelButton1;
    private GraphCanvas graphCanvas1;
    private HeaderLabel headerLabel1;
    private HeaderLabel headerLabel2;
    private HeaderLabel headerLabel3;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private MiniControlWidgets miniControlWidgets1;
    private JProgressBar progressBar;
    private JLabel statusLabel;
    private JButton stopButton;
    private JProgressBar totalProgress;
    private JLabel totalStatusLabel;

    public FittingProgressMonitor(JFrame owner) {
        super(owner);
        this.initComponents();
        this.t = new Thread(this);
        this.t.setDaemon(true);
        this.miniControlWidgets1.setCanvas(this.graphCanvas1);
        this.miniControlWidgets1.constrainToPositive(true, true);
        this.buf = new char[this.BUFFER_SIZE];
        this.progressBar.setMaximum(10);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
    }

    public FittingProgressMonitor(JFrame owner, String title, boolean simple) {
        super(owner);
        this.initComponents();
        this.remove(this.jPanel12);
        this.jPanel11.remove(this.jPanel2);
        this.jPanel3.add(this.jPanel10);
        this.jPanel10.remove(this.stopButton);
        this.titleInfo = title;
        this.setTitle(title);
        this.headerLabel1.setText(" Progress...");
        this.pack();
        this.t = new Thread(this);
        this.t.setDaemon(true);
        this.buf = new char[this.BUFFER_SIZE];
        this.progressBar.setMaximum(10);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
    }

    public void setProcess(Process proc) {
        this.proc = proc;
    }

    public void setETA(long millis) {
        this.ETA = millis;
    }

    public FittingProgressMonitor(JFrame owner, String titleInfo) {
        this(owner);
        this.titleInfo = titleInfo;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setUnbounded(boolean d) {
        this.unbounded = d;
        this.progressBar.setIndeterminate(d);
    }

    public void setProcessPhase(int processPhase) {
        this.processPhase = processPhase;
        this.headerLabel2.setText(" Current phase " + processPhase + " / " + this.maxPhases);
    }

    public void setNumProcessPhases(int processPhase) {
        this.maxPhases = processPhase;
    }

    public void setInStream(InputStream os) {
        this.inStream = new BufferedInputStream(os);
        InputStreamReader reader = new InputStreamReader(os);
        this.inReader = new BufferedReader(reader);
    }

    public void setErrorStream(InputStream os) {
        this.errorStream = new BufferedInputStream(os);
        InputStreamReader reader = new InputStreamReader(os);
        this.errorReader = new BufferedReader(reader);
    }

    public boolean hadErrors() {
        while (!this.finished) {
            Thread.yield();
        }
        if (this.debug) {
            System.out.println("Error status query: result: " + this.error);
        }
        return this.error;
    }

    public String getErrorString() {
        return this.err;
    }

    public String getLogString() {
        return this.log;
    }

    public void readSimulation() {
        try {
            int read;
            while (this.inReader.ready()) {
                read = this.inReader.read(this.buf);
                this.log = this.log + new String(this.buf, 0, read);
                if (read == -1) continue;
                if (this.debug) {
                    System.out.print(new String(this.buf, 0, read));
                }
                if (this.phase != 1 && this.phase != 2 && this.phase != 3) continue;
                if (this.phase == 1) {
                    this.cat = this.cat + new String(this.buf, 0, read);
                }
                for (int i = 0; i < read; ++i) {
                    if (this.debug) {
                        System.out.print(this.buf[i]);
                    }
                    if (this.phase == 1 && this.buf[i] == '|') {
                        this.phase = 2;
                        continue;
                    }
                    if (this.phase == 2) {
                        if (this.buf[i] == '|') {
                            this.statusLabel.setText("Calculating " + this.titleInfo + "....");
                            this.progressBar.setMaximum(this.max);
                            this.phase = 3;
                            continue;
                        }
                        ++this.max;
                        continue;
                    }
                    if (this.phase != 3) continue;
                    this.progressBar.setValue(this.n++);
                    int perc = (int)((float)this.n / (float)this.max * 100.0f);
                    if (this.n < this.max) continue;
                    this.statusLabel.setText("Finishing");
                    this.phase = 4;
                }
            }
            while (this.errorReader.ready()) {
                read = this.errorReader.read(this.buf);
                if (read <= 0) continue;
                this.err = this.err + new String(this.buf, 0, read);
                this.error = true;
                if (!this.debug) continue;
                System.out.print(new String(this.buf, 0, read));
                System.out.println("ERROR IN ERR STREAM!:" + this.err);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void run() {
        this.cancelled = false;
        this.stopped = false;
        try {
            this.phase = 1;
            this.error = false;
            this.finished = false;
            if (this.debug) {
                System.out.println("Progress monitor running...");
            }
            if (this.unbounded) {
                this.progressBar.setForeground(Color.blue);
                this.setTitle(this.titleInfo);
                this.statusLabel.setText("Calculating...");
                this.progressBar.setIndeterminate(true);
            }
            this.err = "";
            this.n = 0;
            this.max = 0;
            this.cur = 0;
            while (!this.stop) {
                this.readSimulation();
                Thread.sleep(100L);
                Thread.yield();
                this.elapsed = System.currentTimeMillis() - this.startTime;
                String etastr = this.ETA == -1L ? "" : " / " + this.ETA / 1000L + " s (estimate)";
                this.totalStatusLabel.setText(" Working...   Time elapsed:" + this.elapsed / 1000L + " s" + etastr);
                this.totalProgress.setValue((int)((float)this.elapsed / (float)this.ETA * 100.0f));
            }
            this.readSimulation();
            this.finished = true;
            this.inStream.close();
            this.errorStream.close();
            if (this.debug) {
                System.out.println("Reading ended.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.finished = true;
        }
    }

    public void start() {
        this.log = "";
        if (this.finished) {
            this.restart();
        } else {
            this.n = 0;
            this.max = 0;
            this.phase = 1;
            this.totalProgress.setMaximum(100);
            this.totalProgress.setValue(0);
            this.startTime = System.currentTimeMillis();
            this.processPhase = 1;
            this.headerLabel2.setText(" Current phase " + this.processPhase + " / " + this.maxPhases);
            this.statusLabel.setText("Preparing... ");
            this.t.setName("Simulation progress panel");
            this.t.setDaemon(true);
            this.t.start();
        }
    }

    public void restart() {
        this.finished = false;
        this.stop = false;
        this.error = false;
        this.n = 0;
        this.max = 0;
        this.phase = 1;
        this.statusLabel.setText("Preparing....");
        this.t = new Thread(this);
        this.t.setName("Fitting progress panel");
        this.t.setDaemon(true);
        this.t.start();
    }

    public void stop() {
        this.stop = true;
        this.finished = true;
    }

    public void stopFully() {
        this.stop = true;
        this.finished = true;
    }

    private void initComponents() {
        this.jPanel11 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel5 = new JPanel();
        this.totalProgress = new JProgressBar();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.totalStatusLabel = new JLabel();
        this.jPanel10 = new JPanel();
        this.stopButton = new JButton();
        this.cancelButton1 = new JButton();
        this.jPanel9 = new JPanel();
        this.headerLabel2 = new HeaderLabel();
        this.jPanel1 = new JPanel();
        this.progressBar = new JProgressBar();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.statusLabel = new JLabel();
        this.jPanel6 = new JPanel();
        this.headerLabel1 = new HeaderLabel();
        this.jPanel12 = new JPanel();
        this.headerLabel3 = new HeaderLabel();
        this.graphCanvas1 = new GraphCanvas();
        this.miniControlWidgets1 = new MiniControlWidgets();
        this.setDefaultCloseOperation(2);
        this.setTitle("(0%) Simulation progress");
        this.jPanel11.setLayout(new BorderLayout());
        this.jPanel11.setPreferredSize(new Dimension(504, 182));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel5.setBorder(new SoftBevelBorder(0));
        this.totalProgress.setForeground(new Color(0, 204, 0));
        this.totalProgress.setFocusable(false);
        this.totalProgress.setPreferredSize(new Dimension(100, 48));
        this.jPanel5.add((Component)this.totalProgress, "Center");
        this.jPanel7.setLayout(new BorderLayout());
        this.jPanel8.setLayout(new FlowLayout(0, 0, 0));
        this.jPanel8.setBorder(new SoftBevelBorder(1));
        this.totalStatusLabel.setText("Working... 1 min 01 sec elapsed... estimated time: 2 min 15 sec");
        this.jPanel8.add(this.totalStatusLabel);
        this.jPanel7.add((Component)this.jPanel8, "Center");
        this.jPanel10.setLayout(new FlowLayout(0, 0, 0));
        this.stopButton.setText("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FittingProgressMonitor.this.stopButtonActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.stopButton);
        this.cancelButton1.setText("Cancel");
        this.cancelButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FittingProgressMonitor.this.cancelButton1ActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.cancelButton1);
        this.jPanel7.add((Component)this.jPanel10, "East");
        this.jPanel5.add((Component)this.jPanel7, "South");
        this.jPanel9.setLayout(new FlowLayout(0, 0, 0));
        this.headerLabel2.setText(" Current phase: 1/4        Current best value for diameter: 1");
        this.headerLabel2.setPreferredSize(new Dimension(2498, 15));
        this.jPanel9.add(this.headerLabel2);
        this.jPanel5.add((Component)this.jPanel9, "North");
        this.jPanel2.add((Component)this.jPanel5, "Center");
        this.jPanel11.add((Component)this.jPanel2, "North");
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new SoftBevelBorder(0));
        this.progressBar.setForeground(new Color(0, 204, 0));
        this.progressBar.setFocusable(false);
        this.progressBar.setPreferredSize(new Dimension(100, 48));
        this.jPanel1.add((Component)this.progressBar, "Center");
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new FlowLayout(0, 0, 0));
        this.jPanel3.setBorder(new SoftBevelBorder(1));
        this.statusLabel.setText("Preparing....");
        this.jPanel3.add(this.statusLabel);
        this.jPanel4.add((Component)this.jPanel3, "Center");
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jPanel6.setLayout(new FlowLayout(0, 0, 0));
        this.headerLabel1.setText(" Sub task progress: ");
        this.headerLabel1.setPreferredSize(new Dimension(2498, 15));
        this.jPanel6.add(this.headerLabel1);
        this.jPanel1.add((Component)this.jPanel6, "North");
        this.jPanel11.add((Component)this.jPanel1, "Center");
        this.getContentPane().add((Component)this.jPanel11, "East");
        this.jPanel12.setLayout(new BorderLayout());
        this.jPanel12.setBorder(new SoftBevelBorder(0));
        this.jPanel12.setPreferredSize(new Dimension(161, 161));
        this.headerLabel3.setText(" Last shape considered::");
        this.headerLabel3.setPreferredSize(new Dimension(155, 15));
        this.jPanel12.add((Component)this.headerLabel3, "North");
        this.graphCanvas1.setBackground(new Color(255, 255, 255));
        this.graphCanvas1.setPreferredSize(new Dimension(155, 140));
        Axis a = new Axis();
        this.graphCanvas1.setAxis(a);
        a.setLogarithmic(true, 1);
        this.graphCanvas1.setAntialiasingEnabled(true);
        a.setDrawTitle(false, 0);
        a.setDrawTitle(false, 1);
        this.jPanel12.add((Component)this.graphCanvas1, "Center");
        this.jPanel12.add((Component)this.miniControlWidgets1, "South");
        this.getContentPane().add((Component)this.jPanel12, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 686) / 2, (screenSize.height - 213) / 2, 686, 213);
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this.proc.destroy();
        this.cancelled = false;
        this.stopped = true;
        this.stop = true;
    }

    public void addResult(XYGraph g, String annot) {
        List l = this.graphCanvas1.getGraphs();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            XYGraph gr = (XYGraph)iter.next();
            gr.setColor(Color.lightGray);
        }
        g.setColor(Color.blue);
        this.graphCanvas1.addGraph(g);
        l = this.graphCanvas1.getAnnotations();
        l.clear();
        l.add(Color.blue);
        l.add(new Font("Arial", 0, 10));
        l.add(annot);
        int[] loc = new int[]{5, 15};
        l.add(loc);
        if (g.getXmax() > this.maxx) {
            this.maxx = g.getXmax();
        }
        if (g.getYmax() > this.maxy) {
            this.maxy = g.getYmax();
        }
        if (this.graphCanvas1.getGraphs().size() == 1) {
            this.graphCanvas1.getAxis().setTics(4);
            this.graphCanvas1.getAxis().setNumberOfTicDecimals(2);
        }
        if (!this.graphCanvas1.isStarted()) {
            this.graphCanvas1.start();
        }
        if (this.graphCanvas1.getGraphs().size() == 1) {
            this.miniControlWidgets1.showAll();
        }
        this.graphCanvas1.refresh();
        this.graphCanvas1.repaint();
    }

    private void cancelButton1ActionPerformed(ActionEvent evt) {
        this.proc.destroy();
        this.cancelled = true;
        this.stopped = false;
        this.stop = true;
    }
}

