/*
 * Decompiled with CFR 0.152.
 */
package UI;

import core.Main;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.stuk.visualization.graphs.Graph;

public class FittingResultsFrame
extends JDialog {
    JLabel lab = new JLabel();
    private JTable areasTable;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextField parField;
    private JLabel parLabel;

    public FittingResultsFrame() {
        super((Frame)Main.mainFrame, false);
        this.initComponents();
        this.setupComponents();
    }

    public void setupComponents() {
        DefaultTableModel dtm = (DefaultTableModel)this.areasTable.getModel();
        this.areasTable.getColumnModel().getColumn(0).setCellRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
                if (value != null) {
                    Graph v = (Graph)value;
                    FittingResultsFrame.this.lab.setForeground(v.getColor());
                    FittingResultsFrame.this.lab.setText(v.getTitle());
                } else {
                    FittingResultsFrame.this.lab.setText("");
                }
                return FittingResultsFrame.this.lab;
            }
        });
    }

    public void clear() {
        DefaultTableModel dtm = (DefaultTableModel)this.areasTable.getModel();
        int n = dtm.getRowCount();
        for (int i = 0; i < n; ++i) {
            dtm.removeRow(0);
        }
        dtm.setColumnCount(3);
        this.parLabel.setText("");
        this.parField.setText("");
        this.parLabel.setEnabled(false);
        this.parField.setEnabled(false);
        this.parLabel.setOpaque(false);
        this.parField.setOpaque(false);
        this.setupComponents();
    }

    public void setParameterValue(String parameter, double value) {
        this.parLabel.setEnabled(true);
        this.parField.setEnabled(true);
        this.parLabel.setOpaque(true);
        this.parField.setOpaque(true);
        this.parLabel.setText(" Best value for " + parameter + ":");
        this.parField.setText("" + value);
    }

    public void setChiSquared(double chi) {
        double ch = (double)((long)(chi * 1000.0)) / 1000.0;
        this.jTextField1.setText("" + ch);
    }

    public void addResult(Graph nuclideId, double area, double areaUnc, Integer absorbed) {
        float au = (float)((long)(areaUnc * 1000.0)) / 1000.0f;
        float a = (float)((long)(area * 1000.0)) / 1000.0f;
        Object[] data1 = new Object[]{nuclideId, "" + a, "" + au};
        Object[] data2 = new Object[]{nuclideId, "" + a, "" + au, absorbed};
        DefaultTableModel dtm = (DefaultTableModel)this.areasTable.getModel();
        if (absorbed == null || absorbed == 0 && dtm.getColumnCount() == 3) {
            dtm.addRow(data1);
        } else {
            if (dtm.getColumnCount() != 4) {
                dtm.addColumn("Absorbed counts");
                this.setupComponents();
            }
            dtm.addRow(data2);
        }
        this.areasTable.setPreferredSize(new Dimension(this.areasTable.getWidth(), dtm.getRowCount() * this.areasTable.getRowHeight()));
    }

    public void addResult(Graph nuclideId, double area, double areaUnc, int absorbed) {
        float au = (float)((long)(areaUnc * 1000.0)) / 1000.0f;
        float a = (float)((long)(area * 1000.0)) / 1000.0f;
        Object[] data1 = new Object[]{nuclideId, "" + a, "" + au};
        Object[] data2 = new Object[]{nuclideId, "" + a, "" + au, "" + absorbed};
        DefaultTableModel dtm = (DefaultTableModel)this.areasTable.getModel();
        if (absorbed == 0 && dtm.getColumnCount() == 3) {
            dtm.addRow(data1);
        } else {
            if (dtm.getColumnCount() != 4) {
                dtm.addColumn("Absorbed counts");
                this.setupComponents();
            }
            dtm.addRow(data2);
        }
        this.areasTable.setPreferredSize(new Dimension(this.areasTable.getWidth(), dtm.getRowCount() * this.areasTable.getRowHeight()));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.areasTable = new JTable();
        this.jPanel1 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.parLabel = new JLabel();
        this.parField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Fitting results");
        this.areasTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Shape", "Area", "Area uncertainty"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.areasTable.setRowSelectionAllowed(false);
        this.jScrollPane1.setViewportView(this.areasTable);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new BorderLayout());
        this.jTextField1.setBackground(new Color(255, 255, 255));
        this.jTextField1.setEditable(false);
        this.jTextField1.setHorizontalAlignment(0);
        this.jTextField1.setText("0.0");
        this.jTextField1.setBorder(null);
        this.jPanel1.add((Component)this.jTextField1, "Center");
        this.jLabel1.setText(" Chi squared:");
        this.jPanel1.add((Component)this.jLabel1, "West");
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BorderLayout());
        this.parLabel.setText(" Value for density:");
        this.jPanel2.add((Component)this.parLabel, "West");
        this.parField.setBackground(new Color(255, 255, 255));
        this.parField.setEditable(false);
        this.parField.setHorizontalAlignment(0);
        this.parField.setText("jTextField2");
        this.parField.setBorder(null);
        this.jPanel2.add((Component)this.parField, "Center");
        this.getContentPane().add((Component)this.jPanel2, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 400) / 2, (screenSize.height - 135) / 2, 400, 135);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new FittingResultsFrame().setVisible(true);
            }
        });
    }
}

