/*
 * Decompiled with CFR 0.152.
 */
package UI;

import core.Main;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.SoftBevelBorder;

public class GecProgressMonitor
extends JDialog
implements Runnable {
    private int BUFFER_SIZE = 1024;
    private boolean stop = false;
    private boolean debug = false;
    private BufferedReader strReader;
    private InputStream inStream;
    private InputStream errorStream;
    private BufferedReader inReader;
    private BufferedReader errorReader;
    private String err;
    private boolean error = false;
    private Thread t;
    private byte[] buf;
    private float std = 0.0f;
    private int n = 0;
    private int phase = 1;
    private int max = 0;
    private int cur = 0;
    private String cat;
    private int find = 0;
    private String temp = "";
    private int num = 0;
    private int perc;
    private float result = 0.0f;
    boolean ended = false;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JProgressBar progressBar;
    private JLabel statusLabel;

    public GecProgressMonitor(JFrame owner) {
        super(owner);
        this.initComponents();
        this.t = new Thread(this);
        this.t.setDaemon(true);
        this.buf = new byte[this.BUFFER_SIZE];
        this.progressBar.setMaximum(10);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
    }

    public void setInStream(InputStream os) {
        this.inStream = new BufferedInputStream(os);
        InputStreamReader reader = new InputStreamReader(os);
        this.inReader = new BufferedReader(reader);
    }

    public void setErrorStream(InputStream os) {
        this.errorStream = new BufferedInputStream(os);
        InputStreamReader reader = new InputStreamReader(os);
        this.errorReader = new BufferedReader(reader);
    }

    public boolean hadErrors() {
        return this.error;
    }

    public String getErrorString() {
        return this.err;
    }

    public float getResult() {
        while (!this.ended) {
            Thread.yield();
        }
        return this.result;
    }

    public void read() {
        try {
            while (this.inStream.available() != 0) {
                int read = this.inStream.read(this.buf);
                int ind = 0;
                if (read != -1) {
                    int i;
                    String s = new String(this.buf, 0, read);
                    if (this.debug) {
                        System.out.print(s);
                    }
                    boolean found = false;
                    if (this.phase == 0) {
                        ind = 0;
                        for (i = 0; i < s.length() && this.num < 7; ++i) {
                            if (s.charAt(ind++) != '\n') continue;
                            ++this.num;
                        }
                        if (this.num > 5) {
                            this.phase = 2;
                            this.cat = s.substring(ind, s.length());
                        }
                    }
                    if (this.phase == 2) {
                        for (i = 0; i < s.length() && !found; ++i) {
                            if (s.charAt(i) != '\n' || i == 0 || i == s.length() - 1) continue;
                            found = true;
                            this.find = i;
                            this.cat = this.cat + s.substring(0, i);
                            this.temp = s.substring(i, s.length());
                        }
                        if (found) {
                            String str = this.cat.substring(0, this.cat.length() - 1);
                            String[] tokens = str.split("\\s+");
                            float cur = 1.0f;
                            float eff = 1.0f;
                            try {
                                cur = Float.parseFloat(tokens[3]);
                                eff = Float.parseFloat(tokens[1]);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            this.perc = (int)(this.std / cur * 100.0f);
                            this.progressBar.setValue(this.perc);
                            this.setTitle("(" + this.perc + "%) Calculation progress");
                            this.statusLabel.setText("Computed " + eff + " decays");
                            found = false;
                            this.cat = this.temp;
                            for (int i2 = 0; i2 < read; ++i2) {
                                String[] tok = this.cat.split("\n");
                                for (int j = 0; j < tok.length; ++j) {
                                    if (!tok[j].startsWith("fraction")) continue;
                                    this.phase = 3;
                                }
                            }
                        } else {
                            this.cat = this.cat + s;
                            found = false;
                        }
                    }
                    if (this.phase != 3) continue;
                    this.cat = this.cat + s;
                    String[] tok = this.cat.split("\n");
                    for (int i3 = 0; i3 < tok.length; ++i3) {
                        if (!tok[i3].startsWith("fraction")) continue;
                        String[] res = tok[i3].split("\\s+");
                        String result = null;
                        if (res.length > 4) {
                            result = res[4];
                        }
                        if (result == null) continue;
                        this.phase = 4;
                        this.result = Float.parseFloat(result);
                    }
                    this.cat = this.cat + s;
                    continue;
                }
                this.stop = true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            while (this.errorStream.available() != 0) {
                int read = this.errorStream.read(this.buf);
                if (read <= 0) continue;
                this.error = true;
                String s = new String(this.buf, 0, read);
                this.err = this.err + s;
                System.out.print(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        try {
            this.std = ((Float)Main.getParameter("5014").getValue()).floatValue();
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(0);
            this.phase = 0;
            this.ended = false;
            try {
                while (!this.stop || this.inStream.available() > 0) {
                    this.read();
                    Thread.sleep(100L);
                }
            }
            catch (Exception weird) {
                weird.printStackTrace();
            }
            this.ended = true;
            this.inStream.close();
            this.errorStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void start() {
        this.n = 0;
        this.max = 0;
        this.phase = 1;
        this.statusLabel.setText("Preparing....");
        this.t.setName("Simulation progress panel");
        this.t.setDaemon(true);
        this.t.start();
    }

    public void stop() {
        this.stop = true;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.progressBar = new JProgressBar();
        this.jPanel4 = new JPanel();
        this.cancelButton = new JButton();
        this.jPanel3 = new JPanel();
        this.statusLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("(0%) \u03b5 calculation progress");
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new SoftBevelBorder(0));
        this.progressBar.setFocusable(false);
        this.jPanel1.add((Component)this.progressBar, "Center");
        this.jPanel4.setLayout(new BorderLayout());
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GecProgressMonitor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.cancelButton, "East");
        this.jPanel3.setLayout(new FlowLayout(0, 0, 0));
        this.jPanel3.setBorder(new SoftBevelBorder(1));
        this.statusLabel.setText("Preparing....");
        this.jPanel3.add(this.statusLabel);
        this.jPanel4.add((Component)this.jPanel3, "Center");
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 323) / 2, (screenSize.height - 87) / 2, 323, 87);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        Main.stopGECalculation();
        this.stop = true;
    }
}

