/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.ParameterEditor;
import UI.ParameterRenderer;
import core.Main;
import core.Parameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class GeometricEfficiencyFrame
extends JDialog {
    static Parameter std;
    static Parameter dr;
    static Parameter sr;
    static Parameter so;
    static Parameter da;
    static Parameter srca;
    static Parameter geo;
    static Parameter sdd;
    static Parameter ps;
    static Parameter sa;
    static Parameter x;
    static Parameter y;
    Color origColor;
    Color origColor2;
    Color disablColor = new Color(0.7f, 0.6f, 0.5f);
    Color disablColor2 = new Color(0.5f, 0.4f, 0.2f);
    boolean loaded = false;
    private JButton cancelButton;
    private JTable detAreaField;
    private JTable detRadiusField;
    private ButtonGroup detectorBtnGroup;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JButton okButton;
    private JRadioButton pointSourceButton;
    private JTable sddField;
    private ButtonGroup sourceBtnGroup;
    private JRadioButton sourceDiameterButton;
    private JTable srcAreaField;
    private JTable srcOffsetField;
    private JTable srcRadiusField;
    private JTable stdField;
    private JTable xField;
    private JTable yField;

    public GeometricEfficiencyFrame() {
        super(Main.mainFrame);
        this.initComponents();
        this.loadComponents();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        JPanel pa = (JPanel)this.getContentPane();
        pa.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Keystroke found!");
                GeometricEfficiencyFrame.this.okButtonActionPerformed(null);
            }
        }, "run_sim", enter, 1);
    }

    public void freeComponents() {
        this.okButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    private void loadComponents() {
        float r;
        if (sr == null) {
            sr = Main.cloneParameter("1", "5010");
            sr.setCoeff(new Float(0.5));
            srca = Main.createParameter("SourceArea");
            r = sr.getFloatValue().floatValue() / 2.0f;
            srca.setValue(new Float(Math.PI * (double)r * (double)r));
            srca.setMinValue(new Float(0.0f));
            srca.setName("Source area.");
            srca.setDescription("The area of the source.");
        }
        if (dr == null) {
            dr = Main.cloneParameter("12", "5011");
            dr.setCoeff(new Float(0.5));
            da = Main.createParameter("DetectorArea");
            r = dr.getFloatValue().floatValue() / 2.0f;
            da.setValue(new Float(Math.PI * (double)r * (double)r));
            da.setMinValue(new Float(0.0f));
            da.setName("Detector area.");
            da.setDescription("The area of the detector.");
        }
        if (sdd == null) {
            sdd = Main.cloneParameter("1001", "5012");
        }
        if (so == null) {
            so = Main.getParameter("5513");
        }
        if (ps == null) {
            ps = Main.createParameter("5013");
            ps.setValue("n");
            ps.setName("Point source.");
        }
        if (std == null) {
            std = Main.createParameter("5014");
            std.setValue(new Float(0.5f));
            std.setMinValue(new Float(0.0f));
            std.setName("Standard deviation in geometric efficiency calculation.");
        }
        if (geo == null) {
            geo = Main.createParameter("5015");
            geo.setValue("y");
            geo.setName("Geometric efficiency calculation only.");
        }
        if (sa == null) {
            sa = Main.cloneParameter("1000", "5016");
        }
        if (x == null) {
            x = Main.cloneParameter("21", "5017");
        }
        if (y == null) {
            y = Main.cloneParameter("22", "5018");
        }
        this.detRadiusField.setValueAt(dr, 0, 0);
        this.srcRadiusField.setValueAt(sr, 0, 0);
        this.srcOffsetField.setValueAt(so, 0, 0);
        this.stdField.setValueAt(std, 0, 0);
        this.sddField.setValueAt(sdd, 0, 0);
        this.xField.setValueAt(x, 0, 0);
        this.yField.setValueAt(y, 0, 0);
        this.detAreaField.setValueAt(da, 0, 0);
        this.srcAreaField.setValueAt(srca, 0, 0);
        this.loaded = true;
    }

    private void initComponents() {
        this.sourceBtnGroup = new ButtonGroup();
        this.detectorBtnGroup = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.sddField = new JTable();
        this.srcRadiusField = new JTable();
        this.detRadiusField = new JTable();
        this.stdField = new JTable();
        this.jLabel13 = new JLabel();
        this.xField = new JTable();
        this.yField = new JTable();
        this.jLabel9 = new JLabel();
        this.srcAreaField = new JTable();
        this.sourceDiameterButton = new JRadioButton();
        this.pointSourceButton = new JRadioButton();
        this.jLabel12 = new JLabel();
        this.detAreaField = new JTable();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.srcOffsetField = new JTable();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jPanel4 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Geometric efficiency calculation");
        this.setResizable(false);
        this.jPanel2.setBorder(new SoftBevelBorder(1));
        this.jPanel2.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        this.jPanel2.setPreferredSize(new Dimension(290, 170));
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Source - detector distance (SDD)");
        this.jPanel2.add((Component)this.jLabel1, new AbsoluteConstraints(14, 13, 167, -1));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Desired relative standard deviation");
        this.jPanel2.add((Component)this.jLabel4, new AbsoluteConstraints(13, 72, 171, -1));
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setText("mm");
        this.jPanel2.add((Component)this.jLabel5, new AbsoluteConstraints(350, 150, 30, 20));
        this.jLabel6.setHorizontalAlignment(2);
        this.jLabel6.setText("mm");
        this.jPanel2.add((Component)this.jLabel6, new AbsoluteConstraints(271, 102, 30, -1));
        this.jLabel7.setHorizontalAlignment(2);
        this.jLabel7.setText("mm");
        this.jPanel2.add((Component)this.jLabel7, new AbsoluteConstraints(271, 43, 30, 19));
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setText("x");
        this.jPanel2.add((Component)this.jLabel10, new AbsoluteConstraints(170, 150, 20, 19));
        this.jLabel11.setHorizontalAlignment(0);
        this.jLabel11.setText("y");
        this.jPanel2.add((Component)this.jLabel11, new AbsoluteConstraints(270, 150, 20, 19));
        this.sddField.setBorder(new SoftBevelBorder(1));
        this.sddField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.sddField.setToolTipText("Distance between the source and the detector");
        this.sddField.setRowSelectionAllowed(false);
        this.sddField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.sddField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.jPanel2.add((Component)this.sddField, new AbsoluteConstraints(191, 13, -1, -1));
        this.srcRadiusField.setBorder(new SoftBevelBorder(1));
        this.srcRadiusField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.srcRadiusField.setRowSelectionAllowed(false);
        this.initTableListeners(this.srcRadiusField);
        this.srcRadiusField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.srcRadiusField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.jPanel2.add((Component)this.srcRadiusField, new AbsoluteConstraints(191, 102, -1, -1));
        this.detRadiusField.setBorder(new SoftBevelBorder(1));
        this.detRadiusField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.detRadiusField.setRowSelectionAllowed(false);
        this.initTableListeners(this.detRadiusField);
        this.detRadiusField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.detRadiusField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.jPanel2.add((Component)this.detRadiusField, new AbsoluteConstraints(191, 43, -1, -1));
        this.stdField.setBorder(new SoftBevelBorder(1));
        this.stdField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.stdField.setToolTipText("The desired standard deviation");
        this.stdField.setRowSelectionAllowed(false);
        this.stdField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.stdField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.jPanel2.add((Component)this.stdField, new AbsoluteConstraints(191, 72, -1, -1));
        this.jLabel13.setHorizontalAlignment(0);
        this.jPanel2.add((Component)this.jLabel13, new AbsoluteConstraints(0, 0, -1, -1));
        this.xField.setBorder(new SoftBevelBorder(1));
        this.xField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.xField.setToolTipText("X-coordinate of the point source (in millimeters)");
        this.xField.setEnabled(false);
        this.xField.setRowSelectionAllowed(false);
        this.xField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.xField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.jPanel2.add((Component)this.xField, new AbsoluteConstraints(190, 150, 50, -1));
        this.yField.setBorder(new SoftBevelBorder(1));
        this.yField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.yField.setToolTipText("Y-coordinate of the point source (in millimeters)");
        this.yField.setEnabled(false);
        this.yField.setRowSelectionAllowed(false);
        this.yField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.yField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.jPanel2.add((Component)this.yField, new AbsoluteConstraints(290, 150, 50, -1));
        this.jLabel9.setHorizontalAlignment(2);
        this.jLabel9.setText("%");
        this.jPanel2.add((Component)this.jLabel9, new AbsoluteConstraints(271, 72, 31, -1));
        this.srcAreaField.setBorder(new SoftBevelBorder(1));
        this.srcAreaField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.srcAreaField.setRowSelectionAllowed(false);
        this.initTableListeners(this.srcAreaField);
        this.srcAreaField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.srcAreaField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.jPanel2.add((Component)this.srcAreaField, new AbsoluteConstraints(341, 102, -1, -1));
        this.sourceBtnGroup.add(this.sourceDiameterButton);
        this.sourceDiameterButton.setSelected(true);
        this.sourceDiameterButton.setText("Source diameter");
        this.sourceDiameterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeometricEfficiencyFrame.this.radioButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.sourceDiameterButton, new AbsoluteConstraints(63, 102, -1, 16));
        this.sourceBtnGroup.add(this.pointSourceButton);
        this.pointSourceButton.setText("Point source");
        this.pointSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeometricEfficiencyFrame.this.radioButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.pointSourceButton, new AbsoluteConstraints(60, 150, -1, 16));
        this.jLabel12.setHorizontalAlignment(2);
        this.jLabel12.setText("mm\u00b2");
        this.jPanel2.add((Component)this.jLabel12, new AbsoluteConstraints(421, 102, 31, -1));
        this.detAreaField.setBorder(new SoftBevelBorder(1));
        this.detAreaField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.detAreaField.setRowSelectionAllowed(false);
        this.initTableListeners(this.detAreaField);
        this.detAreaField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.detAreaField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.jPanel2.add((Component)this.detAreaField, new AbsoluteConstraints(341, 43, -1, -1));
        this.jLabel14.setHorizontalAlignment(2);
        this.jLabel14.setText("mm\u00b2");
        this.jPanel2.add((Component)this.jLabel14, new AbsoluteConstraints(421, 43, 31, -1));
        this.jLabel15.setHorizontalAlignment(4);
        this.jLabel15.setText("Detector diameter");
        this.jPanel2.add((Component)this.jLabel15, new AbsoluteConstraints(93, 43, 92, -1));
        this.jLabel16.setHorizontalAlignment(4);
        this.jLabel16.setText("Area");
        this.jPanel2.add((Component)this.jLabel16, new AbsoluteConstraints(302, 43, 29, -1));
        this.jLabel17.setHorizontalAlignment(4);
        this.jLabel17.setText("Offset");
        this.jPanel2.add((Component)this.jLabel17, new AbsoluteConstraints(280, 120, 50, -1));
        this.jLabel8.setHorizontalAlignment(2);
        this.jLabel8.setText("mm");
        this.jPanel2.add((Component)this.jLabel8, new AbsoluteConstraints(271, 13, 30, -1));
        this.jLabel18.setHorizontalAlignment(2);
        this.jLabel18.setText("mm");
        this.jPanel2.add((Component)this.jLabel18, new AbsoluteConstraints(271, 13, 30, -1));
        this.jLabel19.setHorizontalAlignment(2);
        this.jLabel19.setText("mm");
        this.jPanel2.add((Component)this.jLabel19, new AbsoluteConstraints(250, 150, 20, 20));
        this.srcOffsetField.setBorder(new SoftBevelBorder(1));
        this.srcOffsetField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.srcOffsetField.setRowSelectionAllowed(false);
        this.initTableListeners(this.srcOffsetField);
        this.srcOffsetField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.srcOffsetField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.jPanel2.add((Component)this.srcOffsetField, new AbsoluteConstraints(340, 120, -1, -1));
        this.jLabel20.setHorizontalAlignment(2);
        this.jLabel20.setText("mm");
        this.jPanel2.add((Component)this.jLabel20, new AbsoluteConstraints(420, 120, 30, -1));
        this.jLabel21.setHorizontalAlignment(4);
        this.jLabel21.setText("Area");
        this.jPanel2.add((Component)this.jLabel21, new AbsoluteConstraints(302, 102, 29, -1));
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel4.setLayout(new FlowLayout(2, 7, 5));
        this.okButton.setText("Run geometric efficiency calculation");
        this.okButton.setToolTipText("Start calculation");
        this.okButton.setPreferredSize(null);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeometricEfficiencyFrame.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel");
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeometricEfficiencyFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel4, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 464) / 2, (screenSize.height - 332) / 2, 464, 332);
    }

    private void initTableListeners(JTable table) {
        table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (!GeometricEfficiencyFrame.this.loaded) {
                    return;
                }
                Object src = e.getSource();
                if (src == GeometricEfficiencyFrame.this.detAreaField.getModel()) {
                    Parameter a = (Parameter)GeometricEfficiencyFrame.this.detAreaField.getValueAt(0, 0);
                    float area = a.getFloatValue().floatValue();
                    float r = (float)(Math.sqrt(area) / Math.PI);
                    Parameter b = (Parameter)GeometricEfficiencyFrame.this.detRadiusField.getValueAt(0, 0);
                    b.setValue(new Float(r * 2.0f));
                } else if (src == GeometricEfficiencyFrame.this.detRadiusField.getModel()) {
                    Parameter a = (Parameter)GeometricEfficiencyFrame.this.detRadiusField.getValueAt(0, 0);
                    Parameter b = (Parameter)GeometricEfficiencyFrame.this.detAreaField.getValueAt(0, 0);
                    float r = a.getFloatValue().floatValue() / 2.0f;
                    float area = (float)(Math.PI * (double)r * (double)r);
                    b.setValue(new Float(area));
                } else if (src == GeometricEfficiencyFrame.this.srcAreaField.getModel()) {
                    Parameter a = (Parameter)GeometricEfficiencyFrame.this.srcAreaField.getValueAt(0, 0);
                    float area = a.getFloatValue().floatValue();
                    float r = (float)Math.sqrt((double)area / Math.PI);
                    Parameter b = (Parameter)GeometricEfficiencyFrame.this.srcRadiusField.getValueAt(0, 0);
                    b.setValue(new Float(r * 2.0f));
                } else if (src == GeometricEfficiencyFrame.this.srcRadiusField.getModel()) {
                    Parameter a = (Parameter)GeometricEfficiencyFrame.this.srcRadiusField.getValueAt(0, 0);
                    Parameter b = (Parameter)GeometricEfficiencyFrame.this.srcAreaField.getValueAt(0, 0);
                    float r = a.getFloatValue().floatValue() / 2.0f;
                    float area = (float)(Math.PI * (double)r * (double)r);
                    b.setValue(new Float(area));
                }
                GeometricEfficiencyFrame.this.jPanel2.repaint();
            }
        });
    }

    private void radioButtonActionPerformed(ActionEvent evt) {
        if (this.sourceDiameterButton.isSelected()) {
            this.srcAreaField.setEnabled(true);
            this.srcRadiusField.setEnabled(true);
            this.xField.setEnabled(false);
            this.yField.setEnabled(false);
            this.srcOffsetField.setEnabled(true);
            ps.setValue("n");
        }
        if (this.pointSourceButton.isSelected()) {
            this.xField.setEnabled(true);
            this.yField.setEnabled(true);
            this.srcAreaField.setEnabled(false);
            this.srcOffsetField.setEnabled(false);
            this.srcRadiusField.setEnabled(false);
            ps.setValue("y");
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void removeCancelButton() {
        this.cancelButton.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Main.writeGec();
        Main.runGECalculation();
        this.dispose();
    }
}

