/*
 * Decompiled with CFR 0.152.
 */
package UI;

import core.Main;
import core.TextWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class LogPanel
extends JPanel {
    boolean scrollOnSet = false;
    boolean isLog = true;
    private JMenuItem appendMenuItem;
    private JMenuItem clearMenuItem;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JMenuItem saveMenuItem;
    private JTextArea textArea;

    public LogPanel(boolean isLog) {
        this.initComponents();
    }

    public void setEditable(boolean enabled) {
        this.textArea.setEditable(enabled);
    }

    public void setScrollOnSet(boolean enabled) {
        this.scrollOnSet = enabled;
    }

    public void setText(String text) {
        this.textArea.setText(text);
        if (this.scrollOnSet) {
            this.textArea.getCaret().setDot(0);
        }
    }

    public void setWordWrap(boolean enabled) {
        this.textArea.setWrapStyleWord(enabled);
    }

    public String getText() {
        return this.textArea.getText();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.clearMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.saveMenuItem = new JMenuItem();
        this.appendMenuItem = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.clearMenuItem.setText("Clear");
        this.clearMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPanel.this.clearMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.clearMenuItem);
        this.jPopupMenu1.add(this.jSeparator1);
        this.saveMenuItem.setText("Save ..");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPanel.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.saveMenuItem);
        this.appendMenuItem.setText("Append to file...");
        this.appendMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPanel.this.appendMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.appendMenuItem);
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(255, 255, 255));
        this.textArea.setBackground(new Color(255, 255, 254));
        this.textArea.setColumns(70);
        this.textArea.setRows(15);
        this.textArea.setAutoscrolls(false);
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                LogPanel.this.textAreaKeyTyped(evt);
            }
        });
        this.textArea.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LogPanel.this.textAreaMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                LogPanel.this.textAreaMousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.textArea);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void appendMenuItemActionPerformed(ActionEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File(Main.workingDir));
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                TextWriter w = new TextWriter();
                w.writeText(f.getCanonicalPath(), this.textArea.getText(), true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File(Main.workingDir));
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                TextWriter w = new TextWriter();
                w.writeText(f.getCanonicalPath(), this.textArea.getText(), false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void textAreaKeyTyped(KeyEvent evt) {
        if (this.isLog) {
            Main.log = this.textArea.getText();
        } else {
            Main.notes = this.textArea.getText();
        }
    }

    private void textAreaMousePressed(MouseEvent evt) {
    }

    private void clearMenuItemActionPerformed(ActionEvent evt) {
        this.textArea.setText("");
        if (this.isLog) {
            Main.log = "";
        } else {
            Main.notes = "";
        }
    }

    private void textAreaMouseClicked(MouseEvent evt) {
        if (evt.getButton() != 1) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

