/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.AboutDialog;
import UI.BasicEditor;
import UI.BasicRenderer;
import UI.CustomCellEditor;
import UI.CustomCellRenderer;
import UI.Drawer;
import UI.ElementEditor;
import UI.ElementRenderer;
import UI.FitPanel;
import UI.GeometricEfficiencyFrame;
import UI.HeaderLabel;
import UI.HeaderRenderer;
import UI.LogPanel;
import UI.ParameterEditor;
import UI.ParameterNameRenderer;
import UI.ParameterRenderer;
import UI.PlotPanel;
import UI.Shelf;
import UI.SketchPanel;
import UI.UnitRenderer;
import UI.WelcomePanel;
import core.Element;
import core.Fitter;
import core.Help;
import core.Line;
import core.Main;
import core.Nuclide;
import core.OutputWriter;
import core.Parameter;
import core.SystemMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.stuk.visualization.graphs.XYGraph;

public class MainFrame
extends JFrame {
    boolean expDistrCylin = false;
    boolean manyParticlesRandomly = true;
    boolean lognormalSizeDistr = false;
    float cylindrThickn = 1.0f;
    boolean loaded = false;
    PlotPanel plotPanel;
    public static GeometricEfficiencyFrame gecFrame;
    JDesktopPane current = null;
    static int notesWindowX;
    static int notesWindowY;
    static int notesWindowW;
    static int notesWindowH;
    static boolean notesWindowS;
    static int sketchWindowX;
    static int sketchWindowY;
    static int sketchWindowW;
    static int sketchWindowH;
    static boolean sketchWindowS;
    static int logWindowX;
    static int logWindowY;
    static int logWindowW;
    static int logWindowH;
    static boolean logWindowS;
    static int[] X;
    static int[] Y;
    static Dimension[] size;
    static Point[] location;
    static boolean[] visible;
    static boolean[] minimized;
    static String chooserSaveHome;
    static String chooserOpenHome;
    static int[] M;
    boolean layerMod = false;
    boolean debug = true;
    JInternalFrame gecFrameI;
    private JCheckBoxMenuItem simulatorInputTabMenuItem = null;
    JTextArea debugField = new JTextArea();
    JScrollPane debugPane;
    JPanel debugPanel;
    private int begin = -1;
    private int end = -1;
    private String objStr;
    ElementEditor ed = new ElementEditor(this, null, "LayerEditNumElems", 6000, "Layer element composition");
    private Object[] rowData = new Object[3];
    int cur = 1;
    boolean sumPlot = true;
    XYGraph sum;
    float[] x = null;
    float[] y = null;
    private FitPanel fitPanel;
    JInternalFrame helpFrame;
    JInternalFrame notesFrame;
    public static LogPanel notesPanel;
    JInternalFrame logFrame;
    LogPanel logPanel;
    JInternalFrame sketchFrame;
    SketchPanel sketchPanel;
    boolean lognorm1 = false;
    boolean lognorm = false;
    private boolean loadingCoincidenceData = false;
    boolean sumOnly = false;
    boolean expo1;
    int frmX = -1;
    int frmY = -1;
    boolean srcFrameSet = true;
    boolean logFrameIcon = false;
    boolean sketchFrameIcon = false;
    boolean notesFrameIcon = false;
    boolean wait = false;
    List absorbed = new ArrayList();
    String outputDir = Main.workingDir;
    int freeRow = -1;
    Vector temp = new Vector();
    private JMenu LafMenu;
    private JRadioButton absLayersBtn;
    private JButton addLayerBtn;
    private JButton addNuclideButton;
    private JInternalFrame backScatterFrame;
    private JComboBox backingplateMaterialCombobox;
    private JTable backingplateMaterialPropertiesTable;
    private JTable backingplateMaterialPropertiesTable1;
    private JTable betaLinesTable;
    private ButtonGroup browseCoincGroup;
    private JRadioButton browseLibCoincidences;
    private JRadioButton browseSimCoincidences;
    private JDesktopPane calculateDesktop;
    private JMenuItem cascadeMenuItem;
    private JInternalFrame coincidenceFrame;
    private JComboBox coincidenceNuclideComboBox;
    private JScrollPane coincidenceNuclidesScrollPane;
    private JTable coincidenceNuclidesTable;
    private JTextField coincidenceOutputFileField;
    private JCheckBox coincidencesCheckbox;
    private JCheckBox coincidencesCheckbox1;
    private JDesktopPane coincidencesDesktop;
    private JComboBox deadLayerMaterialCombobox;
    private JTable deadLayerMaterialPropertiesTable;
    private JTable decaysField;
    private JLabel decaysLabel;
    private JButton deleteLayerButton;
    private HeaderLabel depLabel;
    private JLabel depLabel2;
    private JTable depositionAreaField;
    private ButtonGroup depthGroup;
    private HeaderLabel depthLabel;
    private JDesktopPane detectorDesktop;
    private JTable detectorField;
    private JTable detectorFilename;
    private JInternalFrame detectorFrame;
    private JTable detectorPropertiesTable;
    private JRadioButton ellipsoidalBtn;
    private JRadioButton ellipsoidalBtn1;
    private JTable energyBinField;
    private JRadioButton exponentialBtn;
    private JMenuItem fileExitItem;
    private JMenu fileMenu;
    private JMenuItem fileOpenItem;
    private JMenuItem fileSaveAsItem;
    private JMenuItem fileSaveDetAs;
    private JMenuItem fileSaveItem;
    private JTable gammaLinesTable;
    private HeaderLabel headerLabel1;
    private HeaderLabel headerLabel11;
    private HeaderLabel headerLabel12;
    private HeaderLabel headerLabel13;
    private HeaderLabel headerLabel14;
    private HeaderLabel headerLabel15;
    private HeaderLabel headerLabel16;
    private HeaderLabel headerLabel17;
    private HeaderLabel headerLabel18;
    private HeaderLabel headerLabel19;
    private HeaderLabel headerLabel2;
    private HeaderLabel headerLabel23;
    private HeaderLabel headerLabel24;
    private HeaderLabel headerLabel25;
    private HeaderLabel headerLabel26;
    private HeaderLabel headerLabel27;
    private HeaderLabel headerLabel28;
    private HeaderLabel headerLabel29;
    private HeaderLabel headerLabel3;
    private HeaderLabel headerLabel30;
    private HeaderLabel headerLabel31;
    private HeaderLabel headerLabel4;
    private HeaderLabel headerLabel5;
    private HeaderLabel headerLabel6;
    private JMenuItem helpAboutItem;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JMenuItem helpWelcomeItem;
    private JRadioButton homogenousSourceButton;
    private Drawer homogenousSourceDrawer;
    private JRadioButton identicalSizeBtn;
    private JRadioButton identicalSizeBtn1;
    private JCheckBox includeBackingplateCheckbox;
    private JMenuItem infoViewMenuItem;
    private JTable integrationStepField;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel50;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane10;
    private JScrollPane jScrollPane11;
    private JScrollPane jScrollPane12;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JScrollPane jScrollPane9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JTextField jTextField3;
    private JTable layerMaterialElementsTable;
    private JTable layerMaterialPropertiesTable;
    private JDesktopPane layersDesktop;
    private JInternalFrame layersFrame;
    private ButtonGroup layersGroup;
    private HeaderLabel layersHeader;
    private HeaderLabel layersHeader2;
    private HeaderLabel layersHeader3;
    private JPanel layersPanel;
    private JTable layersTable;
    private JTable lineEnergyField;
    private JRadioButton lineEnergyRadioBtn;
    private JCheckBox linearDepositionCheckbox;
    private JTable linesTable;
    private JCheckBoxMenuItem logWindowMenuItem;
    private JRadioButton lognormalSizeBtn;
    private JRadioButton lognormalSizeBtn1;
    private JRadioButton manyParticlesBtn;
    private JRadioButton matrixSourceButton;
    private Drawer matrixSourceDrawer;
    private JMenuItem maximizeAll;
    private JTextField memField;
    private JMenuBar menuBar;
    private JLabel mevLabel;
    private JMenuItem minimizeAllMenuItem;
    private JRadioButton noAbsLayersBtn;
    private JCheckBoxMenuItem notesMenuItem;
    private JComboBox nuclideComboBox;
    private HeaderLabel nuclideLabel;
    private HeaderLabel nuclideLabel1;
    private HeaderLabel nuclidePropertiesLabel;
    private JTable nuclidePropertiesTable;
    private JRadioButton nuclideRadioBtn;
    private ButtonGroup nuclideSelButtonGroup;
    private JInternalFrame nuclidesFrame;
    private JPanel nuclidesPanel;
    private JScrollPane nuclidesScrollPane;
    private JScrollPane nuclidesScrollPane1;
    private JScrollPane nuclidesScrollPane2;
    private JScrollPane nuclidesScrollPane3;
    private JTable nuclidesTable;
    private ButtonGroup occurenceGroup;
    private ButtonGroup occurenceGroup1;
    private JLabel openDetector;
    private JLabel openLibrary;
    private JLabel openLibrary1;
    private JLabel openLibrary2;
    private HeaderLabel pTypeLabel;
    private JCheckBox parallelbeamCheckbox;
    private JInternalFrame paramsFrame;
    private JPanel paramsPanel;
    private JTable particleMaterialElementsTable1;
    private JTable particleMaterialElementsTable2;
    private JTable particlePropertiesTable1;
    private JTable particlePropertiesTable2;
    private JPanel particlesPanel2;
    private JPanel particlesPanel3;
    private JPanel particlesPanel4;
    private ButtonGroup peakShapeGroup;
    private JTable peakTailingPropertiesTable;
    private JCheckBoxMenuItem plotTabMenuItem;
    private HeaderLabel posLabel;
    private JLabel posLabel1;
    private JLabel posLabel2;
    private JLabel posLabel3;
    private JLabel posLabel4;
    private JInternalFrame radiationSourceFrame;
    private JRadioButton radioactiveParticlesButton;
    private Drawer radioactiveParticlesDrawer;
    private JButton removeNuclideButton;
    private JButton runButton;
    private JMenuItem runGeometricEfficiencyMenuItem;
    private JMenu runMenu;
    private JMenuItem runMenuItem;
    private JLabel saveDetector;
    private JTable sddField;
    private HeaderLabel selectedNuclidesLabel;
    private HeaderLabel selectedNuclidesLabel1;
    private HeaderLabel selectedNuclidesLabel2;
    private JCheckBox selfabsCheckBox;
    private JComboBox shieldingModelCombobox;
    private JRadioButton singleParticleBtn;
    private HeaderLabel sizeLabel;
    private HeaderLabel sizeLabel1;
    private JCheckBoxMenuItem sketchWindowMenuItem;
    private JDesktopPane sourceDesktop;
    private JTable sourceMaterialElementsTable1;
    private JTable sourceMaterialElementsTable2;
    private JTable sourcePropertiesTable1;
    private JTable sourcePropertiesTable2;
    private Shelf sourceShelf;
    private ButtonGroup sourceTypeGroup;
    private JRadioButton sphericalBtn;
    private JRadioButton sphericalBtn1;
    private JCheckBox srcDetectorCheckBox;
    private JPanel statusPanel;
    private JCheckBox stragglingCheckBox;
    private JRadioButton surfaceLayerBtn;
    private JRadioButton surfaceLayerBtn1;
    private JTabbedPane tabsPane;
    private JMenuItem tileMenuItem;
    private JTextField timeField;
    private JCheckBox trackAlphaCheckBox;
    private ButtonGroup typeGroup;
    private ButtonGroup typeGroup1;
    private JRadioButton uniformBtn;
    private JMenu viewMenu;
    private JMenu windowMenu;
    private JTable xPosField;
    private JTable yPosField;

    public MainFrame() {
        this.current = this.detectorDesktop;
        MainFrame.loadSettings();
        Main.sp.status.setText("Opening main window : settings");
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.initComponents();
        Main.sp.status.setText("Opening main window : components");
        this.loadComponents();
        Main.sp.status.setText("Opening main window : frames");
        this.initInternalFrames();
        this.setupHelp();
        SystemMonitor sm = new SystemMonitor(this.memField, this.timeField);
        if (Main.debug) {
            this.addDebugMenu();
        }
        this.addPlotTab();
        if (!MainFrame.cookieExists()) {
            this.addWelcomeTab();
            this.tabsPane.setSelectedIndex(0);
        }
        this.buildLafMenu();
    }

    private void buildLafMenu() {
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafs.length; ++i) {
            JMenuItem item = new JMenuItem();
            final UIManager.LookAndFeelInfo laf = lafs[i];
            item.setText(laf.getName());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        UIManager.setLookAndFeel(laf.getClassName());
                        MainFrame.updateComponentTreeUI(Main.mainFrame);
                        MainFrame.updateComponentTreeUI(MainFrame.this.getJMenuBar());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.LafMenu.add(item);
        }
    }

    public void addDebugMenu() {
        JMenu debug = new JMenu("Debug");
        this.simulatorInputTabMenuItem = new JCheckBoxMenuItem("Show inputs page");
        this.simulatorInputTabMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.debugPanel == null) {
                    MainFrame.this.addDebugTab();
                } else {
                    MainFrame.this.tabsPane.remove(MainFrame.this.debugPanel);
                    MainFrame.this.debugPanel = null;
                }
            }
        });
        debug.add(this.simulatorInputTabMenuItem);
        this.menuBar.add(debug);
    }

    private static void updateComponentTreeUI(Component c) {
        if (c instanceof JComponent) {
            ((JComponent)c).updateUI();
            if (c instanceof JCheckBox) {
                ((JCheckBox)c).setOpaque(false);
            }
        }
        Component[] children = null;
        if (c instanceof JTable) {
            JTable tab = (JTable)c;
            int col = tab.getColumnCount();
            for (int i = 0; i < col; ++i) {
                TableCellEditor ed = tab.getColumnModel().getColumn(i).getCellEditor();
                TableCellRenderer re = tab.getColumnModel().getColumn(i).getCellRenderer();
                if (ed instanceof CustomCellEditor) {
                    ((CustomCellEditor)((Object)ed)).updateUI();
                }
                if (!(re instanceof CustomCellRenderer)) continue;
                ((CustomCellRenderer)re).updateUI();
            }
        }
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                MainFrame.updateComponentTreeUI(children[i]);
            }
        }
    }

    public void addWelcomeTab() {
        WelcomePanel wp = new WelcomePanel();
        JInternalFrame f = new JInternalFrame();
        this.tabsPane.insertTab("Welcome", null, wp, null, 0);
    }

    private void addDebugTab() {
        JButton ibtn = new JButton("Simulator input");
        ibtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OutputWriter w = new OutputWriter();
                ByteArrayOutputStream s = new ByteArrayOutputStream(5000);
                w.setOutWriter(s);
                OutputWriter.writeOutput(Main.getInputTemplate(), "");
                MainFrame.this.debugField.setText(s.toString());
            }
        });
        JButton dbtn = new JButton("Detector");
        dbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Writeing!");
                OutputWriter w = new OutputWriter();
                ByteArrayOutputStream s = new ByteArrayOutputStream(5000);
                w.setOutWriter(s);
                OutputWriter.writeOutput(Main.getDetectorTemplate(), "");
                MainFrame.this.debugField.setText(s.toString());
            }
        });
        JButton gbtn = new JButton("Geometric efficiency");
        gbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Writeing!");
                OutputWriter w = new OutputWriter();
                ByteArrayOutputStream s = new ByteArrayOutputStream(5000);
                w.setOutWriter(s);
                OutputWriter.writeOutput(Main.getGeometricEfficiencyTemplate(), "");
                MainFrame.this.debugField.setText(s.toString());
            }
        });
        JButton fbtn = new JButton("Manual fitting");
        fbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Writeing!");
                ByteArrayOutputStream s = new ByteArrayOutputStream(5000);
                Fitter fitter = MainFrame.this.fitPanel.buildFitter();
                fitter.setOutputStream(s);
                fitter.writeInputFiles("FitTarget.phd", "fitShape", "FitInput.xml");
                String str = s.toString();
                MainFrame.this.debugField.setText(str);
            }
        });
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(ibtn);
        p.add(dbtn);
        p.add(gbtn);
        p.add(fbtn);
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.add((Component)p, "North");
        this.debugField.setBackground(Color.white);
        this.debugPane = new JScrollPane(this.debugField);
        p2.add((Component)this.debugPane, "Center");
        this.debugPanel = p2;
        this.tabsPane.add("Inputs", p2);
        this.simulatorInputTabMenuItem.setSelected(true);
    }

    private void setupHelp() {
        Help.enableHelpKey(this.detectorFrame, "detector");
        Help.enableHelpKey(this.tabsPane, "Introduction");
        Help.enableHelpKey(this.detectorDesktop, "DetectorPage");
        Help.enableHelpKey(this.sourceDesktop, "SourcePage");
        Help.enableHelpKey(this.detectorFrame, "AlphaDetectorProperties");
        Help.enableHelpKey(this.nuclidesFrame, "RadionuclidesInTheSource");
        Help.enableHelpKey(this.radiationSourceFrame, "SourceProperties");
        Help.enableHelpKey(this.layersFrame, "AbsorbingLayers");
        Help.enableHelpKey(this.coincidenceFrame, "Coincidences");
        Help.enableHelpKey(this.backScatterFrame, "Backscattering");
        Help.enableHelpKey(this.paramsFrame, "SimulationOptions");
        Help.enableHelpKey(this.gecFrameI, "GeometricEfficiencyCalculation");
        Help.enableHelpKey(this.deadLayerMaterialCombobox, "detector.dead_layer_material");
        Help.enableHelpKey(this.lineEnergyRadioBtn, "source.line_energy");
        Help.enableHelpKey(this.nuclideRadioBtn, "source.nuclide_from_list");
        Help.enableHelpKey(this.nuclideComboBox, "source.nuclide_list");
        Help.enableHelpKey(this.addNuclideButton, "source.add_nuclide");
        Help.enableHelpKey(this.removeNuclideButton, "source.remove_nuclide");
        Help.enableHelpKey(this.nuclidesTable, "source.nuclides_selected");
        Help.enableHelpKey(this.homogenousSourceButton, "source.homogeneous_button");
        Help.enableHelpKey(this.radioactiveParticlesButton, "source.particles_button");
        Help.enableHelpKey(this.matrixSourceButton, "source.matrix_button");
        Help.enableHelpKey(this.sourcePropertiesTable1, "source.homogeneous_properties");
        Help.enableHelpKey(this.particlePropertiesTable1, "source.particle_properties");
        Help.enableHelpKey(this.particlePropertiesTable2, "source.matrix_source");
        Help.enableHelpKey(this.sourcePropertiesTable2, "source.matrix_source");
        Help.enableHelpKey(this.sourceMaterialElementsTable1, "source.homogeneous_materials");
        Help.enableHelpKey(this.sourceMaterialElementsTable2, "source.homogeneous_materials");
        Help.enableHelpKey(this.particleMaterialElementsTable1, "source.particle_materials");
        Help.enableHelpKey(this.particleMaterialElementsTable2, "source.particle_materials");
        Help.enableHelpKey(this.sphericalBtn, "source.spherical_particles");
        Help.enableHelpKey(this.ellipsoidalBtn, "source.ellipsoidal_particles");
        Help.enableHelpKey(this.surfaceLayerBtn, "source.surface_layer");
        Help.enableHelpKey(this.identicalSizeBtn, "source.uniform_particles");
        Help.enableHelpKey(this.lognormalSizeBtn, "source.lognormal_particles");
        Help.enableHelpKey(this.depositionAreaField, "source.many_particles");
        Help.enableHelpKey(this.manyParticlesBtn, "source.many_particles");
        Help.enableHelpKey(this.singleParticleBtn, "source.single_particle");
        Help.enableHelpKey(this.exponentialBtn, "source.exponential_depth");
        Help.enableHelpKey(this.uniformBtn, "source.uniform_depth");
        Help.enableHelpKey(this.noAbsLayersBtn, "layers.no_layers");
        Help.enableHelpKey(this.absLayersBtn, "layers.use_layers");
        Help.enableHelpKey(this.absLayersBtn, "layers.use_layers");
        Help.enableHelpKey(this.addLayerBtn, "layers.add_layer");
        Help.enableHelpKey(this.deleteLayerButton, "layers.delete_layer");
        Help.enableHelpKey(this.layersTable, "layers.layer_table");
        Help.enableHelpKey(this.layerMaterialPropertiesTable, "layers.properties");
        Help.enableHelpKey(this.layerMaterialElementsTable, "layers.material");
        Help.enableHelpKey(this.includeBackingplateCheckbox, "backingplate.include");
        Help.enableHelpKey(this.backingplateMaterialCombobox, "backingplate.material");
        Help.enableHelpKey(this.shieldingModelCombobox, "backingplate.shielding");
        Help.enableHelpKey(this.linearDepositionCheckbox, "backingplate.linear_depo");
        Help.enableHelpKey(this.parallelbeamCheckbox, "backingplate.parallel_beam");
        Help.enableHelpKey(this.coincidencesCheckbox, "coincidences.include_coincidences");
        Help.enableHelpKey(this.trackAlphaCheckBox, "coincidences.track_alpha");
    }

    private static void saveSettings() {
        try {
            FileOutputStream fos = new FileOutputStream("./lib/wins.prs");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            String lafclass = UIManager.getLookAndFeel().getClass().getName();
            oos.writeObject(lafclass);
            oos.writeObject(size);
            oos.writeObject(location);
            oos.writeObject(visible);
            oos.writeObject(minimized);
            oos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void loadSettings() {
        try {
            FileInputStream fis = new FileInputStream("./lib/wins.prs");
            ObjectInputStream ois = new ObjectInputStream(fis);
            String lafclass = (String)ois.readObject();
            size = (Dimension[])ois.readObject();
            location = (Point[])ois.readObject();
            visible = (boolean[])ois.readObject();
            minimized = (boolean[])ois.readObject();
            try {
                UIManager.setLookAndFeel(lafclass);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ois.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void dropCookie() {
        try {
            FileOutputStream fos = new FileOutputStream("./lib/cookie.prs");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeInt(1);
        }
        catch (Exception e) {
            Main.warnUser("Could not drop cookie.\n" + e.getMessage() + "\n Resolve this and restart.", true);
        }
    }

    public static boolean hasCoincidenceData(Nuclide n) {
        List l = n.getLines();
        for (int i = 0; i < l.size(); ++i) {
            Line line = (Line)l.get(i);
            String type = line.getLineType();
            if (!type.equalsIgnoreCase("e") && !type.equalsIgnoreCase("g")) continue;
            return true;
        }
        return false;
    }

    public static void removeCookie() {
        try {
            File f = new File("./lib/cookie.prs");
            f.delete();
        }
        catch (Exception e) {
            Main.warnUser("Could not resolve cookie.\n" + e.getMessage() + "\n Resolve this and restart.");
        }
    }

    public static boolean cookieExists() {
        try {
            File f = new File("./lib/cookie.prs");
            return f.exists();
        }
        catch (Exception e) {
            Main.warnUser("Could not resolve cookie.\n" + e.getMessage() + "\n Resolve this and restart.");
            return true;
        }
    }

    public void loadComponents() {
        int i;
        for (i = 0; i < this.layersTable.getRowCount(); ++i) {
            this.layersTable.setValueAt(null, 0, 0);
        }
        for (i = 0; i < this.nuclidesTable.getRowCount(); ++i) {
            this.nuclidesTable.setValueAt(null, 0, 0);
        }
        this.loadFields();
        this.loadCheckboxes();
        this.loadRadiobuttons();
        this.loadComboboxes();
        this.loadParticleTable();
        this.loadSourceTable();
        String s = (String)Main.getParameter("1029").getValue();
        String[] nucs = s.split("&");
        s = (String)Main.getParameter("1030").getValue();
        String[] libs = s.split("&");
        int ind = 0;
        for (int i2 = 0; i2 < nucs.length; i2 += 2) {
            if (ind < libs.length) {
                int n = libs[ind].length();
                Main.nuclideLibraryPath = libs[ind++].substring(1, n - 1);
                Main.readNuclides();
            }
            if (nucs.length > 1) {
                Main.getParameter("1011").setValue(new Integer(Integer.parseInt(nucs[i2 + 1])));
            }
            Main.getParameter("1029").setValue(nucs[i2]);
            this.loadNuclideTable();
        }
        this.nuclideLabel.setText(" Nuclide list (" + Main.nuclideLibraryPath + ")");
        this.initNuclidesCombobox();
        this.loadMaterialTables();
        this.loadPeaktailingTable();
        if (Main.getParameter("1003").getStringValue().equals("b") && (double)Main.getParameter("7").getFloatValue().floatValue() <= 1.0E-4) {
            this.sourceShelf.maximize(this.homogenousSourceDrawer);
            this.homogenousSourceButton.setSelected(true);
        } else if (Main.getParameter("1006").getStringValue().equals("n") && Main.getParameter("1606").getFloatValue().floatValue() <= 0.0f) {
            this.particleButtons();
            this.sourceShelf.maximize(this.radioactiveParticlesDrawer);
            this.radioactiveParticlesButton.setSelected(true);
        } else {
            this.matrixButtons();
            this.sourceShelf.maximize(this.matrixSourceDrawer);
            this.matrixSourceButton.setSelected(true);
        }
        if (this.lineEnergyRadioBtn.isSelected()) {
            this.jCheckBox1.setEnabled(false);
        } else if (this.getNumberOfItemsInTableCol(this.nuclidesTable, 0) > 1) {
            this.jCheckBox1.setEnabled(true);
        }
        this.loaded = true;
    }

    public void clearTable(JTable table, boolean removeRows) {
        boolean t = this.layerMod;
        this.layerMod = true;
        if (removeRows) {
            DefaultTableModel m = (DefaultTableModel)table.getModel();
            int r = table.getRowCount();
            for (int i = 0; i < r; ++i) {
                m.removeRow(0);
            }
        } else {
            int r = table.getRowCount();
            int c = table.getColumnCount();
            for (int i = 0; i < r; ++i) {
                for (int j = 0; j < c; ++j) {
                    table.setValueAt(null, i, j);
                }
            }
        }
        this.layerMod = t;
    }

    public String getNotes() {
        if (notesPanel != null) {
            return notesPanel.getText();
        }
        return null;
    }

    public void setNotes(String notes) {
        if (notesPanel != null) {
            notesPanel.setText(notes);
        }
    }

    public void clearComponents() {
        int cnt = this.nuclidesTable.getRowCount();
        for (int i = 0; i < cnt; ++i) {
            this.nuclidesTable.setValueAt(null, i, 0);
            this.nuclidesTable.setValueAt(null, i, 1);
        }
        this.clearTable(this.coincidenceNuclidesTable, true);
        this.coincidenceNuclideComboBox.removeAllItems();
        this.shieldingModelCombobox.removeAllItems();
        this.browseSimCoincidences.setSelected(true);
        this.enableCoincidenceDataBrowsing(true);
        this.clearTable(this.betaLinesTable, true);
        this.clearTable(this.gammaLinesTable, true);
        this.loaded = false;
        this.nuclideComboBox.removeAllItems();
        int r = this.layersTable.getRowCount();
        for (int i = 0; i < r; ++i) {
            this.layersTable.setValueAt(null, i, 0);
        }
    }

    private void getStatus(JInternalFrame f, int ind) {
        MainFrame.size[ind] = f.getSize();
        MainFrame.location[ind] = f.getLocation();
        MainFrame.visible[ind] = f.isVisible();
        MainFrame.minimized[ind] = f.isIcon();
    }

    private void setStatus(JInternalFrame f, int ind) {
        f.setSize(size[ind]);
        f.setLocation(location[ind]);
        f.setVisible(visible[ind]);
        try {
            f.setIcon(minimized[ind]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initInternalFrames() {
        GeometricEfficiencyFrame gec;
        Dimension d = this.getToolkit().getScreenSize();
        this.gecFrameI = new JInternalFrame();
        gecFrame = gec = new GeometricEfficiencyFrame();
        this.gecFrameI.getContentPane().add(gec.getContentPane());
        this.gecFrameI.setLocation(50, 50);
        this.gecFrameI.setTitle("Geometric efficiency calculation");
        this.gecFrameI.setSize(465, 236);
        this.gecFrameI.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/EpsilonParamsIcon.png")));
        this.gecFrameI.setIconifiable(true);
        gecFrame.removeCancelButton();
        gec.dispose();
        this.calculateDesktop.add(this.gecFrameI);
        this.gecFrameI.setVisible(true);
        if (visible == null) {
            this.detectorFrame.setLocation(20, 20);
            this.nuclidesFrame.setLocation((int)((float)d.width / 1.85f), (int)((float)d.height / 1.6f) + 10);
            this.paramsFrame.setLocation(30, (int)((float)d.height / 2.2f));
            this.coincidenceFrame.setLocation((int)((float)d.width / 2.1f), (int)((float)d.height / 6.2f));
            this.backScatterFrame.setLocation((int)((float)d.width / 2.3f), (int)((float)d.height / 2.6f));
            size = new Dimension[11];
            location = new Point[11];
            minimized = new boolean[11];
            visible = new boolean[11];
            MainFrame.size[8] = new Dimension(300, 300);
            MainFrame.size[9] = new Dimension(300, 300);
            MainFrame.size[10] = new Dimension(300, 300);
            MainFrame.location[8] = new Point(20, 20);
            MainFrame.location[9] = new Point(20, 20);
            MainFrame.location[10] = new Point(20, 20);
            this.getStatus(this.layersFrame, 0);
            this.getStatus(this.paramsFrame, 1);
            this.getStatus(this.coincidenceFrame, 2);
            this.getStatus(this.backScatterFrame, 3);
            this.getStatus(this.nuclidesFrame, 4);
            this.getStatus(this.detectorFrame, 5);
            this.getStatus(this.gecFrameI, 6);
            this.getStatus(this.radiationSourceFrame, 7);
        } else {
            this.setStatus(this.layersFrame, 0);
            this.setStatus(this.paramsFrame, 1);
            this.setStatus(this.coincidenceFrame, 2);
            this.setStatus(this.backScatterFrame, 3);
            this.setStatus(this.nuclidesFrame, 4);
            this.setStatus(this.detectorFrame, 5);
            this.setStatus(this.gecFrameI, 6);
            this.setStatus(this.radiationSourceFrame, 7);
        }
        try {
            if (visible[8]) {
                this.showNotesWindow();
                this.notesMenuItem.setSelected(true);
                if (minimized[8]) {
                    this.notesFrame.setIcon(true);
                    this.notesFrameIcon = true;
                }
                this.setStatus(this.notesFrame, 8);
            }
            if (visible[9]) {
                this.showSketchWindow();
                this.sketchWindowMenuItem.setSelected(true);
                if (minimized[9]) {
                    this.sketchFrame.setIcon(true);
                    this.sketchFrameIcon = true;
                }
                this.setStatus(this.sketchFrame, 9);
            }
            if (visible[10]) {
                this.showLogWindow();
                this.logWindowMenuItem.setSelected(true);
                if (minimized[10]) {
                    this.logFrame.setIcon(true);
                    this.logFrameIcon = true;
                }
                this.setStatus(this.logFrame, 10);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initNuclidePropertiesTable() {
        Object o = this.nuclideComboBox.getSelectedItem();
        Nuclide n = (Nuclide)o;
        this.loadTableWithNuclide(n);
    }

    private void initLayerTable() {
        this.layersTable.setSelectionMode(0);
        this.layersTable.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (!MainFrame.this.layersTable.isEnabled()) {
                    return;
                }
                if (MainFrame.this.objStr == null) {
                    return;
                }
                Point p = e.getPoint();
                int ind = MainFrame.this.layersTable.rowAtPoint(p);
                if (MainFrame.this.begin == -1) {
                    MainFrame.this.begin = ind;
                } else {
                    MainFrame.this.end = ind;
                }
                if (ind > 0 && MainFrame.this.layersTable.getValueAt(ind, 0) != null) {
                    Graphics g = MainFrame.this.layersTable.getGraphics();
                    g.setColor(Color.black);
                    int y = (ind + 1) * MainFrame.this.layersTable.getRowHeight();
                    g.fillRect(10, y, MainFrame.this.layersTable.getWidth() - 10, 2);
                    g.setColor(Color.gray);
                    g.drawString(MainFrame.this.objStr, 10, y - 5);
                }
            }
        });
        this.layersTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!MainFrame.this.layersTable.isEnabled()) {
                    return;
                }
                int row = MainFrame.this.layersTable.rowAtPoint(e.getPoint());
                MainFrame.this.objStr = (String)MainFrame.this.layersTable.getValueAt(row, 0);
                boolean t = MainFrame.this.loaded;
                MainFrame.this.loaded = false;
                if (MainFrame.this.objStr != null) {
                    MainFrame.this.layerToEditor(row);
                } else {
                    MainFrame.this.clearTable(MainFrame.this.layerMaterialElementsTable, true);
                    MainFrame.this.clearTable(MainFrame.this.layerMaterialPropertiesTable, false);
                }
                MainFrame.this.loaded = t;
            }

            public void mouseReleased(MouseEvent e) {
                if (!MainFrame.this.layersTable.isEnabled()) {
                    return;
                }
                MainFrame.this.layersTable.repaint();
                if (MainFrame.this.begin == -1 || MainFrame.this.begin == MainFrame.this.end) {
                    return;
                }
                MainFrame.this.layerMod = true;
                if (MainFrame.this.begin == -1 || MainFrame.this.end == -1 || MainFrame.this.layersTable.getValueAt(MainFrame.this.begin, 0) == null || MainFrame.this.layersTable.getValueAt(MainFrame.this.end, 0) == null) {
                    MainFrame.this.layersTable.setRowSelectionInterval(MainFrame.this.begin, MainFrame.this.begin);
                    MainFrame.this.layerMod = false;
                    MainFrame.this.begin = -1;
                    MainFrame.this.end = -1;
                    return;
                }
                int dir = 1;
                if (MainFrame.this.end - MainFrame.this.begin < 0) {
                    dir = -1;
                }
                boolean t = MainFrame.this.loaded;
                MainFrame.this.loaded = false;
                for (int i = 0; i < Math.abs(MainFrame.this.begin - MainFrame.this.end) + 1; ++i) {
                    MainFrame.this.layerToClipboard(MainFrame.this.begin, 0);
                    MainFrame.this.layerToClipboard(MainFrame.this.begin + dir, 1);
                    MainFrame.this.clipboardToLayer(MainFrame.this.begin, 1);
                    MainFrame.this.clipboardToLayer(MainFrame.this.begin + dir, 0);
                    MainFrame.this.begin += dir;
                }
                MainFrame.this.loaded = t;
                MainFrame.this.layersTable.setRowSelectionInterval(MainFrame.this.end, MainFrame.this.end);
                MainFrame.this.begin = -1;
                MainFrame.this.end = -1;
                MainFrame.this.loadLayerTable();
                MainFrame.this.layerMod = false;
            }
        });
    }

    private void initNuclidesCombobox() {
        boolean old = this.loadingCoincidenceData;
        this.loadingCoincidenceData = true;
        List nuclides = Main.getNuclides();
        Iterator iter = nuclides.iterator();
        File f = new File(Main.nuclideLibraryPath);
        this.nuclideLabel1.setText(" Coincidence data in " + f.getName());
        int numAdded = 0;
        while (iter.hasNext()) {
            Nuclide n = (Nuclide)iter.next();
            if (!n.getName().startsWith("BSC")) {
                this.nuclideComboBox.addItem(n);
            }
            if (!MainFrame.hasCoincidenceData(n) || n.getName().startsWith("BSC")) continue;
            this.coincidenceNuclideComboBox.addItem(n);
            ++numAdded;
        }
        this.coincidenceNuclideComboBox.setSelectedIndex(-1);
        if (numAdded == 0) {
            this.coincidenceNuclideComboBox.addItem("No coincidence data");
            this.enableCoincidenceCalc(false);
        } else {
            this.enableCoincidenceCalc(true);
        }
        this.nuclideComboBox.setSelectedIndex(this.nuclideComboBox.getItemCount() - 1);
        this.initNuclidePropertiesTable();
        this.loadingCoincidenceData = old;
    }

    private void initTable(JTable table) {
        table.getColumnModel().getColumn(0).setPreferredWidth(195);
        table.getColumnModel().getColumn(1).setPreferredWidth(52);
        table.getColumnModel().getColumn(2).setPreferredWidth(38);
        table.setRowHeight(table.getRowHeight() + 2);
        if (table == this.nuclidePropertiesTable) {
            table.getColumnModel().getColumn(0).setPreferredWidth(175);
            table.getColumnModel().getColumn(1).setPreferredWidth(72);
            table.getColumnModel().getColumn(2).setPreferredWidth(38);
        }
        table.setSelectionMode(0);
    }

    private void initTableListeners(JTable table) {
        table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                Parameter p;
                int row;
                boolean t;
                if (!MainFrame.this.loaded) {
                    return;
                }
                Object src = e.getSource();
                int type = e.getType();
                TableModel lmptm = MainFrame.this.layerMaterialPropertiesTable.getModel();
                if (src == lmptm) {
                    if (type == 0) {
                        MainFrame.this.loadLayerTable();
                    }
                }
                if (src != lmptm && MainFrame.this.loaded) {
                    if (e.getType() == 0 && MainFrame.this.sketchPanel != null) {
                        MainFrame.this.sketchPanel.refresh();
                    }
                }
                if (src == MainFrame.this.detectorPropertiesTable.getModel() || src == MainFrame.this.peakTailingPropertiesTable.getModel()) {
                    if (e.getType() == 0) {
                        MainFrame.this.touch(MainFrame.this.detectorFrame);
                    }
                }
                if (src == MainFrame.this.sourcePropertiesTable1.getModel()) {
                    t = MainFrame.this.loaded;
                    MainFrame.this.loaded = false;
                    if (e.getType() == 0) {
                        row = e.getFirstRow();
                        p = (Parameter)MainFrame.this.sourcePropertiesTable1.getValueAt(row, 1);
                        if (p.hashKey().equals("4")) {
                            if (p.getFloatValue().floatValue() != 0.0f) {
                                Main.getParameter("5").setValue(new Float(p.getFloatValue().floatValue()));
                                Main.getParameter("1606").setValue(new Float(p.getFloatValue().floatValue()));
                                Main.getParameter("side_dummy").setValue(new Float(p.getFloatValue().floatValue()));
                            } else if (Main.getParameter("5").getFloatValue().floatValue() == 0.0f) {
                                Main.warnUser("Side and central thickness shouldn't be 0 at the same time!", true);
                            }
                            MainFrame.this.sourcePropertiesTable1.repaint();
                        }
                        if (p.hashKey().equals("5")) {
                            if (p.getFloatValue().floatValue() == 0.0f && Main.getParameter("4").getFloatValue().floatValue() == 0.0f) {
                                Main.warnUser("Side and central thickness shouldn't be 0 at the same time!", true);
                            }
                            MainFrame.this.sourcePropertiesTable1.repaint();
                        }
                        if (p.hashKey().equals("1606")) {
                            Main.getParameter("5").setValue(new Float(p.getFloatValue().floatValue()));
                            Main.getParameter("4").setValue(new Float(p.getFloatValue().floatValue()));
                            MainFrame.this.sourcePropertiesTable2.repaint();
                        }
                    }
                    MainFrame.this.loaded = t;
                }
                if (src == MainFrame.this.sourcePropertiesTable2.getModel()) {
                    t = MainFrame.this.loaded;
                    MainFrame.this.loaded = false;
                    if (e.getType() == 0) {
                        row = e.getFirstRow();
                        p = (Parameter)MainFrame.this.sourcePropertiesTable2.getValueAt(row, 1);
                        if (p.hashKey().equals("1606")) {
                            Main.getParameter("5").setValue(new Float(p.getFloatValue().floatValue()));
                            Main.getParameter("4").setValue(new Float(p.getFloatValue().floatValue()));
                            Main.getParameter("side_dummy").setValue(new Float(p.getFloatValue().floatValue()));
                            MainFrame.this.sourcePropertiesTable2.repaint();
                        }
                        if (p.hashKey().equals("4")) {
                            if (p.getFloatValue().floatValue() != 0.0f) {
                                Main.getParameter("5").setValue(new Float(p.getFloatValue().floatValue()));
                                Main.getParameter("1606").setValue(new Float(p.getFloatValue().floatValue()));
                                Main.getParameter("side_dummy").setValue(new Float(p.getFloatValue().floatValue()));
                            } else if (Main.getParameter("5").getFloatValue().floatValue() == 0.0f) {
                                Main.warnUser("Side and central thickness shouldn't be 0 at the same time!", true);
                            }
                            MainFrame.this.sourcePropertiesTable1.repaint();
                        }
                        if (p.hashKey().equals("5")) {
                            if (p.getFloatValue().floatValue() == 0.0f && Main.getParameter("4").getFloatValue().floatValue() == 0.0f) {
                                Main.warnUser("Side and central thickness shouldn't be 0 at the same time!", true);
                            }
                            MainFrame.this.sourcePropertiesTable1.repaint();
                        }
                    }
                    MainFrame.this.loaded = t;
                }
                if (src == MainFrame.this.particleMaterialElementsTable1.getModel() || src == MainFrame.this.particleMaterialElementsTable2.getModel() || src == MainFrame.this.sourceMaterialElementsTable1.getModel() || src == MainFrame.this.sourceMaterialElementsTable2.getModel()) {
                    MainFrame.this.radiationSourceFrame.repaint();
                }
            }
        });
    }

    private void initMaterialTable(JTable table) {
        table.getColumnModel().getColumn(0).setPreferredWidth(145);
        table.getColumnModel().getColumn(1).setPreferredWidth(60);
        table.getColumnModel().getColumn(2).setPreferredWidth(40);
        table.setRowHeight(table.getRowHeight() + 2);
    }

    private void initElementTable(JTable table) {
        DefaultTableModel m = (DefaultTableModel)table.getModel();
        table.setRowHeight(26);
    }

    public void freeComponentsRun() {
        this.runMenuItem.setEnabled(true);
        this.addNuclideButton.setEnabled(true);
        this.removeNuclideButton.setEnabled(true);
        this.nuclidePropertiesTable.setEnabled(true);
    }

    public void preRun() {
        Main.log = Main.log + "\nSimulation started...";
        if (this.logPanel != null) {
            this.logPanel.setText(Main.getLog());
        }
    }

    public void postRun() {
        if (this.logPanel != null) {
            this.logPanel.setText(Main.getLog());
        }
        this.wait = false;
    }

    public void lockComponentsRun() {
        this.runMenuItem.setEnabled(false);
        this.addNuclideButton.setEnabled(false);
        this.removeNuclideButton.setEnabled(false);
        this.nuclidePropertiesTable.setEnabled(false);
    }

    public void freeComponentsGec() {
    }

    public void lockComponentsGec() {
    }

    private void untouch(JInternalFrame frame) {
        if (frame == this.detectorFrame) {
            this.saveDetector.setEnabled(false);
            this.detectorFrame.setTitle("Alpha detector");
        }
    }

    private void touch(JInternalFrame frame) {
        if (frame == this.detectorFrame) {
            this.saveDetector.setEnabled(true);
            this.detectorFrame.setTitle("Alpha detector (modified)");
        }
    }

    private void loadCheckboxes() {
        Parameter p = Main.getParameter("1020");
        this.linearDepositionCheckbox.setSelected(p.getIntegerValue() == 1);
        p = Main.getParameter("1019");
        this.parallelbeamCheckbox.setSelected(p.getIntegerValue() == 1);
        p = Main.getParameter("1507");
        p.setValue(this.parallelbeamCheckbox.isSelected() ? "1" : "0");
        p = Main.getParameter("1018");
        this.includeBackingplateCheckbox.setSelected(p.getStringValue().equals("y"));
        this.enableBackingplate(this.includeBackingplateCheckbox.isSelected());
        this.enableCoincidences(this.coincidencesCheckbox.isSelected());
        p = Main.getParameter("1016");
        this.coincidencesCheckbox.setSelected(p.getStringValue().equalsIgnoreCase("y"));
        this.enableCoincidences(this.coincidencesCheckbox.isSelected());
        p = Main.getParameter("1023");
        this.trackAlphaCheckBox.setSelected(p.getIntegerValue() == 1);
        p = Main.getParameter("1505");
        this.srcDetectorCheckBox.setSelected(p.getStringValue().equals("y"));
        p = Main.getParameter("1012");
        this.stragglingCheckBox.setSelected(p.getFloatValue().floatValue() > 0.0f);
    }

    private void loadFields() {
        Parameter p = Main.getParameter("1001");
        this.sddField.setValueAt(p, 0, 0);
        p = Main.getParameter("1005");
        this.energyBinField.setValueAt(p, 0, 0);
        p = Main.getParameter("1011");
        this.decaysField.setValueAt(p, 0, 0);
        p = Main.getParameter("1015");
        this.integrationStepField.setValueAt(p, 0, 0);
        p = Main.getParameter("1014");
        this.detectorField.setValueAt((String)p.getValue(), 0, 0);
        p = Main.getParameter("1026");
        this.detectorFilename.setValueAt(p.getValue().toString(), 0, 0);
        p = Main.getParameter("1116");
        this.coincidenceOutputFileField.setText(p.getValue().toString());
        p = Main.getParameter("1031");
        this.lineEnergyField.setValueAt(p, 0, 0);
        p = Main.getParameter("1");
        this.depositionAreaField.setValueAt(p, 0, 0);
        p = Main.getParameter("21");
        this.xPosField.setValueAt(p, 0, 0);
        p = Main.getParameter("22");
        this.yPosField.setValueAt(p, 0, 0);
        p = Main.getParameter("1030");
        String libName = p.getStringValue();
        libName = libName.substring(1, libName.length() - 1);
    }

    private void loadRadiobuttons() {
        String s = (String)Main.getParameter("1003").getValue();
        this.sphericalBtn.setSelected(s.equals("b"));
        this.sphericalBtn1.setSelected(s.equals("b"));
        this.ellipsoidalBtn.setSelected(s.equals("e"));
        this.ellipsoidalBtn1.setSelected(s.equals("e"));
        if (this.ellipsoidalBtn.isSelected()) {
            this.identicalSizeBtn.setEnabled(false);
            this.lognormalSizeBtn.setEnabled(false);
            this.sizeLabel.setEnabled(false);
        }
        if (this.ellipsoidalBtn1.isSelected()) {
            this.identicalSizeBtn1.setEnabled(false);
            this.lognormalSizeBtn1.setEnabled(false);
            this.sizeLabel1.setEnabled(false);
            this.exponentialBtn.setEnabled(false);
            this.uniformBtn.setEnabled(false);
            this.depthLabel.setEnabled(false);
        }
        if (this.sphericalBtn.isSelected()) {
            this.identicalSizeBtn.setEnabled(true);
            this.lognormalSizeBtn.setEnabled(true);
            this.sizeLabel.setEnabled(true);
        }
        if (this.sphericalBtn1.isSelected()) {
            this.identicalSizeBtn1.setEnabled(true);
            this.lognormalSizeBtn1.setEnabled(true);
            this.sizeLabel1.setEnabled(true);
            this.exponentialBtn.setEnabled(true);
            this.uniformBtn.setEnabled(true);
            this.depthLabel.setEnabled(true);
        }
        s = (String)Main.getParameter("1010").getValue();
        this.lognormalSizeBtn.setSelected(s.equals("y"));
        this.identicalSizeBtn.setSelected(s.equals("n"));
        this.lognormalSizeBtn1.setSelected(s.equals("y"));
        this.identicalSizeBtn1.setSelected(s.equals("n"));
        s = (String)Main.getParameter("1007").getValue();
        this.exponentialBtn.setSelected(s.equals("y"));
        this.uniformBtn.setSelected(s.equals("n"));
        s = (String)Main.getParameter("1009").getValue();
        this.manyParticlesBtn.setSelected(s.equals("y"));
        if (s.equals("y")) {
            this.depositionAreaField.setEnabled(true);
            this.depLabel.setEnabled(true);
            this.depLabel2.setEnabled(true);
            this.xPosField.setEnabled(false);
            this.yPosField.setEnabled(false);
            this.posLabel.setEnabled(false);
            this.posLabel1.setEnabled(false);
            this.posLabel2.setEnabled(false);
            this.posLabel3.setEnabled(false);
            this.posLabel4.setEnabled(false);
        }
        this.singleParticleBtn.setSelected(s.equals("n"));
        if (s.equals("n")) {
            this.depLabel.setEnabled(false);
            this.depLabel2.setEnabled(false);
            this.xPosField.setEnabled(true);
            this.yPosField.setEnabled(true);
            this.posLabel.setEnabled(true);
            this.posLabel1.setEnabled(true);
            this.posLabel2.setEnabled(true);
            this.posLabel3.setEnabled(true);
            this.posLabel4.setEnabled(true);
        }
        if (Main.getParameter("1006").getStringValue().equals("n")) {
            Main.getParameter("4").setValue(Main.getParameter("1606").getValue());
        } else {
            Main.getParameter("1606").setValue(Main.getParameter("4").getValue());
        }
        int numLayers = Main.getParameter("1008").getIntegerValue();
        if (numLayers == 0) {
            this.noAbsLayersBtn.setSelected(true);
            this.noAbsLayersBtnActionPerformed(null);
        } else {
            this.absLayersBtn.setSelected(true);
            this.absLayersBtnActionPerformed(null);
        }
    }

    private void loadPeaktailingTable() {
        if (Main.getParameter("151").getFloatValue().floatValue() > 0.0f) {
            this.loadTableWithParams("detector/peaktailing", this.peakTailingPropertiesTable, true);
        } else {
            this.loadTableWithParams((List)null, this.peakTailingPropertiesTable, true);
        }
    }

    private void loadNuclideTable() {
        String s = (String)Main.getParameter("1029").getValue();
        List l = Main.getNuclides();
        Iterator iter = l.iterator();
        Nuclide sel = null;
        Nuclide line = null;
        while (iter.hasNext() && sel == null && line == null) {
            Nuclide n = (Nuclide)iter.next();
            if (n.getName().regionMatches(false, 0, s, 1, s.length() - 2)) {
                sel = n;
            }
            if (!n.getName().startsWith("Line")) continue;
            line = n;
        }
        if (s.equalsIgnoreCase("'dummy'")) {
            this.lineEnergyField.setEnabled(true);
            this.nuclideComboBox.setEnabled(false);
            this.nuclidePropertiesTable.setEnabled(false);
            this.nuclidesTable.setEnabled(false);
            this.addNuclideButton.setEnabled(false);
            this.removeNuclideButton.setEnabled(false);
            this.mevLabel.setEnabled(true);
            this.decaysLabel.setEnabled(true);
            this.nuclideLabel.setEnabled(false);
            this.openLibrary.setEnabled(false);
            this.selectedNuclidesLabel.setEnabled(false);
            this.nuclidePropertiesLabel.setEnabled(false);
            this.lineEnergyRadioBtn.setSelected(true);
            this.nuclideRadioBtn.setSelected(false);
            this.linesTable.setEnabled(false);
            this.decaysField.setEnabled(true);
            this.nuclidesTable.getTableHeader().setForeground(Color.gray);
            this.nuclideComboBox.setSelectedItem(line);
            this.nuclidePropertiesTable.setValueAt(Main.getParameter("1031").getValue().toString(), 0, 1);
        } else {
            this.lineEnergyField.setEnabled(false);
            this.nuclideComboBox.setEnabled(true);
            this.nuclidePropertiesTable.setEnabled(true);
            this.nuclidesTable.setEnabled(true);
            this.addNuclideButton.setEnabled(true);
            this.removeNuclideButton.setEnabled(true);
            this.decaysField.setEnabled(false);
            this.decaysLabel.setEnabled(false);
            this.nuclideLabel.setEnabled(true);
            this.openLibrary.setEnabled(true);
            this.selectedNuclidesLabel.setEnabled(true);
            this.nuclidePropertiesLabel.setEnabled(true);
            this.nuclidesTable.getTableHeader().setForeground(Color.black);
            this.mevLabel.setEnabled(false);
            this.lineEnergyRadioBtn.setSelected(false);
            this.nuclideRadioBtn.setSelected(true);
            this.nuclideComboBox.setSelectedItem(sel);
            this.loadTableWithNuclide(sel);
            this.moveNuclideToSelection(sel);
            if (MainFrame.hasCoincidenceData(sel)) {
                this.addToCoincidenceNuclidesTable(sel);
            }
        }
    }

    private void moveNuclideToSelection(Nuclide n) {
        int freeRow = -1;
        if (n.getName().startsWith("Line")) {
            n.setName(n.getName() + " (" + (String)this.nuclidePropertiesTable.getValueAt(0, 1) + " MeV)");
            Parameter p = Main.getParameter("1031");
            Float val = new Float((String)this.nuclidePropertiesTable.getValueAt(0, 1));
            if (val.floatValue() > 0.0f) {
                p.setValue(val);
            }
            n.setName("Line energy (" + p.getValue() + " MeV)");
            this.nuclideComboBox.removeItem(n);
            Nuclide newLine = new Nuclide();
            newLine.setName("Line energy");
            this.nuclideComboBox.addItem(newLine);
            this.nuclideComboBox.setSelectedIndex(this.nuclideComboBox.getItemCount() - 1);
        }
        freeRow = -1;
        for (int i = 0; i < this.nuclidesTable.getRowCount() && freeRow == -1; ++i) {
            if (this.nuclidesTable.getValueAt(i, 0) instanceof Nuclide) continue;
            freeRow = i;
        }
        if (freeRow == -1) {
            freeRow = this.nuclidesTable.getRowCount();
            Object[] dat = new Object[]{null, null};
            ((DefaultTableModel)this.nuclidesTable.getModel()).addRow(dat);
            this.resizeTable(this.nuclidesTable);
        }
        this.nuclidesTable.getModel().setValueAt(n, freeRow, 0);
        Parameter p = Main.createParameter("decays" + freeRow);
        p.setValue(new Integer(Main.getParameter("1011").getIntegerValue()));
        p.setMinValue(new Integer(0));
        p.setDescription("Number of decays for " + n.getName());
        this.nuclidesTable.getModel().setValueAt(p, freeRow, 1);
    }

    private void resizeTable(JTable table) {
        int oh = (int)table.getPreferredSize().getHeight();
        int w = (int)table.getPreferredSize().getWidth();
        int h = table.getRowHeight() * table.getRowCount();
        table.setPreferredSize(new Dimension(w, h));
    }

    private void loadTableWithNuclide(Nuclide n) {
        int rows = this.nuclidePropertiesTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            ((DefaultTableModel)this.nuclidePropertiesTable.getModel()).removeRow(rows - i - 1);
        }
        if (n == null) {
            return;
        }
        if (n == null || n.getName() == null || !n.getName().startsWith("Line")) {
            DecimalFormat dec = new DecimalFormat();
            dec.applyPattern("0.###E0");
            float life = n.getHalflife().floatValue();
            this.rowData[0] = "Half life";
            this.rowData[1] = life > 100000.0f ? dec.format(n.getHalflife().floatValue()) : n.getHalflife();
            this.rowData[2] = n.getHalflifeUnit();
            ((DefaultTableModel)this.nuclidePropertiesTable.getModel()).addRow(this.rowData);
            this.rowData[0] = "Alpha branching";
            this.rowData[1] = n.getAlphaBranching();
            this.rowData[2] = "";
            ((DefaultTableModel)this.nuclidePropertiesTable.getModel()).addRow(this.rowData);
            List l = n.getLines();
            int rc = this.linesTable.getRowCount();
            for (int i = 0; i < rc; ++i) {
                ((DefaultTableModel)this.linesTable.getModel()).removeRow(0);
            }
            ArrayList<Line> tList = new ArrayList<Line>();
            for (int i = 0; i < l.size(); ++i) {
                Line line = (Line)l.get(i);
                if (!line.getLineType().equalsIgnoreCase("a")) continue;
                tList.add(line);
            }
            boolean num = false;
            Line[] lines = tList.toArray(new Line[tList.size()]);
            Arrays.sort(lines, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Line l1 = (Line)o1;
                    Line l2 = (Line)o2;
                    if (l1.getLineYield().floatValue() > l2.getLineYield().floatValue()) {
                        return -1;
                    }
                    return 1;
                }
            });
            for (int i = 0; i < lines.length; ++i) {
                Line line = lines[i];
                if (!line.getLineType().equalsIgnoreCase("a")) continue;
                float yield = (float)((int)(line.getLineYield().floatValue() * 100000.0f)) / 1000.0f;
                String yieldstr = "";
                yieldstr = yield == 0.0f ? "< 0.001 %" : (float)((int)(line.getLineYield().floatValue() * 100000.0f)) / 1000.0f + "%";
                Object[] rowData = new Object[]{(float)((int)(line.getLineEnergy().floatValue() * 10.0f)) / 10000.0f + " MeV", yieldstr};
                ((DefaultTableModel)this.linesTable.getModel()).addRow(rowData);
            }
            this.resizeTable(this.linesTable);
        }
    }

    private void loadComboboxes() {
        this.shieldingModelCombobox.addItem("Nigam");
        this.shieldingModelCombobox.addItem("Chaoi");
        this.shieldingModelCombobox.addItem("Moliere");
        int index = (Integer)Main.getParameter("1022").getValue() - 1;
        this.shieldingModelCombobox.setSelectedIndex(index);
        List l = Main.getElements();
        Element selB = null;
        Element selD = null;
        Parameter p = Main.getParameter("1902+0");
        int bz = p.getIntegerValue();
        p = Main.getParameter("1036");
        p.setLocked(true);
        int dz = p.getIntegerValue();
        for (int i = 0; i < l.size(); ++i) {
            Element e = (Element)l.get(i);
            if (e.getZ() == bz) {
                selB = e;
            }
            if (e.getZ() == dz) {
                selD = e;
            }
            this.deadLayerMaterialCombobox.addItem(e);
            this.backingplateMaterialCombobox.addItem(e);
        }
        this.deadLayerMaterialCombobox.setSelectedItem(selD);
        this.backingplateMaterialCombobox.setSelectedItem(selB);
        this.nuclideComboBox.setSelectedItem(null);
        this.initBackingplateMaterialTable();
    }

    private void initBackingplateMaterialTable() {
        Parameter dens = Main.getParameter("1901");
        this.backingplateMaterialPropertiesTable1.setValueAt(dens, 0, 0);
        this.backingplateMaterialPropertiesTable1.setValueAt(dens, 0, 1);
        this.backingplateMaterialPropertiesTable1.setValueAt(dens, 0, 2);
        Parameter t = Main.getParameter("1906");
        this.backingplateMaterialPropertiesTable1.setValueAt(t, 1, 0);
        this.backingplateMaterialPropertiesTable1.setValueAt(t, 1, 1);
        this.backingplateMaterialPropertiesTable1.setValueAt(t, 1, 2);
    }

    private void materialToTable(JTable table, JComboBox box, boolean userSet) {
        Element m = (Element)box.getSelectedItem();
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        model.setValueAt("Atomic number (Z)", 0, 0);
        Parameter pA = null;
        Parameter pZ = null;
        if (table == this.backingplateMaterialPropertiesTable) {
            pA = Main.getParameter("1903+0");
            pZ = Main.getParameter("1902+0");
            Main.getParameter("1904+0").setValue("1.0");
            int z = pZ.getIntegerValue();
            if (z > 0) {
                Element e = Main.getElement(z);
                Parameter dens = Main.getParameter("1901");
                dens.setValue(new Float(e.getDensity()));
                this.backingplateMaterialPropertiesTable1.repaint();
            }
        } else if (table == this.deadLayerMaterialPropertiesTable) {
            pA = Main.getParameter("1037");
            pZ = Main.getParameter("1036");
        }
        model.setValueAt("Mass number (A)", 1, 0);
        if (userSet) {
            pA.setValue(new Integer(Math.round(m.getA())));
            pZ.setValue(m.getZ());
        }
        model.setValueAt(pZ, 0, 1);
        model.setValueAt(pA, 1, 1);
    }

    private void parameterToTable(String hash, JTable table, int row) {
        Parameter p = Main.getParameter(hash);
        this.parameterToTable(p, table, row);
    }

    private void parameterToTable(Parameter p, JTable table, int row) {
        table.setValueAt(p, row, 0);
        table.setValueAt(p, row, 1);
        table.setValueAt(p, row, 2);
    }

    private void loadMaterialPropertiesTable(JTable table, String densHash, String thicknHash, String thickFluctHash) {
        if (densHash != null) {
            this.parameterToTable(densHash, table, 0);
        }
        if (thicknHash != null) {
            this.parameterToTable(thicknHash, table, 1);
        }
        if (thickFluctHash != null) {
            this.parameterToTable(thickFluctHash, table, 2);
        }
    }

    private void loadMaterialElementsTable(JTable table, String numElemsHash, int elemBase) {
        DefaultTableModel m = (DefaultTableModel)table.getModel();
        int rows = table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            m.removeRow(0);
        }
        Parameter p = Main.getParameter(numElemsHash);
        int numElems = (Integer)p.getValue();
        int rowc = 0;
        for (int i = 0; i < numElems; ++i) {
            String zkey = "" + elemBase;
            String akey = "" + (elemBase + 1);
            String fkey = "" + (elemBase + 2);
            zkey = zkey + "+" + i;
            akey = akey + "+" + i;
            fkey = fkey + "+" + i;
            Parameter z = Main.getParameter(zkey);
            Parameter a = Main.getParameter(akey);
            Parameter f = Main.getParameter(fkey);
            Element e = new Element();
            e.setZ((Integer)z.getValue());
            e.setA(new Integer((Integer)a.getValue()));
            Vector<Object> al = new Vector<Object>();
            al.add(e);
            al.add(f);
            Object[] row = new Object[]{al};
            m.addRow(row);
            ++rowc;
        }
        this.resizeTable(table);
        table.repaint();
    }

    private void loadLayerMaterialElementsTable(int layer) {
        if (this.layersTable.getSelectedRow() == -1) {
            return;
        }
        DefaultTableModel m = (DefaultTableModel)this.layerMaterialElementsTable.getModel();
        int rows = this.layerMaterialElementsTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            m.removeRow(0);
        }
        Parameter p = MainFrame.getLayerParam("1510", layer);
        int numElems = (Integer)p.getValue();
        int rowc = 0;
        for (int i = 0; i < numElems; ++i) {
            Parameter z = MainFrame.getLayerElementParam("1802", layer, i);
            Parameter a = MainFrame.getLayerElementParam("1803", layer, i);
            Parameter f = MainFrame.getLayerElementParam("1804", layer, i);
            Element e = new Element();
            e.setZ((Integer)z.getValue());
            e.setA(new Integer((Integer)a.getValue()));
            Vector<Object> al = new Vector<Object>();
            al.add(e);
            al.add(f);
            Object[] row = new Object[]{al};
            m.addRow(row);
            ++rowc;
        }
        this.resizeTable(this.layerMaterialElementsTable);
        this.layerMaterialElementsTable.repaint();
    }

    private void setLayerElementParamValue(String key, int layer, int elem, Parameter value) {
        String hash = key;
        hash = hash + "+" + layer;
        hash = hash + "+" + elem;
        Main.putParameter(hash, value);
    }

    public static Parameter getLayerElementParam(String key, int layer, int elem) {
        String hash = key;
        hash = hash + "+" + layer;
        hash = hash + "+" + elem;
        return Main.getParameter(hash);
    }

    public static Parameter getLayerParam(String key, int layer) {
        String hash = key;
        hash = hash + "+" + layer;
        return Main.getParameter(hash);
    }

    private static void setLayerParamValue(String key, int layer, Object value) {
        String hash = key;
        hash = hash + "+" + layer;
        Parameter p = Main.getParameter(hash);
        p.setValue(value);
    }

    public static List getLayerElementParams(int layer) {
        Parameter elems = MainFrame.getLayerParam("1510", layer);
        int numElems = (Integer)elems.getValue();
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (int j = 0; j < numElems; ++j) {
            Parameter z = MainFrame.getLayerElementParam("1802", layer, j);
            Parameter a = MainFrame.getLayerElementParam("1803", layer, j);
            Parameter f = MainFrame.getLayerElementParam("1804", layer, j);
            list.add(z);
            list.add(a);
            list.add(f);
        }
        return list;
    }

    private void loadLayerTable() {
        boolean t = this.loaded;
        this.loaded = false;
        Parameter p = Main.getParameter("1008");
        ArrayList<Parameter> l = new ArrayList<Parameter>();
        int numLayers = (Integer)p.getValue();
        for (int i = 0; i < numLayers; ++i) {
            l.clear();
            Parameter density = MainFrame.getLayerParam("1801", i);
            Parameter thickness = MainFrame.getLayerParam("1805", i);
            Parameter fluct = MainFrame.getLayerParam("1806", i);
            String name = " " + thickness.getValue().toString() + " " + thickness.getUnit().toString() + " of (";
            Parameter elems = MainFrame.getLayerParam("1510", i);
            int numElems = (Integer)elems.getValue();
            l.add(density);
            l.add(elems);
            for (int j = 0; j < numElems; ++j) {
                if (j != 0) {
                    name = name + "+";
                }
                Element e = new Element();
                Parameter z = MainFrame.getLayerElementParam("1802", i, j);
                Parameter a = MainFrame.getLayerElementParam("1803", i, j);
                Parameter f = MainFrame.getLayerElementParam("1804", i, j);
                l.add(z);
                l.add(a);
                l.add(f);
                name = name + Element.determineAbbreviation((Integer)z.getValue());
            }
            name = name + ")";
            String mname = this.ed.getMixtureName(l);
            if (mname != null) {
                name = " " + thickness.getValue().toString() + " " + thickness.getUnit().toString() + " of " + mname;
            }
            if (i == numLayers - 1) {
                this.loaded = true;
            }
            this.layersTable.setValueAt(name, i, 0);
            this.loaded = false;
        }
        this.loaded = t;
    }

    private void loadParticleTable() {
        if (this.sphericalBtn.isSelected() && !this.lognormalSizeBtn.isSelected()) {
            this.loadTableWithParams("particles/spherical", this.particlePropertiesTable1, true);
            this.loadTableWithParams("particles/spherical", this.particlePropertiesTable2, true);
        } else {
            this.loadTableWithParams("particles/ellipsoidal", this.particlePropertiesTable1, true);
            this.loadTableWithParams("particles/ellipsoidal", this.particlePropertiesTable2, true);
        }
        if (this.lognormalSizeBtn.isSelected()) {
            this.loadTableWithParams("particles/lognormalsize", this.particlePropertiesTable1, true);
            this.loadTableWithParams("particles/lognormalsize", this.particlePropertiesTable2, true);
        }
        if (this.singleParticleBtn.isSelected()) {
            this.loadTableWithParams("particles/singleparticle", this.particlePropertiesTable1, false);
        }
        if (this.exponentialBtn.isSelected()) {
            this.loadTableWithParams("source/exponentialdepth", this.particlePropertiesTable2, false);
        }
    }

    private void loadSourceTable() {
        this.loadTableWithParams("source/convex", this.sourcePropertiesTable1, true);
        this.loadTableWithParams("source/convex", this.sourcePropertiesTable2, true);
    }

    public void loadMaterialTables() {
        this.loadMaterialElementsTable(this.sourceMaterialElementsTable1, "1508", 1602);
        this.loadMaterialElementsTable(this.sourceMaterialElementsTable2, "1508", 1602);
        this.loadMaterialElementsTable(this.particleMaterialElementsTable1, "1509", 1702);
        this.loadMaterialElementsTable(this.particleMaterialElementsTable2, "1509", 1702);
        this.loadLayerTable();
        if (this.loaded) {
            this.loadLayerMaterialElementsTable(this.layersTable.getSelectedRow());
        }
        this.materialToTable(this.deadLayerMaterialPropertiesTable, this.deadLayerMaterialCombobox, false);
        this.materialToTable(this.backingplateMaterialPropertiesTable, this.backingplateMaterialCombobox, false);
    }

    private void loadTableWithParams(List params, JTable table, boolean clear) {
        int i;
        int row = 0;
        int rows = table.getRowCount();
        if (clear) {
            for (i = 0; i < rows; ++i) {
                ((DefaultTableModel)table.getModel()).removeRow(0);
            }
        } else {
            for (i = 0; i < rows; ++i) {
                if (table.getValueAt(rows - i - 1, 0) != null) continue;
                ((DefaultTableModel)table.getModel()).removeRow(rows - i - 1);
            }
        }
        rows = table.getRowCount();
        if (params != null) {
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                Parameter param = (Parameter)iter.next();
                this.rowData[0] = param;
                this.rowData[1] = param;
                this.rowData[2] = param;
                ((DefaultTableModel)table.getModel()).addRow(this.rowData);
                ++row;
            }
        }
        this.rowData[0] = null;
        this.rowData[1] = null;
        this.rowData[2] = null;
    }

    private void loadTableWithParams(String paramset, JTable table, boolean clear) {
        this.loadTableWithParams(this.getParamSet(paramset), table, clear);
    }

    private List getParamSet(String set) {
        return Main.getParamList(set);
    }

    public void plot(List list, String name, boolean popup) {
        if (popup) {
            if (this.plotPanel == null) {
                this.addPlotTab();
            } else {
                this.tabsPane.setSelectedComponent(this.plotPanel);
            }
        }
        XYGraph graph = new XYGraph(true);
        Iterator iter = list.iterator();
        float[] X = (float[])iter.next();
        float[] Y = (float[])iter.next();
        graph.setX(X);
        graph.setY(Y);
        if (this.x == null) {
            this.x = new float[X.length];
            this.y = new float[Y.length];
            System.arraycopy(X, 0, this.x, 0, X.length);
            System.arraycopy(Y, 0, this.y, 0, Y.length);
        } else {
            if (X.length > this.x.length) {
                float[] xn = new float[X.length];
                float[] yn = new float[Y.length];
                System.arraycopy(X, 0, xn, 0, X.length);
                System.arraycopy(this.y, 0, yn, 0, this.y.length);
                this.x = xn;
                this.y = yn;
            }
            for (int i = 0; i < Y.length; ++i) {
                int n = i;
                this.y[n] = this.y[n] + Y[i];
            }
        }
        Nuclide n = null;
        Object o = this.nuclidesTable.getValueAt(0, 0);
        if (o != null && o instanceof Nuclide) {
            n = (Nuclide)o;
        }
        if (n != null && name == null) {
            name = n.getName();
        }
        graph.setTitle(name);
        if (!this.sumOnly || !this.jCheckBox1.isEnabled() || this.getNumberOfItemsInTableCol(this.nuclidesTable, 0) == 1) {
            if (popup) {
                this.plotPanel.addGraph(graph);
                this.plotPanel.repaint();
                this.sumPlot = true;
            } else {
                this.sumPlot = false;
            }
        }
        this.sumPlot = popup;
        if (this.fitPanel != null) {
            this.fitPanel.addGraph(graph, false);
        }
    }

    public void plotSum() {
        if (!this.sumPlot) {
            return;
        }
        XYGraph graph = new XYGraph(true);
        graph.setX(this.x);
        graph.setY(this.y);
        graph.setTitle("Sum");
        this.plotPanel.addGraph(graph);
        if (this.fitPanel != null) {
            this.fitPanel.addGraph(graph, false);
        }
        this.plotPanel.repaint();
        if (this.fitPanel != null) {
            this.fitPanel.repaint();
        }
    }

    public void clearSum() {
        this.sum = null;
        this.x = null;
        this.y = null;
        System.gc();
    }

    public void setPage(Component c) {
        this.tabsPane.setSelectedComponent(c);
    }

    public void setPage(int i) {
        this.tabsPane.setSelectedIndex(i);
    }

    private void addPlotTab() {
        if (this.plotPanel == null) {
            this.plotPanel = new PlotPanel();
            this.plotPanel.setAxisTitles("Energy (MeV)", "Counts");
            if (Main.aasi_fit) {
                this.fitPanel = new FitPanel();
                this.fitPanel.setAxisTitles("x", "y");
            }
        }
        this.tabsPane.addTab("Simulation plot", this.plotPanel);
        this.plotTabMenuItem.setSelected(true);
        if (Main.aasi_fit) {
            JDesktopPane p = new JDesktopPane();
            p.add(this.fitPanel.getPlotFrame());
            this.tabsPane.addTab("Fitting", this.fitPanel);
            this.tabsPane.addTab("Fitting Plot", p);
            this.tabsPane.setSelectedIndex(this.tabsPane.getTabCount() - 1);
            this.tabsPane.setEnabledAt(6, false);
        }
    }

    private int getNumberOfItemsInTableCol(JTable tab, int col) {
        int items = 0;
        for (int i = 0; i < tab.getRowCount(); ++i) {
            if (tab.getValueAt(i, col) == null) continue;
            ++items;
        }
        return items;
    }

    private int firstUnusedRow(JTable table, int col) {
        int rows = table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            Object o = table.getValueAt(i, col);
            if (o != null) continue;
            return i;
        }
        return -1;
    }

    private Parameter createLayerParam(String name, String hash, Object val, Object min, String desc, String unit) {
        Parameter p = new Parameter();
        p.setName(name);
        p.setHashKey(hash);
        p.setValue(val);
        p.setMinValue(min);
        p.setDescription(desc);
        p.setUnit(unit);
        Main.putParameter(hash, p);
        return p;
    }

    private void layerToClipboard(int layer, int clip) {
        List l = MainFrame.getLayerElementParams(layer);
        Parameter numElems = MainFrame.getLayerParam("1510", layer);
        Parameter d = MainFrame.getLayerParam("1801", layer);
        Parameter t = MainFrame.getLayerParam("1805", layer);
        Parameter tf = MainFrame.getLayerParam("1806", layer);
        Main.putParameter("clipe+" + clip, numElems.clone());
        Main.putParameter("clipd+" + clip, d.clone());
        Main.putParameter("clipt+" + clip, t.clone());
        Main.putParameter("cliptf+" + clip, tf.clone());
        boolean ind = false;
        for (int i = 0; i < numElems.getIntegerValue(); ++i) {
            Parameter z = Main.getParameter("1802+" + layer + "+" + i);
            Parameter a = Main.getParameter("1803+" + layer + "+" + i);
            Parameter f = Main.getParameter("1804+" + layer + "+" + i);
            String zkey = "clipz" + clip + "+" + i;
            String akey = "clipa" + clip + "+" + i;
            String fkey = "clipf" + clip + "+" + i;
            Main.putParameter(zkey, z.clone());
            Main.putParameter(akey, a.clone());
            Main.putParameter(fkey, f.clone());
        }
    }

    private void clipboardToLayer(int layer, int clip) {
        Parameter numElems = Main.getParameter("clipe+" + clip);
        Parameter d = Main.getParameter("clipd+" + clip);
        Parameter t = Main.getParameter("clipt+" + clip);
        Parameter tf = Main.getParameter("cliptf+" + clip);
        Main.putParameter("1801+" + layer, d);
        Main.putParameter("1805+" + layer, t);
        Main.putParameter("1806+" + layer, tf);
        Main.putParameter("1510+" + layer, numElems);
        for (int i = 0; i < numElems.getIntegerValue(); ++i) {
            String zkey = "clipz" + clip + "+" + i;
            String akey = "clipa" + clip + "+" + i;
            String fkey = "clipf" + clip + "+" + i;
            Parameter z = Main.getParameter(zkey);
            Parameter a = Main.getParameter(akey);
            Parameter f = Main.getParameter(fkey);
            Main.putParameter("1802+" + layer + "+" + i, z);
            Main.putParameter("1803+" + layer + "+" + i, a);
            Main.putParameter("1804+" + layer + "+" + i, f);
        }
    }

    private void addLayer() {
        int layer = this.firstUnusedRow(this.layersTable, 0);
        Parameter p = Main.getParameter("1008");
        p.setValue(new Integer(p.getIntegerValue() + 1));
        this.layerMaterialPropertiesTable.setEnabled(true);
        Float fdens = new Float(0.0013);
        Float ft = new Float(1.0f);
        Float ftf = new Float(0.0f);
        Float min = new Float(0.0f);
        Integer imin = new Integer(0);
        Integer inum = new Integer(1);
        Parameter dens = this.createLayerParam("Density", "1801+" + layer, fdens, min, "Density of the layer material.", "g/cm\u00b3");
        dens.setMaxValue(new Float(23.0f));
        Parameter t = this.createLayerParam("Thickness", "1805+" + layer, ft, min, "Thickness of the layer material.", "\u00b5m");
        Parameter tf = this.createLayerParam("Thickness fluctuations", "1806+" + layer, ftf, min, "Thickness fluctuations in the layer material.", "\u00b5m");
        tf.setMinBoundInclusive(true);
        Parameter numElems = this.createLayerParam("numElems", "1510+" + layer, inum, imin, "Number of elements in the layer material.", "\u00b5m");
        Float fmin = new Float(0.0f);
        for (int i = 0; i < numElems.getIntegerValue(); ++i) {
            Integer iz = new Integer(1);
            Parameter z = this.createLayerParam("Atomic number", "1802+" + layer + "+" + i, iz, imin, "Atomic number of the element.", "");
            Integer ia = new Integer(1);
            Parameter a = this.createLayerParam("Atomic weight", "1803+" + layer + "+" + i, ia, imin, "Atomic weight of the element.", "");
            Float ff = new Float(1.0f);
            Parameter f = this.createLayerParam("Atomic fraction", "1804+" + layer + "+" + i, ff, fmin, "Atomic fraction of the element.", "");
        }
        this.loadLayerTable();
        this.layerToEditor(layer);
    }

    private void layerToEditor(int row) {
        String fkey;
        String akey;
        String zkey;
        Parameter f;
        Parameter a;
        Parameter z;
        int layer = row;
        Object o = this.layersTable.getValueAt(layer, 0);
        if (o == null) {
            return;
        }
        this.layerMaterialPropertiesTable.setEnabled(true);
        this.loadMaterialPropertiesTable(this.layerMaterialPropertiesTable, "1801+" + layer, "1805+" + layer, "1806+" + layer);
        this.loadLayerMaterialElementsTable(layer);
        this.layerMaterialElementsTable.setEnabled(true);
        List l = MainFrame.getLayerElementParams(layer);
        Parameter numElems = MainFrame.getLayerParam("1510", layer);
        Parameter d = MainFrame.getLayerParam("1801", layer);
        Parameter t = MainFrame.getLayerParam("1805", layer);
        Parameter tf = MainFrame.getLayerParam("1806", layer);
        Main.putParameter("LayerEditNumElems", numElems);
        Main.putParameter("5999", d);
        Main.putParameter("6004", t);
        Main.putParameter("6005", tf);
        int ind = 0;
        int i = 0;
        while (ind < l.size()) {
            z = (Parameter)l.get(ind++);
            a = (Parameter)l.get(ind++);
            f = (Parameter)l.get(ind++);
            zkey = "6000+" + i;
            akey = "6001+" + i;
            fkey = "6002+" + i;
            Main.putParameter(zkey, z);
            Main.putParameter(akey, a);
            Main.putParameter(fkey, f);
            ++i;
        }
        for (i = l.size() / 3; i < 10; ++i) {
            z = Main.cloneParameter("6000+0", "1802+" + layer + "+" + i);
            a = Main.cloneParameter("6001+0", "1803+" + layer + "+" + i);
            f = Main.cloneParameter("6002+0", "1804+" + layer + "+" + i);
            zkey = "6000+" + i;
            akey = "6001+" + i;
            fkey = "6002+" + i;
            Main.putParameter(zkey, z);
            Main.putParameter(akey, a);
            Main.putParameter(fkey, f);
        }
    }

    private void fixLayersDown(int row) {
        Parameter p = Main.getParameter("1008");
        int numLayers = (Integer)p.getValue();
        int offs = 0;
        for (int i = 0; i < numLayers; ++i) {
            if (i == row) {
                ++offs;
                continue;
            }
            Parameter density = MainFrame.getLayerParam("1801", i);
            Parameter thickness = MainFrame.getLayerParam("1805", i);
            Parameter fluct = MainFrame.getLayerParam("1806", i);
            Parameter elems = MainFrame.getLayerParam("1510", i);
            MainFrame.setLayerParamValue("1801", i - offs, density.getValue());
            MainFrame.setLayerParamValue("1805", i - offs, thickness.getValue());
            MainFrame.setLayerParamValue("1806", i - offs, fluct.getValue());
            MainFrame.setLayerParamValue("1510", i - offs, elems.getValue());
            int numElems = (Integer)elems.getValue();
            for (int j = 0; j < numElems; ++j) {
                Parameter z = MainFrame.getLayerElementParam("1802", i, j);
                Parameter a = MainFrame.getLayerElementParam("1803", i, j);
                Parameter f = MainFrame.getLayerElementParam("1804", i, j);
                this.setLayerElementParamValue("1802", i - offs, j, z);
                this.setLayerElementParamValue("1803", i - offs, j, a);
                this.setLayerElementParamValue("1804", i - offs, j, f);
            }
        }
    }

    private void showHelpWindow(String helpFile, String title, Component comp) {
        if (this.helpFrame == null) {
            this.helpFrame = new JInternalFrame();
            this.helpFrame.setClosable(true);
            this.helpFrame.setResizable(true);
            this.helpFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/MainIcon.png")));
            this.helpFrame.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosing(InternalFrameEvent e) {
                    MainFrame.this.helpFrame.dispose();
                }
            });
        }
        this.helpFrame.setTitle(title);
        this.helpFrame.setSize(400, 400);
        this.helpFrame.setLocation(comp.getX() + comp.getWidth() / 2 - this.helpFrame.getWidth() / 2, comp.getY() + comp.getHeight() / 2 - this.helpFrame.getHeight() / 2);
        this.helpFrame.setVisible(true);
        this.current.add((Component)this.helpFrame, -1);
    }

    public void showNotesWindow() {
        if (notesPanel != null) {
            return;
        }
        this.notesFrame = new JInternalFrame();
        this.notesMenuItem.setSelected(true);
        this.notesFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                MainFrame.this.notesMenuItem.setSelected(false);
                MainFrame.this.getStatus(MainFrame.this.notesFrame, 8);
                notesWindowX = MainFrame.this.notesFrame.getX();
                notesWindowY = MainFrame.this.notesFrame.getY();
                notesWindowW = MainFrame.this.notesFrame.getWidth();
                notesWindowH = MainFrame.this.notesFrame.getHeight();
                Main.notes = notesPanel.getText();
                MainFrame.this.notesFrame.dispose();
                MainFrame.this.notesFrame = null;
                notesPanel = null;
            }
        });
        this.notesFrame.setTitle("Notes window");
        this.notesFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/NotesIcon.png")));
        this.notesFrame.setLocation(location[8]);
        this.notesFrame.setResizable(true);
        this.notesFrame.setIconifiable(true);
        notesPanel = new LogPanel(false);
        notesPanel.setEditable(true);
        notesPanel.setWordWrap(true);
        notesPanel.setScrollOnSet(true);
        this.notesFrame.getContentPane().add((Component)notesPanel, "Center");
        this.notesFrame.setSize(size[8]);
        this.notesFrame.setClosable(true);
        if (this.current != null) {
            this.current.add(this.notesFrame);
        }
        notesPanel.setText(Main.getNotes());
        this.notesFrame.setVisible(true);
    }

    private void showLogWindow() {
        this.logFrame = new JInternalFrame();
        this.logFrame.setLocation(location[10]);
        this.logFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                MainFrame.this.logWindowMenuItem.setSelected(false);
                MainFrame.this.getStatus(MainFrame.this.logFrame, 10);
                logWindowX = MainFrame.this.logFrame.getX();
                logWindowY = MainFrame.this.logFrame.getY();
                logWindowW = MainFrame.this.logFrame.getWidth();
                logWindowH = MainFrame.this.logFrame.getHeight();
                MainFrame.this.logFrame.dispose();
                MainFrame.this.logFrame = null;
                MainFrame.this.logPanel = null;
            }
        });
        this.logFrame.setTitle("Log window");
        this.logFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/LogIcon.png")));
        this.logPanel = new LogPanel(true);
        this.logPanel.setEditable(true);
        this.logFrame.setIconifiable(true);
        this.logFrame.setResizable(true);
        this.logFrame.getContentPane().add((Component)this.logPanel, "Center");
        this.logFrame.setSize(size[10]);
        this.logFrame.setClosable(true);
        if (this.current != null) {
            this.current.add(this.logFrame);
        }
        this.logPanel.setText(Main.getLog());
        this.logFrame.setVisible(true);
    }

    private void showSketchWindow() {
        this.sketchFrame = new JInternalFrame();
        this.sketchFrame.setLocation(location[9]);
        this.sketchPanel = new SketchPanel();
        this.sketchPanel.setPreferredSize(new Dimension(300, 300));
        this.sketchFrame.getContentPane().add((Component)this.sketchPanel, "Center");
        this.sketchFrame.setSize(size[9]);
        this.sketchFrame.setClosable(true);
        this.sketchFrame.setResizable(true);
        this.sketchFrame.setIconifiable(true);
        this.sketchFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/SketchIcon.png")));
        this.sketchFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                MainFrame.this.sketchWindowMenuItem.setSelected(false);
                MainFrame.this.getStatus(MainFrame.this.sketchFrame, 9);
                sketchWindowX = MainFrame.this.sketchFrame.getX();
                sketchWindowY = MainFrame.this.sketchFrame.getY();
                sketchWindowW = MainFrame.this.sketchFrame.getWidth();
                sketchWindowH = MainFrame.this.sketchFrame.getHeight();
                MainFrame.this.sketchFrame.dispose();
                MainFrame.this.sketchFrame = null;
                MainFrame.this.sketchPanel = null;
            }
        });
        if (this.current != null) {
            this.current.add(this.sketchFrame);
        }
        if (this.current == this.detectorDesktop) {
            this.sketchFrame.setTitle("Sketch window (Detector)");
            this.sketchPanel.setView(5);
        } else {
            this.sketchFrame.setTitle("Sketch window (Backingplate)");
            this.sketchPanel.setView(4);
        }
        this.sketchFrame.setVisible(true);
    }

    private void fixInputParams() {
        if (this.nuclideRadioBtn.isSelected()) {
            String str = "";
            String libstr = "";
            String base = "";
            boolean differ = false;
            int nrows = this.nuclidesTable.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                Nuclide nuc = (Nuclide)this.nuclidesTable.getValueAt(i, 0);
                if (nuc == null) continue;
                Parameter dec = (Parameter)this.nuclidesTable.getValueAt(i, 1);
                if (i != 0) {
                    str = str + "&";
                }
                str = str + "'" + nuc.getName() + "'" + "&" + dec.getValue().toString();
                libstr = libstr + "'" + this.fixPath(nuc.library) + "'";
                if (i != nrows - 1) {
                    libstr = libstr + '&';
                }
                if (i == 0) {
                    base = nuc.library;
                    continue;
                }
                if (base == null) {
                    System.out.println("NULL BASE!!!");
                    continue;
                }
                if (nuc.library == null) {
                    System.out.println("NULL LIBRARY!!!!!!");
                    continue;
                }
                differ = !base.equals(nuc.library) || differ;
            }
            if (differ) {
                Main.getParameter("1030").setValue(libstr);
            }
            Main.getParameter("1029").setValue(str);
        }
    }

    private void fixDetectorParams() {
        Parameter p = Main.getParameter("1026");
        String detfil = (String)this.detectorFilename.getValueAt(0, 0);
        if (!detfil.startsWith("'")) {
            detfil = "'" + detfil;
        }
        if (!detfil.endsWith("'")) {
            detfil = detfil + "'";
        }
        p.setValue(detfil);
        p = Main.getParameter("1014");
        String detname = (String)this.detectorField.getValueAt(0, 0);
        if (!detname.startsWith("'")) {
            detname = "'" + detname;
        }
        if (!detname.endsWith("'")) {
            detname = detname + "'";
        }
        p.setValue(detname);
    }

    private void enableHeaderLabel(JLabel label) {
        label.setBackground(label.getBackground().darker());
    }

    private void particleButtons() {
        if (this.singleParticleBtn.isSelected()) {
            if (this.sphericalBtn.isSelected() || this.surfaceLayerBtn.isSelected()) {
                this.loadTableWithParams("particles/spherical", this.particlePropertiesTable1, true);
            } else {
                this.loadTableWithParams("particles/ellipsoidal", this.particlePropertiesTable1, true);
            }
            this.lognormalSizeBtn.setEnabled(false);
            this.identicalSizeBtn.setEnabled(false);
            this.sizeLabel.setEnabled(false);
        } else {
            if (!this.ellipsoidalBtn.isSelected()) {
                this.lognormalSizeBtn.setEnabled(true);
                this.identicalSizeBtn.setEnabled(true);
                this.sizeLabel.setEnabled(true);
            }
            if (this.lognormalSizeBtn.isSelected()) {
                this.loadTableWithParams("particles/lognormalsize", this.particlePropertiesTable1, true);
            } else if (this.sphericalBtn.isSelected() || this.surfaceLayerBtn.isSelected()) {
                this.loadTableWithParams("particles/spherical", this.particlePropertiesTable1, true);
            } else {
                this.loadTableWithParams("particles/ellipsoidal", this.particlePropertiesTable1, true);
            }
        }
        Main.getParameter("1009").setValue(this.manyParticlesBtn.isSelected() ? "y" : "n");
        Main.getParameter("1003").setValue(this.ellipsoidalBtn.isSelected() ? "e" : "b");
        Main.getParameter("1004").setValue(this.surfaceLayerBtn.isSelected() ? "y" : "n");
        Main.getParameter("1010").setValue(this.lognormalSizeBtn.isSelected() ? "y" : "n");
        Main.getParameter("1007").setValue("n");
        if (this.sketchPanel != null) {
            this.sketchPanel.refresh();
            this.sketchPanel.repaint();
        }
    }

    private void matrixButtons() {
        if (this.lognormalSizeBtn1.isSelected()) {
            this.loadTableWithParams("particles/lognormalsize", this.particlePropertiesTable2, true);
        } else if (this.sphericalBtn1.isSelected() || this.surfaceLayerBtn1.isSelected()) {
            this.loadTableWithParams("particles/spherical", this.particlePropertiesTable2, true);
        } else {
            this.loadTableWithParams("particles/ellipsoidal", this.particlePropertiesTable2, true);
        }
        if (this.exponentialBtn.isSelected()) {
            this.loadTableWithParams("source/exponentialdepth", this.particlePropertiesTable2, false);
            this.loadTableWithParams("source/cylindrical", this.sourcePropertiesTable2, true);
        } else {
            this.loadTableWithParams("source/convex", this.sourcePropertiesTable2, true);
        }
        Main.getParameter("1009").setValue("y");
        Main.getParameter("1003").setValue(this.ellipsoidalBtn1.isSelected() ? "e" : "b");
        Main.getParameter("1004").setValue(this.surfaceLayerBtn1.isSelected() ? "y" : "n");
        Main.getParameter("1010").setValue(this.lognormalSizeBtn1.isSelected() ? "y" : "n");
        Main.getParameter("1007").setValue(this.exponentialBtn.isSelected() ? "y" : "n");
        if (this.exponentialBtn.isSelected()) {
            Main.getParameter("1006").setValue("n");
        } else {
            Main.getParameter("1006").setValue("y");
        }
        if (Main.getParameter("1006").getStringValue().equals("y")) {
            Main.getParameter("4").setValue(Main.getParameter("1606").getValue());
        } else {
            Main.getParameter("1606").setValue(Main.getParameter("4").getValue());
        }
        Main.getParameter("side_dummy").setLocked(this.exponentialBtn.isSelected());
        Main.getParameter("side_dummy").setValue(Main.getParameter("1606").getValue());
        this.sourcePropertiesTable2.repaint();
        if (this.sketchPanel != null) {
            this.sketchPanel.refresh();
            this.sketchPanel.repaint();
        }
    }

    private void initComponents() {
        this.nuclideSelButtonGroup = new ButtonGroup();
        this.peakShapeGroup = new ButtonGroup();
        this.sourceTypeGroup = new ButtonGroup();
        this.occurenceGroup = new ButtonGroup();
        this.typeGroup = new ButtonGroup();
        this.depthGroup = new ButtonGroup();
        this.typeGroup1 = new ButtonGroup();
        this.occurenceGroup1 = new ButtonGroup();
        this.layersGroup = new ButtonGroup();
        this.browseCoincGroup = new ButtonGroup();
        this.tabsPane = new JTabbedPane();
        this.detectorDesktop = new JDesktopPane();
        this.detectorFrame = new JInternalFrame();
        this.jScrollPane4 = new JScrollPane();
        this.particlesPanel2 = new JPanel();
        this.deadLayerMaterialPropertiesTable = new JTable();
        this.deadLayerMaterialCombobox = new JComboBox();
        this.detectorPropertiesTable = new JTable();
        this.peakTailingPropertiesTable = new JTable();
        this.detectorField = new JTable();
        this.detectorFilename = new JTable();
        this.openDetector = new JLabel();
        this.saveDetector = new JLabel();
        this.headerLabel1 = new HeaderLabel();
        this.headerLabel2 = new HeaderLabel();
        this.headerLabel3 = new HeaderLabel();
        this.headerLabel4 = new HeaderLabel();
        this.headerLabel5 = new HeaderLabel();
        this.headerLabel6 = new HeaderLabel();
        this.sourceDesktop = new JDesktopPane();
        this.radiationSourceFrame = new JInternalFrame();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.sourceShelf = new Shelf();
        this.homogenousSourceDrawer = new Drawer();
        this.homogenousSourceButton = new JRadioButton();
        this.sourcePropertiesTable1 = new JTable();
        this.jScrollPane5 = new JScrollPane();
        this.sourceMaterialElementsTable1 = new JTable();
        this.sourceMaterialElementsTable1.setTableHeader(null);
        this.headerLabel18 = new HeaderLabel();
        this.headerLabel19 = new HeaderLabel();
        this.headerLabel28 = new HeaderLabel();
        this.headerLabel28.setDark(false);
        this.radioactiveParticlesDrawer = new Drawer();
        this.radioactiveParticlesButton = new JRadioButton();
        this.singleParticleBtn = new JRadioButton();
        this.manyParticlesBtn = new JRadioButton();
        this.sphericalBtn = new JRadioButton();
        this.ellipsoidalBtn = new JRadioButton();
        this.surfaceLayerBtn = new JRadioButton();
        this.particlePropertiesTable1 = new JTable();
        this.identicalSizeBtn = new JRadioButton();
        this.lognormalSizeBtn = new JRadioButton();
        this.jScrollPane8 = new JScrollPane();
        this.particleMaterialElementsTable2 = new JTable();
        this.particleMaterialElementsTable2.setTableHeader(null);
        this.headerLabel15 = new HeaderLabel();
        this.headerLabel16 = new HeaderLabel();
        this.sizeLabel = new HeaderLabel();
        this.headerLabel23 = new HeaderLabel();
        this.headerLabel24 = new HeaderLabel();
        this.depositionAreaField = new JTable();
        this.depLabel2 = new JLabel();
        this.headerLabel29 = new HeaderLabel();
        this.headerLabel28.setDark(false);
        this.xPosField = new JTable();
        this.yPosField = new JTable();
        this.posLabel1 = new JLabel();
        this.posLabel2 = new JLabel();
        this.posLabel3 = new JLabel();
        this.posLabel4 = new JLabel();
        this.posLabel = new HeaderLabel();
        this.depLabel = new HeaderLabel();
        this.matrixSourceDrawer = new Drawer();
        this.matrixSourceButton = new JRadioButton();
        this.sphericalBtn1 = new JRadioButton();
        this.ellipsoidalBtn1 = new JRadioButton();
        this.surfaceLayerBtn1 = new JRadioButton();
        this.particlePropertiesTable2 = new JTable();
        this.identicalSizeBtn1 = new JRadioButton();
        this.lognormalSizeBtn1 = new JRadioButton();
        this.uniformBtn = new JRadioButton();
        this.exponentialBtn = new JRadioButton();
        this.sourcePropertiesTable2 = new JTable();
        this.jScrollPane6 = new JScrollPane();
        this.sourceMaterialElementsTable2 = new JTable();
        this.sourceMaterialElementsTable2.setTableHeader(null);
        this.jScrollPane7 = new JScrollPane();
        this.particleMaterialElementsTable1 = new JTable();
        this.particleMaterialElementsTable1.setTableHeader(null);
        this.pTypeLabel = new HeaderLabel();
        this.sizeLabel1 = new HeaderLabel();
        this.depthLabel = new HeaderLabel();
        this.headerLabel11 = new HeaderLabel();
        this.headerLabel12 = new HeaderLabel();
        this.headerLabel13 = new HeaderLabel();
        this.headerLabel14 = new HeaderLabel();
        this.headerLabel30 = new HeaderLabel();
        this.headerLabel28.setDark(false);
        this.headerLabel17 = new HeaderLabel();
        this.jPanel4 = new JPanel();
        this.jLabel6 = new JLabel();
        this.sddField = new JTable();
        this.jLabel5 = new JLabel();
        this.nuclidesFrame = new JInternalFrame();
        this.jScrollPane3 = new JScrollPane();
        this.nuclidesPanel = new JPanel();
        this.nuclidePropertiesTable = new JTable();
        this.nuclideComboBox = new JComboBox();
        this.addNuclideButton = new JButton();
        this.removeNuclideButton = new JButton();
        this.lineEnergyRadioBtn = new JRadioButton();
        this.nuclideRadioBtn = new JRadioButton();
        this.nuclidesScrollPane = new JScrollPane();
        this.linesTable = new JTable();
        this.nuclidesScrollPane1 = new JScrollPane();
        this.nuclidesTable = new JTable();
        this.nuclideLabel = new HeaderLabel();
        this.nuclidePropertiesLabel = new HeaderLabel();
        this.selectedNuclidesLabel = new HeaderLabel();
        this.openLibrary = new JLabel();
        this.lineEnergyField = new JTable();
        this.mevLabel = new JLabel();
        this.decaysLabel = new JLabel();
        this.decaysField = new JTable();
        this.layersDesktop = new JDesktopPane();
        this.layersFrame = new JInternalFrame();
        this.jScrollPane9 = new JScrollPane();
        this.layersPanel = new JPanel();
        this.layersTable = new JTable();
        this.deleteLayerButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.layerMaterialElementsTable = new JTable();
        this.layerMaterialElementsTable.setTableHeader(null);
        this.layerMaterialPropertiesTable = new JTable();
        this.layerMaterialPropertiesTable.setTableHeader(null);
        this.addLayerBtn = new JButton();
        this.layersHeader = new HeaderLabel();
        this.layersHeader2 = new HeaderLabel();
        this.layersHeader3 = new HeaderLabel();
        this.noAbsLayersBtn = new JRadioButton();
        this.absLayersBtn = new JRadioButton();
        this.coincidencesDesktop = new JDesktopPane();
        this.backScatterFrame = new JInternalFrame();
        this.jScrollPane10 = new JScrollPane();
        this.particlesPanel3 = new JPanel();
        this.coincidenceNuclidesScrollPane = new JScrollPane();
        this.coincidenceNuclidesTable = new JTable();
        this.selectedNuclidesLabel1 = new HeaderLabel();
        this.browseSimCoincidences = new JRadioButton();
        this.browseLibCoincidences = new JRadioButton();
        this.nuclideLabel1 = new HeaderLabel();
        this.openLibrary1 = new JLabel();
        this.coincidenceNuclideComboBox = new JComboBox();
        this.selectedNuclidesLabel2 = new HeaderLabel();
        this.nuclidesScrollPane2 = new JScrollPane();
        this.betaLinesTable = new JTable();
        this.nuclidesScrollPane3 = new JScrollPane();
        this.gammaLinesTable = new JTable();
        this.coincidenceFrame = new JInternalFrame();
        this.jScrollPane11 = new JScrollPane();
        this.particlesPanel4 = new JPanel();
        this.coincidencesCheckbox = new JCheckBox();
        this.trackAlphaCheckBox = new JCheckBox();
        this.includeBackingplateCheckbox = new JCheckBox();
        this.headerLabel27 = new HeaderLabel();
        this.shieldingModelCombobox = new JComboBox();
        this.parallelbeamCheckbox = new JCheckBox();
        this.linearDepositionCheckbox = new JCheckBox();
        this.headerLabel25 = new HeaderLabel();
        this.backingplateMaterialCombobox = new JComboBox();
        this.headerLabel26 = new HeaderLabel();
        this.backingplateMaterialPropertiesTable = new JTable();
        this.backingplateMaterialPropertiesTable1 = new JTable();
        this.coincidenceOutputFileField = new JTextField();
        this.headerLabel31 = new HeaderLabel();
        this.openLibrary2 = new JLabel();
        this.coincidencesCheckbox1 = new JCheckBox();
        this.calculateDesktop = new JDesktopPane();
        this.paramsFrame = new JInternalFrame();
        this.jPanel2 = new JPanel();
        this.runButton = new JButton();
        this.jScrollPane12 = new JScrollPane();
        this.paramsPanel = new JPanel();
        this.jLabel43 = new JLabel();
        this.jLabel44 = new JLabel();
        this.stragglingCheckBox = new JCheckBox();
        this.selfabsCheckBox = new JCheckBox();
        this.energyBinField = new JTable();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jLabel49 = new JLabel();
        this.integrationStepField = new JTable();
        this.jLabel50 = new JLabel();
        this.srcDetectorCheckBox = new JCheckBox();
        this.statusPanel = new JPanel();
        this.timeField = new JTextField();
        this.jPanel1 = new JPanel();
        this.memField = new JTextField();
        this.jTextField3 = new JTextField();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.fileOpenItem = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.fileSaveItem = new JMenuItem();
        this.fileSaveAsItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.fileSaveDetAs = new JMenuItem();
        this.jSeparator7 = new JSeparator();
        this.fileExitItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.sketchWindowMenuItem = new JCheckBoxMenuItem();
        this.logWindowMenuItem = new JCheckBoxMenuItem();
        this.notesMenuItem = new JCheckBoxMenuItem();
        this.jSeparator10 = new JSeparator();
        this.LafMenu = new JMenu();
        this.jSeparator2 = new JSeparator();
        this.infoViewMenuItem = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.plotTabMenuItem = new JCheckBoxMenuItem();
        this.runMenu = new JMenu();
        this.runMenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.runGeometricEfficiencyMenuItem = new JMenuItem();
        this.windowMenu = new JMenu();
        this.cascadeMenuItem = new JMenuItem();
        this.tileMenuItem = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.minimizeAllMenuItem = new JMenuItem();
        this.maximizeAll = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.helpWelcomeItem = new JMenuItem();
        this.helpAboutItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("AASI - Advanced Alpha-spectrometric Simulation");
        this.setIconImage(new ImageIcon(this.getClass().getResource("images/MainIcon.png")).getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainFrame.this.formWindowClosing(evt);
            }
        });
        this.tabsPane.setBorder(BorderFactory.createEtchedBorder());
        this.tabsPane.setTabLayoutPolicy(1);
        this.tabsPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainFrame.this.tabsPaneStateChanged(evt);
            }
        });
        this.detectorFrame.setIconifiable(true);
        this.detectorFrame.setResizable(true);
        this.detectorFrame.setTitle("Alpha detector");
        this.detectorFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/DetectorIcon.png")));
        this.detectorFrame.setPreferredSize(new Dimension(440, 311));
        this.detectorFrame.setVisible(true);
        this.detectorFrame.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameActivated(InternalFrameEvent evt) {
                MainFrame.this.internalFrameActivated(evt);
            }

            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jScrollPane4.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane4.setMinimumSize(new Dimension(440, 275));
        this.jScrollPane4.setPreferredSize(new Dimension(440, 275));
        this.particlesPanel2.setMinimumSize(new Dimension(600, 280));
        this.particlesPanel2.setNextFocusableComponent(this.detectorPropertiesTable);
        this.particlesPanel2.setLayout(new GridBagLayout());
        this.deadLayerMaterialPropertiesTable.setModel(new DefaultTableModel(new Object[][]{{"", null, ""}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.deadLayerMaterialPropertiesTable.setAutoResizeMode(0);
        this.deadLayerMaterialPropertiesTable.setEditingColumn(1);
        this.deadLayerMaterialPropertiesTable.setMaximumSize(new Dimension(20, 48));
        this.deadLayerMaterialPropertiesTable.setMinimumSize(new Dimension(200, 48));
        this.deadLayerMaterialPropertiesTable.setOpaque(false);
        this.deadLayerMaterialPropertiesTable.setPreferredSize(new Dimension(200, 80));
        this.deadLayerMaterialPropertiesTable.setRowSelectionAllowed(false);
        this.deadLayerMaterialPropertiesTable.setShowHorizontalLines(false);
        this.deadLayerMaterialPropertiesTable.setShowVerticalLines(false);
        this.deadLayerMaterialPropertiesTable.setSurrendersFocusOnKeystroke(true);
        this.initTable(this.deadLayerMaterialPropertiesTable);
        this.deadLayerMaterialPropertiesTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.deadLayerMaterialPropertiesTable.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.deadLayerMaterialPropertiesTable.getColumnModel().getColumn(2).setCellRenderer(new BasicRenderer());
        this.deadLayerMaterialPropertiesTable.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.particlesPanel2.add((Component)this.deadLayerMaterialPropertiesTable, gridBagConstraints);
        this.deadLayerMaterialCombobox.setToolTipText("Select the material of the detectors dead layer");
        this.deadLayerMaterialCombobox.setMaximumSize(new Dimension(20, 19));
        this.deadLayerMaterialCombobox.setMinimumSize(new Dimension(200, 19));
        this.deadLayerMaterialCombobox.setPreferredSize(new Dimension(200, 19));
        this.deadLayerMaterialCombobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.materialCombobox_handleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.particlesPanel2.add((Component)this.deadLayerMaterialCombobox, gridBagConstraints);
        this.detectorPropertiesTable.setModel(new DefaultTableModel(new Object[][]{{"", null, ""}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.detectorPropertiesTable.setAutoResizeMode(0);
        this.detectorPropertiesTable.setEditingColumn(1);
        this.detectorPropertiesTable.setMinimumSize(new Dimension(200, 80));
        this.detectorPropertiesTable.setOpaque(false);
        this.detectorPropertiesTable.setPreferredSize(new Dimension(200, 80));
        this.detectorPropertiesTable.setRowSelectionAllowed(false);
        this.detectorPropertiesTable.setShowHorizontalLines(false);
        this.detectorPropertiesTable.setShowVerticalLines(false);
        this.loadTableWithParams("detector", this.detectorPropertiesTable, true);
        this.initTable(this.detectorPropertiesTable);
        this.initTableListeners(this.detectorPropertiesTable);
        this.detectorPropertiesTable.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        this.detectorPropertiesTable.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.detectorPropertiesTable.getColumnModel().getColumn(0).setCellRenderer(new ParameterNameRenderer());
        this.detectorPropertiesTable.getColumnModel().getColumn(2).setCellRenderer(new UnitRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.particlesPanel2.add((Component)this.detectorPropertiesTable, gridBagConstraints);
        this.peakTailingPropertiesTable.setModel(new DefaultTableModel(new Object[][]{{"", null, ""}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.peakTailingPropertiesTable.setAutoResizeMode(4);
        this.peakTailingPropertiesTable.setMinimumSize(new Dimension(200, 80));
        this.peakTailingPropertiesTable.setOpaque(false);
        this.peakTailingPropertiesTable.setPreferredSize(new Dimension(200, 80));
        this.peakTailingPropertiesTable.setRowSelectionAllowed(false);
        this.peakTailingPropertiesTable.setShowHorizontalLines(false);
        this.peakTailingPropertiesTable.setShowVerticalLines(false);
        this.loadTableWithParams("detector/peaktailing", this.peakTailingPropertiesTable, true);
        this.initTable(this.peakTailingPropertiesTable);
        this.initTableListeners(this.peakTailingPropertiesTable);
        this.peakTailingPropertiesTable.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        this.peakTailingPropertiesTable.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.peakTailingPropertiesTable.getColumnModel().getColumn(0).setCellRenderer(new ParameterNameRenderer());
        this.peakTailingPropertiesTable.getColumnModel().getColumn(2).setCellRenderer(new UnitRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 60;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 10, 20, 0);
        this.particlesPanel2.add((Component)this.peakTailingPropertiesTable, gridBagConstraints);
        this.detectorField.setBorder(new SoftBevelBorder(1));
        this.detectorField.setModel(new DefaultTableModel(new Object[][]{{""}}, new String[]{"Title 1"}));
        this.detectorField.setToolTipText("User given detector type description");
        this.detectorField.setAutoResizeMode(0);
        this.detectorField.setGridColor(new Color(204, 204, 204));
        this.detectorField.setMinimumSize(new Dimension(200, 16));
        this.detectorField.setPreferredSize(new Dimension(200, 16));
        this.detectorField.setRowSelectionAllowed(false);
        this.detectorField.getColumnModel().getColumn(0).setCellEditor(new BasicEditor());
        this.detectorField.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.particlesPanel2.add((Component)this.detectorField, gridBagConstraints);
        this.detectorFilename.setBorder(new SoftBevelBorder(1));
        this.detectorFilename.setModel(new DefaultTableModel(new Object[][]{{""}}, new String[]{"Title 1"}));
        this.detectorFilename.setToolTipText("Name of the file containing these detector properties");
        this.detectorFilename.setAutoResizeMode(0);
        this.detectorFilename.setGridColor(new Color(204, 204, 204));
        this.detectorFilename.setMinimumSize(new Dimension(153, 16));
        this.detectorFilename.setPreferredSize(new Dimension(153, 16));
        this.detectorFilename.setRowSelectionAllowed(false);
        this.detectorFilename.getColumnModel().getColumn(0).setCellEditor(new BasicEditor());
        this.detectorFilename.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.particlesPanel2.add((Component)this.detectorFilename, gridBagConstraints);
        this.openDetector.setBackground(new Color(102, 102, 102));
        this.openDetector.setForeground(new Color(255, 255, 255));
        this.openDetector.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/OpenSmall.png")));
        this.openDetector.setToolTipText("Open a detector file");
        this.openDetector.setMinimumSize(new Dimension(18, 18));
        this.openDetector.setPreferredSize(new Dimension(18, 18));
        this.openDetector.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                MainFrame.this.openDetectorMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.particlesPanel2.add((Component)this.openDetector, gridBagConstraints);
        this.saveDetector.setBackground(new Color(102, 102, 102));
        this.saveDetector.setForeground(new Color(255, 255, 255));
        this.saveDetector.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/SaveSmall.png")));
        this.saveDetector.setToolTipText("Save the detector file");
        this.saveDetector.setEnabled(false);
        this.saveDetector.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                MainFrame.this.saveDetectorMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.particlesPanel2.add((Component)this.saveDetector, gridBagConstraints);
        this.headerLabel1.setText(" Detector filename");
        this.headerLabel1.setToolTipText("Name of the file containing these detector properties");
        this.headerLabel1.setDark(true);
        this.headerLabel1.setMaximumSize(new Dimension(50, 15));
        this.headerLabel1.setMinimumSize(new Dimension(200, 15));
        this.headerLabel1.setPreferredSize(new Dimension(200, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        this.particlesPanel2.add((Component)this.headerLabel1, gridBagConstraints);
        this.headerLabel2.setText(" Detector properties");
        this.headerLabel2.setToolTipText("Properties of the detector");
        this.headerLabel2.setMaximumSize(new Dimension(1000, 15));
        this.headerLabel2.setMinimumSize(new Dimension(200, 15));
        this.headerLabel2.setPreferredSize(new Dimension(200, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.particlesPanel2.add((Component)this.headerLabel2, gridBagConstraints);
        this.headerLabel3.setText(" Peak shape");
        this.headerLabel3.setToolTipText("Properties of the detector response - Gaussian peak with double exponential left tail.");
        this.headerLabel3.setMinimumSize(new Dimension(200, 15));
        this.headerLabel3.setPreferredSize(new Dimension(200, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.particlesPanel2.add((Component)this.headerLabel3, gridBagConstraints);
        this.headerLabel4.setText(" Dead layer material properties");
        this.headerLabel4.setMaximumSize(new Dimension(20, 15));
        this.headerLabel4.setMinimumSize(new Dimension(200, 15));
        this.headerLabel4.setPreferredSize(new Dimension(200, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.particlesPanel2.add((Component)this.headerLabel4, gridBagConstraints);
        this.headerLabel5.setText(" Dead layer material");
        this.headerLabel5.setToolTipText("The material of the dead layer");
        this.headerLabel5.setMaximumSize(new Dimension(20, 15));
        this.headerLabel5.setMinimumSize(new Dimension(200, 15));
        this.headerLabel5.setPreferredSize(new Dimension(200, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.particlesPanel2.add((Component)this.headerLabel5, gridBagConstraints);
        this.headerLabel6.setText(" Detector type");
        this.headerLabel6.setToolTipText("User given detector type description");
        this.headerLabel6.setMaximumSize(new Dimension(20, 15));
        this.headerLabel6.setMinimumSize(new Dimension(200, 15));
        this.headerLabel6.setPreferredSize(new Dimension(200, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(15, 5, 0, 5);
        this.particlesPanel2.add((Component)this.headerLabel6, gridBagConstraints);
        this.jScrollPane4.setViewportView(this.particlesPanel2);
        this.detectorFrame.getContentPane().add((Component)this.jScrollPane4, "Center");
        this.detectorFrame.setBounds(60, 40, 470, 410);
        this.detectorDesktop.add((Component)this.detectorFrame, JLayeredPane.DEFAULT_LAYER);
        this.tabsPane.addTab("Alpha Detector", null, this.detectorDesktop, "Define alpha detectors properties");
        this.radiationSourceFrame.setIconifiable(true);
        this.radiationSourceFrame.setResizable(true);
        this.radiationSourceFrame.setTitle("Source");
        this.radiationSourceFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/SourceIcon.png")));
        this.radiationSourceFrame.setPreferredSize(new Dimension(582, 621));
        this.radiationSourceFrame.setVisible(true);
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanel3.setPreferredSize(new Dimension(570, 580));
        this.jPanel3.setLayout(new AbsoluteLayout());
        this.sourceShelf.setLayout(null);
        this.homogenousSourceDrawer.setBorder(new SoftBevelBorder(1));
        this.homogenousSourceDrawer.setMaximumSize(new Dimension(530, 160));
        this.homogenousSourceDrawer.setMinimumSize(new Dimension(530, 20));
        this.homogenousSourceDrawer.setPreferredSize(new Dimension(530, 20));
        this.homogenousSourceDrawer.setMaximizeComponent(this.homogenousSourceButton);
        this.homogenousSourceDrawer.setLayout(null);
        this.sourceTypeGroup.add(this.homogenousSourceButton);
        this.homogenousSourceButton.setToolTipText("Use a source that is homogenous");
        this.homogenousSourceButton.setPreferredSize(new Dimension(15, 15));
        this.homogenousSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.homogenousSourceButtonActionPerformed(evt);
            }
        });
        this.homogenousSourceDrawer.add(this.homogenousSourceButton);
        this.homogenousSourceButton.setBounds(2, 2, 20, 15);
        this.sourcePropertiesTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.sourcePropertiesTable1.setOpaque(false);
        this.sourcePropertiesTable1.setRowSelectionAllowed(false);
        this.sourcePropertiesTable1.setShowHorizontalLines(false);
        this.sourcePropertiesTable1.setShowVerticalLines(false);
        this.loadTableWithParams("source/cylindrical", this.sourcePropertiesTable1, true);
        this.initTable(this.sourcePropertiesTable1);
        this.initTableListeners(this.sourcePropertiesTable1);
        this.sourcePropertiesTable1.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        this.sourcePropertiesTable1.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.sourcePropertiesTable1.getColumnModel().getColumn(0).setCellRenderer(new ParameterNameRenderer());
        this.sourcePropertiesTable1.getColumnModel().getColumn(2).setCellRenderer(new UnitRenderer());
        this.homogenousSourceDrawer.add(this.sourcePropertiesTable1);
        this.sourcePropertiesTable1.setBounds(30, 50, 260, 100);
        this.jScrollPane5.setBackground(new Color(255, 255, 255));
        this.jScrollPane5.setPreferredSize(new Dimension(110, 77));
        this.jScrollPane5.setColumnHeader(null);
        this.sourceMaterialElementsTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1"}));
        this.sourceMaterialElementsTable1.setToolTipText("Click to edit the element compostion of the homogeneous source");
        this.sourceMaterialElementsTable1.setAutoResizeMode(4);
        this.sourceMaterialElementsTable1.setGridColor(new Color(204, 204, 204));
        this.sourceMaterialElementsTable1.setPreferredSize(new Dimension(110, 73));
        this.sourceMaterialElementsTable1.setRowSelectionAllowed(false);
        this.sourceMaterialElementsTable1.setShowVerticalLines(false);
        this.initTableListeners(this.sourceMaterialElementsTable1);
        this.initElementTable(this.sourceMaterialElementsTable1);
        this.sourceMaterialElementsTable1.getColumnModel().getColumn(0).setCellRenderer(new ElementRenderer());
        this.sourceMaterialElementsTable1.getColumnModel().getColumn(0).setCellEditor(new ElementEditor(this, this.radiationSourceFrame, "1508", 1602, "Homogeneous source element composition."));
        this.jScrollPane5.setViewportView(this.sourceMaterialElementsTable1);
        this.homogenousSourceDrawer.add(this.jScrollPane5);
        this.jScrollPane5.setBounds(330, 50, 150, 77);
        this.headerLabel18.setText(" Source properties");
        this.headerLabel18.setToolTipText("Properties of the homogenous source");
        this.homogenousSourceDrawer.add(this.headerLabel18);
        this.headerLabel18.setBounds(30, 30, 260, 14);
        this.headerLabel19.setText(" Source element composition");
        this.headerLabel19.setToolTipText("The element composition of the homogenous source");
        this.homogenousSourceDrawer.add(this.headerLabel19);
        this.headerLabel19.setBounds(330, 30, 150, 15);
        this.headerLabel28.setText("      Homogeneous source");
        this.headerLabel28.setToolTipText("Cylindrical source shape with user-given properties");
        this.headerLabel28.setDark(false);
        this.homogenousSourceDrawer.add(this.headerLabel28);
        this.headerLabel28.setBounds(23, 3, 500, 14);
        this.sourceShelf.add(this.homogenousSourceDrawer);
        this.homogenousSourceDrawer.setBounds(10, 10, 530, 20);
        this.radioactiveParticlesDrawer.setBorder(new SoftBevelBorder(1));
        this.radioactiveParticlesDrawer.setMaximumSize(new Dimension(530, 375));
        this.radioactiveParticlesDrawer.setMinimumSize(new Dimension(530, 20));
        this.radioactiveParticlesDrawer.setPreferredSize(new Dimension(530, 20));
        this.radioactiveParticlesDrawer.setMaximizeComponent(this.radioactiveParticlesButton);
        this.radioactiveParticlesDrawer.setLayout(new AbsoluteLayout());
        this.sourceTypeGroup.add(this.radioactiveParticlesButton);
        this.radioactiveParticlesButton.setToolTipText("Radioactive particles deposited on a circular area");
        this.radioactiveParticlesButton.setPreferredSize(new Dimension(15, 15));
        this.radioactiveParticlesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.radioactiveParticlesButtonActionPerformed(evt);
            }
        });
        this.radioactiveParticlesDrawer.add((Component)this.radioactiveParticlesButton, new AbsoluteConstraints(2, 2, 20, -1));
        this.occurenceGroup.add(this.singleParticleBtn);
        this.singleParticleBtn.setText("Single particle");
        this.singleParticleBtn.setToolTipText("A single radioactive particle at specified coordinates.");
        this.singleParticleBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.singleParticleBtnActionPerformed(evt);
            }
        });
        this.radioactiveParticlesDrawer.add((Component)this.singleParticleBtn, new AbsoluteConstraints(30, 50, 110, -1));
        this.occurenceGroup.add(this.manyParticlesBtn);
        this.manyParticlesBtn.setText("Many particles");
        this.manyParticlesBtn.setToolTipText("Many radioactive particles deposited on an area.");
        this.manyParticlesBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.manyParticlesBtnActionPerformed(evt);
            }
        });
        this.radioactiveParticlesDrawer.add((Component)this.manyParticlesBtn, new AbsoluteConstraints(320, 50, 120, -1));
        this.typeGroup.add(this.sphericalBtn);
        this.sphericalBtn.setText("Spherical");
        this.sphericalBtn.setToolTipText("Sphere shaped homogeneous particles.");
        this.sphericalBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.sphericalBtnActionPerformed(evt);
            }
        });
        this.radioactiveParticlesDrawer.add((Component)this.sphericalBtn, new AbsoluteConstraints(30, 150, 110, -1));
        this.typeGroup.add(this.ellipsoidalBtn);
        this.ellipsoidalBtn.setText("Ellipsoidal");
        this.ellipsoidalBtn.setToolTipText("Ellipsoid shaped homogeneous particles.");
        this.ellipsoidalBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.ellipsoidalBtnActionPerformed(evt);
            }
        });
        this.radioactiveParticlesDrawer.add((Component)this.ellipsoidalBtn, new AbsoluteConstraints(170, 150, 110, -1));
        this.typeGroup.add(this.surfaceLayerBtn);
        this.surfaceLayerBtn.setText("Radioactive spherical surface layer");
        this.surfaceLayerBtn.setToolTipText("Radioactive material on the surface of homogeneous stable particles.");
        this.surfaceLayerBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.surfaceLayerBtnActionPerformed(evt);
            }
        });
        this.radioactiveParticlesDrawer.add((Component)this.surfaceLayerBtn, new AbsoluteConstraints(290, 150, 230, -1));
        this.particlePropertiesTable1.setModel(new DefaultTableModel(new Object[][]{{"", null, ""}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.particlePropertiesTable1.setAutoResizeMode(0);
        this.particlePropertiesTable1.setOpaque(false);
        this.particlePropertiesTable1.setRowSelectionAllowed(false);
        this.particlePropertiesTable1.setShowHorizontalLines(false);
        this.particlePropertiesTable1.setShowVerticalLines(false);
        this.initTable(this.particlePropertiesTable1);
        this.initTableListeners(this.particlePropertiesTable1);
        this.particlePropertiesTable1.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        this.particlePropertiesTable1.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.particlePropertiesTable1.getColumnModel().getColumn(0).setCellRenderer(new ParameterNameRenderer());
        this.particlePropertiesTable1.getColumnModel().getColumn(2).setCellRenderer(new UnitRenderer());
        this.radioactiveParticlesDrawer.add((Component)this.particlePropertiesTable1, new AbsoluteConstraints(30, 260, 270, 130));
        this.identicalSizeBtn.setText("All particles have the same size");
        this.identicalSizeBtn.setToolTipText("All particles are the same size.");
        this.identicalSizeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.identicalSizeBtnActionPerformed(evt);
            }
        });
        this.radioactiveParticlesDrawer.add((Component)this.identicalSizeBtn, new AbsoluteConstraints(30, 200, -1, -1));
        this.lognormalSizeBtn.setText("Lognormally distributed particle size");
        this.lognormalSizeBtn.setToolTipText("The size of the particles is lognormally distributed.");
        this.lognormalSizeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.lognormalSizeBtnActionPerformed(evt);
            }
        });
        this.radioactiveParticlesDrawer.add((Component)this.lognormalSizeBtn, new AbsoluteConstraints(290, 200, 230, -1));
        this.jScrollPane8.setBackground(new Color(255, 255, 255));
        this.jScrollPane8.setHorizontalScrollBarPolicy(31);
        this.jScrollPane8.setPreferredSize(new Dimension(110, 77));
        this.jScrollPane8.setColumnHeader(null);
        this.particleMaterialElementsTable2.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1"}));
        this.particleMaterialElementsTable2.setToolTipText("Click to edit the element compostion of the particles");
        this.particleMaterialElementsTable2.setAutoResizeMode(4);
        this.particleMaterialElementsTable2.setGridColor(new Color(204, 204, 204));
        this.particleMaterialElementsTable2.setPreferredSize(new Dimension(110, 73));
        this.particleMaterialElementsTable2.setRowSelectionAllowed(false);
        this.particleMaterialElementsTable2.setShowVerticalLines(false);
        this.initTableListeners(this.particleMaterialElementsTable2);
        this.initElementTable(this.particleMaterialElementsTable2);
        this.particleMaterialElementsTable2.getColumnModel().getColumn(0).setCellRenderer(new ElementRenderer());
        this.particleMaterialElementsTable2.getColumnModel().getColumn(0).setCellEditor(new ElementEditor(this, this.radiationSourceFrame, "1509", 1702, "Particle element composition"));
        this.jScrollPane8.setViewportView(this.particleMaterialElementsTable2);
        this.radioactiveParticlesDrawer.add((Component)this.jScrollPane8, new AbsoluteConstraints(330, 260, 140, -1));
        this.headerLabel15.setText(" Particle occurrence");
        this.headerLabel15.setToolTipText("An idividual radioactive particle or a set of particles may be considered in the simulation.");
        this.radioactiveParticlesDrawer.add((Component)this.headerLabel15, new AbsoluteConstraints(30, 30, 490, -1));
        this.headerLabel16.setText(" Particle type");
        this.headerLabel16.setToolTipText("The type of radioactive particles to use in the simulation.");
        this.radioactiveParticlesDrawer.add((Component)this.headerLabel16, new AbsoluteConstraints(30, 130, 490, -1));
        this.sizeLabel.setText(" Size of the particles");
        this.sizeLabel.setToolTipText("The size of the particles in simulation.");
        this.radioactiveParticlesDrawer.add((Component)this.sizeLabel, new AbsoluteConstraints(30, 180, 490, -1));
        this.headerLabel23.setText(" Particle properties");
        this.headerLabel23.setToolTipText("Properties of the particles");
        this.radioactiveParticlesDrawer.add((Component)this.headerLabel23, new AbsoluteConstraints(30, 240, 270, -1));
        this.headerLabel24.setText(" Particle element composition");
        this.headerLabel24.setToolTipText("Element composition of the particles");
        this.radioactiveParticlesDrawer.add((Component)this.headerLabel24, new AbsoluteConstraints(330, 240, 140, -1));
        this.depositionAreaField.setBorder(new SoftBevelBorder(1));
        this.depositionAreaField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.depositionAreaField.setToolTipText("The diameter of the area the particles are deposited to");
        this.depositionAreaField.setPreferredSize(new Dimension(55, 16));
        this.depositionAreaField.setRowSelectionAllowed(false);
        this.depositionAreaField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.depositionAreaField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.radioactiveParticlesDrawer.add((Component)this.depositionAreaField, new AbsoluteConstraints(360, 100, -1, -1));
        this.depLabel2.setText("mm");
        this.radioactiveParticlesDrawer.add((Component)this.depLabel2, new AbsoluteConstraints(420, 100, -1, -1));
        this.headerLabel29.setText("      Radioactive particles");
        this.headerLabel29.setToolTipText("Radioactive particles deposited on a circular area");
        this.headerLabel29.setDark(false);
        this.radioactiveParticlesDrawer.add((Component)this.headerLabel29, new AbsoluteConstraints(23, 3, 500, -1));
        this.xPosField.setBorder(new SoftBevelBorder(1));
        this.xPosField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.xPosField.setToolTipText("The diameter of the area the particles are deposited to");
        this.xPosField.setPreferredSize(new Dimension(55, 16));
        this.xPosField.setRowSelectionAllowed(false);
        this.xPosField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.xPosField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.radioactiveParticlesDrawer.add((Component)this.xPosField, new AbsoluteConstraints(70, 100, -1, -1));
        this.yPosField.setBorder(new SoftBevelBorder(1));
        this.yPosField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.yPosField.setToolTipText("The diameter of the area the particles are deposited to");
        this.yPosField.setNextFocusableComponent(this.particlePropertiesTable1);
        this.yPosField.setPreferredSize(new Dimension(55, 16));
        this.yPosField.setRowSelectionAllowed(false);
        this.yPosField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.yPosField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.radioactiveParticlesDrawer.add((Component)this.yPosField, new AbsoluteConstraints(170, 100, -1, -1));
        this.posLabel1.setHorizontalAlignment(4);
        this.posLabel1.setText("x:");
        this.radioactiveParticlesDrawer.add((Component)this.posLabel1, new AbsoluteConstraints(50, 100, 20, -1));
        this.posLabel2.setHorizontalAlignment(4);
        this.posLabel2.setText("y:");
        this.radioactiveParticlesDrawer.add((Component)this.posLabel2, new AbsoluteConstraints(150, 100, 20, -1));
        this.posLabel3.setText("mm");
        this.radioactiveParticlesDrawer.add((Component)this.posLabel3, new AbsoluteConstraints(130, 100, -1, -1));
        this.posLabel4.setText("mm");
        this.radioactiveParticlesDrawer.add((Component)this.posLabel4, new AbsoluteConstraints(230, 100, -1, -1));
        this.posLabel.setText("Location");
        this.posLabel.setToolTipText("X- and y-coordinates of the particle (symmetry axis with respect to the detector refer to 0,0)\n");
        this.posLabel.setDark(false);
        this.radioactiveParticlesDrawer.add((Component)this.posLabel, new AbsoluteConstraints(50, 80, 200, -1));
        this.depLabel.setText("Diameter of the deposition area");
        this.depLabel.setToolTipText("The diameter of the circular area where the radioactive particels are deposited");
        this.depLabel.setDark(false);
        this.radioactiveParticlesDrawer.add((Component)this.depLabel, new AbsoluteConstraints(340, 80, 180, -1));
        this.sourceShelf.add(this.radioactiveParticlesDrawer);
        this.radioactiveParticlesDrawer.setBounds(10, 40, 530, 20);
        this.matrixSourceDrawer.setBorder(new SoftBevelBorder(1));
        this.matrixSourceDrawer.setMaximizeComponent(this.matrixSourceButton);
        this.matrixSourceDrawer.setMaximumSize(new Dimension(530, 430));
        this.matrixSourceDrawer.setMinimumSize(new Dimension(530, 20));
        this.matrixSourceDrawer.setPreferredSize(new Dimension(530, 20));
        this.radioactiveParticlesDrawer.setMaximizeComponent(this.radioactiveParticlesButton);
        this.matrixSourceDrawer.setLayout(new AbsoluteLayout());
        this.sourceTypeGroup.add(this.matrixSourceButton);
        this.matrixSourceButton.setToolTipText("Radioactive particles embedded in a homogenous matrix e.g. An air filter");
        this.matrixSourceButton.setPreferredSize(new Dimension(15, 15));
        this.matrixSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.matrixSourceButtonActionPerformed(evt);
            }
        });
        this.matrixSourceDrawer.add((Component)this.matrixSourceButton, new AbsoluteConstraints(2, 2, 20, -1));
        this.typeGroup1.add(this.sphericalBtn1);
        this.sphericalBtn1.setText("Spherical");
        this.sphericalBtn1.setToolTipText("Sphere shaped homogeneous particles.");
        this.sphericalBtn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.sphericalBtn1ActionPerformed(evt);
            }
        });
        this.matrixSourceDrawer.add((Component)this.sphericalBtn1, new AbsoluteConstraints(30, 50, 110, -1));
        this.typeGroup1.add(this.ellipsoidalBtn1);
        this.ellipsoidalBtn1.setText("Ellipsoidal");
        this.ellipsoidalBtn1.setToolTipText("Ellipsoid shaped homogeneous particles.");
        this.ellipsoidalBtn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.ellipsoidalBtn1ActionPerformed(evt);
            }
        });
        this.matrixSourceDrawer.add((Component)this.ellipsoidalBtn1, new AbsoluteConstraints(160, 50, 130, -1));
        this.typeGroup1.add(this.surfaceLayerBtn1);
        this.surfaceLayerBtn1.setText("Radioactive spherical surface layer");
        this.surfaceLayerBtn1.setToolTipText("Radioactive material on the surface of homogeneous stable particles.");
        this.surfaceLayerBtn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.surfaceLayerBtn1ActionPerformed(evt);
            }
        });
        this.matrixSourceDrawer.add((Component)this.surfaceLayerBtn1, new AbsoluteConstraints(290, 50, 230, -1));
        this.particlePropertiesTable2.setModel(new DefaultTableModel(new Object[][]{{"", null, ""}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.particlePropertiesTable2.setAutoResizeMode(0);
        this.particlePropertiesTable2.setOpaque(false);
        this.particlePropertiesTable2.setRowSelectionAllowed(false);
        this.particlePropertiesTable2.setShowHorizontalLines(false);
        this.particlePropertiesTable2.setShowVerticalLines(false);
        this.initTable(this.particlePropertiesTable2);
        this.initTableListeners(this.particlePropertiesTable2);
        this.particlePropertiesTable2.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        this.particlePropertiesTable2.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.particlePropertiesTable2.getColumnModel().getColumn(0).setCellRenderer(new ParameterNameRenderer());
        this.particlePropertiesTable2.getColumnModel().getColumn(2).setCellRenderer(new UnitRenderer());
        this.matrixSourceDrawer.add((Component)this.particlePropertiesTable2, new AbsoluteConstraints(30, 200, 280, -1));
        this.identicalSizeBtn1.setText("All particles have the same size");
        this.identicalSizeBtn1.setToolTipText("All particles are the same size.");
        this.identicalSizeBtn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.identicalSizeBtn1ActionPerformed(evt);
            }
        });
        this.matrixSourceDrawer.add((Component)this.identicalSizeBtn1, new AbsoluteConstraints(30, 100, -1, -1));
        this.lognormalSizeBtn1.setText("Lognormally distributed particle size");
        this.lognormalSizeBtn1.setToolTipText("The number of emitted alpha particles is weighted by particle mass");
        this.lognormalSizeBtn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.lognormalSizeBtn1ActionPerformed(evt);
            }
        });
        this.matrixSourceDrawer.add((Component)this.lognormalSizeBtn1, new AbsoluteConstraints(290, 100, 230, -1));
        this.depthGroup.add(this.uniformBtn);
        this.uniformBtn.setText("Uniform");
        this.uniformBtn.setToolTipText("Radioactive particles are homogeneously distributed into the source matrix.");
        this.uniformBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.uniformBtnActionPerformed(evt);
            }
        });
        this.matrixSourceDrawer.add((Component)this.uniformBtn, new AbsoluteConstraints(30, 150, 110, -1));
        this.depthGroup.add(this.exponentialBtn);
        this.exponentialBtn.setText("Exponential");
        this.exponentialBtn.setToolTipText("Use exponential depth distribution characterized by the mean penetration depth and proportion of penetrated particles.");
        this.exponentialBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.exponentialBtnActionPerformed(evt);
            }
        });
        this.matrixSourceDrawer.add((Component)this.exponentialBtn, new AbsoluteConstraints(160, 150, 150, -1));
        this.sourcePropertiesTable2.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.sourcePropertiesTable2.setOpaque(false);
        this.sourcePropertiesTable2.setRowSelectionAllowed(false);
        this.sourcePropertiesTable2.setShowHorizontalLines(false);
        this.sourcePropertiesTable2.setShowVerticalLines(false);
        this.loadTableWithParams("source/cylindrical", this.sourcePropertiesTable2, true);
        this.initTable(this.sourcePropertiesTable2);
        this.initTableListeners(this.sourcePropertiesTable2);
        this.sourcePropertiesTable2.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        this.sourcePropertiesTable2.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.sourcePropertiesTable2.getColumnModel().getColumn(0).setCellRenderer(new ParameterNameRenderer());
        this.sourcePropertiesTable2.getColumnModel().getColumn(2).setCellRenderer(new UnitRenderer());
        this.matrixSourceDrawer.add((Component)this.sourcePropertiesTable2, new AbsoluteConstraints(30, 330, 280, -1));
        this.jScrollPane6.setBackground(new Color(255, 255, 255));
        this.jScrollPane6.setPreferredSize(new Dimension(110, 69));
        this.jScrollPane6.setColumnHeader(null);
        this.sourceMaterialElementsTable2.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1"}));
        this.sourceMaterialElementsTable2.setToolTipText("Click to edit the element compostion of the matrix");
        this.sourceMaterialElementsTable2.setAutoResizeMode(4);
        this.sourceMaterialElementsTable2.setGridColor(new Color(204, 204, 204));
        this.sourceMaterialElementsTable2.setPreferredSize(new Dimension(110, 73));
        this.sourceMaterialElementsTable2.setRowSelectionAllowed(false);
        this.sourceMaterialElementsTable2.setShowVerticalLines(false);
        this.initTableListeners(this.sourceMaterialElementsTable2);
        this.initElementTable(this.sourceMaterialElementsTable2);
        this.sourceMaterialElementsTable2.getColumnModel().getColumn(0).setCellRenderer(new ElementRenderer());
        this.sourceMaterialElementsTable2.getColumnModel().getColumn(0).setCellEditor(new ElementEditor(this, this.radiationSourceFrame, "1508", 1602, "Matrix element composition"));
        this.jScrollPane6.setViewportView(this.sourceMaterialElementsTable2);
        this.matrixSourceDrawer.add((Component)this.jScrollPane6, new AbsoluteConstraints(330, 330, 140, 77));
        this.jScrollPane7.setBackground(new Color(255, 255, 255));
        this.jScrollPane7.setHorizontalScrollBarPolicy(31);
        this.jScrollPane7.setPreferredSize(new Dimension(110, 69));
        this.jScrollPane7.setColumnHeader(null);
        this.particleMaterialElementsTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1"}));
        this.particleMaterialElementsTable1.setToolTipText("Click to edit the element compostion of the particles");
        this.particleMaterialElementsTable1.setAutoResizeMode(4);
        this.particleMaterialElementsTable1.setGridColor(new Color(204, 204, 204));
        this.particleMaterialElementsTable1.setPreferredSize(new Dimension(110, 73));
        this.particleMaterialElementsTable1.setRowSelectionAllowed(false);
        this.particleMaterialElementsTable1.setShowVerticalLines(false);
        this.initTableListeners(this.particleMaterialElementsTable1);
        this.initElementTable(this.particleMaterialElementsTable1);
        this.particleMaterialElementsTable1.getColumnModel().getColumn(0).setCellRenderer(new ElementRenderer());
        this.particleMaterialElementsTable1.getColumnModel().getColumn(0).setCellEditor(new ElementEditor(this, this.radiationSourceFrame, "1509", 1702, "Particle element composition"));
        this.jScrollPane7.setViewportView(this.particleMaterialElementsTable1);
        this.matrixSourceDrawer.add((Component)this.jScrollPane7, new AbsoluteConstraints(330, 200, 140, 77));
        this.pTypeLabel.setText(" Particle type");
        this.pTypeLabel.setToolTipText("The type of radioactive particles used in the simulation.");
        this.matrixSourceDrawer.add((Component)this.pTypeLabel, new AbsoluteConstraints(30, 30, 490, -1));
        this.sizeLabel1.setText(" Size of the particles");
        this.sizeLabel1.setToolTipText("The size of the particles used in the simulation.");
        this.matrixSourceDrawer.add((Component)this.sizeLabel1, new AbsoluteConstraints(30, 80, 490, -1));
        this.depthLabel.setText(" Particle depth distribution in the source matrix");
        this.depthLabel.setToolTipText("Particle depth distribution in the source matrix.");
        this.matrixSourceDrawer.add((Component)this.depthLabel, new AbsoluteConstraints(30, 130, 490, -1));
        this.headerLabel11.setText(" Particle properties");
        this.headerLabel11.setToolTipText("Properties of the particles");
        this.matrixSourceDrawer.add((Component)this.headerLabel11, new AbsoluteConstraints(30, 180, 280, -1));
        this.headerLabel12.setText(" Matrix properties");
        this.matrixSourceDrawer.add((Component)this.headerLabel12, new AbsoluteConstraints(30, 310, 280, -1));
        this.headerLabel13.setText(" Particle element composition");
        this.matrixSourceDrawer.add((Component)this.headerLabel13, new AbsoluteConstraints(330, 180, 140, -1));
        this.headerLabel14.setText(" Matrix element composition");
        this.matrixSourceDrawer.add((Component)this.headerLabel14, new AbsoluteConstraints(330, 310, 140, -1));
        this.headerLabel30.setText("      Radioactive particles in a homogenous source matrix");
        this.headerLabel30.setToolTipText("Radioactive particles embedded in a homogenous matrix e.g. An air filter");
        this.headerLabel30.setDark(false);
        this.matrixSourceDrawer.add((Component)this.headerLabel30, new AbsoluteConstraints(23, 3, 500, -1));
        this.sourceShelf.add(this.matrixSourceDrawer);
        this.matrixSourceDrawer.setBounds(10, 70, 530, 20);
        this.jPanel3.add((Component)this.sourceShelf, new AbsoluteConstraints(10, 60, 560, 540));
        this.headerLabel17.setText(" Source type");
        this.headerLabel17.setToolTipText("The type of radiation source to use in the simulation");
        this.jPanel3.add((Component)this.headerLabel17, new AbsoluteConstraints(20, 45, 160, -1));
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jLabel6.setLabelFor(this.sddField);
        this.jLabel6.setText("Distance from the detector");
        this.jPanel4.add(this.jLabel6);
        this.sddField.setBorder(new SoftBevelBorder(1));
        this.sddField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.sddField.setToolTipText("Sets the distance between the source and the detector");
        this.sddField.setPreferredSize(new Dimension(55, 16));
        this.sddField.setRowSelectionAllowed(false);
        this.initTableListeners(this.sddField);
        this.sddField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.sddField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        this.jPanel4.add(this.sddField);
        this.jLabel5.setText("mm");
        this.jPanel4.add(this.jLabel5);
        this.jPanel3.add((Component)this.jPanel4, new AbsoluteConstraints(20, 0, 360, 40));
        this.jScrollPane2.setViewportView(this.jPanel3);
        this.radiationSourceFrame.getContentPane().add((Component)this.jScrollPane2, "Center");
        this.radiationSourceFrame.setBounds(610, 20, 590, 620);
        this.sourceDesktop.add((Component)this.radiationSourceFrame, JLayeredPane.DEFAULT_LAYER);
        this.nuclidesFrame.setIconifiable(true);
        this.nuclidesFrame.setResizable(true);
        this.nuclidesFrame.setTitle("Radionuclides in the source");
        this.nuclidesFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/NuclidesIcon.png")));
        this.nuclidesFrame.setVisible(true);
        this.jScrollPane3.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.nuclidesPanel.setMinimumSize(new Dimension(580, 410));
        this.nuclidesPanel.setPreferredSize(new Dimension(580, 300));
        this.nuclidesPanel.setLayout(new GridBagLayout());
        this.nuclidePropertiesTable.setModel(new DefaultTableModel(new Object[][]{{"", null, ""}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.nuclidePropertiesTable.setAutoResizeMode(0);
        this.nuclidePropertiesTable.setGridColor(new Color(204, 204, 204));
        this.nuclidePropertiesTable.setMinimumSize(new Dimension(210, 32));
        this.nuclidePropertiesTable.setOpaque(false);
        this.nuclidePropertiesTable.setPreferredSize(new Dimension(210, 32));
        this.nuclidePropertiesTable.setRowSelectionAllowed(false);
        this.nuclidePropertiesTable.setShowHorizontalLines(false);
        this.nuclidePropertiesTable.setShowVerticalLines(false);
        this.initTable(this.nuclidePropertiesTable);
        this.nuclidePropertiesTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.nuclidePropertiesTable.getColumnModel().getColumn(1).setCellRenderer(new BasicRenderer());
        this.nuclidePropertiesTable.getColumnModel().getColumn(2).setCellRenderer(new BasicRenderer());
        this.nuclidePropertiesTable.getColumnModel().getColumn(1).setCellEditor(new BasicEditor());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 50, 0, 0);
        this.nuclidesPanel.add((Component)this.nuclidePropertiesTable, gridBagConstraints);
        this.nuclideComboBox.setToolTipText("Choose nuclide");
        this.nuclideComboBox.setMinimumSize(new Dimension(180, 19));
        this.nuclideComboBox.setPreferredSize(new Dimension(190, 19));
        this.nuclideComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.nuclideComboBox_handleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.nuclidesPanel.add((Component)this.nuclideComboBox, gridBagConstraints);
        this.addNuclideButton.setText("->");
        this.addNuclideButton.setToolTipText("Move edited nuclide into selection");
        this.addNuclideButton.setPreferredSize(new Dimension(50, 24));
        this.addNuclideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.button_handleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.nuclidesPanel.add((Component)this.addNuclideButton, gridBagConstraints);
        this.removeNuclideButton.setText("x");
        this.removeNuclideButton.setToolTipText("Remove selected nuclide");
        this.removeNuclideButton.setPreferredSize(new Dimension(50, 24));
        this.removeNuclideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.button_handleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 11;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.nuclidesPanel.add((Component)this.removeNuclideButton, gridBagConstraints);
        this.nuclideSelButtonGroup.add(this.lineEnergyRadioBtn);
        this.lineEnergyRadioBtn.setSelected(true);
        this.lineEnergyRadioBtn.setText("The source emits alpha particles of energy");
        this.lineEnergyRadioBtn.setToolTipText("Specify the energy of emitted alpha particles");
        this.lineEnergyRadioBtn.setMinimumSize(new Dimension(300, 23));
        this.lineEnergyRadioBtn.setPreferredSize(new Dimension(300, 23));
        this.lineEnergyRadioBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.lineEnergyRadioBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        this.nuclidesPanel.add((Component)this.lineEnergyRadioBtn, gridBagConstraints);
        this.nuclideSelButtonGroup.add(this.nuclideRadioBtn);
        this.nuclideRadioBtn.setText("Select alpha particle emitting radionuclide from list");
        this.nuclideRadioBtn.setToolTipText("Use library data for alpha particle energies");
        this.nuclideRadioBtn.setMinimumSize(new Dimension(300, 23));
        this.nuclideRadioBtn.setPreferredSize(new Dimension(300, 23));
        this.nuclideRadioBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.nuclideRadioBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        this.nuclidesPanel.add((Component)this.nuclideRadioBtn, gridBagConstraints);
        this.nuclidesScrollPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.nuclidesScrollPane.setHorizontalScrollBarPolicy(31);
        this.nuclidesScrollPane.setMinimumSize(new Dimension(210, 160));
        this.nuclidesScrollPane.setPreferredSize(new Dimension(210, 160));
        this.linesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Energy", "Yield"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.linesTable.setAutoResizeMode(4);
        this.linesTable.setGridColor(new Color(204, 204, 204));
        this.linesTable.setOpaque(false);
        this.linesTable.setPreferredSize(new Dimension(200, 63));
        this.linesTable.setRowSelectionAllowed(false);
        this.linesTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer(0));
        this.linesTable.getColumnModel().getColumn(1).setCellRenderer(new BasicRenderer(1));
        this.linesTable.getColumnModel().getColumn(0).setHeaderRenderer(new HeaderRenderer());
        this.linesTable.getColumnModel().getColumn(1).setHeaderRenderer(new HeaderRenderer());
        this.linesTable.getTableHeader().setReorderingAllowed(false);
        this.nuclidesScrollPane.setViewportView(this.linesTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 50, 0, 0);
        this.nuclidesPanel.add((Component)this.nuclidesScrollPane, gridBagConstraints);
        this.nuclidesScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.nuclidesScrollPane1.setPreferredSize(new Dimension(223, 270));
        this.nuclidesTable.setModel(new DefaultTableModel(new Object[][]{{"", null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Nuclide", "# of decays"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.nuclidesTable.setAutoResizeMode(4);
        this.nuclidesTable.setGridColor(new Color(204, 204, 204));
        this.nuclidesTable.setOpaque(false);
        this.nuclidesTable.setPreferredSize(new Dimension(200, 240));
        this.nuclidesTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, vColIndex);
                if (value instanceof Nuclide && MainFrame.hasCoincidenceData((Nuclide)value)) {
                    c.setForeground(Color.BLUE);
                }
                return c;
            }
        });
        this.nuclidesTable.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.nuclidesTable.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        this.nuclidesTable.getColumnModel().getColumn(0).setHeaderRenderer(new HeaderRenderer());
        this.nuclidesTable.getColumnModel().getColumn(1).setHeaderRenderer(new HeaderRenderer());
        this.nuclidesTable.getTableHeader().setReorderingAllowed(false);
        this.nuclidesTable.setSelectionMode(0);
        this.nuclidesScrollPane1.setViewportView(this.nuclidesTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.nuclidesPanel.add((Component)this.nuclidesScrollPane1, gridBagConstraints);
        this.nuclideLabel.setText(" Nuclide list");
        this.nuclideLabel.setMinimumSize(new Dimension(210, 15));
        this.nuclideLabel.setPreferredSize(new Dimension(210, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 50, 0, 0);
        this.nuclidesPanel.add((Component)this.nuclideLabel, gridBagConstraints);
        this.nuclidePropertiesLabel.setText(" Nuclide properties");
        this.nuclidePropertiesLabel.setPreferredSize(new Dimension(210, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 120;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 50, 0, 0);
        this.nuclidesPanel.add((Component)this.nuclidePropertiesLabel, gridBagConstraints);
        this.selectedNuclidesLabel.setText(" Nuclides selected for simulation");
        this.selectedNuclidesLabel.setToolTipText("Nuclides with coincidence data are shown in blue");
        this.selectedNuclidesLabel.setPreferredSize(new Dimension(200, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 45;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.nuclidesPanel.add((Component)this.selectedNuclidesLabel, gridBagConstraints);
        this.openLibrary.setBackground(new Color(102, 102, 102));
        this.openLibrary.setForeground(new Color(255, 255, 255));
        this.openLibrary.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/OpenSmall.png")));
        this.openLibrary.setToolTipText("Load the nuclide list from a library");
        this.openLibrary.setFocusable(false);
        this.openLibrary.setPreferredSize(new Dimension(18, 16));
        this.openLibrary.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.openLibraryMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 50, 0, 0);
        this.nuclidesPanel.add((Component)this.openLibrary, gridBagConstraints);
        this.lineEnergyField.setBorder(new SoftBevelBorder(1));
        this.lineEnergyField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.lineEnergyField.setMinimumSize(new Dimension(55, 16));
        this.lineEnergyField.setPreferredSize(new Dimension(55, 16));
        this.lineEnergyField.setRowSelectionAllowed(false);
        this.lineEnergyField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.lineEnergyField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.nuclidesPanel.add((Component)this.lineEnergyField, gridBagConstraints);
        this.mevLabel.setText("MeV   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.nuclidesPanel.add((Component)this.mevLabel, gridBagConstraints);
        this.decaysLabel.setText("Number of decays");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.nuclidesPanel.add((Component)this.decaysLabel, gridBagConstraints);
        this.decaysField.setBorder(new SoftBevelBorder(1));
        this.decaysField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.decaysField.setRowSelectionAllowed(false);
        this.decaysField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.decaysField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.nuclidesPanel.add((Component)this.decaysField, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.nuclidesPanel);
        this.nuclidesFrame.getContentPane().add((Component)this.jScrollPane3, "Center");
        this.nuclidesFrame.setBounds(10, 370, 600, 380);
        this.sourceDesktop.add((Component)this.nuclidesFrame, JLayeredPane.DEFAULT_LAYER);
        this.tabsPane.addTab("Source", this.sourceDesktop);
        this.layersFrame.setIconifiable(true);
        this.layersFrame.setResizable(true);
        this.layersFrame.setTitle("Absorbing Layers");
        this.layersFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/LayersIcon.png")));
        this.layersFrame.setPreferredSize(new Dimension(410, 320));
        this.layersFrame.setVisible(true);
        this.layersFrame.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameActivated(InternalFrameEvent evt) {
                MainFrame.this.internalFrameActivated(evt);
            }

            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jScrollPane9.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.layersPanel.setPreferredSize(new Dimension(380, 277));
        this.layersPanel.setLayout(new GridBagLayout());
        this.layersTable.setBorder(new SoftBevelBorder(1));
        this.layersTable.setModel(new DefaultTableModel(new Object[][]{{""}, {null}, {null}, {null}, {null}, {null}, {null}}, new String[]{"Title 1"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.layersTable.setAutoResizeMode(4);
        this.layersTable.setGridColor(new Color(204, 204, 204));
        this.initLayerTable();
        this.initTableListeners(this.layersTable);
        this.layersTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(5, 40, 0, 0);
        this.layersPanel.add((Component)this.layersTable, gridBagConstraints);
        this.deleteLayerButton.setText("Delete layer");
        this.deleteLayerButton.setToolTipText("Remove selected layer");
        this.deleteLayerButton.setMaximumSize(new Dimension(105, 23));
        this.deleteLayerButton.setMinimumSize(new Dimension(105, 23));
        this.deleteLayerButton.setPreferredSize(new Dimension(65, 23));
        this.deleteLayerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.deleteLayerButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 10, 0, 0);
        this.layersPanel.add((Component)this.deleteLayerButton, gridBagConstraints);
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setMinimumSize(new Dimension(140, 77));
        this.jScrollPane1.setPreferredSize(new Dimension(140, 77));
        this.jScrollPane1.setColumnHeader(null);
        this.layerMaterialElementsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1"}));
        this.layerMaterialElementsTable.setToolTipText("The elements in the mixture. Click to edit.");
        this.layerMaterialElementsTable.setAutoResizeMode(4);
        this.layerMaterialElementsTable.setEnabled(false);
        this.layerMaterialElementsTable.setGridColor(new Color(204, 204, 204));
        this.layerMaterialElementsTable.setPreferredSize(new Dimension(110, 74));
        this.layerMaterialElementsTable.setRowSelectionAllowed(false);
        this.layerMaterialElementsTable.setShowVerticalLines(false);
        this.initElementTable(this.layerMaterialElementsTable);
        this.layerMaterialElementsTable.getColumnModel().getColumn(0).setCellRenderer(new ElementRenderer());
        this.layerMaterialElementsTable.getColumnModel().getColumn(0).setCellEditor(new ElementEditor(this, this.layersFrame, "LayerEditNumElems", 6000, "Layer element composition"));
        this.jScrollPane1.setViewportView(this.layerMaterialElementsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 6, 0);
        this.layersPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.layerMaterialPropertiesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.layerMaterialPropertiesTable.setAutoResizeMode(4);
        this.layerMaterialPropertiesTable.setEnabled(false);
        this.layerMaterialPropertiesTable.setGridColor(new Color(204, 204, 204));
        this.layerMaterialPropertiesTable.setOpaque(false);
        this.layerMaterialPropertiesTable.setPreferredSize(new Dimension(200, 50));
        this.layerMaterialPropertiesTable.setRowSelectionAllowed(false);
        this.layerMaterialPropertiesTable.setShowHorizontalLines(false);
        this.layerMaterialPropertiesTable.setShowVerticalLines(false);
        this.initMaterialTable(this.layerMaterialPropertiesTable);
        this.initTableListeners(this.layerMaterialPropertiesTable);
        this.layerMaterialPropertiesTable.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        this.layerMaterialPropertiesTable.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.layerMaterialPropertiesTable.getColumnModel().getColumn(0).setCellRenderer(new ParameterNameRenderer());
        this.layerMaterialPropertiesTable.getColumnModel().getColumn(2).setCellRenderer(new UnitRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 40, 0, 0);
        this.layersPanel.add((Component)this.layerMaterialPropertiesTable, gridBagConstraints);
        this.addLayerBtn.setText("Add layer");
        this.addLayerBtn.setToolTipText("Move the selected layer into the editing");
        this.addLayerBtn.setMaximumSize(new Dimension(105, 23));
        this.addLayerBtn.setMinimumSize(new Dimension(105, 23));
        this.addLayerBtn.setPreferredSize(new Dimension(105, 23));
        this.addLayerBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.addLayerBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.layersPanel.add((Component)this.addLayerBtn, gridBagConstraints);
        this.layersHeader.setText(" Layers");
        this.layersHeader.setMinimumSize(new Dimension(270, 15));
        this.layersHeader.setPreferredSize(new Dimension(270, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 40, 0, 1);
        this.layersPanel.add((Component)this.layersHeader, gridBagConstraints);
        this.layersHeader2.setText(" Layer properties");
        this.layersHeader2.setMinimumSize(new Dimension(200, 15));
        this.layersHeader2.setPreferredSize(new Dimension(200, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.layersPanel.add((Component)this.layersHeader2, gridBagConstraints);
        this.layersHeader3.setText(" Layer element composition");
        this.layersHeader3.setMaximumSize(new Dimension(140, 15));
        this.layersHeader3.setMinimumSize(new Dimension(140, 15));
        this.layersHeader3.setPreferredSize(new Dimension(140, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.layersPanel.add((Component)this.layersHeader3, gridBagConstraints);
        this.layersGroup.add(this.noAbsLayersBtn);
        this.noAbsLayersBtn.setText("No absorbing layers");
        this.noAbsLayersBtn.setToolTipText("Choose to use no absorbing layers");
        this.noAbsLayersBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.noAbsLayersBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.layersPanel.add((Component)this.noAbsLayersBtn, gridBagConstraints);
        this.layersGroup.add(this.absLayersBtn);
        this.absLayersBtn.setText("Use absorbing layers");
        this.absLayersBtn.setToolTipText("Choose to use absorbing layers defined below");
        this.absLayersBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.absLayersBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 10, 0, 0);
        this.layersPanel.add((Component)this.absLayersBtn, gridBagConstraints);
        this.jScrollPane9.setViewportView(this.layersPanel);
        this.layersFrame.getContentPane().add((Component)this.jScrollPane9, "Center");
        this.layersFrame.setBounds(340, 170, 420, 340);
        this.layersDesktop.add((Component)this.layersFrame, JLayeredPane.DEFAULT_LAYER);
        this.tabsPane.addTab("Absorbing layers", this.layersDesktop);
        this.backScatterFrame.setIconifiable(true);
        this.backScatterFrame.setResizable(true);
        this.backScatterFrame.setTitle("Coincidence data browser");
        this.backScatterFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/BackscatteringIcon.png")));
        this.backScatterFrame.setPreferredSize(new Dimension(350, 450));
        this.backScatterFrame.setVisible(true);
        this.backScatterFrame.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameActivated(InternalFrameEvent evt) {
                MainFrame.this.internalFrameActivated(evt);
            }

            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jScrollPane10.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.particlesPanel3.setMinimumSize(new Dimension(290, 450));
        this.particlesPanel3.setLayout(new AbsoluteLayout());
        this.coincidenceNuclidesScrollPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.coincidenceNuclidesScrollPane.setEnabled(false);
        this.coincidenceNuclidesScrollPane.setPreferredSize(new Dimension(469, 403));
        this.coincidenceNuclidesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Nuclide"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.coincidenceNuclidesTable.setAutoResizeMode(0);
        this.coincidenceNuclidesTable.setGridColor(new Color(204, 204, 204));
        this.coincidenceNuclidesTable.setOpaque(false);
        this.coincidenceNuclidesTable.setPreferredSize(new Dimension(200, 240));
        this.coincidenceNuclidesTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.coincidenceNuclidesTable.getColumnModel().getColumn(0).setHeaderRenderer(new HeaderRenderer());
        this.coincidenceNuclidesTable.getTableHeader().setReorderingAllowed(false);
        this.coincidenceNuclidesTable.setSelectionMode(0);
        this.coincidenceNuclidesTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                MainFrame.this.coincidenceNuclidesTableMousePressed(evt);
            }
        });
        this.coincidenceNuclidesScrollPane.setViewportView(this.coincidenceNuclidesTable);
        this.particlesPanel3.add((Component)this.coincidenceNuclidesScrollPane, new AbsoluteConstraints(40, 50, 240, 100));
        this.selectedNuclidesLabel1.setText(" Nuclides in the simulation with coincidence data");
        this.particlesPanel3.add((Component)this.selectedNuclidesLabel1, new AbsoluteConstraints(40, 30, 240, -1));
        this.browseCoincGroup.add(this.browseSimCoincidences);
        this.browseSimCoincidences.setSelected(true);
        this.browseSimCoincidences.setText("Browse coincidence data for nuclides in the simulation");
        this.browseSimCoincidences.setToolTipText("Browse coincidence data of nucllides selected for simulation");
        this.enableCoincidenceDataBrowsing(true);
        this.browseSimCoincidences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.browseSimCoincidencesActionPerformed(evt);
            }
        });
        this.particlesPanel3.add((Component)this.browseSimCoincidences, new AbsoluteConstraints(0, 0, -1, -1));
        this.browseCoincGroup.add(this.browseLibCoincidences);
        this.browseLibCoincidences.setText("Browse coincidence data for other nuclides in a library");
        this.browseLibCoincidences.setToolTipText("Browse coincidence data in a library");
        this.browseLibCoincidences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.browseLibCoincidencesActionPerformed(evt);
            }
        });
        this.particlesPanel3.add((Component)this.browseLibCoincidences, new AbsoluteConstraints(0, 150, -1, -1));
        this.nuclideLabel1.setText(" Nuclide list");
        this.particlesPanel3.add((Component)this.nuclideLabel1, new AbsoluteConstraints(40, 180, 240, -1));
        this.openLibrary1.setBackground(new Color(102, 102, 102));
        this.openLibrary1.setForeground(new Color(255, 255, 255));
        this.openLibrary1.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/OpenSmall.png")));
        this.openLibrary1.setText(" Detector file");
        this.openLibrary1.setToolTipText("Load the nuclide list from a library");
        this.openLibrary1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.openLibrary1MouseClicked(evt);
            }
        });
        this.particlesPanel3.add((Component)this.openLibrary1, new AbsoluteConstraints(40, 200, 18, 16));
        this.coincidenceNuclideComboBox.setToolTipText("Choose the nuclide to browse");
        this.coincidenceNuclideComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.coincidenceNuclideComboBoxActionPerformed(evt);
            }
        });
        this.particlesPanel3.add((Component)this.coincidenceNuclideComboBox, new AbsoluteConstraints(60, 200, 220, -1));
        this.selectedNuclidesLabel2.setText(" No data to show...");
        this.particlesPanel3.add((Component)this.selectedNuclidesLabel2, new AbsoluteConstraints(10, 230, 280, -1));
        this.nuclidesScrollPane2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.nuclidesScrollPane2.setHorizontalScrollBarPolicy(31);
        this.betaLinesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Beta line energy", "yield per transition", "X-ray energy"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.betaLinesTable.setAutoResizeMode(0);
        this.betaLinesTable.setGridColor(new Color(204, 204, 204));
        this.betaLinesTable.setOpaque(false);
        this.betaLinesTable.setPreferredSize(new Dimension(260, 63));
        this.betaLinesTable.setRowSelectionAllowed(false);
        this.betaLinesTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer(0));
        this.betaLinesTable.getColumnModel().getColumn(1).setCellRenderer(new BasicRenderer(1));
        this.betaLinesTable.getColumnModel().getColumn(2).setCellRenderer(new BasicRenderer(1));
        this.betaLinesTable.getColumnModel().getColumn(0).setHeaderRenderer(new HeaderRenderer());
        this.betaLinesTable.getColumnModel().getColumn(1).setHeaderRenderer(new HeaderRenderer());
        this.betaLinesTable.getColumnModel().getColumn(2).setHeaderRenderer(new HeaderRenderer());
        this.betaLinesTable.getTableHeader().setReorderingAllowed(false);
        this.nuclidesScrollPane2.setViewportView(this.betaLinesTable);
        this.particlesPanel3.add((Component)this.nuclidesScrollPane2, new AbsoluteConstraints(10, 330, 280, 80));
        this.nuclidesScrollPane3.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.nuclidesScrollPane3.setHorizontalScrollBarPolicy(31);
        this.gammaLinesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Gamma line energy", "yield per transition"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.gammaLinesTable.setAutoResizeMode(0);
        this.gammaLinesTable.setGridColor(new Color(204, 204, 204));
        this.gammaLinesTable.setOpaque(false);
        this.gammaLinesTable.setPreferredSize(new Dimension(260, 63));
        this.gammaLinesTable.setRowSelectionAllowed(false);
        this.gammaLinesTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer(0));
        this.gammaLinesTable.getColumnModel().getColumn(1).setCellRenderer(new BasicRenderer(1));
        this.gammaLinesTable.getColumnModel().getColumn(0).setHeaderRenderer(new HeaderRenderer());
        this.gammaLinesTable.getColumnModel().getColumn(1).setHeaderRenderer(new HeaderRenderer());
        this.gammaLinesTable.getTableHeader().setReorderingAllowed(false);
        this.nuclidesScrollPane3.setViewportView(this.gammaLinesTable);
        this.particlesPanel3.add((Component)this.nuclidesScrollPane3, new AbsoluteConstraints(10, 250, 280, 80));
        this.jScrollPane10.setViewportView(this.particlesPanel3);
        this.backScatterFrame.getContentPane().add((Component)this.jScrollPane10, "Center");
        this.backScatterFrame.setBounds(50, 120, 310, 450);
        this.coincidencesDesktop.add((Component)this.backScatterFrame, JLayeredPane.DEFAULT_LAYER);
        this.coincidenceFrame.setIconifiable(true);
        this.coincidenceFrame.setResizable(true);
        this.coincidenceFrame.setTitle("Coincidences & backscattering");
        this.coincidenceFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/CoincidencesIcon.png")));
        this.coincidenceFrame.setPreferredSize(new Dimension(430, 350));
        this.coincidenceFrame.setVisible(true);
        this.jScrollPane11.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.particlesPanel4.setMinimumSize(new Dimension(400, 420));
        this.particlesPanel4.setPreferredSize(new Dimension(350, 350));
        this.particlesPanel4.setLayout(new AbsoluteLayout());
        this.coincidencesCheckbox.setText("Calculate coincidences");
        this.coincidencesCheckbox.setToolTipText("Enables the calculation of coincidences for the nuclides that have coincidence data");
        this.coincidencesCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.checkBox_handleActionPerformed(evt);
            }
        });
        this.particlesPanel4.add((Component)this.coincidencesCheckbox, new AbsoluteConstraints(10, 0, 360, -1));
        this.trackAlphaCheckBox.setText("Track alpha particles in the backingplate");
        this.trackAlphaCheckBox.setToolTipText("Enable alpha particle tracking in the backingplate");
        this.trackAlphaCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.checkBox_handleActionPerformed(evt);
            }
        });
        this.particlesPanel4.add((Component)this.trackAlphaCheckBox, new AbsoluteConstraints(10, 60, 340, -1));
        this.includeBackingplateCheckbox.setText("Include backingplate in calculations");
        this.includeBackingplateCheckbox.setToolTipText("Includes the backingplate in the calculations.");
        this.includeBackingplateCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.checkBox_handleActionPerformed(evt);
            }
        });
        this.particlesPanel4.add((Component)this.includeBackingplateCheckbox, new AbsoluteConstraints(10, 40, 370, -1));
        this.headerLabel27.setText(" Shielding model");
        this.particlesPanel4.add((Component)this.headerLabel27, new AbsoluteConstraints(10, 140, 330, -1));
        this.shieldingModelCombobox.setToolTipText("Choose shielding model");
        this.shieldingModelCombobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.shieldingCombo_handleActionPerformed(evt);
            }
        });
        this.particlesPanel4.add((Component)this.shieldingModelCombobox, new AbsoluteConstraints(10, 160, 180, -1));
        this.parallelbeamCheckbox.setText("Parallel beam emission with full particle tracking");
        this.parallelbeamCheckbox.setToolTipText("Emits a parallel beam with full tracking for electrons");
        this.parallelbeamCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.checkBox_handleActionPerformed(evt);
            }
        });
        this.particlesPanel4.add((Component)this.parallelbeamCheckbox, new AbsoluteConstraints(10, 180, 370, -1));
        this.linearDepositionCheckbox.setText("Linear deposition model in the dead layer (electrons only)");
        this.linearDepositionCheckbox.setToolTipText("Use linear deposition model for electrons");
        this.linearDepositionCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.checkBox_handleActionPerformed(evt);
            }
        });
        this.particlesPanel4.add((Component)this.linearDepositionCheckbox, new AbsoluteConstraints(10, 200, 390, -1));
        this.headerLabel25.setText(" Backingplate material");
        this.particlesPanel4.add((Component)this.headerLabel25, new AbsoluteConstraints(10, 230, 330, -1));
        this.backingplateMaterialCombobox.setToolTipText("Choose backingplate material");
        this.backingplateMaterialCombobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.materialCombobox_handleActionPerformed(evt);
            }
        });
        this.particlesPanel4.add((Component)this.backingplateMaterialCombobox, new AbsoluteConstraints(10, 250, 330, -1));
        this.headerLabel26.setText(" Backingplate material properties");
        this.particlesPanel4.add((Component)this.headerLabel26, new AbsoluteConstraints(10, 280, 330, -1));
        this.backingplateMaterialPropertiesTable.setModel(new DefaultTableModel(new Object[][]{{"", null, ""}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.backingplateMaterialPropertiesTable.setAutoResizeMode(0);
        this.backingplateMaterialPropertiesTable.setGridColor(new Color(204, 204, 204));
        this.backingplateMaterialPropertiesTable.setOpaque(false);
        this.backingplateMaterialPropertiesTable.setRowSelectionAllowed(false);
        this.backingplateMaterialPropertiesTable.setShowHorizontalLines(false);
        this.backingplateMaterialPropertiesTable.setShowVerticalLines(false);
        this.initMaterialTable(this.backingplateMaterialPropertiesTable);
        this.backingplateMaterialPropertiesTable.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        this.backingplateMaterialPropertiesTable.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.backingplateMaterialPropertiesTable.getColumnModel().getColumn(0).setCellRenderer(new BasicRenderer());
        this.backingplateMaterialPropertiesTable.getColumnModel().getColumn(2).setCellRenderer(new BasicRenderer());
        this.particlesPanel4.add((Component)this.backingplateMaterialPropertiesTable, new AbsoluteConstraints(10, 340, 190, -1));
        this.backingplateMaterialPropertiesTable1.setModel(new DefaultTableModel(new Object[][]{{"", null, ""}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.backingplateMaterialPropertiesTable1.setAutoResizeMode(0);
        this.backingplateMaterialPropertiesTable1.setGridColor(new Color(204, 204, 204));
        this.backingplateMaterialPropertiesTable1.setOpaque(false);
        this.backingplateMaterialPropertiesTable1.setRowSelectionAllowed(false);
        this.backingplateMaterialPropertiesTable1.setShowHorizontalLines(false);
        this.backingplateMaterialPropertiesTable1.setShowVerticalLines(false);
        this.initMaterialTable(this.backingplateMaterialPropertiesTable1);
        this.backingplateMaterialPropertiesTable1.getColumnModel().getColumn(1).setCellEditor(new ParameterEditor());
        this.backingplateMaterialPropertiesTable1.getColumnModel().getColumn(1).setCellRenderer(new ParameterRenderer());
        this.backingplateMaterialPropertiesTable1.getColumnModel().getColumn(0).setCellRenderer(new ParameterNameRenderer());
        this.backingplateMaterialPropertiesTable1.getColumnModel().getColumn(2).setCellRenderer(new UnitRenderer());
        this.initBackingplateMaterialTable();
        this.particlesPanel4.add((Component)this.backingplateMaterialPropertiesTable1, new AbsoluteConstraints(10, 300, 190, -1));
        this.coincidenceOutputFileField.setToolTipText("The output file path");
        this.coincidenceOutputFileField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.coincidenceOutputFileFieldActionPerformed(evt);
            }
        });
        this.coincidenceOutputFileField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MainFrame.this.coincidenceOutputFileFieldKeyReleased(evt);
            }
        });
        this.particlesPanel4.add((Component)this.coincidenceOutputFileField, new AbsoluteConstraints(30, 110, 310, -1));
        this.headerLabel31.setText(" Coincidence output file");
        this.particlesPanel4.add((Component)this.headerLabel31, new AbsoluteConstraints(10, 90, 330, -1));
        this.openLibrary2.setBackground(new Color(102, 102, 102));
        this.openLibrary2.setForeground(new Color(255, 255, 255));
        this.openLibrary2.setIcon(new ImageIcon(this.getClass().getResource("/UI/images/OpenSmall.png")));
        this.openLibrary2.setText(" Detector file");
        this.openLibrary2.setToolTipText("Choose the output file");
        this.openLibrary2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.openLibrary2MouseClicked(evt);
            }
        });
        this.particlesPanel4.add((Component)this.openLibrary2, new AbsoluteConstraints(10, 110, 18, 16));
        this.coincidencesCheckbox1.setText("Store coincidence output in a file");
        this.coincidencesCheckbox1.setToolTipText("Enables the storing of coincidence data into a file");
        this.coincidencesCheckbox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.coincidencesCheckbox1checkBox_handleActionPerformed(evt);
            }
        });
        this.particlesPanel4.add((Component)this.coincidencesCheckbox1, new AbsoluteConstraints(10, 20, 360, -1));
        this.jScrollPane11.setViewportView(this.particlesPanel4);
        this.coincidenceFrame.getContentPane().add((Component)this.jScrollPane11, "Center");
        this.coincidenceFrame.setBounds(690, 90, 430, 470);
        this.coincidencesDesktop.add((Component)this.coincidenceFrame, JLayeredPane.DEFAULT_LAYER);
        this.tabsPane.addTab("Coincidences & Backscattering", null, this.coincidencesDesktop, "Define coincidence and backscattering properties");
        this.paramsFrame.setIconifiable(true);
        this.paramsFrame.setResizable(true);
        this.paramsFrame.setTitle("Run spectrum simulation");
        this.paramsFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/UI/images/RunningParamsIcon.png")));
        this.paramsFrame.setPreferredSize(new Dimension(430, 230));
        this.paramsFrame.setVisible(true);
        this.jPanel2.setPreferredSize(new Dimension(418, 30));
        this.jPanel2.setLayout(new FlowLayout(1, 2, 2));
        this.runButton.setText("Run simulation");
        this.runButton.setToolTipText("Begin the simulation run");
        this.runButton.setPreferredSize(null);
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.runButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.runButton);
        this.paramsFrame.getContentPane().add((Component)this.jPanel2, "South");
        this.jScrollPane12.setPreferredSize(new Dimension(428, 173));
        this.paramsPanel.setBorder(new SoftBevelBorder(1));
        this.paramsPanel.setMinimumSize(new Dimension(470, 150));
        this.paramsPanel.setPreferredSize(new Dimension(370, 150));
        this.paramsPanel.setLayout(new GridBagLayout());
        this.jLabel43.setText("Energy bin size");
        this.jLabel43.setMaximumSize(new Dimension(110, 15));
        this.jLabel43.setMinimumSize(new Dimension(110, 15));
        this.jLabel43.setPreferredSize(new Dimension(110, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.paramsPanel.add((Component)this.jLabel43, gridBagConstraints);
        this.jLabel44.setText("keV");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 120;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.paramsPanel.add((Component)this.jLabel44, gridBagConstraints);
        this.stragglingCheckBox.setText("Include Gaussian straggling");
        this.stragglingCheckBox.setToolTipText("Include gaussian straggling");
        this.stragglingCheckBox.setMaximumSize(new Dimension(180, 23));
        this.stragglingCheckBox.setMinimumSize(new Dimension(180, 23));
        this.stragglingCheckBox.setPreferredSize(new Dimension(180, 23));
        this.stragglingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.stragglingCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.paramsPanel.add((Component)this.stragglingCheckBox, gridBagConstraints);
        this.selfabsCheckBox.setText("Self-absorption");
        this.selfabsCheckBox.setToolTipText("Toggle self-absorption in the source on/off");
        this.selfabsCheckBox.setEnabled(false);
        this.selfabsCheckBox.setRequestFocusEnabled(false);
        this.selfabsCheckBox.setVisible(false);
        this.selfabsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.selfabsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.paramsPanel.add((Component)this.selfabsCheckBox, gridBagConstraints);
        this.energyBinField.setBorder(new SoftBevelBorder(1));
        this.energyBinField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.energyBinField.setAutoResizeMode(4);
        this.energyBinField.setMinimumSize(new Dimension(100, 16));
        this.energyBinField.setPreferredSize(new Dimension(50, 16));
        this.energyBinField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.energyBinField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.paramsPanel.add((Component)this.energyBinField, gridBagConstraints);
        this.jCheckBox1.setText("Plot sum graph only for multiple nuclide simulation");
        this.jCheckBox1.setToolTipText("When selected, plots only the sum graph for simulations with multiple nuclides");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jCheckBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 29;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.paramsPanel.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jCheckBox2.setText("Popup info window after simulation");
        this.jCheckBox2.setToolTipText("When selected, pops up the Simulation info browser after simulation");
        this.jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jCheckBox2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.paramsPanel.add((Component)this.jCheckBox2, gridBagConstraints);
        this.jLabel49.setText("Integration step");
        this.jLabel49.setHorizontalTextPosition(4);
        this.jLabel49.setMaximumSize(new Dimension(110, 15));
        this.jLabel49.setMinimumSize(new Dimension(110, 15));
        this.jLabel49.setPreferredSize(new Dimension(110, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 0, 0);
        this.paramsPanel.add((Component)this.jLabel49, gridBagConstraints);
        this.integrationStepField.setBorder(new SoftBevelBorder(1));
        this.integrationStepField.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        this.integrationStepField.setAutoResizeMode(4);
        this.integrationStepField.setMinimumSize(new Dimension(100, 16));
        this.integrationStepField.setPreferredSize(new Dimension(50, 16));
        this.integrationStepField.getColumnModel().getColumn(0).setCellRenderer(new ParameterRenderer(true));
        this.integrationStepField.getColumnModel().getColumn(0).setCellEditor(new ParameterEditor(true));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(4, 10, 0, 0);
        this.paramsPanel.add((Component)this.integrationStepField, gridBagConstraints);
        this.jLabel50.setHorizontalAlignment(2);
        this.jLabel50.setText("\u00b5m");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 120;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 0, 0);
        this.paramsPanel.add((Component)this.jLabel50, gridBagConstraints);
        this.srcDetectorCheckBox.setText("Emissions to source detector cone only");
        this.srcDetectorCheckBox.setToolTipText("Alpha particles will be emitted into the source - detector cone only");
        this.srcDetectorCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.srcDetectorCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.paramsPanel.add((Component)this.srcDetectorCheckBox, gridBagConstraints);
        this.jScrollPane12.setViewportView(this.paramsPanel);
        this.paramsFrame.getContentPane().add((Component)this.jScrollPane12, "Center");
        this.paramsFrame.setBounds(180, 400, 390, 240);
        this.calculateDesktop.add((Component)this.paramsFrame, JLayeredPane.DEFAULT_LAYER);
        this.tabsPane.addTab("Simulation", this.calculateDesktop);
        this.getContentPane().add((Component)this.tabsPane, "Center");
        this.statusPanel.setLayout(new BorderLayout());
        this.timeField.setEditable(false);
        this.timeField.setText("version. 2.0");
        this.timeField.setBorder(new SoftBevelBorder(1));
        this.timeField.setPreferredSize(new Dimension(157, 21));
        this.statusPanel.add((Component)this.timeField, "West");
        this.statusPanel.add((Component)this.jPanel1, "North");
        this.memField.setEditable(false);
        this.memField.setText("Mem:256MB");
        this.memField.setBorder(new SoftBevelBorder(1));
        this.memField.setPreferredSize(new Dimension(157, 21));
        this.statusPanel.add((Component)this.memField, "East");
        this.jTextField3.setEditable(false);
        this.jTextField3.setBorder(new SoftBevelBorder(1));
        this.jTextField3.setPreferredSize(new Dimension(157, 21));
        this.statusPanel.add((Component)this.jTextField3, "Center");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.fileMenu.setText("File");
        this.fileMenu.setMnemonic('F');
        this.fileOpenItem.setText("Open input & detector");
        this.fileOpenItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.fileOpenItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.fileOpenItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileOpenItem);
        this.fileMenu.add(this.jSeparator6);
        this.fileSaveItem.setText("Save input");
        this.fileSaveItem.setEnabled(false);
        this.fileSaveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.fileSaveItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileSaveItem);
        this.fileSaveAsItem.setText("Save input as...");
        this.fileSaveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileSaveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.fileSaveAsItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileSaveAsItem);
        this.fileMenu.add(this.jSeparator1);
        this.fileSaveDetAs.setText("Save detector as...");
        this.fileSaveDetAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.fileSaveDetAsActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileSaveDetAs);
        this.fileMenu.add(this.jSeparator7);
        this.fileExitItem.setText("Exit");
        this.fileExitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.fileExitItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileExitItem);
        this.menuBar.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.viewMenu.setMnemonic('V');
        this.sketchWindowMenuItem.setText("Sketch window");
        this.sketchWindowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.sketchWindowMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.sketchWindowMenuItem);
        this.logWindowMenuItem.setText("Log window");
        this.logWindowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.logWindowMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.logWindowMenuItem);
        this.notesMenuItem.setText("Notes window");
        this.notesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.notesMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.notesMenuItem);
        this.viewMenu.add(this.jSeparator10);
        this.LafMenu.setText("Look & feel");
        this.viewMenu.add(this.LafMenu);
        this.viewMenu.add(this.jSeparator2);
        this.infoViewMenuItem.setText("Simulation info browser");
        this.infoViewMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.infoViewMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.infoViewMenuItem);
        this.viewMenu.add(this.jSeparator9);
        this.plotTabMenuItem.setText("Plot page");
        this.plotTabMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.plotTabMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.plotTabMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.plotTabMenuItem);
        this.menuBar.add(this.viewMenu);
        this.runMenu.setText("Run");
        this.runMenu.setMnemonic('R');
        this.runMenuItem.setText("Run simulation");
        this.runMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.runMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.runMenuItemActionPerformed(evt);
            }
        });
        this.runMenu.add(this.runMenuItem);
        this.runMenu.add(this.jSeparator3);
        this.runGeometricEfficiencyMenuItem.setText("Run geometric efficiency calculation...");
        this.runGeometricEfficiencyMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.runGeometricEfficiencyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.runGeometricEfficiencyMenuItemActionPerformed(evt);
            }
        });
        this.runMenu.add(this.runGeometricEfficiencyMenuItem);
        this.menuBar.add(this.runMenu);
        this.windowMenu.setText("Window");
        this.windowMenu.setMnemonic('W');
        this.cascadeMenuItem.setText("Cascade");
        this.cascadeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cascadeMenuItemActionPerformed(evt);
            }
        });
        this.windowMenu.add(this.cascadeMenuItem);
        this.tileMenuItem.setText("Tile");
        this.tileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.tileMenuItemActionPerformed(evt);
            }
        });
        this.windowMenu.add(this.tileMenuItem);
        this.windowMenu.add(this.jSeparator8);
        this.minimizeAllMenuItem.setText("Minimize all");
        this.minimizeAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.minimizeAllMenuItemActionPerformed(evt);
            }
        });
        this.windowMenu.add(this.minimizeAllMenuItem);
        this.maximizeAll.setText("Maximize all");
        this.maximizeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.maximizeAllActionPerformed(evt);
            }
        });
        this.windowMenu.add(this.maximizeAll);
        this.menuBar.add(this.windowMenu);
        this.helpMenu.setText("Help");
        this.helpMenu.setMnemonic('H');
        this.helpMenuItem.setText("Help");
        this.helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.helpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.helpMenu.add(this.jSeparator4);
        this.helpWelcomeItem.setText("Show welcome page");
        this.helpWelcomeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.helpWelcomeItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpWelcomeItem);
        this.helpAboutItem.setText("About...");
        this.helpAboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.helpAboutItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpAboutItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    private void fileSaveDetAsActionPerformed(ActionEvent evt) {
        this.saveDetectorMouseReleased(null);
    }

    private void stragglingCheckBoxActionPerformed(ActionEvent evt) {
        Parameter p = Main.getParameter("1012");
        p.setValue(this.stragglingCheckBox.isSelected() ? new Float(1.0) : new Float(-1.0f));
    }

    private void srcDetectorCheckBoxActionPerformed(ActionEvent evt) {
        Parameter p = Main.getParameter("1505");
        p.setValue(this.srcDetectorCheckBox.isSelected() ? "y" : "n");
    }

    private void infoViewMenuItemActionPerformed(ActionEvent evt) {
        Main.showInfoWindow();
    }

    private void coincidenceNuclideComboBoxActionPerformed(ActionEvent evt) {
        if (this.loadingCoincidenceData) {
            return;
        }
        Object o = this.coincidenceNuclideComboBox.getSelectedItem();
        if (o == null || !(o instanceof Nuclide)) {
            return;
        }
        this.showCoincidenceData((Nuclide)o);
    }

    private void openLibrary1MouseClicked(MouseEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            FileFilter f1 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return false;
                    }
                    return MainFrame.this.getExtension(f).equals("xml");
                }

                public String getDescription() {
                    return "(.xml) xml format nuclide library.";
                }
            };
            chooser.addChoosableFileFilter(f1);
            chooser.setCurrentDirectory(new File(Main.workingDir));
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                String oldPath = Main.nuclideLibraryPath;
                Main.nuclideLibraryPath = chooser.getSelectedFile().getCanonicalPath();
                Main.readNuclides();
                List nuc = Main.getNuclides();
                this.coincidenceNuclideComboBox.removeAllItems();
                int numAdded = 0;
                this.clearTable(this.betaLinesTable, true);
                this.clearTable(this.gammaLinesTable, true);
                for (int i = 0; i < nuc.size(); ++i) {
                    Nuclide n = (Nuclide)nuc.get(i);
                    if (!MainFrame.hasCoincidenceData(n) || n.getName().equals("BSC")) continue;
                    this.coincidenceNuclideComboBox.addItem(n);
                    ++numAdded;
                }
                this.nuclideLabel1.setText(" Coincidence data in " + chooser.getSelectedFile().getName());
                if (numAdded == 0) {
                    this.coincidenceNuclideComboBox.addItem("No coincidence data");
                }
                Main.nuclideLibraryPath = oldPath;
                Main.readNuclides();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showCoincidenceData(Nuclide n) {
        this.clearTable(this.gammaLinesTable, true);
        this.clearTable(this.betaLinesTable, true);
        List l = n.getLines();
        this.selectedNuclidesLabel2.setText(" Coincidence data for " + n.getName());
        for (int i = 0; i < l.size(); ++i) {
            Float f2;
            Float f1;
            Line line = (Line)l.get(i);
            String type = line.getLineType();
            if (type.equalsIgnoreCase("e")) {
                f1 = new Float(line.getLineEnergy().floatValue());
                f2 = new Float(line.getLineYield().floatValue());
                Float f3 = new Float(line.getXRayEnergy().floatValue());
                Object[] rowd = new Object[]{f1.toString() + " keV", f2.floatValue() * 100.0f + " %", f3.toString() + " keV"};
                ((DefaultTableModel)this.betaLinesTable.getModel()).addRow(rowd);
                continue;
            }
            if (!type.equalsIgnoreCase("g")) continue;
            f1 = new Float(line.getLineEnergy().floatValue());
            f2 = new Float(line.getLineYield().floatValue());
            Object[] rowd = new Object[]{f1 + " keV", f2.floatValue() * 100.0f + " %"};
            ((DefaultTableModel)this.gammaLinesTable.getModel()).addRow(rowd);
        }
        int h = this.betaLinesTable.getRowCount() * this.betaLinesTable.getRowHeight();
        this.resizeTable(this.betaLinesTable);
        this.resizeTable(this.gammaLinesTable);
    }

    private void coincidenceNuclidesTableMousePressed(MouseEvent evt) {
        if (!this.coincidenceNuclidesTable.isEnabled()) {
            return;
        }
        int row = this.coincidenceNuclidesTable.rowAtPoint(evt.getPoint());
        if (row < 0) {
            return;
        }
        Nuclide n = (Nuclide)this.coincidenceNuclidesTable.getValueAt(row, 0);
        if (n == null) {
            this.selectedNuclidesLabel2.setText(" No data to show...");
            return;
        }
        this.showCoincidenceData(n);
    }

    private void browseLibCoincidencesActionPerformed(ActionEvent evt) {
        this.clearTable(this.gammaLinesTable, true);
        this.clearTable(this.betaLinesTable, true);
        this.selectedNuclidesLabel2.setText(" No data to show...");
        this.enableCoincidenceDataBrowsing(this.browseSimCoincidences.isSelected());
        this.coincidenceNuclidesTable.getSelectionModel().clearSelection();
    }

    private void browseSimCoincidencesActionPerformed(ActionEvent evt) {
        this.clearTable(this.gammaLinesTable, true);
        this.clearTable(this.betaLinesTable, true);
        this.enableCoincidenceDataBrowsing(this.browseSimCoincidences.isSelected());
    }

    public String getExtension(File f) {
        String ext = "";
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private void openLibraryMouseClicked(MouseEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            FileFilter f1 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return MainFrame.this.getExtension(f).equals("xml");
                }

                public String getDescription() {
                    return "(.xml) xml format nuclide library.";
                }
            };
            chooser.addChoosableFileFilter(f1);
            chooser.setCurrentDirectory(new File(Main.workingDir));
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                Main.nuclideLibraryPath = chooser.getSelectedFile().getCanonicalPath();
                Parameter p = Main.getParameter("1030");
                p.setValue("'" + chooser.getSelectedFile().getAbsolutePath() + "'");
                Main.readNuclides();
                this.nuclideLabel.setText(" Nuclide list (" + chooser.getSelectedFile().getName() + ")");
                this.nuclideComboBox.removeAllItems();
                List l = Main.getNuclides();
                for (int i = 0; i < l.size(); ++i) {
                    Nuclide n = (Nuclide)l.get(i);
                    if (n.getName().equalsIgnoreCase("BSC")) continue;
                    this.nuclideComboBox.addItem(n);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String fixPath(String path) {
        char[] ch = path.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] != '\\') continue;
            ch[i] = 47;
        }
        return new String(ch);
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        Main.setPopupInfoWindow(this.jCheckBox2.isSelected());
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.sumOnly = this.jCheckBox1.isSelected();
    }

    private void helpWelcomeItemActionPerformed(ActionEvent evt) {
        if (!(this.tabsPane.getComponentAt(0) instanceof WelcomePanel)) {
            this.addWelcomeTab();
        }
        this.tabsPane.setSelectedIndex(0);
    }

    private void plotTabMenuItemActionPerformed(ActionEvent evt) {
        if (this.plotPanel == null) {
            this.addPlotTab();
        } else {
            this.tabsPane.remove(this.plotPanel);
            this.plotPanel = null;
        }
    }

    private void maximizeAllActionPerformed(ActionEvent evt) {
        Component c = this.tabsPane.getSelectedComponent();
        if (c instanceof JDesktopPane) {
            JDesktopPane p = (JDesktopPane)c;
            JInternalFrame[] frames = p.getAllFrames();
            for (int i = 0; i < frames.length; ++i) {
                try {
                    frames[i].setIcon(false);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void minimizeAllMenuItemActionPerformed(ActionEvent evt) {
        Component c = this.tabsPane.getSelectedComponent();
        if (c instanceof JDesktopPane) {
            JDesktopPane p = (JDesktopPane)c;
            JInternalFrame[] frames = p.getAllFrames();
            for (int i = 0; i < frames.length; ++i) {
                try {
                    frames[i].setIcon(true);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void tileMenuItemActionPerformed(ActionEvent evt) {
        Component c = this.tabsPane.getSelectedComponent();
        if (c instanceof JDesktopPane) {
            JDesktopPane p = (JDesktopPane)c;
            JInternalFrame[] frames = p.getAllFrames();
            int x = 0;
            int y = 0;
            int maxH = -1;
            int mw = Toolkit.getDefaultToolkit().getScreenSize().width;
            for (int i = 0; i < frames.length; ++i) {
                frames[i].setLocation(x, y);
                int h = frames[i].getHeight();
                if (h > maxH) {
                    maxH = h;
                }
                if ((x += frames[i].getWidth()) <= mw) continue;
                x = 0;
                y += maxH;
                maxH = -1;
            }
        }
    }

    private void cascadeMenuItemActionPerformed(ActionEvent evt) {
        Component c = this.tabsPane.getSelectedComponent();
        if (c instanceof JDesktopPane) {
            JDesktopPane p = (JDesktopPane)c;
            JInternalFrame[] frames = p.getAllFrames();
            int x = 0;
            int y = 0;
            for (int i = 0; i < frames.length; ++i) {
                frames[i].setLocation(x, y);
                frames[i].grabFocus();
                frames[i].setLayer(i);
                x += 10;
                y += 10;
            }
        }
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        Help.showHelp();
    }

    private void noAbsLayersBtnActionPerformed(ActionEvent evt) {
        if (this.loaded) {
            Main.getParameter("1008").setValue(new Integer(0));
        }
        this.layersHeader.setEnabled(false);
        this.layersHeader2.setEnabled(false);
        this.layersHeader3.setEnabled(false);
        this.layerMaterialPropertiesTable.setEnabled(false);
        this.layerMaterialElementsTable.setEnabled(false);
        this.layersTable.setEnabled(false);
        this.addLayerBtn.setEnabled(false);
        this.deleteLayerButton.setEnabled(false);
        this.layersFrame.repaint();
        if (this.sketchPanel != null) {
            this.sketchPanel.refresh();
        }
    }

    private void absLayersBtnActionPerformed(ActionEvent evt) {
        if (this.loaded) {
            Main.getParameter("1008").setValue(new Integer(this.firstUnusedRow(this.layersTable, 0)));
        }
        this.layersHeader.setEnabled(true);
        this.layersHeader2.setEnabled(true);
        this.layersHeader3.setEnabled(true);
        this.layerMaterialPropertiesTable.setEnabled(true);
        this.layerMaterialElementsTable.setEnabled(true);
        this.layersTable.setEnabled(true);
        this.addLayerBtn.setEnabled(true);
        this.deleteLayerButton.setEnabled(true);
        this.layersFrame.repaint();
        if (this.sketchPanel != null) {
            this.sketchPanel.refresh();
        }
    }

    private void openDetectorMouseClicked(MouseEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            FileFilter f1 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return MainFrame.this.getExtension(f).equals("det");
                }

                public String getDescription() {
                    return "(.det) AASI detector file.";
                }
            };
            chooser.addChoosableFileFilter(f1);
            chooser.setCurrentDirectory(new File(Main.workingDir));
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                Main.detectorPath = chooser.getSelectedFile().getCanonicalPath();
                Main.readDetector();
                this.clearComponents();
                this.loadComponents();
                this.detectorPropertiesTable.repaint();
                this.peakTailingPropertiesTable.repaint();
                Parameter p = Main.getParameter("1026");
                p.setValue("'" + chooser.getSelectedFile().getName() + "'");
                this.detectorFilename.setValueAt(p.getValue().toString(), 0, 0);
                this.detectorFilename.repaint();
                if (this.sketchPanel != null) {
                    this.sketchPanel.setView(5);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void saveDetectorMouseReleased(MouseEvent evt) {
        if (!this.saveDetector.isEnabled()) {
            return;
        }
        try {
            JFileChooser chooser = new JFileChooser();
            FileFilter f1 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return MainFrame.this.getExtension(f).equals("det");
                }

                public String getDescription() {
                    return "(.det) AASI detector file.";
                }
            };
            chooser.addChoosableFileFilter(f1);
            chooser.setCurrentDirectory(new File(chooserSaveHome));
            this.fixDetectorParams();
            String fname = Main.getParameter("1026").getStringValue();
            File file = new File(fname.substring(1, fname.length() - 1));
            chooser.setSelectedFile(file);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                chooserSaveHome = chooser.getSelectedFile().getParent();
                this.fixDetectorParams();
                File f = chooser.getSelectedFile();
                Parameter p = Main.getParameter("1026");
                p.setValue("'" + f.getName() + "'");
                this.detectorFilename.setValueAt(p.getStringValue(), 0, 0);
                Main.detectorSavePath = f.getCanonicalPath();
                Main.saveDetector();
                this.untouch(this.detectorFrame);
                this.detectorField.repaint();
                this.detectorFilename.repaint();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void homogenousSourceButtonActionPerformed(ActionEvent evt) {
        Main.cloneParameter("7", "orig_diam");
        Main.cloneParameter("1701", "orig_dens");
        Main.cloneParameter("1003", "orig_shape");
        Main.getParameter("7").setValue(new Float(1.0E-6));
        Main.getParameter("1701").setValue(new Float(1.0E-6));
        Main.getParameter("1003").setValue("b");
        Parameter p = Main.getParameter("orig_thickn");
        if (p != null) {
            Main.putParameter("1606", p);
        }
        if ((p = Main.getParameter("orig_convex")) != null) {
            Main.putParameter("1006", p);
        }
        Main.getParameter("1009").setValue("y");
        Main.getParameter("1004").setValue("n");
        Main.getParameter("1010").setValue("n");
        Main.getParameter("1007").setValue("n");
        Main.getParameter("1006").setValue("y");
        if (this.sketchPanel != null) {
            this.sketchPanel.setView(1);
        }
        if (this.homogenousSourceDrawer.isMinimized() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.sourceShelf.maximize(this.homogenousSourceDrawer);
        this.homogenousSourceButton.grabFocus();
    }

    private void radioactiveParticlesButtonActionPerformed(ActionEvent evt) {
        Main.cloneParameter("1606", "orig_thickn");
        Main.cloneParameter("1006", "orig_convex");
        Main.getParameter("1606").setValue(new Float(0.0f));
        Main.getParameter("1006").setValue("n");
        Parameter p = Main.getParameter("orig_diam");
        if (p != null) {
            Main.putParameter("7", p);
        }
        if ((p = Main.getParameter("orig_shape")) != null) {
            Main.putParameter("1003", p);
        }
        if ((p = Main.getParameter("orig_dens")) != null) {
            Main.putParameter("1701", p);
        }
        if (this.sketchPanel != null) {
            this.sketchPanel.setView(3);
        }
        this.particleButtons();
        if (this.radioactiveParticlesDrawer.isMinimized() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.sourceShelf.maximize(this.radioactiveParticlesDrawer);
        this.radioactiveParticlesButton.grabFocus();
    }

    private void singleParticleBtnActionPerformed(ActionEvent evt) {
        if (!this.singleParticleBtn.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.lognorm = this.lognormalSizeBtn.isSelected();
        this.lognormalSizeBtn.setSelected(false);
        this.identicalSizeBtn.setSelected(false);
        this.depositionAreaField.setEnabled(false);
        this.depLabel.setEnabled(false);
        this.depLabel2.setEnabled(false);
        this.xPosField.setEnabled(true);
        this.yPosField.setEnabled(true);
        this.posLabel.setEnabled(true);
        this.posLabel1.setEnabled(true);
        this.posLabel2.setEnabled(true);
        this.posLabel3.setEnabled(true);
        this.posLabel4.setEnabled(true);
        this.particleButtons();
    }

    private void manyParticlesBtnActionPerformed(ActionEvent evt) {
        if (!this.manyParticlesBtn.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.lognormalSizeBtn.setSelected(false);
        this.identicalSizeBtn.setSelected(false);
        if (this.lognorm && !this.ellipsoidalBtn.isSelected()) {
            this.lognormalSizeBtn.setSelected(true);
        } else {
            this.identicalSizeBtn.setSelected(true);
        }
        this.depositionAreaField.setEnabled(true);
        this.depLabel.setEnabled(true);
        this.depLabel2.setEnabled(true);
        this.xPosField.setEnabled(false);
        this.yPosField.setEnabled(false);
        this.posLabel.setEnabled(false);
        this.posLabel1.setEnabled(false);
        this.posLabel2.setEnabled(false);
        this.posLabel3.setEnabled(false);
        this.posLabel4.setEnabled(false);
        this.particleButtons();
    }

    private void sphericalBtnActionPerformed(ActionEvent evt) {
        if (!this.identicalSizeBtn.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.identicalSizeBtn.setSelected(false);
        if (!this.singleParticleBtn.isSelected()) {
            this.identicalSizeBtn.setSelected(false);
            if (this.lognorm) {
                this.lognormalSizeBtn.setSelected(true);
            } else {
                this.identicalSizeBtn.setSelected(true);
            }
        }
        this.particleButtons();
    }

    private void ellipsoidalBtnActionPerformed(ActionEvent evt) {
        if (!this.ellipsoidalBtn.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        if (!this.singleParticleBtn.isSelected() && !this.lognorm) {
            this.lognorm = this.lognormalSizeBtn.isSelected();
        }
        this.lognormalSizeBtn.setEnabled(false);
        this.identicalSizeBtn.setEnabled(false);
        this.lognormalSizeBtn.setSelected(false);
        this.identicalSizeBtn.setSelected(!this.singleParticleBtn.isSelected());
        this.sizeLabel.setEnabled(false);
        this.particleButtons();
    }

    private void surfaceLayerBtnActionPerformed(ActionEvent evt) {
        if (!this.surfaceLayerBtn.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        if (!this.singleParticleBtn.isSelected()) {
            this.identicalSizeBtn.setSelected(false);
            if (this.lognorm) {
                this.lognormalSizeBtn.setSelected(true);
            } else {
                this.identicalSizeBtn.setSelected(true);
            }
        }
        this.particleButtons();
    }

    private void identicalSizeBtnActionPerformed(ActionEvent evt) {
        this.lognormalSizeBtn.setSelected(false);
        this.identicalSizeBtn.setSelected(true);
        this.lognorm = false;
        this.particleButtons();
    }

    private void lognormalSizeBtnActionPerformed(ActionEvent evt) {
        if (!this.lognormalSizeBtn.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.lognormalSizeBtn.setSelected(true);
        this.identicalSizeBtn.setSelected(false);
        this.lognorm = true;
        this.particleButtons();
    }

    private void matrixSourceButtonActionPerformed(ActionEvent evt) {
        Parameter p = Main.getParameter("orig_thickn");
        if (p != null) {
            Main.putParameter("1606", p);
        }
        if ((p = Main.getParameter("orig_convex")) != null) {
            Main.putParameter("1006", p);
        }
        if ((p = Main.getParameter("orig_diam")) != null) {
            Main.putParameter("7", p);
        }
        if ((p = Main.getParameter("orig_shape")) != null) {
            Main.putParameter("1003", p);
        }
        if ((p = Main.getParameter("orig_dens")) != null) {
            Main.putParameter("1701", p);
        }
        if (this.sketchPanel != null) {
            this.sketchPanel.setView(3);
        }
        this.matrixButtons();
        if (this.matrixSourceDrawer.isMinimized() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.sourceShelf.maximize(this.matrixSourceDrawer);
        this.matrixSourceButton.grabFocus();
    }

    private void sphericalBtn1ActionPerformed(ActionEvent evt) {
        if (!this.sphericalBtn1.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.lognormalSizeBtn1.setEnabled(true);
        this.identicalSizeBtn1.setEnabled(true);
        this.sizeLabel1.setEnabled(true);
        this.identicalSizeBtn1.setSelected(false);
        if (this.lognorm1) {
            this.lognormalSizeBtn1.setSelected(true);
        } else {
            this.identicalSizeBtn1.setSelected(true);
        }
        this.exponentialBtn.setEnabled(true);
        this.uniformBtn.setEnabled(true);
        if (this.expo1) {
            this.exponentialBtn.setSelected(true);
        } else {
            this.exponentialBtn.setSelected(false);
        }
        this.depthLabel.setEnabled(true);
        this.matrixButtons();
    }

    private void ellipsoidalBtn1ActionPerformed(ActionEvent evt) {
        if (!this.ellipsoidalBtn1.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        if (!this.singleParticleBtn.isSelected()) {
            this.lognorm1 = this.lognormalSizeBtn1.isSelected();
        }
        this.lognormalSizeBtn1.setEnabled(false);
        this.identicalSizeBtn1.setEnabled(false);
        this.lognormalSizeBtn1.setSelected(false);
        this.identicalSizeBtn1.setSelected(true);
        this.expo1 = this.exponentialBtn.isSelected();
        this.sizeLabel1.setEnabled(false);
        this.exponentialBtn.setEnabled(false);
        this.uniformBtn.setEnabled(false);
        this.exponentialBtn.setSelected(false);
        this.uniformBtn.setSelected(true);
        this.depthLabel.setEnabled(false);
        this.matrixButtons();
    }

    private void surfaceLayerBtn1ActionPerformed(ActionEvent evt) {
        if (!this.surfaceLayerBtn1.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.identicalSizeBtn1.setSelected(false);
        if (this.lognorm1) {
            this.lognormalSizeBtn1.setSelected(true);
        } else {
            this.identicalSizeBtn1.setSelected(true);
        }
        this.lognormalSizeBtn1.setEnabled(true);
        this.identicalSizeBtn1.setEnabled(true);
        this.sizeLabel1.setEnabled(true);
        this.exponentialBtn.setEnabled(true);
        this.uniformBtn.setEnabled(true);
        if (this.expo1) {
            this.exponentialBtn.setSelected(true);
        } else {
            this.exponentialBtn.setSelected(false);
        }
        this.depthLabel.setEnabled(true);
        this.matrixButtons();
    }

    private void identicalSizeBtn1ActionPerformed(ActionEvent evt) {
        if (!this.identicalSizeBtn1.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.lognormalSizeBtn1.setSelected(false);
        this.identicalSizeBtn1.setSelected(true);
        this.lognorm1 = false;
        this.matrixButtons();
    }

    private void lognormalSizeBtn1ActionPerformed(ActionEvent evt) {
        if (!this.lognormalSizeBtn1.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.lognormalSizeBtn1.setSelected(true);
        this.identicalSizeBtn1.setSelected(false);
        this.lognorm1 = true;
        this.matrixButtons();
    }

    private void uniformBtnActionPerformed(ActionEvent evt) {
        if (!this.uniformBtn.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.expo1 = false;
        this.matrixButtons();
    }

    private void exponentialBtnActionPerformed(ActionEvent evt) {
        if (!this.exponentialBtn.isSelected() && this.fitPanel != null) {
            this.fitPanel.invalidateVariableParams();
        }
        this.expo1 = true;
        this.matrixButtons();
    }

    private void nuclideComboBox_handleActionPerformed(ActionEvent evt) {
        Object o = this.nuclideComboBox.getSelectedItem();
        if (o instanceof Nuclide) {
            Nuclide n = (Nuclide)o;
            this.loadTableWithNuclide(n);
        }
    }

    private void enableCoincidenceDataBrowsing(boolean enabled) {
        this.selectedNuclidesLabel1.setEnabled(enabled);
        this.coincidenceNuclidesTable.setEnabled(enabled);
        this.coincidenceNuclidesTable.getTableHeader().setEnabled(enabled);
        this.nuclideLabel1.setEnabled(!enabled);
        this.coincidenceNuclideComboBox.setEnabled(!enabled);
        this.openLibrary1.setEnabled(!enabled);
    }

    private void addToCoincidenceNuclidesTable(Nuclide n) {
        Object[] row = new Object[]{n};
        ((DefaultTableModel)this.coincidenceNuclidesTable.getModel()).addRow(row);
    }

    private void button_handleActionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.addNuclideButton) {
            Nuclide n = (Nuclide)this.nuclideComboBox.getSelectedItem();
            for (int i = 0; i < this.nuclidesTable.getRowCount(); ++i) {
                Nuclide o = (Nuclide)this.nuclidesTable.getValueAt(i, 0);
                if (o == null || !o.getName().equals(n.getName()) || !o.library.equals(n.library)) continue;
                Main.warnUser("Nuclide " + n.getName() + " from library " + n.library + " is already in the selection.");
                return;
            }
            if (MainFrame.hasCoincidenceData(n)) {
                this.addToCoincidenceNuclidesTable(n);
                this.enableCoincidenceCalc(true);
            }
            Parameter p = Main.getParameter("1029");
            if (n.getName().startsWith("Line")) {
                p.setValue("'dummy'");
            } else {
                p.setValue("'" + n.getName() + "'");
            }
            this.moveNuclideToSelection(n);
            String str = "";
            int ctr = 0;
            int nrows = this.nuclidesTable.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                Nuclide nuc = (Nuclide)this.nuclidesTable.getValueAt(i, 0);
                if (nuc == null) continue;
                ++ctr;
                Parameter dec = (Parameter)this.nuclidesTable.getValueAt(i, 1);
                if (i != 0) {
                    str = str + "&";
                }
                str = str + "'" + nuc.getName() + "'" + "&" + dec.getValue().toString();
            }
            if (ctr > 1) {
                this.jCheckBox1.setEnabled(true);
            } else {
                this.jCheckBox1.setEnabled(false);
            }
            Main.getParameter("1029").setValue(str);
        } else if (src == this.removeNuclideButton) {
            Nuclide nuc;
            Object ob;
            this.temp.clear();
            int srow = this.nuclidesTable.getSelectedRow();
            if (srow < 0) {
                srow = 0;
            }
            if ((ob = this.nuclidesTable.getValueAt(srow, 0)) instanceof Nuclide && MainFrame.hasCoincidenceData(nuc = (Nuclide)ob)) {
                DefaultTableModel m = (DefaultTableModel)this.coincidenceNuclidesTable.getModel();
                int rows = m.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    Nuclide obj = (Nuclide)m.getValueAt(i, 0);
                    if (!obj.library.equals(nuc.library) || !obj.getName().equals(nuc.getName())) continue;
                    m.removeRow(i);
                    break;
                }
                if (m.getRowCount() == 0) {
                    this.enableCoincidenceCalc(false);
                }
                if (this.browseSimCoincidences.isSelected()) {
                    this.clearTable(this.betaLinesTable, true);
                    this.clearTable(this.gammaLinesTable, true);
                }
            }
            if (this.nuclidesTable.getRowCount() > 15) {
                ((DefaultTableModel)this.nuclidesTable.getModel()).removeRow(srow);
                this.resizeTable(this.nuclidesTable);
            } else {
                int i;
                int i2;
                this.nuclidesTable.setValueAt(null, srow, 0);
                this.nuclidesTable.setValueAt(null, srow, 1);
                Vector<Vector> v = ((DefaultTableModel)this.nuclidesTable.getModel()).getDataVector();
                for (i2 = 0; i2 < v.size(); ++i2) {
                    this.temp.add(v.elementAt(i2).elementAt(0));
                }
                for (i2 = 0; i2 < this.nuclidesTable.getRowCount(); ++i2) {
                    this.nuclidesTable.setValueAt(null, i2, 0);
                }
                int row = 0;
                for (i = 0; i < this.temp.size(); ++i) {
                    Object o = this.temp.elementAt(i);
                    if (!(o instanceof Nuclide)) continue;
                    this.nuclidesTable.setValueAt(o, row++, 0);
                }
                for (i = 0; i < v.size(); ++i) {
                    this.temp.add(v.elementAt(i).elementAt(1));
                }
                for (i = 0; i < this.nuclidesTable.getRowCount(); ++i) {
                    this.nuclidesTable.setValueAt(null, i, 1);
                }
                row = 0;
                for (i = 0; i < this.temp.size(); ++i) {
                    Object o = this.temp.elementAt(i);
                    if (!(o instanceof Parameter)) continue;
                    this.nuclidesTable.setValueAt(o, row++, 1);
                }
            }
            String str = "";
            int nrows = this.nuclidesTable.getRowCount();
            int ctr = 0;
            for (int i = 0; i < nrows; ++i) {
                Nuclide nuc2 = (Nuclide)this.nuclidesTable.getValueAt(i, 0);
                if (nuc2 == null) continue;
                ++ctr;
                if (i != 0) {
                    str = str + "&";
                }
                Parameter dec = (Parameter)this.nuclidesTable.getValueAt(i, 1);
                str = str + nuc2.getName() + "&" + dec.getValue().toString();
            }
            Main.getParameter("1029").setValue(str);
            if (ctr > 1) {
                this.jCheckBox1.setEnabled(true);
            } else {
                this.jCheckBox1.setEnabled(false);
            }
        }
    }

    private void lineEnergyRadioBtnActionPerformed(ActionEvent evt) {
        if (this.lineEnergyRadioBtn.isSelected()) {
            Main.getParameter("1029").setValue("'dummy'");
            this.lineEnergyField.setEnabled(true);
            this.nuclideComboBox.setEnabled(false);
            this.nuclidePropertiesTable.setEnabled(false);
            this.nuclidesTable.setEnabled(false);
            this.addNuclideButton.setEnabled(false);
            this.removeNuclideButton.setEnabled(false);
            this.nuclideLabel.setEnabled(false);
            this.openLibrary.setEnabled(false);
            this.nuclidePropertiesLabel.setEnabled(false);
            this.selectedNuclidesLabel.setEnabled(false);
            this.decaysField.setEnabled(true);
            this.linesTable.setEnabled(false);
            this.decaysLabel.setEnabled(true);
            this.mevLabel.setEnabled(true);
            this.nuclidesFrame.repaint();
            this.jCheckBox1.setEnabled(false);
        }
    }

    private void nuclideRadioBtnActionPerformed(ActionEvent evt) {
        if (this.nuclideRadioBtn.isSelected()) {
            this.lineEnergyField.setEnabled(false);
            this.nuclideComboBox.setEnabled(true);
            this.nuclidePropertiesTable.setEnabled(true);
            this.nuclidesTable.setEnabled(true);
            this.addNuclideButton.setEnabled(true);
            this.removeNuclideButton.setEnabled(true);
            this.nuclideLabel.setEnabled(true);
            this.openLibrary.setEnabled(true);
            this.linesTable.setEnabled(true);
            this.nuclidePropertiesLabel.setEnabled(true);
            this.selectedNuclidesLabel.setEnabled(true);
            this.decaysField.setEnabled(false);
            this.decaysLabel.setEnabled(false);
            this.mevLabel.setEnabled(false);
            int numNuclids = this.getNumberOfItemsInTableCol(this.nuclidesTable, 0);
            if (numNuclids > 0) {
                Main.getParameter("1029").setValue(this.nuclidesTable.getValueAt(0, 0));
            }
            if (numNuclids > 1) {
                this.jCheckBox1.setEnabled(true);
            } else {
                this.jCheckBox1.setEnabled(false);
            }
            this.nuclidesFrame.repaint();
        }
    }

    private void deleteLayerButtonActionPerformed(ActionEvent evt) {
        this.layerMod = true;
        int row = this.layersTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        Object o = this.layersTable.getValueAt(row, 0);
        if (o == null) {
            return;
        }
        DefaultTableModel m = (DefaultTableModel)this.layersTable.getModel();
        this.fixLayersDown(row);
        m.removeRow(row);
        Object[] data = new Object[]{null};
        m.addRow(data);
        Parameter p = Main.getParameter("1008");
        p.setValue(new Integer(p.getIntegerValue() - 1));
        this.layerMod = false;
        this.clearTable(this.layerMaterialElementsTable, true);
        this.clearTable(this.layerMaterialPropertiesTable, false);
        if (this.sketchPanel != null) {
            this.sketchPanel.refresh();
        }
    }

    private void addLayerBtnActionPerformed(ActionEvent evt) {
        this.addLayer();
    }

    private void shieldingCombo_handleActionPerformed(ActionEvent evt) {
        Parameter p = Main.getParameter("1022");
        p.setValue(new Integer(this.shieldingModelCombobox.getSelectedIndex() + 1));
    }

    private void materialCombobox_handleActionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o == this.deadLayerMaterialCombobox && this.loaded) {
            this.materialToTable(this.deadLayerMaterialPropertiesTable, this.deadLayerMaterialCombobox, true);
            this.touch(this.detectorFrame);
        } else if (o == this.backingplateMaterialCombobox && this.loaded) {
            this.materialToTable(this.backingplateMaterialPropertiesTable, this.backingplateMaterialCombobox, true);
        }
    }

    private void internalFrameActivated(InternalFrameEvent evt) {
        if (this.sketchPanel == null) {
            return;
        }
        Object o = evt.getSource();
        if (o == this.layersFrame) {
            this.sketchFrame.setTitle("Sketch window (Layers)");
            this.sketchPanel.setView(6);
        } else if (o == this.detectorFrame) {
            this.sketchFrame.setTitle("Sketch window (Detector)");
            this.sketchPanel.setView(5);
        } else if (o == this.backScatterFrame) {
            this.sketchFrame.setTitle("Sketch window (Backingplate)");
            this.sketchPanel.setView(4);
        }
    }

    private void checkBox_handleActionPerformed(ActionEvent evt) {
        Parameter p;
        Object src = evt.getSource();
        if (src == this.includeBackingplateCheckbox) {
            p = Main.getParameter("1018");
            this.enableBackingplate(this.includeBackingplateCheckbox.isSelected());
            p.setValue(this.includeBackingplateCheckbox.isSelected() ? "y" : "n");
        }
        if (src == this.parallelbeamCheckbox) {
            p = Main.getParameter("1019");
            p.setValue(this.parallelbeamCheckbox.isSelected() ? new Integer(1) : new Integer(0));
            p = Main.getParameter("1507");
            p.setValue(this.parallelbeamCheckbox.isSelected() ? "1" : "0");
        }
        if (src == this.coincidencesCheckbox) {
            p = Main.getParameter("1016");
            p.setValue(this.coincidencesCheckbox.isSelected() ? "y" : "n");
            this.enableCoincidences(this.coincidencesCheckbox.isSelected());
        }
        if (src == this.trackAlphaCheckBox) {
            p = Main.getParameter("1023");
            p.setValue(new Integer(this.trackAlphaCheckBox.isSelected() ? 1 : 0));
            if (this.trackAlphaCheckBox.isSelected()) {
                this.includeBackingplateCheckbox.setSelected(true);
                this.enableBackingplate(this.includeBackingplateCheckbox.isSelected());
                p = Main.getParameter("1018");
                p.setValue(this.includeBackingplateCheckbox.isSelected() ? "y" : "n");
            }
        }
        if (src == this.parallelbeamCheckbox) {
            p = Main.getParameter("1019");
            p.setValue(new Integer(this.parallelbeamCheckbox.isSelected() ? 1 : 0));
        }
        if (src == this.linearDepositionCheckbox) {
            p = Main.getParameter("1020");
            p.setValue(new Integer(this.linearDepositionCheckbox.isSelected() ? 1 : 0));
        }
    }

    private void selfabsCheckBoxActionPerformed(ActionEvent evt) {
        Main.getParameter("1000").setValue(this.selfabsCheckBox.isSelected() ? "y" : "n");
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        this.runMenuItemActionPerformed(evt);
    }

    private void enableRadSrcFrm(boolean enabled) {
        this.headerLabel12.setEnabled(enabled);
        this.headerLabel13.setEnabled(enabled);
        this.headerLabel14.setEnabled(enabled);
        this.pTypeLabel.setEnabled(enabled);
        this.depthLabel.setEnabled(enabled);
        this.sizeLabel1.setEnabled(enabled);
        this.sphericalBtn.setEnabled(enabled);
        this.sphericalBtn1.setEnabled(enabled);
        this.ellipsoidalBtn.setEnabled(enabled);
        this.ellipsoidalBtn1.setEnabled(enabled);
        this.surfaceLayerBtn.setEnabled(enabled);
        this.surfaceLayerBtn1.setEnabled(enabled);
        this.singleParticleBtn.setEnabled(enabled);
        this.manyParticlesBtn.setEnabled(enabled);
        this.exponentialBtn.setEnabled(enabled);
        this.uniformBtn.setEnabled(enabled);
        this.identicalSizeBtn.setEnabled(enabled);
        this.identicalSizeBtn1.setEnabled(enabled);
        this.lognormalSizeBtn.setEnabled(enabled);
        this.lognormalSizeBtn1.setEnabled(enabled);
        this.particlePropertiesTable2.setRowSelectionAllowed(!enabled);
        this.particlePropertiesTable2.getSelectionModel().clearSelection();
        this.particlePropertiesTable1.setRowSelectionAllowed(!enabled);
        this.particlePropertiesTable1.getSelectionModel().clearSelection();
        this.sourcePropertiesTable1.setRowSelectionAllowed(!enabled);
        this.sourcePropertiesTable1.getSelectionModel().clearSelection();
        this.sourcePropertiesTable2.setRowSelectionAllowed(!enabled);
        this.sourcePropertiesTable2.getSelectionModel().clearSelection();
        this.sourcePropertiesTable2.setEnabled(enabled);
        this.sourceMaterialElementsTable2.setEnabled(enabled);
        this.sourceMaterialElementsTable1.setEnabled(enabled);
        this.particleMaterialElementsTable1.setEnabled(enabled);
        this.particleMaterialElementsTable2.setEnabled(enabled);
        this.sddField.setEnabled(enabled);
        this.jLabel6.setEnabled(enabled);
        this.jLabel5.setEnabled(enabled);
        if (enabled) {
            if (!this.radioactiveParticlesDrawer.isMinimized()) {
                this.particleButtons();
            }
            if (!this.matrixSourceDrawer.isMinimized()) {
                this.matrixButtons();
            }
            this.homogenousSourceDrawer.setEnabled(enabled);
            this.headerLabel28.setEnabled(enabled);
            this.radioactiveParticlesDrawer.setEnabled(enabled);
            this.headerLabel29.setEnabled(enabled);
            this.matrixSourceDrawer.setEnabled(enabled);
            this.headerLabel30.setEnabled(enabled);
        } else {
            if (this.homogenousSourceDrawer.isMinimized()) {
                this.homogenousSourceDrawer.setEnabled(false);
                this.headerLabel28.setEnabled(false);
            }
            if (this.radioactiveParticlesDrawer.isMinimized()) {
                this.radioactiveParticlesDrawer.setEnabled(false);
                this.headerLabel29.setEnabled(false);
            }
            if (this.matrixSourceDrawer.isMinimized()) {
                this.matrixSourceDrawer.setEnabled(false);
                this.headerLabel30.setEnabled(false);
            }
        }
    }

    public FitPanel getFitPanel() {
        return this.fitPanel;
    }

    private void tabsPaneStateChanged(ChangeEvent evt) {
        Component comp;
        JTabbedPane pane = (JTabbedPane)evt.getSource();
        if (this.current != null) {
            try {
                if (this.logFrame != null) {
                    this.logFrameIcon = this.logFrame.isIcon();
                    this.logFrame.setIcon(false);
                    this.current.remove(this.logFrame);
                }
                if (this.sketchFrame != null) {
                    this.sketchFrameIcon = this.sketchFrame.isIcon();
                    this.sketchFrame.setIcon(false);
                    this.current.remove(this.sketchFrame);
                }
                if (notesPanel != null) {
                    this.notesFrameIcon = this.notesFrame.isIcon();
                    this.notesFrame.setIcon(false);
                    this.current.remove(this.notesFrame);
                }
                if (this.helpFrame != null) {
                    this.current.remove(this.helpFrame);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((comp = pane.getSelectedComponent()) instanceof WelcomePanel) {
            Help.enableHelpKey(this.tabsPane, "Introduction");
        }
        if (comp == this.detectorDesktop) {
            Help.enableHelpKey(this.tabsPane, "DetectorPage");
        }
        if (comp == this.sourceDesktop) {
            if (this.fitPanel != null && !this.srcFrameSet) {
                this.srcFrameSet = true;
                if (this.frmX != -1) {
                    this.radiationSourceFrame.setLocation(this.frmX, this.frmY);
                }
            }
            Help.enableHelpKey(this.tabsPane, "SourcePage");
        }
        if (comp == this.layersDesktop) {
            Help.enableHelpKey(this.tabsPane, "AbsorbingLayersPage");
        }
        if (comp == this.coincidencesDesktop) {
            Help.enableHelpKey(this.tabsPane, "CoincidencesBackscattering");
        }
        if (comp == this.calculateDesktop) {
            Help.enableHelpKey(this.tabsPane, "CalculationPage");
        }
        if (comp == this.plotPanel) {
            Help.enableHelpKey(this.tabsPane, "PlotPage");
        }
        if (comp == this.fitPanel) {
            this.frmX = this.radiationSourceFrame.getX();
            this.frmY = this.radiationSourceFrame.getY();
            if (!this.homogenousSourceDrawer.isMinimized() && this.fitPanel != null) {
                this.fitPanel.setVariableParameters(this.sourcePropertiesTable1, "homogeneous source");
            } else if (!this.radioactiveParticlesDrawer.isMinimized() && this.fitPanel != null) {
                this.fitPanel.setVariableParameters(this.particlePropertiesTable1, "radioactive particles");
            } else if (!this.matrixSourceDrawer.isMinimized() && this.fitPanel != null) {
                this.fitPanel.setVariableParameters(this.particlePropertiesTable2, "radioactive particles in a homogeneous matrix");
            }
            this.srcFrameSet = false;
            if (this.fitPanel != null) {
                this.fitPanel.refresh();
            }
        }
        if (comp != this.fitPanel) {
            // empty if block
        }
        this.current = comp instanceof JDesktopPane && this.tabsPane.getSelectedIndex() < 6 ? (JDesktopPane)pane.getSelectedComponent() : null;
        if (this.current == null) {
            this.fileMenu.setEnabled(false);
            this.windowMenu.setEnabled(false);
            this.viewMenu.setEnabled(false);
        } else {
            this.fileMenu.setEnabled(true);
            this.windowMenu.setEnabled(true);
            this.viewMenu.setEnabled(true);
        }
        if (this.current != null) {
            try {
                if (this.logPanel != null) {
                    this.current.add(this.logFrame);
                    if (this.logFrameIcon) {
                        this.logFrame.setIcon(true);
                    }
                }
                if (notesPanel != null) {
                    this.current.add(this.notesFrame);
                    if (this.notesFrameIcon) {
                        this.notesFrame.setIcon(true);
                    }
                }
                if (this.helpFrame != null) {
                    boolean icon = this.helpFrame.isIcon();
                    if (!icon) {
                        this.current.add(this.helpFrame);
                    } else {
                        this.current.add(this.helpFrame.getDesktopIcon());
                    }
                }
                if (this.sketchPanel != null) {
                    this.current.add(this.sketchFrame);
                    if (this.sketchFrameIcon) {
                        this.sketchFrame.setIcon(true);
                    }
                    if (this.current == this.calculateDesktop) {
                        this.sketchFrame.setTitle("Sketch window (Setup)");
                        this.sketchPanel.setView(0);
                        this.paramsFrame.grabFocus();
                        try {
                            this.nuclidesFrame.setSelected(false);
                            this.layersFrame.setSelected(false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else if (this.current == this.detectorDesktop) {
                        this.sketchFrame.setTitle("Sketch window (Detector)");
                        this.sketchPanel.setView(5);
                        try {
                            this.detectorFrame.setSelected(false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else if (this.current == this.coincidencesDesktop) {
                        this.sketchFrame.setTitle("Sketch window (Backingplate)");
                        this.sketchPanel.setView(4);
                        try {
                            this.backScatterFrame.setSelected(false);
                            this.coincidenceFrame.setSelected(false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else if (this.current == this.sourceDesktop) {
                        this.sketchFrame.setTitle("Sketch window (Source)");
                        if (this.homogenousSourceButton.isSelected()) {
                            this.sketchPanel.setView(1);
                        } else {
                            this.sketchPanel.setView(3);
                        }
                        try {
                            this.radiationSourceFrame.setSelected(false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else if (this.current == this.layersDesktop) {
                        this.sketchFrame.setTitle("Sketch window (Layers)");
                        this.sketchPanel.setView(6);
                        try {
                            this.layersFrame.setSelected(false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.debug && this.tabsPane.getSelectedComponent() == this.debugPanel) {
            System.out.println("Writeing!");
            this.fixInputParams();
            OutputWriter w = new OutputWriter();
            ByteArrayOutputStream s = new ByteArrayOutputStream(5000);
            w.setOutWriter(s);
            OutputWriter.writeOutput(Main.getInputTemplate(), "");
            this.debugField.setText(s.toString());
        }
    }

    private void helpAboutItemActionPerformed(ActionEvent evt) {
        new AboutDialog(this);
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.notesFrame != null) {
            notesWindowX = this.notesFrame.getX();
            notesWindowY = this.notesFrame.getY();
            notesWindowW = this.notesFrame.getWidth();
            notesWindowH = this.notesFrame.getHeight();
            notesWindowS = this.notesFrame.isVisible();
        } else {
            notesWindowS = false;
        }
        if (this.sketchFrame != null) {
            sketchWindowX = this.sketchFrame.getX();
            sketchWindowY = this.sketchFrame.getY();
            sketchWindowW = this.sketchFrame.getWidth();
            sketchWindowH = this.sketchFrame.getHeight();
            sketchWindowS = this.sketchFrame.isVisible();
        } else {
            sketchWindowS = false;
        }
        if (this.logFrame != null) {
            logWindowX = this.logFrame.getX();
            logWindowY = this.logFrame.getY();
            logWindowW = this.logFrame.getWidth();
            logWindowH = this.logFrame.getHeight();
            logWindowS = this.logFrame.isVisible();
        } else {
            logWindowS = false;
        }
        this.getStatus(this.layersFrame, 0);
        this.getStatus(this.paramsFrame, 1);
        this.getStatus(this.coincidenceFrame, 2);
        this.getStatus(this.backScatterFrame, 3);
        this.getStatus(this.nuclidesFrame, 4);
        this.getStatus(this.detectorFrame, 5);
        this.getStatus(this.gecFrameI, 6);
        this.getStatus(this.radiationSourceFrame, 7);
        if (notesPanel != null) {
            this.getStatus(this.notesFrame, 8);
        } else {
            MainFrame.visible[8] = false;
        }
        if (this.sketchPanel != null) {
            this.getStatus(this.sketchFrame, 9);
        } else {
            MainFrame.visible[9] = false;
        }
        if (this.logPanel != null) {
            this.getStatus(this.logFrame, 10);
        } else {
            MainFrame.visible[10] = false;
        }
        if (this.plotPanel != null) {
            this.plotPanel.saveSettings();
        }
        MainFrame.saveSettings();
    }

    private void notesMenuItemActionPerformed(ActionEvent evt) {
        if (this.notesMenuItem.isSelected()) {
            if (this.notesFrame == null) {
                this.showNotesWindow();
            }
        } else {
            notesWindowX = this.notesFrame.getX();
            notesWindowY = this.notesFrame.getY();
            notesWindowW = this.notesFrame.getWidth();
            notesWindowH = this.notesFrame.getHeight();
            Main.notes = notesPanel.getText();
            this.notesFrame.dispose();
            this.notesFrame = null;
            notesPanel = null;
        }
    }

    private void logWindowMenuItemActionPerformed(ActionEvent evt) {
        if (this.logWindowMenuItem.isSelected()) {
            if (this.logFrame == null) {
                this.showLogWindow();
            }
        } else {
            logWindowX = this.logFrame.getX();
            logWindowY = this.logFrame.getY();
            logWindowW = this.logFrame.getWidth();
            logWindowH = this.logFrame.getHeight();
            this.logFrame.dispose();
            this.logFrame = null;
            this.logPanel = null;
        }
    }

    private void sketchWindowMenuItemActionPerformed(ActionEvent evt) {
        if (this.sketchWindowMenuItem.isSelected()) {
            if (this.sketchFrame == null) {
                this.showSketchWindow();
            }
        } else {
            sketchWindowX = this.sketchFrame.getX();
            sketchWindowY = this.sketchFrame.getY();
            sketchWindowW = this.sketchFrame.getWidth();
            sketchWindowH = this.sketchFrame.getHeight();
            this.sketchFrame.dispose();
            this.sketchFrame = null;
            this.sketchPanel = null;
        }
    }

    private void runGeometricEfficiencyMenuItemActionPerformed(ActionEvent evt) {
        this.lockComponentsGec();
        gecFrame = new GeometricEfficiencyFrame();
        gecFrame.show();
    }

    private void fileExitItemActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
        System.exit(0);
    }

    private void fileSaveAsItemActionPerformed(ActionEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            FileFilter f1 = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return MainFrame.this.getExtension(f).equals("inp");
                }

                public String getDescription() {
                    return "(.inp) AASI input file.";
                }
            };
            chooser.addChoosableFileFilter(f1);
            chooser.setCurrentDirectory(new File(chooserSaveHome));
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                chooserSaveHome = chooser.getSelectedFile().getParent();
                this.fixDetectorParams();
                this.fixInputParams();
                Main.outputSavePath = chooser.getSelectedFile().getCanonicalPath();
                Main.saveInput();
                this.fileSaveItem.setEnabled(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void enableCoincidenceCalc(boolean enabled) {
    }

    private void enableCoincidences(boolean enabled) {
        this.headerLabel27.setEnabled(enabled);
        this.coincidencesCheckbox1.setEnabled(enabled);
        if (this.coincidencesCheckbox1.isSelected() && enabled) {
            this.headerLabel31.setEnabled(true);
            this.coincidenceOutputFileField.setEnabled(true);
            this.openLibrary2.setEnabled(true);
        } else {
            this.headerLabel31.setEnabled(false);
            this.coincidenceOutputFileField.setEnabled(false);
            this.openLibrary2.setEnabled(false);
        }
        this.shieldingModelCombobox.setEnabled(enabled);
        this.parallelbeamCheckbox.setEnabled(enabled);
        this.linearDepositionCheckbox.setEnabled(enabled);
    }

    private void enableBackingplate(boolean enabled) {
        this.headerLabel25.setEnabled(enabled);
        this.backingplateMaterialCombobox.setEnabled(enabled);
        this.headerLabel26.setEnabled(enabled);
        this.backingplateMaterialPropertiesTable.setEnabled(enabled);
        this.backingplateMaterialPropertiesTable1.setEnabled(enabled);
    }

    private void fileSaveItemActionPerformed(ActionEvent evt) {
        this.fixDetectorParams();
        this.fixInputParams();
        Main.saveInput();
    }

    public void open(String fileName) {
        try {
            File f = new File(fileName);
            Main.inputPath = f.getCanonicalPath();
            String det = f.getParent() + "/";
            Main.readInput();
            if (notesPanel != null) {
                notesPanel.setText(Main.notes);
            }
            Parameter p = Main.getParameter("1026");
            String df = (String)p.getValue();
            df = df.substring(1, df.length() - 1);
            Main.detectorPath = det + df;
            Main.readDetector();
            this.clearComponents();
            this.loadComponents();
            Main.outputSavePath = new String(Main.inputPath);
            Main.detectorSavePath = new String(Main.detectorPath);
            this.fileSaveItem.setEnabled(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void fileOpenItemActionPerformed(ActionEvent evt) {
        block9: {
            try {
                JFileChooser chooser = new JFileChooser();
                FileFilter f1 = new FileFilter(){

                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return MainFrame.this.getExtension(f).equals("inp");
                    }

                    public String getDescription() {
                        return "(.inp) AASI input file.";
                    }
                };
                chooser.addChoosableFileFilter(f1);
                chooser.setCurrentDirectory(new File(chooserOpenHome));
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal != 0) break block9;
                chooserOpenHome = chooser.getSelectedFile().getParent();
                Main.inputPath = chooser.getSelectedFile().getCanonicalPath();
                String det = chooser.getSelectedFile().getParent() + "/";
                Main.readInput();
                if (notesPanel != null) {
                    notesPanel.setText(Main.notes);
                }
                Parameter p = Main.getParameter("1026");
                String df = (String)p.getValue();
                df = df.substring(1, df.length() - 1);
                Main.detectorPath = det + df;
                boolean success = true;
                try {
                    Main.readDetector();
                }
                catch (Exception ex) {
                    success = false;
                }
                if (!success) {
                    try {
                        Main.detectorPath = ".." + File.separator + "detectors" + File.separator + df;
                        Main.readDetector();
                    }
                    catch (Exception ex) {
                        Main.warnUser("Detector file " + df + " not found.\nMake sure its in the same directory as the input or \n in the AASI/detectors directory.\nUsing AASI/bin/Detector.det instead.");
                    }
                }
                this.clearComponents();
                this.loadComponents();
                Main.outputSavePath = new String(Main.inputPath);
                Main.detectorSavePath = new String(Main.detectorPath);
                this.fileSaveItem.setEnabled(true);
                if (this.fitPanel != null) {
                    this.fitPanel.invalidateVariableParams();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public int runAndWait() {
        this.absorbed.clear();
        this.sumPlot = true;
        this.lockComponentsRun();
        Main.clearInfoWindow();
        this.fixDetectorParams();
        this.clearSum();
        if (this.lineEnergyRadioBtn.isSelected()) {
            Parameter p = (Parameter)this.decaysField.getValueAt(0, 0);
            Main.getParameter("1011").setValue(p.getIntegerValue());
            Main.writeOutput();
            Main.runSimulator();
            this.freeComponentsRun();
            return 1;
        }
        Main.clearSimulationState();
        this.wait = false;
        int nnuclides = this.getNumberOfItemsInTableCol(this.nuclidesTable, 0);
        boolean stop = false;
        if (nnuclides == 0) {
            this.tabsPane.setSelectedComponent(this.sourceDesktop);
            Main.warnUser("Should select a nuclide or line-energy as the\nalpha radiation emitter before running simulation.");
            stop = true;
        }
        int simNum = 0;
        for (int i = 0; i < nnuclides && !stop; ++i) {
            Parameter p = (Parameter)this.nuclidesTable.getValueAt(i, 1);
            Nuclide n = (Nuclide)this.nuclidesTable.getValueAt(i, 0);
            String origValue = Main.getParameter("1016").getStringValue();
            if (!MainFrame.hasCoincidenceData(n)) {
                origValue = Main.getParameter("1016").getStringValue();
                Main.getParameter("1016").setValue("n");
            }
            if (Main.getParameter("1016").getStringValue().equals("n") || !this.coincidencesCheckbox1.isSelected()) {
                Main.getParameter("1116").setValue("'dummycoinc.ccf'");
            } else {
                Main.getParameter("1116").setValue(this.coincidenceOutputFileField.getText());
            }
            boolean bl = stop = Main.getSimulationHadErrors() || Main.getSimulationStoppedByUser();
            if (!stop) {
                Main.getParameter("1011").setValue(p.getIntegerValue());
                Main.getParameter("1029").setValue("'" + n.getName() + "'");
                Main.getParameter("1030").setValue("'" + n.library + "'");
                Main.writeOutput();
                Main.runSimulator();
                this.wait = true;
                Main.getParameter("1016").setValue(origValue);
            }
            ++simNum;
            this.absorbed.add(new Integer(Main.absorbed));
        }
        Main.getParameter("1116").setValue(this.coincidenceOutputFileField.getText());
        this.freeComponentsRun();
        if (nnuclides > 1 && !stop) {
            this.plotSum();
        }
        Main.clearSimulationState();
        return simNum;
    }

    public int getAbsorbed(int simNum) {
        return (Integer)this.absorbed.get(simNum);
    }

    public void run() {
        this.lockComponentsRun();
        Main.clearInfoWindow();
        this.fixDetectorParams();
        this.clearSum();
        if (this.lineEnergyRadioBtn.isSelected()) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    Parameter p = (Parameter)MainFrame.this.decaysField.getValueAt(0, 0);
                    Main.getParameter("1011").setValue(p.getIntegerValue());
                    Main.writeOutput();
                    Main.runSimulator();
                    MainFrame.this.freeComponentsRun();
                }
            });
            t.start();
        } else {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    String coincValue;
                    Main.clearSimulationState();
                    MainFrame.this.wait = false;
                    int nnuclides = MainFrame.this.getNumberOfItemsInTableCol(MainFrame.this.nuclidesTable, 0);
                    boolean stop = false;
                    if (nnuclides == 0) {
                        MainFrame.this.tabsPane.setSelectedComponent(MainFrame.this.sourceDesktop);
                        Main.warnUser("Should select a nuclide or line-energy as the\nalpha radiation emitter before running simulation.");
                        stop = true;
                    }
                    if ((coincValue = Main.getParameter("1016").getStringValue()).equals("y")) {
                        boolean hasData = false;
                        int ndata = 0;
                        for (int i = 0; i < nnuclides; ++i) {
                            Nuclide n = (Nuclide)MainFrame.this.nuclidesTable.getValueAt(i, 0);
                            if (MainFrame.hasCoincidenceData(n)) {
                                ++ndata;
                            }
                            hasData = hasData || MainFrame.hasCoincidenceData(n);
                        }
                        if (ndata > 1 && MainFrame.this.coincidencesCheckbox1.isSelected()) {
                            Main.warnUser("You are simulating multiple nuclides with coincidences.\nOnly the last coincidence calculation result will be stored to the coincidence output file:\n" + MainFrame.this.coincidenceOutputFileField.getText());
                        }
                        if (!hasData) {
                            Main.warnUser("You have selected coincidence calculations but none of the nuclides in the simulation have coincidence data!\nCoincidences will be disabled", true);
                        }
                    }
                    for (int i = 0; i < nnuclides && !stop; ++i) {
                        Parameter p = (Parameter)MainFrame.this.nuclidesTable.getValueAt(i, 1);
                        Nuclide n = (Nuclide)MainFrame.this.nuclidesTable.getValueAt(i, 0);
                        String origValue = Main.getParameter("1016").getStringValue();
                        if (!MainFrame.hasCoincidenceData(n)) {
                            Main.getParameter("1016").setValue("n");
                        }
                        if (Main.getParameter("1016").getStringValue().equals("n") || !MainFrame.this.coincidencesCheckbox1.isSelected()) {
                            Main.getParameter("1116").setValue("'dummycoinc.ccf'");
                        } else {
                            Main.getParameter("1116").setValue(MainFrame.this.coincidenceOutputFileField.getText());
                        }
                        boolean bl = stop = Main.getSimulationHadErrors() || Main.getSimulationStoppedByUser();
                        if (stop) continue;
                        Main.getParameter("1011").setValue(p.getIntegerValue());
                        Main.getParameter("1029").setValue("'" + n.getName() + "'");
                        Main.getParameter("1030").setValue("'" + n.library + "'");
                        Main.writeOutput();
                        Main.runSimulator();
                        MainFrame.this.wait = true;
                        Main.getParameter("1016").setValue(origValue);
                    }
                    Main.getParameter("1116").setValue(MainFrame.this.coincidenceOutputFileField.getText());
                    MainFrame.this.freeComponentsRun();
                    if (nnuclides > 1 && !stop) {
                        MainFrame.this.plotSum();
                    }
                    Main.clearSimulationState();
                }
            });
            t.setName("GUI simulation invoker");
            t.start();
        }
    }

    private void runMenuItemActionPerformed(ActionEvent evt) {
        Main.setPopupPlot(true);
        this.run();
    }

    private void coincidenceOutputFileFieldKeyReleased(KeyEvent evt) {
        String s = this.coincidenceOutputFileField.getText();
        if (s == null || s.length() == 0) {
            return;
        }
        if (s.charAt(0) != '\'') {
            s = "'" + s;
        }
        if (s.charAt(s.length() - 1) != '\'') {
            s = s + "'";
        }
        Main.getParameter("1116").setValue(s);
    }

    private void chooseCoincidenceOutputMouseClicked(MouseEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File(this.outputDir));
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                this.outputDir = f.getParent();
                Main.getParameter("1116").setValue("'" + f.getAbsolutePath() + "'");
                this.coincidenceOutputFileField.setText("'" + f.getAbsolutePath() + "'");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void openLibrary2MouseClicked(MouseEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File(this.outputDir));
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                this.outputDir = f.getParent();
                Main.getParameter("1116").setValue("'" + f.getAbsolutePath() + "'");
                this.coincidenceOutputFileField.setText("'" + f.getAbsolutePath() + "'");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void coincidenceOutputFileFieldActionPerformed(ActionEvent evt) {
    }

    private void coincidencesCheckbox1checkBox_handleActionPerformed(ActionEvent evt) {
        this.enableCoincidences(this.coincidencesCheckbox.isSelected());
    }

    static {
        notesWindowX = 20;
        notesWindowY = 20;
        notesWindowW = 300;
        notesWindowH = 300;
        notesWindowS = false;
        sketchWindowX = 20;
        sketchWindowY = 20;
        sketchWindowW = 300;
        sketchWindowH = 320;
        sketchWindowS = false;
        logWindowX = 20;
        logWindowY = 20;
        logWindowW = 400;
        logWindowH = 200;
        logWindowS = false;
        chooserSaveHome = Main.workingDir;
        chooserOpenHome = Main.workingDir;
    }
}

