/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.CustomCellEditor;
import core.Help;
import core.Main;
import core.Parameter;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class ParameterEditor
extends CustomCellEditor
implements TableCellEditor {
    JTextField textField = new JTextField();
    JCheckBox checkBox = new JCheckBox();
    static Double inf;
    Parameter editedParam;
    int editedParamType = -1;
    private final int NONE = 0;
    private final int FLOAT = 1;
    private final int BOOLEAN = 2;
    private final int INTEGER = 3;
    private final int NOT_EDITABLE = 4;
    private boolean changed = false;
    private boolean editingDone = true;
    JTable tab;
    String str;

    public ParameterEditor() {
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ParameterEditor.this.changed = true;
            }
        });
        this.textField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (ParameterEditor.this.changed) {
                    ParameterEditor.this.fireEditingStopped();
                } else {
                    ParameterEditor.this.tab.removeEditor();
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    public void updateUI() {
        this.textField.updateUI();
        this.checkBox.updateUI();
    }

    public ParameterEditor(boolean alignRight) {
        this();
        if (alignRight) {
            this.textField.setHorizontalAlignment(4);
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        this.changed = false;
        System.out.println("Begin editing.");
        this.editingDone = false;
        this.tab = table;
        this.editedParam = (Parameter)value;
        if (this.editedParam == null) {
            this.fireEditingCanceled();
            return null;
        }
        if (this.editedParam.getName() != null && this.editedParam.getName().endsWith("Z")) {
            this.editedParamType = 4;
            this.textField.setEditable(false);
            this.textField.setText(this.editedParam.getValue().toString());
            return this.textField;
        }
        this.textField.setEditable(true);
        if (this.editedParam.getHelpId() != null) {
            System.out.println("HelpId defined:" + this.editedParam.getHelpId());
            Help.enableHelpKey(this.textField, this.editedParam.getHelpId());
        } else if (Help.getId(table) != null) {
            Help.enableHelpKey(this.textField, Help.getId(table));
        }
        Object val = this.editedParam.getValue();
        if (val instanceof Boolean) {
            this.editedParamType = 2;
            this.checkBox.setSelected((Boolean)val);
            return this.checkBox;
        }
        if (val instanceof Float) {
            this.editedParamType = 1;
            this.textField.setText(val.toString());
            return this.textField;
        }
        if (val instanceof Integer) {
            this.editedParamType = 3;
            this.textField.setText(val.toString());
            return this.textField;
        }
        this.textField.setText(val.toString());
        return this.textField;
    }

    public Object getCellEditorValue() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ParameterEditor.this.tab.removeEditor();
                }
            });
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (this.editedParamType == 0) {
                this.editedParam = null;
                return null;
            }
            String txt = this.textField.getText();
            txt.replaceAll("\\s*", "");
            if (txt.length() < 1) {
                return this.editedParam;
            }
            if (this.editedParamType == 1) {
                Float min = (Float)this.editedParam.getMinValue();
                Float max = (Float)this.editedParam.getMaxValue();
                Float val = new Float(this.textField.getText());
                if (min != null) {
                    if (!this.editedParam.getMinBoundInclusive()) {
                        if (val.floatValue() <= min.floatValue()) {
                            if (max != null) {
                                this.warn("Illegal value. Value must be in the range ( " + min + " , " + max + " ).");
                            } else {
                                this.warn("Illegal value. Value must be > " + min);
                            }
                            return this.editedParam;
                        }
                    } else if (val.floatValue() < min.floatValue()) {
                        if (max != null) {
                            this.warn("Illegal value. Value must be in the range ( " + min + " , " + max + " ).");
                        } else {
                            this.warn("Illegal value. Value must be >= " + min);
                        }
                        return this.editedParam;
                    }
                }
                if (max != null) {
                    if (!this.editedParam.getMaxBoundInclusive()) {
                        if (val.floatValue() >= max.floatValue()) {
                            if (min != null) {
                                this.warn("Illegal value. Value must be in the range ( " + min + " , " + max + " ).");
                            } else {
                                this.warn("Illegal value. Value must be < " + max);
                            }
                            return this.editedParam;
                        }
                    } else if (val.floatValue() > max.floatValue()) {
                        if (max != null) {
                            this.warn("Illegal value. Value must be in the range ( " + min + " , " + max + " ).");
                        } else {
                            this.warn("Illegal value. Value must be <= " + max);
                        }
                        return this.editedParam;
                    }
                }
                this.editedParam.setValue(val);
                return this.editedParam;
            }
            if (this.editedParamType == 3) {
                Integer min = (Integer)this.editedParam.getMinValue();
                Integer max = (Integer)this.editedParam.getMaxValue();
                Integer val = new Integer(this.textField.getText());
                if (min != null) {
                    if (!this.editedParam.getMinBoundInclusive()) {
                        if (val <= min) {
                            if (max != null) {
                                this.warn("Illegal value. Value must be in the range ( " + min + " , " + max + " ). ");
                            } else {
                                this.warn("Illegal value. Value must be > " + min);
                            }
                            return this.editedParam;
                        }
                    } else if (val < min) {
                        if (max != null) {
                            this.warn("Illegal value. Value must be in the range ( " + min + " , " + max + "). ");
                        } else {
                            this.warn("Illegal value. Value must be >= " + min);
                        }
                        return this.editedParam;
                    }
                }
                if (max != null) {
                    if (!this.editedParam.getMaxBoundInclusive()) {
                        if (val >= max) {
                            if (min != null) {
                                this.warn("Illegal value. Value must be in the range (" + min + "," + max + ").");
                            } else {
                                this.warn("Illegal value. Value must be < " + max);
                            }
                            return this.editedParam;
                        }
                    } else if (val > max) {
                        if (max != null) {
                            this.warn("Illegal value. Value must be in the range ( " + min + " , " + max + " ).");
                        } else {
                            this.warn("Illegal value. Value must be <= " + max);
                        }
                        return this.editedParam;
                    }
                }
                this.editedParam.setValue(val);
                return this.editedParam;
            }
            Parameter ret = this.editedParam;
            this.editedParamType = 0;
            this.editedParam = null;
            this.editingDone = true;
            return ret;
        }
        catch (Exception e) {
            String name = this.editedParam.getValue().getClass().getName();
            String[] tok = name.split("\\.");
            this.warn("Improper value. Was expecting " + tok[tok.length - 1].toLowerCase());
            return this.editedParam;
        }
    }

    private void warn(String wstr) {
        this.str = wstr;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Main.warnUser(ParameterEditor.this.str);
            }
        });
    }
}

