/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.BasicRenderer;
import UI.CustomCellRenderer;
import core.Parameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class ParameterNameRenderer
extends CustomCellRenderer
implements TableCellRenderer {
    JTextField field;
    static Parameter selectedParameter;
    static JLabel empty;
    JLabel label;
    Color background;
    JCheckBox variate;
    static boolean variationMode;
    JPanel panel;
    ActionListener action;

    public ParameterNameRenderer() {
        if (this.field == null) {
            this.field = new JTextField();
        }
        this.label = new JLabel();
        this.label.setFont(this.field.getFont());
        if (empty == null) {
            empty = new JLabel();
        }
        empty.setOpaque(false);
        this.label.setBorder(null);
        empty.setBorder(null);
        this.background = BasicRenderer.background;
        this.label.setBackground(this.background);
    }

    public static void setVariationMode(boolean enabled) {
        variationMode = enabled;
    }

    public ParameterNameRenderer(boolean alignRight) {
        this();
        if (alignRight) {
            this.label.setHorizontalAlignment(4);
        }
    }

    public void updateUI() {
        if (this.field != null) {
            this.field.updateUI();
        }
        if (empty != null) {
            empty.updateUI();
        }
        if (this.label != null) {
            this.label.updateUI();
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        boolean locked = false;
        if (value != null && !(value instanceof String)) {
            Parameter par = (Parameter)value;
            this.label.setForeground(empty.getForeground());
            if (par.getDescription() != null) {
                this.label.setToolTipText(par.getDescription());
            }
            if (!isSelected && variationMode) {
                this.label.setToolTipText(null);
            }
            this.label.setText(" " + par.getName().toString());
            if (isSelected && !variationMode) {
                this.label.setBackground(table.getSelectionBackground());
                this.label.setForeground(table.getSelectionForeground());
            }
        } else {
            return empty;
        }
        this.label.setEnabled(table.isEnabled() && !locked && (!variationMode || isSelected));
        this.label.setOpaque(!table.isEnabled());
        this.label.setOpaque(false);
        if (isSelected) {
            this.label.setOpaque(true);
        }
        if (variationMode && table.isEnabled() && !locked) {
            if (this.panel == null) {
                this.panel = new JPanel();
            }
            this.panel.setLayout(new FlowLayout(0, 0, 0));
            if (this.variate == null) {
                this.variate = new JCheckBox();
            }
            this.variate.setSelected(isSelected);
            this.variate.setOpaque(false);
            this.panel.add(this.variate);
            this.panel.add(this.label);
            if (isSelected) {
                selectedParameter = (Parameter)value;
            }
            return this.panel;
        }
        return this.label;
    }

    public static Parameter getSelectedParameter() {
        return selectedParameter;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    static {
        variationMode = false;
    }
}

