/*
 * Decompiled with CFR 0.152.
 */
package UI;

import java.awt.Color;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.JLabel;

class ProportionLabel
extends JLabel {
    float start = 0.0f;
    float end = 0.5f;
    float amnt = 0.0f;
    boolean last = false;
    DecimalFormat dec = new DecimalFormat();
    static JLabel tlabel;
    static Color backDis;

    public ProportionLabel() {
        if (tlabel == null) {
            tlabel = new JLabel();
            tlabel.setEnabled(false);
            Color c = tlabel.getBackground();
            int f = 15;
            backDis = new Color(c.getRed() - f, c.getGreen() - f, c.getBlue() - f);
        }
        this.dec.setMaximumFractionDigits(1);
        DecimalFormatSymbols s = this.dec.getDecimalFormatSymbols();
        s.setDecimalSeparator('.');
        this.dec.setDecimalFormatSymbols(s);
    }

    public void setMinMax(float min, float max) {
        this.start = min;
        this.end = max;
    }

    public void setFinal(boolean v) {
        this.last = v;
    }

    public void setAmount(float v) {
        this.amnt = v;
    }

    public void paint(Graphics g) {
        if (!this.isEnabled()) {
            super.paint(g);
            g.setColor(backDis);
            int sx = Math.round(this.start * (float)this.getWidth());
            int ex = Math.round(this.end * (float)this.getWidth());
            if (sx == ex) {
                return;
            }
            int w = this.getWidth();
            int h = this.getHeight();
            if (!this.last) {
                g.fillRect(0, 0, ex - sx, this.getHeight());
            }
            return;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.green);
        int sx = Math.round(this.start * (float)this.getWidth());
        int ex = Math.round(this.end * (float)this.getWidth());
        if (sx == ex) {
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        if (!this.last) {
            g.fillRect(0, 0, ex - sx, this.getHeight());
        } else {
            g.fillRect(0, 0, w - sx, this.getHeight());
        }
        g.setColor(Color.black);
        g.drawString("" + this.dec.format(this.amnt * 100.0f) + "%", w / 2, h - 2);
    }
}

