/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Main;
import core.Parameter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InputReader {
    private static boolean debug = true;
    static boolean blank = false;
    static boolean autoCreate = false;
    static BufferedReader r;
    static String delim;

    public void setAutoCreateParameters(boolean enabled) {
        autoCreate = enabled;
    }

    public void loadInput(String inputPath, List inputTemplate) throws Exception {
        BufferedReader in;
        Object line = null;
        String[] tokens = null;
        Object param = null;
        r = in = new BufferedReader(new FileReader(inputPath));
        Iterator iter = inputTemplate.iterator();
        while (iter.hasNext()) {
            if (!blank) {
                tokens = InputReader.nextLineTokens(in, delim);
            } else {
                blank = false;
            }
            if (tokens == null) continue;
            Object o = iter.next();
            List l = (List)o;
            String s = (String)l.get(0);
            if (!s.startsWith("blank")) {
                InputReader.handleTokens((List)o, tokens);
                continue;
            }
            blank = true;
        }
        in.close();
    }

    private static void handleTokens(String s, String[] tokens) {
        if (s.charAt(0) == '#') {
            InputReader.handleLoop(s, tokens);
        } else {
            Parameter param = Main.getParameter(s);
            if (param == null && autoCreate) {
                param = Main.createParameter(s);
                param.setValue("");
                param.setName(s);
            }
            if (param != null) {
                Object value = param.getValue();
                InputReader.setParamValue(param, tokens[0]);
                if (debug) {
                    System.out.println("\t" + param.getName() + " (" + s + ")");
                    System.out.println("\t\t<-" + tokens[0]);
                }
            } else if (debug) {
                System.out.println("Skipped " + s);
            }
        }
    }

    private static void handleTokens(List temp, String[] tokens) {
        int i = 0;
        Iterator temp_iter = temp.iterator();
        while (temp_iter.hasNext()) {
            Object paramhash = temp_iter.next();
            String hash = (String)paramhash;
            if (hash.charAt(0) == '?') {
                InputReader.handleConditional(hash, tokens);
                continue;
            }
            if (hash.charAt(0) == '#') {
                InputReader.handleLoop(hash, tokens);
                continue;
            }
            Parameter param = Main.getParameter((String)paramhash);
            if (param == null && autoCreate) {
                param = Main.createParameter((String)paramhash);
                param.setValue("");
                param.setName((String)paramhash);
            }
            if (param != null) {
                Object value = param.getValue();
                if (debug) {
                    System.out.println("\t" + param.getName() + " (" + paramhash + ")");
                    if (paramhash.equals("1906")) {
                        System.out.println("Here");
                    }
                    System.out.println("\t\t<-" + tokens[i]);
                }
                InputReader.setParamValue(param, tokens[i++]);
                continue;
            }
            if (!debug) continue;
            System.out.println("Skipped " + (String)paramhash);
        }
    }

    private static void handleConditional(String s, String[] tokens) {
        String cond = "=|<|>|:";
        s = s.substring(1, s.length() - 1);
        String[] expr = s.split(cond);
        Parameter operand = Main.getParameter(expr[0]);
        String operator = s.substring(expr[0].length(), expr[0].length() + 1);
        String literal = expr[1];
        int sepInd = s.lastIndexOf(58);
        int bInd = s.indexOf(58);
        String ctrue = s.substring(bInd + 1, sepInd);
        String cfalse = s.substring(sepInd + 1, s.length());
        Object templ = null;
        if (debug) {
            System.out.println("\n\n\nFound conditional!");
            System.out.println(expr.length + " tokens:");
            System.out.println("\t\tOperand:" + operand.getName());
            System.out.println("\t\tOperator:" + operator);
            System.out.println("\t\tLiteral:" + literal);
            System.out.println("\t\ttrue:" + ctrue);
            System.out.println("\t\tfalse:" + cfalse);
        }
        if ((templ = InputReader.compare(operand, literal, operator) ? InputReader.eval(ctrue) : InputReader.eval(cfalse)) == null) {
            blank = true;
            return;
        }
        if (templ instanceof String) {
            InputReader.handleTokens((String)templ, tokens);
        } else {
            InputReader.handleTokens((List)templ, tokens);
        }
    }

    public static void handleLoop(String s, String[] tokens) {
        block22: {
            Object templ;
            int compound;
            block24: {
                int rowLoop;
                block23: {
                    String[] newTokens;
                    block21: {
                        String cond = "c|r|\\{";
                        rowLoop = -1;
                        compound = -1;
                        int cInd = s.indexOf(99);
                        int rInd = s.indexOf(114);
                        int bInd = s.indexOf(123);
                        int opInd = -1;
                        if (cInd == -1) {
                            cInd = Integer.MAX_VALUE;
                        }
                        if (rInd == -1) {
                            rInd = Integer.MAX_VALUE;
                        }
                        if (bInd == -1) {
                            bInd = Integer.MAX_VALUE;
                        }
                        if (cInd < rInd && cInd < bInd) {
                            opInd = cInd;
                        } else if (rInd < cInd && rInd < bInd) {
                            opInd = rInd;
                            rowLoop = 1;
                        } else {
                            opInd = bInd;
                            compound = 1;
                        }
                        s = s.substring(1);
                        String operator = "" + s.charAt(opInd - 1);
                        String arg = s.substring(opInd);
                        String opKey = s.substring(0, opInd - 1);
                        Parameter operand = Main.getParameter(opKey);
                        if (arg.charAt(arg.length() - 1) == '}') {
                            arg = arg.substring(0, arg.length() - 1);
                        }
                        templ = null;
                        String str = InputReader.loop(operand, arg);
                        templ = InputReader.eval(str);
                        newTokens = new String[tokens.length - 1];
                        if (debug) {
                            System.out.println("\n\n\nFound loop!");
                            System.out.println("\t\tOperand hash:" + opKey);
                            System.out.println("\t\tIterations:" + operand.getValue());
                            System.out.println("\t\tOperator:" + operator);
                            System.out.println("\t\tArg:" + arg);
                        }
                        if (rowLoop == 1) {
                            rowLoop = (Integer)operand.getValue();
                        }
                        if (compound == 1) {
                            compound = (Integer)operand.getValue();
                        }
                        for (int i = 1; i < tokens.length; ++i) {
                            newTokens[i - 1] = tokens[i];
                        }
                        if (!(templ instanceof String) || rowLoop != -1 || compound != -1) break block21;
                        InputReader.handleTokens((String)templ, newTokens);
                        break block22;
                    }
                    if (!(templ instanceof List) || rowLoop != -1 || compound != -1) break block23;
                    InputReader.handleTokens((List)templ, newTokens);
                    break block22;
                }
                if (rowLoop == -1) break block24;
                List tList = (List)templ;
                int ind = 0;
                int i = 0;
                while (i < rowLoop) {
                    String[] rtokens = tokens;
                    if (rtokens != null) {
                        ArrayList<String> templElem = new ArrayList<String>();
                        int endInd = tList.size() / rowLoop;
                        for (int j = 0; j < endInd; ++j) {
                            String templStr = (String)tList.get(ind);
                            templElem.add(templStr);
                            ++ind;
                        }
                        InputReader.handleTokens(templElem, rtokens);
                        ++i;
                    }
                    if (i == rowLoop) continue;
                    tokens = InputReader.nextLineTokens(r, delim);
                }
                break block22;
            }
            if (compound == -1) break block22;
            List tList = (List)templ;
            int ind = 1;
            int i = 0;
            while (ind < tList.size()) {
                String[] rtokens = tokens;
                if (rtokens != null) {
                    ArrayList<String> templElem = new ArrayList<String>();
                    boolean nline = false;
                    int j = 0;
                    while (!nline && ind < tList.size()) {
                        String templStr = (String)tList.get(ind);
                        if (templStr.startsWith("\\")) {
                            nline = true;
                            ++ind;
                        } else {
                            templElem.add(templStr);
                            ++ind;
                        }
                        ++j;
                    }
                    InputReader.handleTokens(templElem, rtokens);
                }
                if (ind < tList.size()) {
                    tokens = InputReader.nextLineTokens(r, delim);
                }
                ++i;
            }
        }
    }

    private static void setParamValue(Parameter p, String value) {
        Object v = p.getValue();
        if (v instanceof Float) {
            if (p.getCoeff() == null) {
                p.setValue(new Float(value));
            } else {
                Float fval = new Float(value);
                p.setValue(new Float(fval.floatValue() / p.getCoeff().floatValue()));
            }
        } else if (v instanceof Integer) {
            p.setValue(new Integer(value));
        } else if (v instanceof String) {
            p.setValue(value);
        } else {
            throw new RuntimeException("Illegal parameter value! Must be one of: float, integer, string!");
        }
    }

    public static boolean compare(Parameter operand, String literal, String operator) {
        Object o = operand.getValue();
        if (o instanceof Float) {
            Float comp = new Float(literal);
            Float value = (Float)o;
            int res = value.compareTo(comp);
            if (operator.equals("=")) {
                return res == 0;
            }
            if (operator.equals("<")) {
                return res < 0;
            }
            return res > 0;
        }
        if (o instanceof String) {
            String value = (String)o;
            int res = value.compareTo(literal);
            if (operator.equals("=")) {
                return res == 0;
            }
            if (operator.equals("<")) {
                return res < 0;
            }
            return res > 0;
        }
        if (o instanceof Integer) {
            Integer comp = new Integer(literal);
            Integer value = (Integer)o;
            int res = value.compareTo(comp);
            if (operator.equals("=")) {
                return res == 0;
            }
            if (operator.equals("<")) {
                return res < 0;
            }
            return res > 0;
        }
        return false;
    }

    public static Object eval(String expr) {
        String delim = ",";
        if (expr.charAt(0) == '?' || expr.charAt(0) == '#') {
            return expr;
        }
        String[] tokens = expr.split(delim);
        ArrayList<String> tempList = new ArrayList<String>();
        boolean cat = false;
        String templS = tokens[0];
        for (int i = 1; i < tokens.length + 1; ++i) {
            templS = cat ? templS + "," + tokens[i - 1] : tokens[i - 1];
            if (tokens[i - 1].indexOf(114) != -1) {
                cat = true;
            }
            if (i == tokens.length) {
                cat = false;
            } else if (tokens[i].startsWith("\\")) {
                cat = false;
            }
            if (cat) continue;
            tempList.add(templS);
        }
        if (tokens.length == 1) {
            if (expr.equals("blank")) {
                return null;
            }
            return tokens[0];
        }
        return tempList;
    }

    public static String loop(Parameter op, String arg) {
        int lim = (Integer)op.getValue();
        String[] args = arg.split(",");
        String argn = "";
        String cat = "";
        for (int i = 0; i < lim; ++i) {
            for (int j = 0; j < args.length; ++j) {
                argn = args[j];
                if (argn.charAt(0) != '\\') {
                    if (argn.charAt(0) != '?' && argn.indexOf(35) == -1) {
                        Main.cloneParameter(argn, argn + "+" + i);
                        if (debug) {
                            System.out.println("Created param:" + argn + "+" + i);
                        }
                    } else {
                        String[] args2 = argn.split("r|c");
                        args2[0] = args2[0].substring(1);
                        Main.cloneParameter(args2[0], args2[0] + "+" + i);
                        if (debug) {
                            System.out.println("Created param:" + args2[0] + "+" + i);
                        }
                        Main.cloneParameter(args2[1], args2[1] + "+" + i);
                        if (debug) {
                            System.out.println("Created param:" + args2[1] + "+" + i);
                        }
                        argn = "#" + args2[0] + "+" + i + argn.charAt(args2[0].length() + 1) + args2[1];
                    }
                    if (i == 0 && j == 0) {
                        cat = cat + argn + "+" + i;
                        continue;
                    }
                    cat = cat + ',' + argn + "+" + i;
                    continue;
                }
                cat = i == 0 && j == 0 ? cat + "\\" : cat + ",\\";
            }
        }
        return cat;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static String[] nextLineTokens(BufferedReader reader, String delim) {
        String[] tokens = null;
        boolean read = false;
        try {
            block2: while (!read) {
                String line = reader.readLine();
                if (line == null) {
                    return null;
                }
                if ((line = line.replaceFirst("!.*", "")).length() == 0) {
                    return null;
                }
                if (Character.isWhitespace((line = InputReader.retainStrings(line)).charAt(0))) {
                    line = line.replaceFirst("\\s+", "");
                }
                if (line.length() != 0) {
                    tokens = line.split(delim);
                    read = true;
                    int i = 0;
                    while (true) {
                        if (i >= tokens.length) continue block2;
                        tokens[i] = tokens[i].replaceAll("#", " ");
                        ++i;
                    }
                }
                read = false;
            }
            return tokens;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tokens;
    }

    private static String retainStrings(String s) {
        char[] c = s.toCharArray();
        int phase = 1;
        for (int i = 0; i < c.length; ++i) {
            if (phase == 1) {
                if (c[i] != '\'') continue;
                phase = 2;
                continue;
            }
            if (phase != 2) continue;
            if (c[i] == ' ') {
                c[i] = 35;
                continue;
            }
            if (c[i] != '\'') continue;
            phase = 1;
        }
        return new String(c);
    }

    static {
        delim = "\\s+,|,\\s+|\\s+|,";
    }
}

