/*
 * Decompiled with CFR 0.152.
 */
package core;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SPEReader {
    private int phase = 0;
    private int ENERGY = 1;
    private int SPECTRUM = 2;
    private int ID = 3;
    private int DATE = 4;
    double width = 0.0;

    public double getChannelWidth() {
        return this.width * 1000.0;
    }

    public List read(String filePath) {
        ArrayList<float[]> ret = new ArrayList<float[]>();
        String line = "";
        boolean ctr = false;
        float[] energy = null;
        float[] counts = null;
        float[] x = new float[]{0.0f, 0.0f};
        float[] y = new float[]{1.0f, 1.0f};
        float s = 1.0f;
        int pt = 0;
        int speLine = 0;
        float a = 10.545455f;
        float b = 77.85785f;
        int index = 0;
        int lineNum = 0;
        ArrayList<Float> list = new ArrayList<Float>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            while ((line = in.readLine()) != null) {
                System.out.println("LINE" + ++lineNum + " :" + line);
                int len = line.length();
                if (len > 0 && Character.isWhitespace(line.charAt(0))) {
                    line = line.replaceFirst("\\s+", "");
                }
                line = line.replaceAll("\\s+", ",");
                if (len > 0) {
                    String[] tok;
                    if (this.phase == this.ENERGY) {
                        tok = line.split(",");
                        x[pt] = Float.parseFloat(tok[1]);
                        y[pt] = Float.parseFloat(tok[2]);
                        this.phase = 0;
                    }
                    if (this.phase == this.SPECTRUM) {
                        if (speLine > 0) {
                            tok = line.split(",");
                            for (int i = 0; i < tok.length; ++i) {
                                float channel = index + 1;
                                float e = (channel * a + b) / 1000.0f;
                                float c = Integer.parseInt(tok[i]);
                                ++index;
                                list.add(new Float(e));
                                list.add(new Float(c));
                            }
                        }
                        ++speLine;
                    }
                }
                if (line.startsWith("$SPECID:")) {
                    this.phase = this.ID;
                }
                if (line.startsWith("$DATE_MEA:")) {
                    this.phase = this.DATE;
                }
                if (!line.startsWith("$DATA:")) continue;
                this.phase = this.SPECTRUM;
            }
            energy = new float[list.size() / 2];
            counts = new float[energy.length];
            Iterator iter = list.iterator();
            int i = 0;
            while (iter.hasNext()) {
                energy[i] = ((Float)iter.next()).floatValue();
                counts[i++] = ((Float)iter.next()).floatValue();
            }
            System.out.println("Parsed " + energy.length + " channels");
            ret.add(energy);
            ret.add(counts);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }
}

