/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.SikaOutputHandler;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SikaOutputReader {
    SikaOutputHandler handler = null;

    public void loadResults(String path) {
        try {
            File xmlfile = new File(path);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            FileInputStream instream = new FileInputStream(xmlfile);
            this.handler = new SikaOutputHandler();
            reader.setContentHandler(this.handler);
            reader.parse(new InputSource(instream));
            instream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public double getChiSquared() {
        return this.handler.getChiSquared();
    }

    public List getMultipliers() {
        return this.handler.getMultipliers();
    }

    public List getMultiplierUncertainties() {
        return this.handler.getMultiplierUncertainties();
    }

    public double getSlope() {
        return this.handler.getSlope();
    }

    public double getOffset() {
        return this.handler.getOffset();
    }

    public int getNumShapes() {
        return this.handler.getNumberOfShapes();
    }

    public String getShapeName(int shape) {
        return this.handler.getShapeName(shape);
    }

    public String getShapeFileName(String shapeName) {
        return this.handler.getShapeFileName(shapeName);
    }

    public boolean hasEnergyCalibration() {
        return this.handler.hasEnergyCalibration();
    }
}

