/*
 * Decompiled with CFR 0.152.
 */
package org.stuk.visualization.polygonal.util;

import UI.BasicEditor;
import UI.ImageUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.stuk.visualization.polygonal.BlinnShader;
import org.stuk.visualization.polygonal.FrameBuffer;
import org.stuk.visualization.polygonal.RenderingPipeline;
import org.stuk.visualization.polygonal.ScanConverter;
import org.stuk.visualization.polygonal.Shader;
import org.stuk.visualization.polygonal.util.PolyUtils;

public class PolyTest
extends JFrame {
    double[][] id = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    boolean stop = true;
    int w = 300;
    int h = 300;
    RenderingPipeline p;
    FrameBuffer fb;
    double dir = -1.0;
    double xdir = -1.0;
    double ydir = -1.0;
    double zdir = -1.0;
    double xdirc = -0.1;
    double ydirc = -0.1;
    double zdirc = -0.1;
    List bin = new ArrayList();
    double[] vrp = new double[]{40.0, 0.0, 20.0};
    double[] fp = new double[]{0.0, 0.0, 20.0};
    double[] up = new double[]{0.0, 0.0, 1.0};
    double[][] Tv = new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    double[] light = new double[]{1.0, 0.0, 0.0};
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField jTextField1;

    public PolyTest() {
        this.initComponents();
        this.setUpRenderer();
        this.testView();
    }

    private void setUpRenderer() {
        int numdatas = 7;
        this.p = new RenderingPipeline();
        this.fb = new FrameBuffer(this.w, this.h);
        ScanConverter sc = new ScanConverter(this.w, this.h, numdatas);
        double[] pl = new double[]{450.0, 0.0, 0.0};
        Vector<double[]> light = new Vector<double[]>();
        light.add(pl);
        this.p.setLights(light);
        BasicEditor dum = new BasicEditor();
        BufferedImage img = ImageUtil.getBufferedImage(dum.getClass().getResource("images/EnvMap.png"), (Component)new JLabel());
        BlinnShader s = new BlinnShader(img, this.p);
        this.p.setFrameBuffer(this.fb);
        this.p.setShader(s);
        this.p.setScanConverter(sc);
        double[][] prj = PolyUtils.getProjectionTransform(4.0, 1000.0, Math.toRadians(90.0), 1.0);
        this.p.setProjectionTransform(prj);
        PolyUtils.getViewingTransform(this.vrp, this.fp, this.up, this.Tv);
        this.p.setViewingTransform(this.Tv);
    }

    private void setUpParticleView() {
        double scale = 1000.0;
        double rx = 0.1 * scale;
        double ry = 0.2 * scale;
        double rz = 0.1194 * scale;
        this.fp[2] = 0.0;
        this.vrp[2] = 0.0;
        this.vrp[0] = 800.0;
        this.createEllipsoid(0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 20, this.bin);
    }

    private void testView() {
        double[] vrp2 = new double[]{0.75, 0.0, 0.0};
        double[] lp = new double[]{1.0, 0.0, 0.0};
        double[] fp2 = new double[]{0.0, 0.0, 0.01};
        this.vrp = vrp2;
        this.fp = fp2;
        double[] v1 = new double[]{0.0, 0.0, 0.0, 1.0};
        double[] v2 = new double[]{0.0, 0.05, 0.5, 1.0};
        double[] v3 = new double[]{0.0, 0.05, 0.5, 1.0};
        ArrayList<double[]> poly = new ArrayList<double[]>();
        poly.add(v1);
        poly.add(v2);
        ArrayList<double[]> data = new ArrayList<double[]>();
        double[] d1 = new double[]{0.0, v1[0], v1[1], v1[2], v1[0], v1[1], v1[2]};
        double[] d2 = new double[]{0.0, v1[0], v1[1], v1[2], v1[0], v1[1], v1[2]};
        double[] d3 = new double[]{0.0, v1[0], v1[1], v1[2], v1[0], v1[1], v1[2]};
        data.add(d1);
        data.add(d2);
        this.bin.add(poly);
        this.bin.add(data);
    }

    private void setUpGeneralView() {
        ArrayList c1 = new ArrayList();
        ArrayList d1 = new ArrayList();
        ArrayList c2 = new ArrayList();
        ArrayList d2 = new ArrayList();
        double scale = 10.0;
        double tdet = 14.0 * scale;
        double rdet = 11.0 * scale;
        double sdd = 44.0 * scale;
        this.createCylinder(0.0, 0.0, rdet, sdd, tdet, 8, this.bin, 0.4);
        this.createCylinder(0.0, 0.0, rdet + 50.0, sdd + tdet + 60.0, 100.0, 8, this.bin, 0.6);
        this.createCircle(0.0, 0.0, rdet, sdd + tdet, 8, c1, d1, 0.2);
        this.createCircle(0.0, 0.0, rdet + 50.0, sdd + tdet + 60.0, 8, c2, d2, 0.2);
        this.createCylinder(c1, d1, c2, d2, this.bin);
        double tsrc = 1.0 * scale;
        double rsrc = 6.96 * scale;
        this.createCylinder(0.0, 0.0, rsrc, -tsrc + 2.0, 10.0, 18, this.bin, 1.0);
        this.createCylinder(0.0, 0.0, rdet, -tsrc, tsrc, 18, this.bin, 0.8);
        this.fp[2] = sdd / 2.0;
        this.vrp[2] = sdd / 2.0;
        this.vrp[0] = 1600.0;
    }

    private void setUpDetectorView() {
        ArrayList c1 = new ArrayList();
        ArrayList d1 = new ArrayList();
        ArrayList c2 = new ArrayList();
        ArrayList d2 = new ArrayList();
        double scale = 10.0;
        double tdet = 14.0 * scale;
        double rdet = 11.0 * scale;
        double sdd = 44.0 * scale;
        this.createCylinder(0.0, 0.0, rdet, 0.0, tdet, 18, this.bin, 0.4);
        this.vrp[0] = 517.5;
        this.vrp[1] = 0.0;
        this.vrp[2] = 222.5;
        this.fp[0] = -0.5;
        this.fp[1] = 0.0;
        this.fp[2] = 0.5;
    }

    private void setUpSourceView() {
        ArrayList c1 = new ArrayList();
        ArrayList d1 = new ArrayList();
        ArrayList c2 = new ArrayList();
        ArrayList d2 = new ArrayList();
        double scale = 20.0;
        double tsrc = 1.0 * scale;
        double rsrc = 6.96 * scale;
        double rdet = 11.96 * scale;
        this.createCylinder(0.0, 0.0, rsrc, -tsrc + 2.0, 10.0, 18, this.bin, 1.0);
        this.createCircle(0.0, 0.0, rdet, -tsrc, 8, c1, d1, 0.7);
        this.bin.add(c1);
        this.bin.add(d1);
        double sdd = 44.0 * scale;
        this.fp[2] = sdd / 2.0;
        this.vrp[2] = sdd / 2.0;
    }

    private void setUpBackingplateView() {
        ArrayList c1 = new ArrayList();
        ArrayList d1 = new ArrayList();
        ArrayList c2 = new ArrayList();
        ArrayList d2 = new ArrayList();
        double scale = 20.0;
        double tsrc = 1.0 * scale;
        double rsrc = 6.96 * scale;
        double rdet = 11.96 * scale;
        this.createCylinder(0.0, 0.0, rsrc, -tsrc + 2.0, scale, 18, this.bin, 1.0);
        this.createCylinder(0.0, 0.0, rdet, -tsrc, tsrc, 18, this.bin, 0.8);
        double sdd = 44.0 * scale;
        this.vrp[0] = 362.5;
        this.vrp[1] = -185.0;
        this.vrp[2] = 45.5;
        this.fp[0] = -1237.5;
        this.fp[1] = -185.0;
        this.fp[2] = 45.5;
    }

    public void start() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                while (!PolyTest.this.stop) {
                    PolyTest.this.vrp[0] = PolyTest.this.vrp[0] - 2.5 * PolyTest.this.xdir;
                    PolyTest.this.vrp[1] = PolyTest.this.vrp[1] - 2.5 * PolyTest.this.ydir;
                    PolyTest.this.vrp[2] = PolyTest.this.vrp[2] - 2.5 * PolyTest.this.zdir;
                    PolyTest.this.fp[0] = PolyTest.this.fp[0] - 2.5 * PolyTest.this.xdir;
                    PolyTest.this.fp[1] = PolyTest.this.fp[1] - 2.5 * PolyTest.this.ydir;
                    PolyTest.this.fp[2] = PolyTest.this.fp[2] - 2.5 * PolyTest.this.zdir;
                    PolyTest.this.render();
                }
            }
        });
        t.start();
    }

    public void render() {
        System.out.println("Ref Point:" + PolyUtils.vectorToString(this.vrp) + " Focal point:" + PolyUtils.vectorToString(this.fp));
        PolyUtils.getViewingTransform(this.vrp, this.fp, this.up, this.Tv);
        this.p.setViewingTransform(this.Tv);
        this.jTextField1.setText(PolyUtils.vectorToString(this.fp));
        this.fb.clear();
        this.p.getGlobalData().clear();
        this.p.getGlobalData().add(this.vrp);
        int i = 0;
        while (i < this.bin.size()) {
            Object o;
            if ((o = this.bin.get(i++)) instanceof Shader) {
                this.p.setShader((Shader)o);
                continue;
            }
            List v = (List)o;
            List d = (List)this.bin.get(i++);
            this.p.setVertices(v);
            this.p.setVertexData(d);
            this.p.render();
        }
        Graphics2D g = (Graphics2D)this.jPanel1.getGraphics();
        g.drawImage(this.fb.getImage(), null, 0, 0);
    }

    private void createCircle(double x, double y, double r, double z, int numSegs, List vertices, List datas, double in) {
        double ang = 0.0;
        double angIncr = Math.PI * 2 / (double)numSegs;
        for (int i = 0; i < numSegs; ++i) {
            double[] v = new double[]{0.0, 0.0, 0.0, 1.0};
            v[0] = x + Math.cos(ang) * r;
            v[1] = y + Math.sin(ang) * r;
            v[2] = z;
            double[] d = new double[]{0.0, v[0], v[1], v[2], 0.0, 0.0, 1.0};
            ang += angIncr;
            vertices.add(v);
            datas.add(d);
        }
    }

    private void createCylinder(List cap1, List cap1d, List cap2, List cap2d, List target) {
        target.add(cap1);
        target.add(cap1d);
        target.add(cap2);
        target.add(cap2d);
        this.createSides(cap1, cap1d, cap2, cap2d, target);
    }

    private void indexify() {
        int j;
        Hashtable<String, double[]> vset = new Hashtable<String, double[]>();
        Hashtable kset = new Hashtable();
        ArrayList keybin = new ArrayList();
        int numProcessed = 0;
        int i = 0;
        while (i < this.bin.size()) {
            List polygon = (List)this.bin.get(i++);
            List data = (List)this.bin.get(i++);
            ArrayList<String> polykeys = new ArrayList<String>();
            for (j = 0; j < polygon.size(); ++j) {
                double[] vertex = (double[])polygon.get(j);
                String key = PolyUtils.vectorToString(vertex);
                vset.put(key, vertex);
                polykeys.add(key);
                ++numProcessed;
            }
            keybin.add(polykeys);
        }
        System.out.println("Simplified " + numProcessed + " vertices to " + vset.size());
        this.bin.clear();
        for (i = 0; i < keybin.size(); ++i) {
            List polykeys = (List)keybin.get(i);
            ArrayList poly = new ArrayList();
            ArrayList<double[]> data = new ArrayList<double[]>();
            for (j = 0; j < polykeys.size(); ++j) {
                String key = (String)polykeys.get(j);
                poly.add(vset.get(key));
                double[] dat = new double[]{0.0, 0.5};
                data.add(dat);
            }
            this.bin.add(poly);
            this.bin.add(data);
        }
    }

    private void createEllipsoid(double x, double y, double z, double rX, double rY, double rZ, int numSeg, List target) {
        double full = Math.PI * 2;
        double half = Math.PI;
        double quart = 1.5707963267948966;
        int N = numSeg;
        double[] u = new double[4];
        double[] v = new double[4];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                u[0] = (double)i * full / (double)N;
                v[0] = quart - (double)j * half / (double)N;
                u[1] = (double)((i + 1) % N) * full / (double)N;
                v[1] = quart - (double)j * half / (double)N;
                u[2] = (double)((i + 1) % N) * full / (double)N;
                v[2] = quart - (double)((j + 1) % N) * half / (double)N;
                u[3] = (double)i * full / (double)N;
                v[3] = quart - (double)((j + 1) % N) * half / (double)N;
                ArrayList<double[]> poly = new ArrayList<double[]>();
                poly.add(this.eVertex(u[0], v[0], rX, rY, rZ));
                poly.add(this.eVertex(u[1], v[1], rX, rY, rZ));
                poly.add(this.eVertex(u[2], v[2], rX, rY, rZ));
                poly.add(this.eVertex(u[3], v[3], rX, rY, rZ));
                target.add(poly);
                ArrayList<double[]> data = new ArrayList<double[]>();
                data.add(this.eData(u[0], v[0], rX, rY, rZ));
                data.add(this.eData(u[1], v[1], rX, rY, rZ));
                data.add(this.eData(u[2], v[2], rX, rY, rZ));
                data.add(this.eData(u[3], v[3], rX, rY, rZ));
                target.add(data);
            }
        }
    }

    private double[] eVertex(double u, double v, double rx, double ry, double rz) {
        double[] v1 = new double[]{Math.round(rx * Math.cos(u) * Math.cos(v)), Math.round(ry * Math.cos(u) * Math.sin(v)), Math.round(rz * Math.sin(u)), 1.0};
        return v1;
    }

    private double[] eData(double u, double v, double rx, double ry, double rz) {
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        v1[0] = Math.round(rx * Math.cos(u) * Math.cos(v));
        v1[1] = Math.round(ry * Math.cos(u) * Math.sin(v));
        v1[2] = Math.round(rz * Math.sin(u));
        PolyUtils.set(v2, v1);
        PolyUtils.normalize(v1);
        double[] d = new double[]{0.0, v2[0], v2[1], v2[2], v1[0], v1[1], v1[2]};
        return d;
    }

    private void createCylinder(double x, double y, double r, double z, double h, int numSegs, List target, double i) {
        ArrayList cap1 = new ArrayList();
        ArrayList cap1d = new ArrayList();
        ArrayList cap2 = new ArrayList();
        ArrayList cap2d = new ArrayList();
        this.createCircle(x, y, r, z, numSegs, cap1, cap1d, i);
        this.createCircle(x, y, r, z + h, numSegs, cap2, cap2d, i);
        this.createCylinder(cap1, cap1d, cap2, cap2d, target);
    }

    private void createSides(List cap1, List cap1d, List cap2, List cap2d, List target) {
        for (int i = 0; i < cap1.size() - 1; ++i) {
            double[] v1 = (double[])cap1.get(i);
            double[] v2 = (double[])cap1.get(i + 1);
            double[] v3 = (double[])cap2.get(i + 1);
            double[] v4 = (double[])cap2.get(i);
            double[] d1 = (double[])cap1d.get(i);
            double[] d2 = (double[])cap1d.get(i + 1);
            double[] d3 = (double[])cap2d.get(i + 1);
            double[] d4 = (double[])cap2d.get(i);
            double[] n1 = (double[])v1.clone();
            double[] n2 = (double[])v2.clone();
            double[] n3 = (double[])v3.clone();
            double[] n4 = (double[])v4.clone();
            ArrayList<double[]> sidePoly = new ArrayList<double[]>();
            ArrayList<double[]> sideData = new ArrayList<double[]>();
            sidePoly.add(v1);
            sidePoly.add(v2);
            sidePoly.add(v3);
            sidePoly.add(v4);
            PolyUtils.normalize(n1);
            PolyUtils.normalize(n2);
            PolyUtils.normalize(n3);
            PolyUtils.normalize(n4);
            double[] dt1 = new double[]{0.0, v1[0], v1[1], v1[2], n1[0], n1[1], n1[2]};
            double[] dt2 = new double[]{0.0, v2[0], v2[1], v2[2], n2[0], n2[1], n2[2]};
            double[] dt3 = new double[]{0.0, v3[0], v3[1], v3[2], n3[0], n3[1], n3[2]};
            double[] dt4 = new double[]{0.0, v4[0], v4[1], v4[2], n4[0], n4[1], n4[2]};
            sideData.add(dt1);
            sideData.add(dt2);
            sideData.add(dt3);
            sideData.add(dt4);
            target.add(sidePoly);
            target.add(sideData);
        }
        double[] v1 = (double[])cap1.get(cap1.size() - 1);
        double[] v2 = (double[])cap1.get(0);
        double[] v3 = (double[])cap2.get(0);
        double[] v4 = (double[])cap2.get(cap2.size() - 1);
        double[] d1 = (double[])cap1d.get(cap1d.size() - 1);
        double[] d2 = (double[])cap1d.get(0);
        double[] d3 = (double[])cap2d.get(0);
        double[] d4 = (double[])cap2d.get(cap2d.size() - 1);
        double[] n1 = (double[])v1.clone();
        double[] n2 = (double[])v2.clone();
        double[] n3 = (double[])v3.clone();
        double[] n4 = (double[])v4.clone();
        ArrayList<double[]> sidePoly = new ArrayList<double[]>();
        ArrayList<double[]> sideData = new ArrayList<double[]>();
        sidePoly.add(v1);
        sidePoly.add(v2);
        sidePoly.add(v3);
        sidePoly.add(v4);
        PolyUtils.normalize(n1);
        PolyUtils.normalize(n2);
        PolyUtils.normalize(n3);
        PolyUtils.normalize(n4);
        double[] dt1 = new double[]{0.0, v1[0], v1[1], v1[2], n1[0], n1[1], n1[2]};
        double[] dt2 = new double[]{0.0, v2[0], v2[1], v2[2], n2[0], n2[1], n2[2]};
        double[] dt3 = new double[]{0.0, v3[0], v3[1], v3[2], n3[0], n3[1], n3[2]};
        double[] dt4 = new double[]{0.0, v4[0], v4[1], v4[2], n4[0], n4[1], n4[2]};
        sideData.add(dt1);
        sideData.add(dt2);
        sideData.add(dt3);
        sideData.add(dt4);
        target.add(sidePoly);
        target.add(sideData);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jTextField1 = new JTextField();
        this.setDefaultCloseOperation(3);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                PolyTest.this.windowResized(evt);
            }
        });
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setPreferredSize(new Dimension(300, 300));
        this.jPanel2.add((Component)this.jPanel1, new AbsoluteConstraints(0, 0, 300, 310));
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel3.setBorder(new SoftBevelBorder(1));
        this.jButton1.setText("xdir");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTest.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.jButton2.setText("ydir");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTest.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton2);
        this.jButton3.setText("zdir");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTest.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton3);
        this.jButton4.setText("refresh");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTest.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton4);
        this.jTextField1.setText("1.232");
        this.jTextField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PolyTest.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jTextField1);
        this.getContentPane().add((Component)this.jPanel3, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 300) / 2, (screenSize.height - 358) / 2, 300, 358);
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        String s = this.jTextField1.getText();
        String[] tokens = s.split(",");
        this.fp[0] = Double.parseDouble(tokens[0]);
        this.fp[1] = Double.parseDouble(tokens[1]);
        this.fp[2] = Double.parseDouble(tokens[2]);
    }

    private void windowResized(ComponentEvent evt) {
        this.render();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.render();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        boolean bl = this.stop = !this.stop;
        if (!this.stop) {
            this.zdir = this.zdirc = -this.zdirc;
            this.xdir = 0.0;
            this.ydir = 0.0;
            this.start();
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        boolean bl = this.stop = !this.stop;
        if (!this.stop) {
            this.ydir = this.ydirc = -this.ydirc;
            this.xdir = 0.0;
            this.zdir = 0.0;
            this.start();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        boolean bl = this.stop = !this.stop;
        if (!this.stop) {
            this.xdir = this.xdirc = -this.xdirc;
            this.ydir = 0.0;
            this.zdir = 0.0;
            this.start();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PolyTest().setVisible(true);
            }
        });
    }
}

