/*
 * Decompiled with CFR 0.152.
 */
package fi.stuk.visualization.polygonal;

import fi.stuk.visualization.polygonal.RenderingPipeline;
import fi.stuk.visualization.polygonal.Shader;
import fi.stuk.visualization.polygonal.util.PolyUtils;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class BlinnShader
extends Shader {
    double[] darray = new double[]{0.0, 0.0, 0.0, 255.0};
    BufferedImage envMap;
    double[] n = new double[]{1.0, 0.0, 0.0};
    double[] r = new double[]{0.0, 0.0, 0.0};
    double[] e = new double[]{0.0, 0.0, 0.0};
    double[] p = new double[]{0.0, 0.0, 0.0};
    RenderingPipeline rp;
    double[] sin;
    double[] cos;
    int w;
    int h;
    int ctr = 0;
    double ang = 0.0;
    double[] dArray = new double[]{0.0, 0.0, 0.0, 255.0};
    double ambient;
    double diffuse;
    double specular;
    double Li = 1.0;
    double Kd = 0.3;
    double Ka = 0.01;
    double Ks = 0.6;
    double Rx;
    double Ry;
    double Rz;
    double[] R = new double[]{0.0, 0.0, 1.0};
    double Vx;
    double Vy;
    double Vz;
    double[] V = new double[]{0.0, 0.0, 1.0};
    double[] N = new double[]{0.0, 0.0, 0.0};
    double[] L = new double[]{0.0, 0.0, 0.0};
    double[] P = new double[]{0.0, 0.0, 0.0};
    double[] pl = new double[]{0.0, 0.0, 0.0};
    double[] pl2 = new double[]{0.0, 0.0, 0.0};
    double[] eyeToPos = new double[]{0.0, 0.0, 0.0};
    double shininess = 186.0;

    public BlinnShader(BufferedImage envMap, RenderingPipeline rp) {
        this.envMap = envMap;
        this.rp = rp;
        this.w = envMap.getWidth() - 1;
        this.h = envMap.getHeight() - 1;
    }

    public void shade(int x, int y, double[] data, boolean isEdge) {
        double z = data[0];
        this.e[0] = x;
        this.e[1] = y;
        this.e[2] = z;
        PolyUtils.normalize(this.e);
        this.n[0] = data[4];
        this.n[1] = data[5];
        this.n[2] = data[6];
        double i = this.readEnvMap();
        double i2 = this.phong(x, y, data);
        if (i2 > i) {
            i = i2;
        }
        if (i < 0.0) {
            i = 0.0;
        }
        if (i > 1.0) {
            i = 1.0;
        }
        this.darray[0] = i * 255.0;
        this.darray[1] = i * 255.0;
        this.darray[2] = i * 255.0;
        this.fb.set(x, y, z, this.darray);
    }

    private double readEnvMap() {
        this.ang += 0.001;
        ++this.ctr;
        this.reflect(this.e, this.n);
        double theta = Math.atan(this.r[1] / this.r[0]);
        double rho = Math.acos(this.r[2]);
        double cx = Math.cos(rho) * Math.sin(theta);
        double cy = Math.sin(rho) * Math.sin(theta);
        int x = (int)(Math.abs(cx) * (double)this.w) % this.w;
        int y = (int)(Math.abs(cy) * (double)this.h) % this.h;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        WritableRaster r = this.envMap.getRaster();
        double ret = r.getSampleDouble(x, y, 0);
        ret += r.getSampleDouble(x, y, 1);
        ret += r.getSampleDouble(x, y, 2);
        ret /= 3.0;
        return ret /= 255.0;
    }

    private void reflect(double[] v, double[] n) {
        this.r[0] = v[1] * n[2] - n[1] * v[2];
        this.r[1] = v[2] * n[0] - n[2] * v[0];
        this.r[2] = v[0] * n[1] - n[0] * v[1];
    }

    public double phong(int x, int y, double[] data) {
        double[] vrp = (double[])this.rp.getGlobalData().get(0);
        double z = data[0];
        this.L = (double[])this.rp.getLights().get(0);
        this.P[0] = data[1];
        this.P[1] = data[2];
        this.P[2] = data[3];
        this.N[0] = data[4];
        this.N[1] = data[5];
        this.N[2] = data[6];
        PolyUtils.minus(this.L, this.P, this.pl);
        PolyUtils.normalize(this.pl);
        this.ambient = this.Li * this.Ka;
        this.diffuse = PolyUtils.dot(this.pl, this.N) * this.Li * this.Kd;
        PolyUtils.minus(vrp, this.P, this.V);
        PolyUtils.normalize(this.V);
        PolyUtils.plus(this.V, this.pl, this.R);
        PolyUtils.mul(0.5, this.R, this.N);
        this.specular = Math.pow(PolyUtils.dot(this.N, this.V), this.shininess) * this.Ks;
        double I = this.ambient + this.diffuse + this.specular;
        if (I < 0.0) {
            I = 0.0;
        }
        if (I > 1.0) {
            I = 1.0;
        }
        return I;
    }
}

