/*
 * Decompiled with CFR 0.152.
 */
package fi.stuk.visualization.polygonal.util;

public class PolyUtils {
    static double[] UV = new double[]{0.0, 0.0, 0.0};
    static double[] t = new double[]{0.0, 0.0, 0.0};
    static double[] v1 = new double[]{0.0, 0.0, 0.0};
    static double[] v = new double[]{0.0, 0.0, 0.0};
    static double[] u = new double[]{0.0, 0.0, 0.0};
    static double[] N = new double[]{0.0, 0.0, 0.0};
    static double[] nul = new double[]{0.0, 0.0, 0.0};
    static double[][] Binv = new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    private static double[][] Tmp = new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    private static double[] tmp = new double[]{0.0, 0.0, 0.0, 0.0};

    public static void minus(double[] a, double[] b, double[] res) {
        for (int i = 0; i < a.length; ++i) {
            res[i] = a[i] - b[i];
        }
    }

    public static void plus(double[] a, double[] b, double[] res) {
        for (int i = 0; i < a.length; ++i) {
            res[i] = a[i] + b[i];
        }
    }

    public static void mul(double a, double[] v, double[] res) {
        for (int i = 0; i < v.length; ++i) {
            res[i] = v[i] * a;
        }
    }

    public static double dot(double[] v1, double[] v2) {
        double dot = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            dot += v1[i] * v2[i];
        }
        return dot;
    }

    public static void cross(double[] u, double[] v, double[] res) {
        res[0] = u[1] * v[2] - u[2] * v[1];
        res[1] = u[2] * v[0] - u[0] * v[2];
        res[2] = u[0] * v[1] - u[1] * v[0];
    }

    public static void normalize(double[] v) {
        double len = v[0] * v[0] + v[1] * v[1] + v[2] * v[2];
        len = Math.sqrt(len);
        v[0] = v[0] / len;
        v[1] = v[1] / len;
        v[2] = v[2] / len;
    }

    public static void set(double[] trg, double[] src) {
        for (int i = 0; i < src.length; ++i) {
            trg[i] = src[i];
        }
    }

    public static void set(double[][] trg, double[][] src) {
        for (int i = 0; i < trg.length; ++i) {
            for (int j = 0; j < trg[i].length; ++j) {
                trg[i][j] = src[i][j];
                trg[i][j] = src[i][j];
                trg[i][j] = src[i][j];
            }
        }
    }

    public static void getViewingTransform(double[] vrp, double[] fp, double[] up, double[][] res) {
        PolyUtils.minus(vrp, fp, N);
        PolyUtils.normalize(N);
        PolyUtils.set(UV, up);
        PolyUtils.mul(PolyUtils.dot(N, UV), N, t);
        PolyUtils.minus(UV, t, v);
        PolyUtils.normalize(v);
        PolyUtils.cross(N, v, u);
        PolyUtils.getViewingTransform(u, v, N, vrp, res);
    }

    public static void getViewingTransform(double[] u, double[] v, double[] n, double[] o, double[][] res) {
        PolyUtils.Binv[0][0] = u[0];
        PolyUtils.Binv[0][1] = v[0];
        PolyUtils.Binv[0][2] = n[0];
        PolyUtils.Binv[0][3] = 0.0;
        PolyUtils.Binv[1][0] = u[1];
        PolyUtils.Binv[1][1] = v[1];
        PolyUtils.Binv[1][2] = n[1];
        PolyUtils.Binv[1][3] = 0.0;
        PolyUtils.Binv[2][0] = u[2];
        PolyUtils.Binv[2][1] = v[2];
        PolyUtils.Binv[2][2] = n[2];
        PolyUtils.Binv[2][3] = 0.0;
        PolyUtils.Binv[3][0] = -PolyUtils.dot(o, u);
        PolyUtils.Binv[3][1] = -PolyUtils.dot(o, v);
        PolyUtils.Binv[3][2] = -PolyUtils.dot(o, n);
        PolyUtils.Binv[3][3] = 1.0;
        PolyUtils.transpose(Binv, res);
    }

    public static double[][] getProjectionTransform(double d) {
        double[][] prj = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0 / d, 1.0}};
        return prj;
    }

    public static double[][] getProjectionTransform(double near, double far, double top, double bottom, double left, double right) {
        double[][] prj = new double[][]{{2.0 / (right - left), 0.0, 0.0, -(right + left) / (right - left)}, {0.0, 2.0 / (top - bottom), 0.0, -(top + bottom) / (top - bottom)}, {0.0, 0.0, 2.0 / (far - near), -(far + near) / (far - near)}, {0.0, 0.0, 0.0, 1.0}};
        return prj;
    }

    public static double[][] getProjectionTransform(double near, double far, double fov, double aspect) {
        double[][] prj = new double[][]{{Math.tan(fov / 2.0) / aspect, 0.0, 0.0, 0.0}, {0.0, 1.0 / Math.tan(fov / 2.0), 0.0, 0.0}, {0.0, 0.0, (far + near) / (near - far), 2.0 * far * near / (near - far)}, {0.0, 0.0, -1.0, 1.0}};
        return prj;
    }

    public static double[][] getDeviceTransform(int x1, int y1, int x2, int y2) {
        double[][] prj = new double[][]{{(x2 - x1) / 2, 0.0, 0.0, x1 + (x2 - x1)}, {0.0, y2 - y1, 0.0, y1 + (y2 - y1)}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        return prj;
    }

    public static void matMult4(double[][] A, double[][] B, double[][] res) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double val = 0.0;
                for (int k = 0; k < 4; ++k) {
                    val += A[i][k] * B[k][j];
                }
                res[i][j] = val;
            }
        }
    }

    public static void matMult4(double[] v, double[][] A, double[] res) {
        for (int i = 0; i < 4; ++i) {
            double val = 0.0;
            for (int j = 0; j < 4; ++j) {
                val += v[j] * A[i][j];
            }
            res[i] = val;
        }
    }

    public static String matrixToString(double[][] A) {
        String ret = "";
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < A[i].length; ++j) {
                ret = ret + A[i][j] + " ";
            }
            ret = ret + '\n';
        }
        return ret;
    }

    public static String vectorToString(double[] v) {
        String ret = "";
        for (int i = 0; i < v.length; ++i) {
            ret = ret + v[i];
            if (i == v.length - 1) continue;
            ret = ret + ",";
        }
        return ret;
    }

    public static void transpose(double[][] M, double[][] res) {
        for (int i = 0; i < M.length; ++i) {
            for (int j = 0; j < M[i].length; ++j) {
                res[i][j] = M[j][i];
            }
        }
    }

    public static void rotate(double[] v, double[] axis, double theta, double[] res) {
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        double t = 1.0 - c;
        double x = axis[0];
        double y = axis[1];
        double z = axis[2];
        double[][] M = new double[][]{{t * x * x + c, t * x * y - s * z, t * x * z + s * y, 0.0}, {t * x * y + s * z, t * y * y + c, t * y * z - s * x, 0.0}, {t * x * z - s * z, t * y * z + s * x, t * z * z + c, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        PolyUtils.matMult4(v, (double[][])M, res);
    }

    public static void main(String[] args) {
        double[] u = new double[]{1.0, 0.0, 0.0};
        double[] v = new double[]{0.0, 1.0, 0.0};
        double[] n = new double[]{0.0, 0.0, 1.0};
        double[] pt = new double[]{0.0, 0.0, -5.0};
        double[] lookAt = new double[]{0.0, 0.0, 0.0};
        double[] up = new double[]{0.0, 3.0, 0.0};
        double[][] res = new double[4][4];
        double[][] rest = new double[4][4];
        PolyUtils.getViewingTransform(pt, lookAt, up, res);
        System.out.println(PolyUtils.matrixToString(res));
    }
}

