/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DateTransformationConverter;
import jas.hist.JASHist1DHistogramData;
import jas.hist.JASHist1DHistogramStyle;
import jas.plot.CoordinateTransformation;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.MutableLegendEntry;
import jas.plot.Overlay;
import jas.plot.OverlayContainer;
import jas.plot.PlotGraphics;
import jas.plot.StringCoordinateTransformation;
import java.awt.BasicStroke;

class OneDOverlay
implements Overlay,
MutableLegendEntry {
    private JASHist1DHistogramData source;
    private OverlayContainer container;
    private double[] data;
    private double[] dataX;
    private String[] labels;
    private double[] minus;
    private double[] plus;
    private double xmax;
    private double xmin;
    private static final float[][] lineStyles = new float[][]{null, {1.0f, 5.0f}, {4.0f, 6.0f}, {6.0f, 4.0f, 2.0f, 4.0f}};

    OneDOverlay(JASHist1DHistogramData jASHist1DHistogramData) {
        this.source = jASHist1DHistogramData;
    }

    public void setTitle(String string) {
        this.source.setLegendText(string);
    }

    public String getTitle() {
        return this.source.getLegendText();
    }

    public void containerNotify(OverlayContainer overlayContainer) {
        this.container = overlayContainer;
    }

    public void paint(PlotGraphics plotGraphics, boolean bl) {
        JASHist1DHistogramStyle jASHist1DHistogramStyle = this.source.style;
        CoordinateTransformation coordinateTransformation = this.container.getXTransformation();
        CoordinateTransformation coordinateTransformation2 = this.container.getYTransformation(this.source.getYAxis());
        if (coordinateTransformation instanceof DateCoordinateTransformation) {
            coordinateTransformation = new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation);
        }
        if (coordinateTransformation instanceof DoubleCoordinateTransformation && coordinateTransformation2 instanceof DoubleCoordinateTransformation) {
            DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)coordinateTransformation;
            DoubleCoordinateTransformation doubleCoordinateTransformation2 = (DoubleCoordinateTransformation)coordinateTransformation2;
            int n = this.data.length;
            double d = (this.xmax - this.xmin) / (double)n;
            double d2 = (doubleCoordinateTransformation.convert(this.xmax) - doubleCoordinateTransformation.convert(this.xmin)) / (double)n;
            boolean bl2 = d2 > 5.0;
            double d3 = Math.min(d, 3.0 * d / d2);
            plotGraphics.setTransformation(doubleCoordinateTransformation, doubleCoordinateTransformation2);
            double d4 = this.xmin;
            double d5 = this.xmin;
            double d6 = 0.0;
            if (doubleCoordinateTransformation2.getPlotMin() > d6) {
                d6 = doubleCoordinateTransformation2.getPlotMin();
            }
            if (doubleCoordinateTransformation2.getPlotMax() < d6) {
                d6 = doubleCoordinateTransformation2.getPlotMax();
            }
            double d7 = d6;
            double[] dArray = null;
            double[] dArray2 = null;
            int n2 = 0;
            if (jASHist1DHistogramStyle.getShowLinesBetweenPoints() || jASHist1DHistogramStyle.getShowDataPoints()) {
                dArray = new double[n];
                dArray2 = new double[n];
            }
            for (int i = 0; i < n; ++i) {
                double d8 = this.data[i];
                d4 = this.dataX == null ? d4 + d : this.dataX[i];
                BasicStroke basicStroke = new BasicStroke(jASHist1DHistogramStyle.getHistogramBarLineWidth(), 2, 1, 10.0f, lineStyles[jASHist1DHistogramStyle.getHistogramBarLineStyle()], 0.0f);
                plotGraphics.setStroke(basicStroke);
                if (jASHist1DHistogramStyle.getShowHistogramBars()) {
                    if (!Double.isNaN(d8)) {
                        plotGraphics.setColor(jASHist1DHistogramStyle.getHistogramBarColor());
                        if (jASHist1DHistogramStyle.getHistogramFill()) {
                            plotGraphics.fillRect(d5, d6, d4, d8);
                            plotGraphics.setColor(jASHist1DHistogramStyle.getHistogramBarLineColor());
                            if (bl2) {
                                plotGraphics.drawRect(d5, d6, d4, d8);
                            } else {
                                plotGraphics.drawLine(d5, d7, d5, d8);
                                plotGraphics.drawLine(d5, d8, d4, d8);
                            }
                        } else {
                            plotGraphics.setColor(jASHist1DHistogramStyle.getHistogramBarLineColor());
                            plotGraphics.drawLine(d5, d7, d5, d8);
                            plotGraphics.drawLine(d5, d8, d4, d8);
                        }
                    } else if (!jASHist1DHistogramStyle.getHistogramFill() || !bl2) {
                        plotGraphics.drawLine(d5, d7, d5, d6);
                    }
                }
                plotGraphics.setStroke(null);
                if (jASHist1DHistogramStyle.getShowErrorBars() && !Double.isNaN(d8)) {
                    plotGraphics.setColor(jASHist1DHistogramStyle.getErrorBarColor());
                    double d9 = d == 0.0 ? d4 : d5 + d / 2.0;
                    double d10 = d3;
                    double d11 = this.data[i] + this.plus[i];
                    double d12 = this.data[i] - this.minus[i];
                    basicStroke = new BasicStroke(jASHist1DHistogramStyle.getErrorBarWidth(), 2, 1, 10.0f, lineStyles[jASHist1DHistogramStyle.getErrorBarStyle()], 0.0f);
                    plotGraphics.setStroke(basicStroke);
                    if (!Double.isNaN(d11) && !Double.isNaN(d12) && d12 != d11) {
                        plotGraphics.drawLine(d9, d11, d9, d12);
                        if (bl2) {
                            BasicStroke basicStroke2 = new BasicStroke(jASHist1DHistogramStyle.getErrorBarWidth(), 2, 1, 10.0f);
                            plotGraphics.setStroke(basicStroke2);
                            plotGraphics.drawLine(d9 - d10, d11, d9 + d10, d11);
                            plotGraphics.drawLine(d9 - d10, d12, d9 + d10, d12);
                        }
                    }
                    plotGraphics.setStroke(null);
                }
                if (dArray != null) {
                    if (Double.isNaN(d8)) {
                        if (n2 > 0) {
                            if (jASHist1DHistogramStyle.getShowLinesBetweenPoints()) {
                                plotGraphics.setColor(jASHist1DHistogramStyle.getLineColor());
                                basicStroke = new BasicStroke(jASHist1DHistogramStyle.getLinesBetweenPointsWidth(), 2, 1, 10.0f, lineStyles[jASHist1DHistogramStyle.getLinesBetweenPointsStyle()], 0.0f);
                                plotGraphics.setStroke(basicStroke);
                                plotGraphics.drawPolyLine(dArray, dArray2, n2);
                                plotGraphics.setStroke(null);
                            }
                            if (jASHist1DHistogramStyle.getShowDataPoints()) {
                                plotGraphics.setColor(jASHist1DHistogramStyle.getDataPointColor());
                                plotGraphics.drawPolySymbol(dArray, dArray2, jASHist1DHistogramStyle.getDataPointSize(), jASHist1DHistogramStyle.getDataPointStyle(), n2);
                            }
                            n2 = 0;
                        }
                    } else {
                        dArray[n2] = this.dataX == null ? d5 + d / 2.0 : d4;
                        dArray2[n2++] = d8;
                    }
                }
                d5 = d4;
                d7 = d8 == Double.NaN ? d6 : d8;
            }
            if (n2 > 0) {
                if (jASHist1DHistogramStyle.getShowLinesBetweenPoints()) {
                    plotGraphics.setColor(jASHist1DHistogramStyle.getLineColor());
                    BasicStroke basicStroke = new BasicStroke(jASHist1DHistogramStyle.getLinesBetweenPointsWidth(), 2, 1, 10.0f, lineStyles[jASHist1DHistogramStyle.getLinesBetweenPointsStyle()], 0.0f);
                    plotGraphics.setStroke(basicStroke);
                    plotGraphics.drawPolyLine(dArray, dArray2, n2);
                    plotGraphics.setStroke(null);
                }
                if (jASHist1DHistogramStyle.getShowDataPoints()) {
                    plotGraphics.setColor(jASHist1DHistogramStyle.getDataPointColor());
                    plotGraphics.drawPolySymbol(dArray, dArray2, jASHist1DHistogramStyle.getDataPointSize(), jASHist1DHistogramStyle.getDataPointStyle(), n2);
                }
            }
        } else if (coordinateTransformation instanceof StringCoordinateTransformation && coordinateTransformation2 instanceof DoubleCoordinateTransformation) {
            StringCoordinateTransformation stringCoordinateTransformation = (StringCoordinateTransformation)coordinateTransformation;
            DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)coordinateTransformation2;
            int n = this.labels.length;
            double d = stringCoordinateTransformation.binWidth();
            boolean bl3 = d > 5.0;
            plotGraphics.setTransformation(null, doubleCoordinateTransformation);
            double d13 = 0.0;
            if (doubleCoordinateTransformation.getPlotMin() > d13) {
                d13 = doubleCoordinateTransformation.getPlotMin();
            }
            if (doubleCoordinateTransformation.getPlotMax() < d13) {
                d13 = doubleCoordinateTransformation.getPlotMax();
            }
            double d14 = doubleCoordinateTransformation.getPlotMin();
            double[] dArray = null;
            double[] dArray3 = null;
            int n3 = 0;
            if (jASHist1DHistogramStyle.getShowLinesBetweenPoints() || jASHist1DHistogramStyle.getShowDataPoints()) {
                dArray = new double[n];
                dArray3 = new double[n];
            }
            for (int i = 0; i < n; ++i) {
                double d15 = stringCoordinateTransformation.convert(this.labels[i]) + d / 2.0;
                double d16 = d15 - d;
                double d17 = this.data[i];
                BasicStroke basicStroke = new BasicStroke(jASHist1DHistogramStyle.getHistogramBarLineWidth(), 2, 1, 10.0f, lineStyles[jASHist1DHistogramStyle.getHistogramBarLineStyle()], 0.0f);
                plotGraphics.setStroke(basicStroke);
                if (jASHist1DHistogramStyle.getShowHistogramBars()) {
                    if (!Double.isNaN(d17)) {
                        plotGraphics.setColor(jASHist1DHistogramStyle.getHistogramBarColor());
                        if (jASHist1DHistogramStyle.getHistogramFill()) {
                            plotGraphics.fillRect(d16, d14, d15, d17);
                            plotGraphics.setColor(jASHist1DHistogramStyle.getHistogramBarLineColor());
                            if (bl3) {
                                plotGraphics.drawRect(d16, d14, d15, d17);
                            } else {
                                plotGraphics.drawLine(d16, d14, d16, d17);
                                plotGraphics.drawLine(d16, d17, d15, d17);
                            }
                        } else {
                            plotGraphics.setColor(jASHist1DHistogramStyle.getHistogramBarLineColor());
                            plotGraphics.drawLine(d16, d14, d16, d17);
                            plotGraphics.drawLine(d16, d17, d15, d17);
                        }
                    } else if (!jASHist1DHistogramStyle.getHistogramFill() || !bl3) {
                        plotGraphics.drawLine(d16, d14, d16, d13);
                    }
                }
                plotGraphics.setStroke(null);
                if (jASHist1DHistogramStyle.getShowErrorBars() && !Double.isNaN(d17)) {
                    basicStroke = new BasicStroke(jASHist1DHistogramStyle.getErrorBarWidth(), 2, 1, 10.0f, lineStyles[jASHist1DHistogramStyle.getErrorBarStyle()], 0.0f);
                    plotGraphics.setStroke(basicStroke);
                    plotGraphics.setColor(jASHist1DHistogramStyle.getErrorBarColor());
                    double d18 = d15 - d / 2.0;
                    double d19 = Math.min(3.0, d / 2.0);
                    double d20 = this.data[i] + this.plus[i];
                    double d21 = this.data[i] - this.minus[i];
                    if (!Double.isNaN(d20) && !Double.isNaN(d21) && d21 != d20) {
                        plotGraphics.drawLine(d18, d20, d18, d21);
                        if (bl3) {
                            BasicStroke basicStroke3 = new BasicStroke(jASHist1DHistogramStyle.getErrorBarWidth(), 2, 1, 10.0f);
                            plotGraphics.setStroke(basicStroke3);
                            plotGraphics.drawLine(d18 - d19, d20, d18 + d19, d20);
                            plotGraphics.drawLine(d18 - d19, d21, d18 + d19, d21);
                        }
                    }
                    plotGraphics.setStroke(null);
                }
                if (dArray != null) {
                    if (Double.isNaN(d17)) {
                        if (n3 > 0) {
                            if (jASHist1DHistogramStyle.getShowLinesBetweenPoints()) {
                                plotGraphics.setColor(jASHist1DHistogramStyle.getLineColor());
                                basicStroke = new BasicStroke(jASHist1DHistogramStyle.getLinesBetweenPointsWidth(), 2, 1, 10.0f, lineStyles[jASHist1DHistogramStyle.getLinesBetweenPointsStyle()], 0.0f);
                                plotGraphics.setStroke(basicStroke);
                                plotGraphics.drawPolyLine(dArray, dArray3, n3);
                                plotGraphics.setStroke(null);
                            }
                            if (jASHist1DHistogramStyle.getShowDataPoints()) {
                                plotGraphics.setColor(jASHist1DHistogramStyle.getDataPointColor());
                                plotGraphics.drawPolySymbol(dArray, dArray3, jASHist1DHistogramStyle.getDataPointSize(), jASHist1DHistogramStyle.getDataPointStyle(), n3);
                            }
                            n3 = 0;
                        }
                    } else {
                        dArray[n3] = this.dataX == null ? d16 + d / 2.0 : d15;
                        dArray3[n3++] = d17;
                    }
                }
                d16 = d15;
            }
            if (n3 > 0) {
                if (jASHist1DHistogramStyle.getShowLinesBetweenPoints()) {
                    plotGraphics.setColor(jASHist1DHistogramStyle.getLineColor());
                    BasicStroke basicStroke = new BasicStroke(jASHist1DHistogramStyle.getLinesBetweenPointsWidth(), 2, 1, 10.0f, lineStyles[jASHist1DHistogramStyle.getLinesBetweenPointsStyle()], 0.0f);
                    plotGraphics.setStroke(basicStroke);
                    plotGraphics.drawPolyLine(dArray, dArray3, n3);
                    plotGraphics.setStroke(null);
                }
                if (jASHist1DHistogramStyle.getShowDataPoints()) {
                    plotGraphics.setColor(jASHist1DHistogramStyle.getDataPointColor());
                    plotGraphics.drawPolySymbol(dArray, dArray3, jASHist1DHistogramStyle.getDataPointSize(), jASHist1DHistogramStyle.getDataPointStyle(), n3);
                }
            }
        }
    }

    public void paintIcon(PlotGraphics plotGraphics, int n, int n2) {
        JASHist1DHistogramStyle jASHist1DHistogramStyle = this.source.style;
        if (jASHist1DHistogramStyle.getShowDataPoints()) {
            plotGraphics.setColor(jASHist1DHistogramStyle.getDataPointColor());
            plotGraphics.drawSymbol(n / 2, n2 / 2, n / 2, jASHist1DHistogramStyle.getDataPointStyle());
        } else if (jASHist1DHistogramStyle.getShowHistogramBars()) {
            if (jASHist1DHistogramStyle.getHistogramFill()) {
                plotGraphics.setColor(jASHist1DHistogramStyle.getHistogramBarColor());
                plotGraphics.fillRect(1.0, 1.0, n - 2, n2 - 2);
            } else {
                plotGraphics.setColor(jASHist1DHistogramStyle.getHistogramBarLineColor());
                BasicStroke basicStroke = new BasicStroke(jASHist1DHistogramStyle.getHistogramBarLineWidth(), 2, 1, 10.0f, lineStyles[jASHist1DHistogramStyle.getHistogramBarLineStyle()], 0.0f);
                plotGraphics.setStroke(basicStroke);
                plotGraphics.drawLine(1.0, n2 / 2, n - 2, n2 / 2);
                plotGraphics.setStroke(null);
            }
        } else if (jASHist1DHistogramStyle.getShowLinesBetweenPoints()) {
            plotGraphics.setColor(jASHist1DHistogramStyle.getLineColor());
            BasicStroke basicStroke = new BasicStroke(jASHist1DHistogramStyle.getLinesBetweenPointsWidth(), 2, 1, 10.0f, lineStyles[jASHist1DHistogramStyle.getLinesBetweenPointsStyle()], 0.0f);
            plotGraphics.setStroke(basicStroke);
            plotGraphics.drawLine(1.0, n2 / 2, n - 2, n2 / 2);
            plotGraphics.setStroke(null);
        } else if (jASHist1DHistogramStyle.getShowErrorBars()) {
            plotGraphics.setColor(jASHist1DHistogramStyle.getErrorBarColor());
            BasicStroke basicStroke = new BasicStroke(jASHist1DHistogramStyle.getErrorBarWidth(), 2, 1, 10.0f, lineStyles[jASHist1DHistogramStyle.getErrorBarStyle()], 0.0f);
            plotGraphics.setStroke(basicStroke);
            plotGraphics.drawLine(1.0, n2 / 2, n - 2, n2 / 2);
            plotGraphics.setStroke(null);
        } else if (jASHist1DHistogramStyle.getHistogramFill()) {
            plotGraphics.setColor(jASHist1DHistogramStyle.getHistogramBarColor());
            plotGraphics.fillRect(1.0, 1.0, n - 2, n2 - 2);
        }
    }

    public boolean titleIsChanged() {
        return this.source.isLegendChanged();
    }

    void setData(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2) {
        this.data = dArray;
        this.plus = dArray2;
        this.minus = dArray3;
        this.xmin = d;
        this.xmax = d2;
    }

    void setData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.dataX = dArray;
        this.data = dArray2;
        this.plus = dArray3;
        this.minus = dArray4;
    }

    void setData(double[] dArray, double[] dArray2, double[] dArray3, String[] stringArray) {
        this.data = dArray;
        this.plus = dArray2;
        this.minus = dArray3;
        this.labels = stringArray;
    }
}

