/*
 * Decompiled with CFR 0.152.
 */
package gov.stuk.visualization.polygonal;

import gov.stuk.visualization.polygonal.FrameBuffer;
import gov.stuk.visualization.polygonal.ScanConverter;
import gov.stuk.visualization.polygonal.Shader;
import gov.stuk.visualization.polygonal.util.PolyUtils;
import java.util.List;
import java.util.Vector;

public class RenderingPipeline {
    double[][] Tm = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    double[][] Tv = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    double[][] Tp = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    double[][] C = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    double[][] Td = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    double[][] tmp = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    double[] eye = new double[]{0.0, 0.0, 0.0, 0.0};
    List lights;
    List globalData = new Vector();
    ScanConverter sc;
    Shader sh;
    List perVertexData;
    List vertices;
    List tvertices = new Vector();
    int numVerts;
    FrameBuffer fb;
    boolean stateIsDetermined = true;
    static String[][] tmpS = new String[][]{{"", "", ""}, {"", "", ""}, {"", "", ""}};

    public RenderingPipeline() {
        this.Td = PolyUtils.getDeviceTransform(0, 0, 300, 300);
    }

    public void setModelingTransform(double[][] Tm) {
        this.Tm = Tm;
    }

    public void setViewingTransform(double[][] Tv) {
        this.Tv = Tv;
        this.stateIsDetermined = false;
    }

    public void setProjectionTransform(double[][] Tp) {
        this.Tp = Tp;
        this.stateIsDetermined = false;
    }

    public List getGlobalData() {
        return this.globalData;
    }

    public void setLights(List lights) {
        this.lights = lights;
    }

    public void setVertices(List vertices) {
        this.vertices = vertices;
        this.numVerts = vertices.size();
    }

    public void setVertexData(List vertexdata) {
        this.perVertexData = vertexdata;
    }

    public void setScanConverter(ScanConverter sc) {
        this.sc = sc;
    }

    public void setShader(Shader shader) {
        this.sh = shader;
    }

    public void setFrameBuffer(FrameBuffer fb) {
        this.fb = fb;
    }

    private void calculateCompositeTransform() {
        PolyUtils.matMult4(this.Tp, this.Tv, this.C);
    }

    public List getLights() {
        return this.lights;
    }

    public void setEyePosition(double[] eye) {
        this.eye = eye;
    }

    public double[] getEyePosition() {
        return this.eye;
    }

    public void render() {
        int i = 0;
        this.tvertices.clear();
        if (!this.stateIsDetermined) {
            this.calculateCompositeTransform();
            this.stateIsDetermined = true;
        }
        while (i < this.numVerts) {
            double[] vertex = (double[])this.vertices.get(i);
            double[] tVertex2 = new double[]{0.0, 0.0, 0.0, 0.0};
            double[] tVertex = new double[]{0.0, 0.0, 0.0, 0.0};
            PolyUtils.matMult4(vertex, this.C, tVertex);
            tVertex[0] = tVertex[0] * (double)this.fb.w;
            tVertex[1] = tVertex[1] * (double)this.fb.h;
            tVertex[0] = tVertex[0] / tVertex[3];
            tVertex[1] = tVertex[1] / tVertex[3];
            this.tvertices.add(tVertex);
            if (tVertex[3] < 0.0) {
                return;
            }
            ++i;
        }
        this.sh.setFrameBuffer(this.fb);
        this.sc.setShader(this.sh);
        this.sc.scanConvert(this.tvertices, this.perVertexData);
    }

    private static void matMultS(String[][] A, String[][] B) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    String[] stringArray = tmpS[i];
                    int n = j;
                    stringArray[n] = stringArray[n] + A[i][k] + B[k][j];
                    if (k == 2) continue;
                    String[] stringArray2 = tmpS[i];
                    int n2 = j;
                    stringArray2[n2] = stringArray2[n2] + "+";
                }
                System.out.print(tmpS[i][j]);
                if (j != 2) {
                    System.out.print(" , ");
                    continue;
                }
                System.out.print("\n");
            }
        }
    }

    public static void main(String[] args) {
        double[] v = new double[]{11.0, 31.0, 22.0};
        double[][] mat = new double[][]{{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}};
        String[][] mats1 = new String[][]{{"a00", "a01", "a02"}, {"a10", "a11", "a12"}, {"a20", "a21", "a22"}};
        String[][] mats2 = new String[][]{{"b00", "b01", "b02"}, {"b10", "b11", "b12"}, {"b20", "b21", "b22"}};
        String[] vecs = new String[]{"p", "q", "r"};
        RenderingPipeline.matMultS(mats1, mats2);
    }
}

