/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.CustomCellEditor;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class BasicEditor
extends CustomCellEditor
implements TableCellEditor {
    JTextField textField = new JTextField();
    Float editedParam;
    int type = 0;
    static final int FLOAT = 1;
    static final int INTEGER = 2;
    static final int STRING = 3;

    public BasicEditor() {
        this.textField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                BasicEditor.this.fireEditingStopped();
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    public void updateUI() {
        this.textField.updateUI();
    }

    public BasicEditor(boolean alignRight) {
        this();
        if (alignRight) {
            this.textField.setHorizontalAlignment(4);
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        if (value == null) {
            this.fireEditingCanceled();
            return null;
        }
        this.textField.setText(value.toString());
        this.type = value instanceof Float ? 1 : (value instanceof Integer ? 2 : 3);
        return this.textField;
    }

    public Object getCellEditorValue() {
        String txt = this.textField.getText();
        if (txt.length() < 1) {
            return this.editedParam;
        }
        if (this.type == 1) {
            Float val = new Float(this.textField.getText());
            return val;
        }
        if (this.type == 2) {
            Integer val = new Integer(this.textField.getText());
            return val;
        }
        if (this.type == 3) {
            String val = new String(this.textField.getText());
            return val;
        }
        return this.editedParam;
    }
}

