/*
 * Decompiled with CFR 0.152.
 */
package UI;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JLabel;

public class ClockPanel
extends JLabel
implements Runnable {
    private Color faceColor;
    private float thickn = 3.0f;
    private Stroke stroke;
    private double bigHandDeg = 0.0;
    private double smallHandDeg = 0.0;
    private Thread t;
    boolean stop = false;

    public void start() {
        this.t = new Thread(this);
        this.stop = false;
        this.t.start();
    }

    public void stop() {
        this.stop = true;
    }

    public void run() {
        while (!this.stop) {
            try {
                Thread.sleep(50L);
                this.bigHandDeg += 0.1;
                this.smallHandDeg += 0.015915494309189534;
                this.repaint();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public ClockPanel() {
        this.initComponents();
        this.stroke = new BasicStroke(this.getThickn());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void paint(Graphics g) {
        int ins = (int)this.thickn;
        int w = this.getWidth();
        int h = this.getHeight();
        int r = w / 2 - ins;
        int ex = w - ins;
        int ey = w - ins;
        int ex2 = w - ins;
        int ey2 = w - ins;
        ex = w / 2 + (int)(Math.cos(this.bigHandDeg) * (double)r);
        ey = w / 2 + (int)(Math.sin(this.bigHandDeg) * (double)r);
        ex2 = w / 2 + (int)(Math.cos(this.smallHandDeg) * ((double)r * 0.7));
        ey2 = w / 2 + (int)(Math.sin(this.smallHandDeg) * ((double)r * 0.7));
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.getBackground());
        g2d.fillRect(0 + ins, 0 + ins, w - ins, h - ins);
        g2d.setColor(this.getFaceColor());
        g2d.fillOval(0 + ins, 0 + ins, w - 2 * ins, h - 2 * ins);
        g2d.setStroke(this.getStroke());
        g2d.setColor(this.getForeground());
        g2d.drawOval(0 + ins, 0 + ins, w - 2 * ins, h - 2 * ins);
        g2d.drawLine(w / 2, h / 2, ex, ey);
        g2d.drawLine(w / 2, h / 2, ex2, ey2);
    }

    public Color getFaceColor() {
        return this.faceColor;
    }

    public void setFaceColor(Color faceColor) {
        this.faceColor = faceColor;
    }

    public float getThickn() {
        return this.thickn;
    }

    public void setThickn(float thickn) {
        this.thickn = thickn;
        this.stroke = new BasicStroke(thickn);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }
}

