/*
 * Decompiled with CFR 0.152.
 */
package core;

import UI.MainFrame;
import UI.ProgressDialog;
import core.NuclideParser;
import core.NuclideReader;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Main {
    static MainFrame mainFrame = null;
    public static ProgressDialog progressDialog = null;

    public Main() {
        mainFrame = new MainFrame();
        progressDialog = new ProgressDialog(mainFrame);
        mainFrame.setVisible(true);
    }

    public static void importEnsDef(final String path) {
        progressDialog.setVisible(true);
        progressDialog.start();
        Thread t = new Thread(new Runnable(){

            public void run() {
                List nuclideList = NuclideParser.parseNuclides(path);
                int lsep = Math.max(path.lastIndexOf(File.separatorChar) + 1, 0);
                String name = path.substring(lsep, path.length());
                mainFrame.setLibraryNuclides(nuclideList, name);
                progressDialog.stop();
                progressDialog.dispose();
                mainFrame.repaint();
            }
        });
        t.start();
    }

    public static void importXML(String path) {
        NuclideReader reader = new NuclideReader();
        List nuclideList = reader.getNuclides(path);
        int lsep = Math.max(path.lastIndexOf(File.separatorChar) + 1, 0);
        String name = path.substring(lsep, path.length());
        mainFrame.setLibraryNuclides(nuclideList, name);
        mainFrame.repaint();
    }

    public static void main(String[] args) {
        try {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Main();
    }

    public static void warnUser(String message) {
        JOptionPane.showMessageDialog(mainFrame, message, "Error", 0);
    }

    public static void warnUser(String message, boolean warning) {
        if (!warning) {
            JOptionPane.showMessageDialog(mainFrame, message, "Error", 0);
        } else {
            JOptionPane.showMessageDialog(mainFrame, message, "Warning", 2);
        }
    }
}

